/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.routing.experimentalLeeMoore1;

import com.sun.electric.tool.routing.experimentalLeeMoore1.ConnectionPoints;
import com.sun.electric.tool.routing.experimentalLeeMoore1.FindVirtualEndInterface;
import com.sun.electric.tool.routing.experimentalLeeMoore1.LeeMoore.Tupel;
import com.sun.electric.tool.routing.experimentalLeeMoore1.RoutingPart;
import com.sun.electric.tool.routing.experimentalLeeMoore1.WorkPool;
import com.sun.electric.tool.routing.experimentalLeeMoore1.WorkerThread;

public class FindVirtualEnd_Simple
implements FindVirtualEndInterface {
    private static boolean X_DIRECTION;
    private static boolean Y_DIRECTION;
    private static int MAXLAYER;

    public FindVirtualEnd_Simple(boolean xdir, boolean ydir, int l) {
        X_DIRECTION = xdir;
        Y_DIRECTION = ydir;
        MAXLAYER = l;
    }

    @Override
    public synchronized ConnectionPoints findVirtualEnd(RoutingPart rp, int id) {
        Tupel start = rp.start;
        Tupel ende = rp.end;
        if (Math.abs(this.getMiddlePoint(start).getX_InsideRoutingArray() - this.getMiddlePoint(ende).getX_InsideRoutingArray()) >= Math.abs(this.getMiddlePoint(start).getY_InsideRoutingArray() - this.getMiddlePoint(ende).getY_InsideRoutingArray())) {
            boolean routingDirection = X_DIRECTION;
            if (start.getX_InsideRoutingArray() <= ende.getX_InsideRoutingArray()) {
                for (int l = 0; l < MAXLAYER; ++l) {
                    if (!this.isCorrectOddEvenLayerForRoutingDirection(l, routingDirection)) continue;
                    for (int y = FindVirtualEnd_Simple.getLowIndexIn_Y(id) + 1; y < FindVirtualEnd_Simple.getHighIndexIn_Y(id) - 1; y += 10) {
                        Tupel vEnd = new Tupel(FindVirtualEnd_Simple.getHighIndexIn_X(id), y, l, false);
                        if (!this.isFree(vEnd)) continue;
                        return this.makeReturnArg(vEnd, routingDirection, 1);
                    }
                }
            } else {
                for (int l = 0; l < MAXLAYER; ++l) {
                    if (!this.isCorrectOddEvenLayerForRoutingDirection(l, routingDirection)) continue;
                    for (int y = FindVirtualEnd_Simple.getLowIndexIn_Y(id) + 1; y < FindVirtualEnd_Simple.getHighIndexIn_Y(id) - 1; y += 10) {
                        Tupel vEnd = new Tupel(FindVirtualEnd_Simple.getLowIndexIn_X(id), y, l, false);
                        if (!this.isFree(vEnd)) continue;
                        return this.makeReturnArg(vEnd, routingDirection, -1);
                    }
                }
            }
        } else {
            boolean routingDirection = Y_DIRECTION;
            if (start.getY_InsideRoutingArray() <= ende.getY_InsideRoutingArray()) {
                for (int l = 0; l < MAXLAYER; ++l) {
                    if (!this.isCorrectOddEvenLayerForRoutingDirection(l, routingDirection)) continue;
                    for (int x = FindVirtualEnd_Simple.getLowIndexIn_X(id) + 1; x < FindVirtualEnd_Simple.getHighIndexIn_X(id) - 1; x += 10) {
                        Tupel vEnd = new Tupel(x, FindVirtualEnd_Simple.getHighIndexIn_Y(id), l, false);
                        if (!this.isFree(vEnd)) continue;
                        return this.makeReturnArg(vEnd, routingDirection, 1);
                    }
                }
            } else {
                for (int l = 0; l < MAXLAYER; ++l) {
                    if (!this.isCorrectOddEvenLayerForRoutingDirection(l, routingDirection)) continue;
                    for (int x = FindVirtualEnd_Simple.getLowIndexIn_X(id) + 1; x < FindVirtualEnd_Simple.getHighIndexIn_X(id) - 1; x += 10) {
                        Tupel vEnd = new Tupel(x, FindVirtualEnd_Simple.getLowIndexIn_Y(id), l, false);
                        if (!this.isFree(vEnd)) continue;
                        return this.makeReturnArg(vEnd, routingDirection, -1);
                    }
                }
            }
        }
        return new ConnectionPoints();
    }

    private Tupel getMiddlePoint(Tupel end) {
        return WorkerThread.getMiddlePoint(end);
    }

    private boolean isCorrectOddEvenLayerForRoutingDirection(int layer, boolean direction) {
        if (direction == X_DIRECTION && (layer + 1) % 2 == 1) {
            return true;
        }
        return direction == Y_DIRECTION && (layer + 1) % 2 == 0;
    }

    private ConnectionPoints makeReturnArg(Tupel pkt, boolean direction, int range2) {
        if (direction == X_DIRECTION) {
            return new ConnectionPoints(new Tupel(pkt.getX_InsideRoutingArray(), pkt.getY_InsideRoutingArray(), pkt.getLayer(), false), new Tupel(pkt.getX_InsideRoutingArray() + range2, pkt.getY_InsideRoutingArray(), pkt.getLayer(), false));
        }
        return new ConnectionPoints(new Tupel(pkt.getX_InsideRoutingArray(), pkt.getY_InsideRoutingArray(), pkt.getLayer(), false), new Tupel(pkt.getX_InsideRoutingArray(), pkt.getY_InsideRoutingArray() + range2, pkt.getLayer(), false));
    }

    private boolean isFree(Tupel t) {
        if (t.getX_InsideRoutingArray() >= 0 && t.getX_InsideRoutingArray() < WorkerThread.size_x && t.getY_InsideRoutingArray() >= 0 && t.getY_InsideRoutingArray() < WorkerThread.size_y && t.getLayer() >= 0 && t.getLayer() <= MAXLAYER) {
            return WorkerThread.regionBoundaries[t.getX_InsideRoutingArray()][t.getY_InsideRoutingArray()][t.getLayer()];
        }
        return false;
    }

    private static int getHighIndexIn_X(int rank) {
        return WorkPool.getHighIndexIn_X(rank);
    }

    private static int getHighIndexIn_Y(int rank) {
        return WorkPool.getHighIndexIn_Y(rank);
    }

    private static int getLowIndexIn_X(int rank) {
        return WorkPool.getLowIndexIn_X(rank);
    }

    private static int getLowIndexIn_Y(int rank) {
        return WorkPool.getLowIndexIn_Y(rank);
    }
}

