/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.simulation.test;

import com.sun.electric.tool.simulation.test.ChainControl;
import com.sun.electric.tool.simulation.test.ChainNode;
import com.sun.electric.tool.simulation.test.ChipNode;
import com.sun.electric.tool.simulation.test.MyTreeNode;
import com.sun.electric.tool.simulation.test.SubchainNode;
import com.sun.electric.tool.simulation.test.TestNode;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class ChainG
extends JFrame
implements TreeModelListener,
ChainNode.ShiftListener {
    static final int WIDTH = 1800;
    static final int HEIGHT = 600;
    ChainControl chainControl = null;
    String fileName = null;
    JTree treeLeft = null;
    DefaultTreeModel treeModel = null;
    JTextArea bitsTextArea;
    JTextArea logTextArea;
    JTextField pathText;
    JTextField systemComment;
    JTextField setInBitsText;
    JLabel labelPath;
    JLabel labelComment;
    JRadioButton outBitsButton;
    JRadioButton inBitsButton;
    JRadioButton outBitsExpButton;
    JButton setInBitsButton;
    JButton shiftButton;
    JCheckBox readEnable;
    JCheckBox writeEnable;

    public ChainG(String xml) {
        super("ChainG");
        this.createGUI();
        this.openFile(xml);
    }

    public ChainG(ChainControl cc) {
        super("ChainG");
        this.createGUI();
        this.setChainControl(cc);
    }

    private void openFile(String name) {
        if (name != null) {
            this.fileName = name;
            try {
                this.chainControl = new ChainControl(name);
            }
            catch (OutOfMemoryError e) {
                System.out.println("Out of memory, rerun with larger heap space using -Xmx1000m");
                System.exit(1);
            }
            if (this.chainControl != null) {
                this.chainControl.resetInBits();
            }
        }
        this.setChainControl(this.chainControl);
    }

    private void setChainControl(ChainControl control) {
        if (control != null) {
            this.chainControl = control;
            this.treeModel = new DefaultTreeModel(this.chainControl.getSystem());
            this.treeLeft.setModel(this.treeModel);
            this.treeModel.addTreeModelListener(this);
            MyTreeNode system = this.chainControl.getSystem();
            for (int i = 0; i < system.getChildCount(); ++i) {
                MyTreeNode anode = system.getChildAt(i);
                if (!(anode instanceof ChipNode)) continue;
                ChipNode chip = (ChipNode)anode;
                for (int j = 0; j < chip.getChildCount(); ++j) {
                    ChainNode chain2 = (ChainNode)chip.getChildAt(j);
                    chain2.addListener(this);
                }
            }
        } else {
            this.treeLeft.setModel(null);
        }
    }

    private void createGUI() {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        JComponent contentPane = (JComponent)this.getContentPane();
        this.treeLeft = new JTree();
        MyRenderer myRenderer = new MyRenderer();
        this.treeLeft.setCellRenderer(myRenderer);
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        JPanel paneLeft = new JPanel(gridbag);
        c.fill = 1;
        GridBagLayout gridbagTop = new GridBagLayout();
        JPanel displayPanel = new JPanel(gridbagTop);
        c.fill = 2;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 2;
        c.weightx = 1.0;
        c.weighty = 0.0;
        gridbag.setConstraints(displayPanel, c);
        paneLeft.add(displayPanel);
        c.fill = 1;
        JLabel showLabel = new JLabel("Show:", 2);
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        gridbagTop.setConstraints(showLabel, c);
        displayPanel.add(showLabel);
        this.outBitsButton = new JRadioButton("OutBits", true);
        c.gridx = 1;
        c.gridy = 0;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        gridbagTop.setConstraints(this.outBitsButton, c);
        displayPanel.add(this.outBitsButton);
        this.outBitsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChainG.this.displayButtonChanged();
            }
        });
        this.inBitsButton = new JRadioButton("InBits", true);
        c.gridx = 2;
        c.gridy = 0;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        gridbagTop.setConstraints(this.inBitsButton, c);
        displayPanel.add(this.inBitsButton);
        this.inBitsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChainG.this.displayButtonChanged();
            }
        });
        this.outBitsExpButton = new JRadioButton("OutBitsExp", true);
        c.gridx = 3;
        c.gridy = 0;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        gridbagTop.setConstraints(this.outBitsExpButton, c);
        displayPanel.add(this.outBitsExpButton);
        this.outBitsExpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChainG.this.displayButtonChanged();
            }
        });
        ButtonGroup bitsToShowGroup = new ButtonGroup();
        bitsToShowGroup.add(this.outBitsButton);
        bitsToShowGroup.add(this.inBitsButton);
        bitsToShowGroup.add(this.outBitsExpButton);
        this.outBitsButton.setSelected(true);
        JScrollPane scrollPaneLeft = new JScrollPane(this.treeLeft);
        scrollPaneLeft.setPreferredSize(new Dimension(900, 480));
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 2;
        c.weightx = 1.0;
        c.weighty = 1.0;
        gridbag.setConstraints(scrollPaneLeft, c);
        paneLeft.add(scrollPaneLeft);
        this.labelPath = new JLabel("Path", 0);
        c.fill = 2;
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        gridbag.setConstraints(this.labelPath, c);
        paneLeft.add(this.labelPath);
        this.labelComment = new JLabel(" Comment ", 0);
        c.gridx = 0;
        c.gridy = 3;
        gridbag.setConstraints(this.labelComment, c);
        paneLeft.add(this.labelComment);
        this.pathText = new JTextField();
        this.pathText.setEditable(false);
        c.gridx = 1;
        c.gridy = 2;
        c.weightx = 1.0;
        gridbag.setConstraints(this.pathText, c);
        paneLeft.add(this.pathText);
        this.systemComment = new JTextField();
        this.systemComment.setEditable(false);
        c.gridx = 1;
        c.gridy = 3;
        gridbag.setConstraints(this.systemComment, c);
        paneLeft.add(this.systemComment);
        this.setInBitsButton = new JButton("Set inBits to: ");
        this.setInBitsButton.setEnabled(false);
        c.gridx = 0;
        c.gridy = 4;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        gridbag.setConstraints(this.setInBitsButton, c);
        paneLeft.add(this.setInBitsButton);
        this.setInBitsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChainG.this.setSelectedInBits();
            }
        });
        this.setInBitsText = new JTextField();
        this.setInBitsText.setEditable(false);
        c.gridx = 1;
        c.gridy = 4;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        gridbag.setConstraints(this.setInBitsText, c);
        paneLeft.add(this.setInBitsText);
        this.shiftButton = new JButton("Shift Selected Chain");
        this.shiftButton.setEnabled(false);
        c.gridx = 0;
        c.gridy = 5;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        gridbag.setConstraints(this.shiftButton, c);
        paneLeft.add(this.shiftButton);
        this.shiftButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChainG.this.doShift();
            }
        });
        GridBagLayout gridbagSOP = new GridBagLayout();
        JPanel shiftOptionsPanel = new JPanel(gridbagSOP);
        c.gridx = 1;
        c.gridy = 5;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        gridbag.setConstraints(shiftOptionsPanel, c);
        paneLeft.add(shiftOptionsPanel);
        this.readEnable = new JCheckBox("read enable", false);
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        gridbagSOP.setConstraints(this.readEnable, c);
        shiftOptionsPanel.add(this.readEnable);
        this.writeEnable = new JCheckBox("write enable", false);
        c.gridx = 1;
        c.gridy = 0;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        gridbagSOP.setConstraints(this.writeEnable, c);
        shiftOptionsPanel.add(this.writeEnable);
        gridbag = new GridBagLayout();
        JPanel paneBottom = new JPanel(gridbag);
        c.fill = 1;
        this.bitsTextArea = new JTextArea(3, 10);
        this.bitsTextArea.setEditable(false);
        this.bitsTextArea.setLineWrap(true);
        JScrollPane scrollPaneBottom = new JScrollPane(this.bitsTextArea, 22, 31);
        scrollPaneBottom.setBorder(new TitledBorder("BitVector"));
        scrollPaneBottom.setBackground(Color.WHITE);
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 0.5;
        gridbag.setConstraints(scrollPaneBottom, c);
        paneBottom.add(scrollPaneBottom);
        this.logTextArea = new JTextArea(5, 10);
        this.logTextArea.setEditable(false);
        JScrollPane scrollPaneBottom2 = new JScrollPane(this.logTextArea, 22, 30);
        scrollPaneBottom2.setBorder(new TitledBorder("Log Window"));
        scrollPaneBottom2.setBackground(Color.WHITE);
        c.gridx = 0;
        c.gridy = 1;
        c.weightx = 1.0;
        c.weighty = 0.5;
        gridbag.setConstraints(scrollPaneBottom2, c);
        paneBottom.add(scrollPaneBottom2);
        JSplitPane splitPaneBottom = new JSplitPane(0, paneLeft, paneBottom);
        contentPane.add(splitPaneBottom);
        JMenuBar menuBar = new JMenuBar();
        this.setJMenuBar(menuBar);
        JMenu menu = new JMenu("File");
        menu.setMnemonic('f');
        menuBar.add(menu);
        JMenuItem menuItem = new JMenuItem("Open File");
        menuItem.setMnemonic('o');
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ChainG.this.openPressed();
            }
        });
        menu.add(menuItem);
        menuItem = new JMenuItem("Reopen");
        menuItem.setMnemonic('r');
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ChainG.this.reopenPressed();
            }
        });
        menu.add(menuItem);
        menu = new JMenu("Edit");
        menu.setMnemonic('e');
        menuBar.add(menu);
        menuItem = new JMenuItem("Copy");
        menuItem.setMnemonic('c');
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ChainG.this.copyPressed();
            }
        });
        menu.add(menuItem);
        this.treeLeft.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                ChainG.this.treeLeftSelChanged(e);
            }
        });
    }

    private void openPressed() {
        String file = this.getFileName(true);
        if (file == null) {
            return;
        }
        this.logOut("Opening: " + file);
        this.openFile(file);
    }

    private void reopenPressed() {
        this.logOut("Reopening: " + this.fileName);
        this.openFile(this.fileName);
    }

    protected String getFileName(boolean forOpen) {
        JFileChooser fc = new JFileChooser();
        fc.setCurrentDirectory(new File("."));
        int result2 = forOpen ? fc.showOpenDialog(this) : fc.showSaveDialog(this);
        File chosenFile = fc.getSelectedFile();
        if (result2 == 0 && chosenFile != null) {
            return chosenFile.getPath();
        }
        return null;
    }

    private void copyPressed() {
        this.logOut("copy not implemented");
    }

    private MyTreeNode getSelectedNode() {
        TreePath p = this.treeLeft.getSelectionPath();
        if (p != null) {
            return (MyTreeNode)p.getLastPathComponent();
        }
        return null;
    }

    private void treeLeftSelChanged(TreeSelectionEvent e) {
        MyTreeNode node = this.getSelectedNode();
        if (node != null) {
            if (node.getComment() != null) {
                this.systemComment.setText(node.getComment());
            } else {
                this.systemComment.setText("");
            }
            if (node.getClass() == ChainNode.class || node.getClass() == SubchainNode.class) {
                SubchainNode chainNode = (SubchainNode)node;
                this.bitsTextArea.setText("InBits:\t" + chainNode.getInBitsIndiscriminate().getState() + "\n" + "OutBits:\t" + chainNode.getOutBitsIndiscriminate().getState() + "\n" + "OutBitsExp:\t" + chainNode.getOldOutBitsExpected().getState());
                this.pathText.setText(chainNode.getPathString());
                this.setInBitsText.setText(chainNode.getInBitsIndiscriminate().getState());
            } else {
                this.bitsTextArea.setText("None Selected");
                this.pathText.setText("None Selected");
            }
        }
        this.updateButtonEnables();
    }

    private void updateButtonEnables() {
        MyTreeNode node;
        if (this.inBitsButton.isSelected() && (node = this.getSelectedNode()) instanceof SubchainNode) {
            this.setInBitsButton.setEnabled(true);
            this.setInBitsText.setEditable(true);
            this.shiftButton.setEnabled(true);
            this.readEnable.setEnabled(true);
            this.writeEnable.setEnabled(true);
            return;
        }
        this.setInBitsButton.setEnabled(false);
        this.setInBitsText.setEditable(false);
        this.shiftButton.setEnabled(false);
        this.readEnable.setEnabled(false);
        this.writeEnable.setEnabled(false);
    }

    private void displayButtonChanged() {
        if (this.treeModel != null) {
            this.treeModel.nodeChanged(this.chainControl.getSystem());
        }
        this.updateButtonEnables();
    }

    private void doShift() {
        if (this.chainControl.getJtag() == null) {
            JOptionPane.showMessageDialog(this, "No Jtag Tester specified in ChainControl", "Error", 0);
            return;
        }
        String path = this.pathText.getText();
        path = this.chainControl.getParentChain(path);
        this.shiftButton.setEnabled(false);
        this.shiftButton.setText("Shifting...");
        this.chainControl.shift(path, this.readEnable.isSelected(), this.writeEnable.isSelected(), 1, 1, 1);
    }

    @Override
    public void shiftCompleted(ChainNode node) {
        this.treeModel.nodeChanged(node);
        this.shiftButton.setText("Shift Selected Chain");
        this.updateButtonEnables();
    }

    private void setSelectedInBits() {
        MyTreeNode node = this.getSelectedNode();
        if (node instanceof SubchainNode) {
            int nodeLength;
            SubchainNode subchainNode = (SubchainNode)node;
            String newInBits = this.setInBitsText.getText().trim();
            int newBitsLength = newInBits.length();
            if (newBitsLength != (nodeLength = subchainNode.getInBitsIndiscriminate().getNumBits())) {
                JOptionPane.showMessageDialog(this, "Cannot set node of " + nodeLength + " bits to string of " + newBitsLength + " bits", "Error", 0);
                return;
            }
            subchainNode.setInBits(newInBits);
            this.treeLeftSelChanged(null);
            this.treeModel.nodeChanged(this.chainControl.getSystem());
        }
    }

    private ChainNode getParentChainNode(MyTreeNode node) {
        if (node instanceof ChainNode) {
            return (ChainNode)node;
        }
        while (node != null) {
            if (!((node = node.getParent()) instanceof ChainNode)) continue;
            return (ChainNode)node;
        }
        return null;
    }

    public static void main(String[] argv) {
        final String xml = argv.length >= 1 ? argv[0] : null;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ChainG.createAndShowGUI(xml);
            }
        });
    }

    public static void createAndShowGUI(ChainControl cc, String windowTitle) {
        ChainG mainFrame = new ChainG(cc);
        mainFrame.setTitle(windowTitle);
        mainFrame.pack();
        mainFrame.setVisible(true);
    }

    public static void createAndShowGUI(ChainControl cc) {
        ChainG.createAndShowGUI(cc, "Chip");
    }

    private static void createAndShowGUI(String xml) {
        ChainG mainFrame = new ChainG(xml);
        mainFrame.pack();
        mainFrame.setVisible(true);
    }

    @Override
    public void treeNodesChanged(TreeModelEvent e) {
        this.treeLeftSelChanged(null);
    }

    @Override
    public void treeNodesInserted(TreeModelEvent e) {
    }

    @Override
    public void treeNodesRemoved(TreeModelEvent e) {
    }

    @Override
    public void treeStructureChanged(TreeModelEvent e) {
    }

    public void logOut(String line) {
        if (this.logTextArea != null) {
            this.logTextArea.append(line + "\n");
        }
    }

    private class MyRenderer
    extends DefaultTreeCellRenderer {
        ImageIcon icon1 = new ImageIcon("icon/chip.gif");
        ImageIcon icon2 = new ImageIcon("icon/chain_root.gif");

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            if (value.getClass() == TestNode.class) {
                this.setIcon(null);
            } else if (value.getClass() == ChipNode.class) {
                this.setIcon(this.icon1);
            } else if (value.getClass() == ChainNode.class) {
                this.setIcon(this.icon2);
            }
            String state = "";
            if (value instanceof SubchainNode) {
                SubchainNode node = (SubchainNode)value;
                if (ChainG.this.inBitsButton.isSelected()) {
                    state = node.getInBitsIndiscriminate().getState();
                } else if (ChainG.this.outBitsButton.isSelected()) {
                    state = node.getOutBitsIndiscriminate().getState();
                } else if (ChainG.this.outBitsExpButton.isSelected()) {
                    state = node.getOldOutBitsExpected().getState();
                }
                this.setText(value.toString() + " " + state);
            }
            return this;
        }
    }
}

