/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.simulation.test;

import com.sun.electric.tool.simulation.test.BitVector;
import com.sun.electric.tool.simulation.test.BypassJtagTester;
import com.sun.electric.tool.simulation.test.ChainNode;
import com.sun.electric.tool.simulation.test.SimulationModel;

public class JtagSubchainTesterModel
extends BypassJtagTester {
    private final String phi2;
    private final String phi1;
    private final String write;
    private final String read;
    private final String sin;
    private final String sout;

    JtagSubchainTesterModel(SimulationModel vm, String jtagInBus, String jtagOutBus) {
        super(vm);
        int i = jtagInBus.indexOf(91);
        if (i != -1) {
            jtagInBus = jtagInBus.substring(0, i);
        }
        this.phi2 = jtagInBus + "[2]";
        this.phi1 = jtagInBus + "[3]";
        this.write = jtagInBus + "[4]";
        this.read = jtagInBus + "[5]";
        this.sin = jtagInBus + "[1]";
        if (jtagOutBus != null && !jtagOutBus.equals("")) {
            i = jtagOutBus.indexOf(91);
            if (i != -1) {
                jtagOutBus = jtagOutBus.substring(0, i);
            }
            this.sout = jtagOutBus + "[1]";
        } else {
            this.sout = jtagInBus + "[8]";
        }
        this.configure((float)vm.getVdd(), 100000L);
    }

    JtagSubchainTesterModel(SimulationModel vm, String phi2, String phi1, String write, String read, String sin, String sout) {
        super(vm);
        this.phi2 = phi2;
        this.phi1 = phi1;
        this.write = write;
        this.read = read;
        this.sin = sin;
        this.sout = sout;
        this.configure((float)vm.getVdd(), 100000L);
    }

    @Override
    public void reset() {
        this.model.setNodeState(this.phi2, 1);
        this.model.setNodeState(this.phi1, 0);
        this.model.setNodeState(this.write, 0);
        this.model.setNodeState(this.read, 0);
        this.model.setNodeState(this.sin, 0);
    }

    @Override
    public void tms_reset() {
        this.reset();
    }

    @Override
    void shift(ChainNode chain2, boolean readEnable, boolean writeEnable, int irBadSeverity) {
        if (this.isBypassScanning()) {
            this.doBypassScanning(chain2, readEnable, writeEnable);
            return;
        }
        if (readEnable) {
            this.model.setNodeState(this.read, 1);
            this.model.waitNS(this.delay * 4.0);
            this.model.setNodeState(this.read, 0);
            this.model.waitNS(this.delay * 2.0);
        }
        BitVector in = chain2.getInBits();
        BitVector out = new BitVector(in.getNumBits(), "scannedOut");
        for (int i = in.getNumBits() - 1; i >= 0; --i) {
            int state = this.model.getNodeState(this.sout);
            if (state != 1 && state != 0) {
                System.out.println("Invalid state " + state + " scanned out, setting it to zero");
                state = 0;
            }
            out.set(i, state != 0);
            state = in.get(i) ? 1 : 0;
            this.model.setNodeState(this.sin, state);
            this.cycleClks(1);
        }
        chain2.getOutBits().put(0, out);
        if (writeEnable) {
            this.model.setNodeState(this.write, 1);
            this.model.waitNS(this.delay * 4.0);
            this.model.setNodeState(this.write, 0);
            this.model.waitNS(this.delay * 2.0);
            BitVector bitsToCheck = new BitVector(chain2.getInBits().getNumBits(), "bitsToCheck");
            bitsToCheck.set(0, chain2.getInBits().getNumBits(), true);
            this.checkDataNets(chain2, 0, bitsToCheck);
            this.checkDataNets(chain2, 1, bitsToCheck);
        }
    }

    private void cycleClks(int times) {
        for (int i = 0; i < times; ++i) {
            this.model.waitNS(this.delay * 0.45);
            this.model.setNodeState(this.phi2, 0);
            this.model.waitNS(this.delay * 0.05);
            this.model.setNodeState(this.phi1, 1);
            this.model.waitNS(this.delay * 0.95);
            this.model.setNodeState(this.phi1, 0);
            this.model.waitNS(this.delay * 0.05);
            this.model.setNodeState(this.phi2, 1);
            this.model.waitNS(this.delay * 0.5);
        }
    }
}

