/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.util.concurrent.datastructures;

import com.sun.electric.tool.util.concurrent.datastructures.IDEStructure;
import com.sun.electric.tool.util.concurrent.utils.ConcurrentCollectionFactory;
import java.util.List;
import java.util.concurrent.atomic.AtomicStampedReference;

public class BDEQueue<T>
extends IDEStructure<T> {
    private List<T> objects = ConcurrentCollectionFactory.createArrayList();
    private volatile int bottom;
    private AtomicStampedReference<Integer> top = new AtomicStampedReference<Integer>(0, 0);
    private int capacity;
    private volatile int amount;

    public BDEQueue(int capacity) {
        this.capacity = capacity;
        this.bottom = 0;
        this.amount = 0;
    }

    @Override
    public T getFromTop() {
        int[] stamp = new int[1];
        int oldTop = this.top.get(stamp);
        int newTop = oldTop + 1;
        int oldStamp = stamp[0];
        int newStamp = oldStamp + 1;
        if (this.bottom <= oldTop) {
            return null;
        }
        T tmp = this.objects.get(oldTop);
        if (this.top.compareAndSet(oldTop, newTop, oldStamp, newStamp)) {
            --this.amount;
            return tmp;
        }
        return null;
    }

    @Override
    public void add(T item) {
        this.tryAdd(item);
    }

    @Override
    public boolean isEmpty() {
        return this.top.getReference() >= this.bottom;
    }

    @Override
    public T remove() {
        if (this.bottom == 0) {
            return null;
        }
        --this.bottom;
        T tmp = this.objects.get(this.bottom);
        int[] stamp = new int[1];
        int oldTop = this.top.get(stamp);
        int newTop = oldTop + 1;
        int oldStamp = stamp[0];
        int newStamp = oldStamp + 1;
        if (this.bottom > oldTop) {
            --this.amount;
            return tmp;
        }
        if (this.bottom == oldTop) {
            this.bottom = 0;
            if (this.top.compareAndSet(oldTop, newTop, oldStamp, newStamp)) {
                --this.amount;
                return tmp;
            }
        }
        this.top.set(newTop, newStamp);
        return null;
    }

    @Override
    public boolean isFull() {
        return this.amount == this.capacity;
    }

    @Override
    public boolean tryAdd(T item) {
        if (this.isFull()) {
            return false;
        }
        this.objects.add(item);
        ++this.bottom;
        ++this.amount;
        return true;
    }
}

