/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.util.concurrent.runtime.pipeline;

import com.sun.electric.tool.util.concurrent.datastructures.IStructure;
import com.sun.electric.tool.util.concurrent.debug.Debug;
import com.sun.electric.tool.util.concurrent.runtime.pipeline.PipelineWorkerStrategy;
import com.sun.electric.tool.util.concurrent.runtime.pipeline.SimplePipelineWorker;
import com.sun.electric.tool.util.concurrent.utils.ConcurrentCollectionFactory;
import java.util.List;

public class PipelineRuntime<PipeIn, PipeOut> {
    private List<Thread> threads = ConcurrentCollectionFactory.createLinkedList();
    private List<Stage<?, ?>> stages = ConcurrentCollectionFactory.createLinkedList();

    public void input(PipeIn input2) {
        this.stages.get(0).send(input2);
    }

    public <Input, Output> void addStage(StageImpl<Input, Output> impl, int numOfWorkers) {
        Stage stage = new Stage(numOfWorkers);
        for (int i = 0; i < numOfWorkers; ++i) {
            try {
                PipelineWorkerStrategy strategy = PipelineRuntime.createPipelineWorker(PipelineWorkerStrategyType.simple, stage, (StageImpl)impl.clone());
                Thread thread = new Thread((Runnable)strategy, "StageID" + this.stages.size() + "_" + i);
                thread.start();
                this.threads.add(thread);
                stage.getWorkers().add(strategy);
                continue;
            }
            catch (CloneNotSupportedException e) {
                e.printStackTrace();
            }
        }
        this.stages.add(stage);
        if (this.stages.size() > 1) {
            ((Stage)this.stages.get(this.stages.size() - 2)).next = stage;
        }
        if (Debug.isDebug()) {
            System.out.println("Stage added: " + (this.stages.size() - 1) + "/" + numOfWorkers);
        }
    }

    public void shutdown() throws InterruptedException {
        for (Stage<?, ?> stage : this.stages) {
            stage.shutdown();
        }
        for (Thread thread : this.threads) {
            thread.join();
        }
        if (Debug.isDebug()) {
            System.out.println("Pipeline shutdown");
        }
    }

    public static <Input, Output> PipelineWorkerStrategy createPipelineWorker(PipelineWorkerStrategyType type, Stage<Input, Output> stage, StageImpl<Input, Output> impl) {
        if (type == PipelineWorkerStrategyType.simple) {
            return new SimplePipelineWorker<Input, Output>(stage, impl);
        }
        return null;
    }

    public static abstract class StageImpl<Input, Output>
    implements Cloneable {
        public abstract Output execute(Input var1);

        public Object clone() throws CloneNotSupportedException {
            return super.clone();
        }
    }

    public static class Stage<Input, Output> {
        private IStructure<Input> inputQueue = ConcurrentCollectionFactory.createLockFreeQueue();
        private List<PipelineWorkerStrategy> workers = ConcurrentCollectionFactory.createLinkedList();
        private Stage<?, ?> next;

        public Stage(int numOfWorkers) {
        }

        public void send(Object item) {
            this.inputQueue.add(item);
        }

        public void forward(Object item) {
            if (this.next != null) {
                this.next.send(item);
            }
        }

        public Input recv() {
            return this.inputQueue.remove();
        }

        public void setWorkers(List<PipelineWorkerStrategy> workers) {
            this.workers = workers;
        }

        public List<PipelineWorkerStrategy> getWorkers() {
            return this.workers;
        }

        public void shutdown() {
            for (PipelineWorkerStrategy strategy : this.workers) {
                strategy.shutdown();
            }
        }

        public void setNext(Stage<?, ?> next2) {
            this.next = next2;
        }

        public Stage<?, ?> getNext() {
            return this.next;
        }
    }

    public static enum PipelineWorkerStrategyType {
        simple;

    }
}

