/*
 * Decompiled with CFR 0.152.
 */
package kawa.standard;

import gnu.bytecode.ClassType;
import gnu.bytecode.Field;
import gnu.bytecode.Method;
import gnu.bytecode.Type;
import gnu.expr.ApplyExp;
import gnu.expr.Compilation;
import gnu.expr.Declaration;
import gnu.expr.Expression;
import gnu.expr.Language;
import gnu.expr.ModuleExp;
import gnu.expr.ModuleInfo;
import gnu.expr.ModuleManager;
import gnu.expr.QuoteExp;
import gnu.expr.ReferenceExp;
import gnu.expr.ScopeExp;
import gnu.expr.SetExp;
import gnu.kawa.reflect.Invoke;
import gnu.kawa.reflect.SlotGet;
import gnu.lists.FString;
import gnu.lists.LList;
import gnu.lists.Pair;
import gnu.mapping.InPort;
import gnu.mapping.Symbol;
import gnu.text.SourceMessages;
import gnu.text.SyntaxException;
import gnu.text.URI_utils;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Hashtable;
import java.util.Vector;
import kawa.lang.Syntax;
import kawa.lang.Translator;
import kawa.standard.Scheme;

public class require
extends Syntax {
    public static final require require = new require();
    static Hashtable featureMap;
    private static final String SLIB_PREFIX = "gnu.kawa.slib.";

    static void map(String featureName, String className) {
        featureMap.put(featureName, className);
    }

    public static String mapFeature(String featureName) {
        return (String)featureMap.get(featureName);
    }

    public static Object find(String typeName) {
        return ModuleInfo.find(typeName).getInstance();
    }

    public boolean scanForDefinitions(Pair st, Vector forms, ScopeExp defs, Translator tr) {
        Type type;
        block15: {
            String str;
            int len;
            Object name;
            Pair args;
            block12: {
                Pair p;
                block14: {
                    block13: {
                        if (tr.getState() == 1) {
                            tr.setState(2);
                            tr.pendingForm = st;
                            return true;
                        }
                        args = (Pair)st.cdr;
                        name = args.car;
                        type = null;
                        if (!(name instanceof Pair)) break block12;
                        p = (Pair)name;
                        if (!tr.matches(p.car, "quote")) break block12;
                        name = p.cdr;
                        if (!(name instanceof Pair)) break block13;
                        p = (Pair)name;
                        if (p.cdr == LList.Empty && p.car instanceof String) break block14;
                    }
                    tr.error('e', "invalid quoted symbol for 'require'");
                    return false;
                }
                name = kawa.standard.require.mapFeature((String)p.car);
                if (name == null) {
                    tr.error('e', "unknown feature name '" + p.car + "' for 'require'");
                    return false;
                }
                type = ClassType.make((String)name);
                break block15;
            }
            if (name instanceof FString) {
                String sourceName = name.toString();
                ModuleInfo info = kawa.standard.require.lookupModuleFromSourcePath(sourceName, defs);
                if (info == null) {
                    tr.error('e', "malformed URL: " + sourceName);
                    return false;
                }
                return kawa.standard.require.importDefinitions(null, info, null, forms, defs, tr);
            }
            if (name instanceof String && (len = (str = (String)name).length()) > 2 && str.charAt(0) == '<' && str.charAt(len - 1) == '>') {
                if ((str = str.substring(1, len - 1)).indexOf(46) < 0) {
                    str = tr.classPrefix + str;
                }
                if (args.cdr instanceof Pair && ((Pair)args.cdr).car instanceof FString) {
                    String sourceName = ((Pair)args.cdr).car.toString();
                    ModuleInfo info = kawa.standard.require.lookupModuleFromSourcePath(sourceName, defs);
                    if (info == null) {
                        tr.error('e', "malformed URL: " + sourceName);
                        return false;
                    }
                    return kawa.standard.require.importDefinitions(str, info, null, forms, defs, tr);
                }
                type = Scheme.string2Type(str);
            }
        }
        if (type == null) {
            tr.error('e', "invalid specifier for 'require'");
            return false;
        }
        kawa.standard.require.importDefinitions(null, ModuleInfo.find(type), null, forms, defs, tr);
        return true;
    }

    public static ModuleInfo lookupModuleFromSourcePath(String sourceName, ScopeExp defs) {
        ModuleManager manager = ModuleManager.getInstance();
        try {
            sourceName = URI_utils.resolve(sourceName, defs.getFileName()).toString();
        }
        catch (URISyntaxException ex) {
            return null;
        }
        return manager.findWithSourcePath(sourceName);
    }

    public static boolean importDefinitions(String className, ModuleInfo info, String uri, Vector forms, ScopeExp defs, Compilation tr) {
        long now;
        ModuleManager manager = ModuleManager.getInstance();
        String sourceName = info.sourcePath;
        if ((info.getState() & 1) == 0 && sourceName != null && !info.checkCurrent(manager, now = System.currentTimeMillis())) {
            Compilation comp;
            SourceMessages messages = tr.getMessages();
            Language language = Language.getDefaultLanguage();
            try {
                InPort fstream = InPort.openFile(info.sourceAbsPath);
                info.clearClass();
                info.className = className;
                comp = language.parse(fstream, messages, info);
                comp.immediate = tr.immediate;
            }
            catch (FileNotFoundException ex) {
                tr.error('e', "not found: " + ex.getMessage());
                return false;
            }
            catch (IOException ex) {
                tr.error('e', "caught " + ex);
                return false;
            }
            catch (SyntaxException ex) {
                if (ex.getMessages() != messages) {
                    throw new RuntimeException("confussing syntax error: " + ex);
                }
                return false;
            }
            ModuleExp mexp = comp.getModule();
            ClassType ctype = mexp.classFor(comp);
            info.className = ctype.getName();
        }
        if (tr.minfo != null && tr.getState() < 4) {
            tr.minfo.addDependency(info);
            if (!info.loadEager(12) && info.getState() < 6) {
                tr.pushPendingImport(info, defs);
                return true;
            }
        }
        ClassType type = info.getClassType();
        String tname = info.className;
        boolean immediate = tr.immediate && defs instanceof ModuleExp;
        boolean isRunnable = info.getState() < 6 || type.isSubtype(Compilation.typeRunnable);
        Declaration decl = null;
        ClassType thisType = ClassType.make("kawa.standard.require");
        Expression[] args = new Expression[]{new QuoteExp((Object)tname)};
        Expression dofind = Invoke.makeInvokeStatic(thisType, "find", args);
        Field instanceField = null;
        Language language = tr.getLanguage();
        dofind.setLine(tr);
        int formsStart = forms.size();
        ModuleExp mod = info.setupModuleExp();
        Vector<Declaration> declPairs = new Vector<Declaration>();
        for (Declaration fdecl = mod.firstDecl(); fdecl != null; fdecl = fdecl.nextDecl()) {
            Declaration adecl;
            Object aname;
            String fname;
            Object fdname = fdecl.getSymbol();
            boolean isStatic = fdecl.getFlag(2048);
            if (!isStatic && decl == null) {
                String iname = tname.replace('.', '$') + "$instance";
                decl = new Declaration((Object)iname.intern(), type);
                if (!immediate) {
                    decl.setPrivate(true);
                }
                decl.setFlag(0x40004000);
                defs.addDeclaration(decl);
                decl.noteValue(dofind);
                SetExp sexp = new SetExp(decl, dofind);
                sexp.setLine(tr);
                sexp.setDefining(true);
                forms.addElement(sexp);
                formsStart = forms.size();
                decl.setFlag(0x20000000);
                if (isRunnable) {
                    decl.setSimple(false);
                }
                decl.setFlag(8192);
            }
            if (fdecl.isPrivate()) continue;
            if (fdecl.field != null && (fname = fdecl.field.getName()).equals("$instance")) {
                instanceField = fdecl.field;
                continue;
            }
            if (fdname instanceof Symbol) {
                aname = fdname;
            } else {
                String sname = fdname.toString();
                aname = uri == null ? sname.intern() : Symbol.make(uri, sname);
            }
            boolean isImportedInstance = fdecl.field != null && fdecl.field.getName().endsWith("$instance");
            Declaration old = defs.lookup(aname, language, language.getNamespaceOf(fdecl));
            if (isImportedInstance) {
                if (old != null) continue;
                adecl = defs.addDeclaration(aname);
                adecl.setFlag(0x40004000);
                adecl.setType(fdecl.getType());
                adecl.setFlag(8192);
            } else {
                if (old != null && !old.getFlag(512) && Declaration.followAliases(old) == Declaration.followAliases(fdecl)) continue;
                if (old != null && old.getFlag(66048)) {
                    old.setFlag(false, 66048);
                    adecl = old;
                } else {
                    adecl = defs.addDeclaration(aname);
                    if (old != null) {
                        ScopeExp.duplicateDeclarationError(old, adecl, tr);
                    }
                }
                adecl.setAlias(true);
                adecl.setIndirectBinding(true);
            }
            adecl.setLocation(tr);
            ReferenceExp fref = new ReferenceExp(fdecl);
            fref.setContextDecl(decl);
            if (!isImportedInstance) {
                fref.setDontDereference(true);
                fref.setFlag(8);
                if (!immediate) {
                    adecl.setPrivate(true);
                }
            }
            if (fdecl.getFlag(16384)) {
                adecl.setFlag(16384);
            }
            if (fdecl.getFlag(32768)) {
                adecl.setFlag(32768);
            }
            if (fdecl.isProcedureDecl()) {
                adecl.setProcedureDecl(true);
            }
            if (isStatic) {
                adecl.setFlag(2048);
            }
            SetExp sexp = new SetExp(adecl, (Expression)fref);
            adecl.setFlag(0x20000000);
            sexp.setDefining(true);
            if (isImportedInstance) {
                forms.insertElementAt(sexp, formsStart);
                ++formsStart;
            } else {
                forms.addElement(sexp);
            }
            declPairs.add(adecl);
            declPairs.add(fdecl);
            adecl.noteValue(fref);
            adecl.setFlag(131072);
            tr.push(adecl);
        }
        int ndecls = declPairs.size();
        for (int i = 0; i < ndecls; i += 2) {
            Declaration adecl = (Declaration)declPairs.elementAt(i);
            Declaration fdecl = (Declaration)declPairs.elementAt(i + 1);
            Expression fval = fdecl.getValue();
            if (!fdecl.isIndirectBinding() || !(fval instanceof ReferenceExp)) continue;
            ReferenceExp aref = (ReferenceExp)adecl.getValue();
            Declaration xdecl = ((ReferenceExp)fval).getBinding();
            aref.setBinding(xdecl);
            if (!xdecl.needsContext()) continue;
            String iname = xdecl.field.getDeclaringClass().getName().replace('.', '$') + "$instance";
            Declaration cdecl = defs.lookup(iname.intern());
            cdecl.setFlag(1024);
            aref.setContextDecl(cdecl);
        }
        if (isRunnable) {
            Method run = Compilation.typeRunnable.getDeclaredMethod("run", 0);
            if (decl != null) {
                dofind = new ReferenceExp(decl);
            } else if (instanceField != null) {
                args = new Expression[]{new QuoteExp(type), new QuoteExp((Object)"$instance")};
                dofind = new ApplyExp(SlotGet.staticField, args);
            }
            dofind = new ApplyExp(run, new Expression[]{dofind});
            dofind.setLine(tr);
            forms.addElement(dofind);
        }
        tr.mustCompileHere();
        return true;
    }

    public Expression rewriteForm(Pair form, Translator tr) {
        return null;
    }

    static {
        require.setName("require");
        featureMap = new Hashtable();
        kawa.standard.require.map("generic-write", "gnu.kawa.slib.genwrite");
        kawa.standard.require.map("pretty-print", "gnu.kawa.slib.pp");
        kawa.standard.require.map("pprint-file", "gnu.kawa.slib.ppfile");
        kawa.standard.require.map("printf", "gnu.kawa.slib.printf");
        kawa.standard.require.map("xml", "gnu.kawa.slib.XML");
        kawa.standard.require.map("readtable", "gnu.kawa.slib.readtable");
        kawa.standard.require.map("srfi-10", "gnu.kawa.slib.readtable");
        kawa.standard.require.map("http", "gnu.kawa.servlet.HTTP");
        kawa.standard.require.map("srfi-1", "gnu.kawa.slib.srfi1");
        kawa.standard.require.map("list-lib", "gnu.kawa.slib.srfi1");
        kawa.standard.require.map("srfi-34", "gnu.kawa.slib.srfi34");
        kawa.standard.require.map("srfi-35", "gnu.kawa.slib.conditions");
        kawa.standard.require.map("condition", "gnu.kawa.slib.conditions");
        kawa.standard.require.map("conditions", "gnu.kawa.slib.conditions");
        kawa.standard.require.map("srfi-37", "gnu.kawa.slib.srfi37");
        kawa.standard.require.map("args-fold", "gnu.kawa.slib.srfi37");
        kawa.standard.require.map("srfi-64", "gnu.kawa.slib.testing");
        kawa.standard.require.map("testing", "gnu.kawa.slib.testing");
        kawa.standard.require.map("srfi-69", "gnu.kawa.slib.srfi69");
        kawa.standard.require.map("hash-table", "gnu.kawa.slib.srfi69");
        kawa.standard.require.map("gui", "gnu.kawa.slib.gui");
        kawa.standard.require.map("swing-gui", "gnu.kawa.slib.swing");
    }
}

