/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.bytecode.ClassType;
import gnu.bytecode.CodeAttr;
import gnu.bytecode.Method;
import gnu.bytecode.Type;
import gnu.bytecode.Variable;
import gnu.expr.Compilation;
import gnu.expr.Declaration;
import gnu.expr.Expression;
import gnu.expr.Initializer;
import gnu.expr.Literal;
import gnu.expr.QuoteExp;
import gnu.expr.StackTarget;
import gnu.expr.Target;
import gnu.mapping.EnvironmentKey;
import gnu.mapping.Namespace;
import gnu.mapping.Symbol;

public class BindingInitializer
extends Initializer {
    Declaration decl;
    Expression value;
    static final Method makeSymbolMethod = Compilation.typeSymbol.getDeclaredMethod("makeUninterned", 1);

    public static void create(Declaration declaration, Expression expression, Compilation compilation) {
        BindingInitializer bindingInitializer = new BindingInitializer(declaration, expression);
        if (declaration.field != null && declaration.field.getStaticFlag()) {
            bindingInitializer.next = compilation.clinitChain;
            compilation.clinitChain = bindingInitializer;
        } else {
            bindingInitializer.next = compilation.mainLambda.initChain;
            compilation.mainLambda.initChain = bindingInitializer;
        }
    }

    public BindingInitializer(Declaration declaration, Expression expression) {
        this.decl = declaration;
        this.value = expression;
        this.field = declaration.field;
    }

    public void emit(Compilation compilation) {
        Literal literal;
        Object object2;
        CodeAttr codeAttr = compilation.getCode();
        if (this.value instanceof QuoteExp && (object2 = ((QuoteExp)this.value).getValue()) != null && !(object2 instanceof String)) {
            literal = compilation.litTable.findLiteral(object2);
            if (literal.field == this.field) {
                return;
            }
        }
        if (this.field != null && !this.field.getStaticFlag()) {
            codeAttr.emitPushThis();
        }
        if (this.value == null) {
            boolean bl = compilation.getLanguage().hasSeparateFunctionNamespace();
            literal = bl && this.decl.isProcedureDecl() ? EnvironmentKey.FUNCTION : null;
            Object object3 = this.decl.getSymbol();
            if (this.decl.isAlias()) {
                compilation.compileConstant(object3, Target.pushObject);
                codeAttr.emitInvokeStatic(BindingInitializer.makeLocationMethod(object3));
            } else {
                ClassType classType = ClassType.make("gnu.mapping.ThreadLocation");
                if (this.decl.getFlag(0x10010010)) {
                    if (object3 instanceof String) {
                        object3 = Namespace.EmptyNamespace.getSymbol((String)object3);
                    }
                    compilation.compileConstant(object3, Target.pushObject);
                    if (literal == null) {
                        codeAttr.emitPushNull();
                    } else {
                        compilation.compileConstant(literal, Target.pushObject);
                    }
                    codeAttr.emitInvokeStatic(classType.getDeclaredMethod("getInstance", 2));
                } else {
                    if (object3 != null) {
                        object3 = object3.toString();
                    }
                    compilation.compileConstant(object3, Target.pushObject);
                    codeAttr.emitInvokeStatic(classType.getDeclaredMethod("makePrivate", 1));
                }
            }
        } else {
            object2 = this.field == null ? this.decl.getType() : this.field.getType();
            this.value.compileWithPosition(compilation, StackTarget.getInstance((Type)object2));
        }
        if (this.field == null) {
            Variable variable = this.decl.getVariable();
            if (variable == null) {
                variable = this.decl.allocateVariable(codeAttr);
            }
            codeAttr.emitStore(variable);
        } else if (this.field.getStaticFlag()) {
            codeAttr.emitPutStatic(this.field);
        } else {
            codeAttr.emitPutField(this.field);
        }
    }

    public static Method makeLocationMethod(Object object2) {
        Type[] typeArray = new Type[]{object2 instanceof Symbol ? Compilation.typeSymbol : Type.string_type};
        return Compilation.typeLocation.getDeclaredMethod("make", typeArray);
    }
}

