/*
 * Decompiled with CFR 0.152.
 */
package gnu.mapping;

import gnu.expr.Keyword;
import gnu.kawa.util.HeapSort;
import gnu.lists.Consumer;
import gnu.lists.EmptyList;
import gnu.lists.LList;
import gnu.lists.Pair;
import gnu.mapping.ArgList;
import gnu.mapping.ArgListBuilder;
import gnu.mapping.ArgListImpl;
import gnu.mapping.ArgListPair;
import gnu.mapping.ArgListVector;
import gnu.mapping.Procedure;
import gnu.mapping.ValueStack;
import gnu.mapping.Values;
import gnu.mapping.WrongArguments;
import gnu.mapping.WrongType;
import java.lang.invoke.MethodHandle;

public class CallContext
extends ArgListImpl
implements ArgList,
ArgListBuilder {
    static ThreadLocal currentContext = new ThreadLocal();
    public MethodHandle applyMethod;
    public Procedure proc;
    private ValueStack vstack = new ValueStack();
    public Consumer consumer = this.vstack;
    public int next;
    int matchState;
    public static final int MATCH_THROW_ON_EXCEPTION = 0;
    public static final int MATCH_CHECK = 1;
    public static final int MATCH_CHECK_ONLY = 2;
    static final KeywordSorter keywordSorter = new KeywordSorter();
    int nextKeyword;
    public Object[][] evalFrames;
    int consumerOnPushArgState;

    public static void setInstance(CallContext ctx) {
        Thread thread2 = Thread.currentThread();
        currentContext.set(ctx);
    }

    public static CallContext getOnlyInstance() {
        return (CallContext)currentContext.get();
    }

    public static CallContext getInstance() {
        CallContext ctx = CallContext.getOnlyInstance();
        if (ctx == null) {
            ctx = new CallContext();
            CallContext.setInstance(ctx);
        }
        return ctx;
    }

    public final void setNextProcedure(Procedure proc, MethodHandle apply) {
        this.proc = proc;
        this.applyMethod = apply;
    }

    public final void setNextProcedure(Procedure proc) {
        this.proc = proc;
        this.applyMethod = proc == null ? null : proc.applyToConsumerMethod;
    }

    @Override
    public Object getArgAsObject(int i) {
        return this.values[i];
    }

    public void rewind(int mode) {
        this.matchState = mode;
        this.rewind();
    }

    public void rewind() {
        this.next = 0;
        this.nextKeyword = 0;
    }

    public void reset() {
        super.clear();
        this.rewind(0);
    }

    public void shiftArgs(Procedure proc, int toDrop) {
        super.shiftArgs(toDrop);
        this.rewind();
        this.setNextProcedure(proc);
    }

    public int getMode() {
        return this.matchState;
    }

    public void matchError(int code) {
        if (this.matchState == 0) {
            short arg = (short)code;
            if ((code &= 0xFFFF0000) == -983040 || code == -917504) {
                WrongArguments wr = new WrongArguments(this.proc, this.getArgCount());
                System.err.println("before WrongArgs code:" + Integer.toHexString(code) + " proc:" + this.proc + (this.proc == null ? "" : " max:" + this.proc.maxArgs()) + " nargs:" + this.getArgCount() + " wr.m:" + wr.getMessage() + " wr:" + wr + " next:" + this.next + " count:" + this.count + " firstK:" + this.firstKeyword + " numK:" + this.numKeywords + " nextK:" + this.nextKeyword);
                throw wr;
            }
            if (code == -720896) {
                String pname;
                StringBuilder mbuf = new StringBuilder();
                String string = pname = this.proc == null ? null : this.proc.getName();
                if (pname == null) {
                    mbuf.append("call has ");
                } else {
                    mbuf.append("call to ");
                    mbuf.append(pname);
                    mbuf.append(" has ");
                }
                if (this.keywords == null || this.numKeywords <= arg) {
                    mbuf.append("unexpected keyword");
                } else {
                    if (this.sortedKeywords != null && this.nextKeyword > 0 && arg == this.sortedKeywords[this.nextKeyword] && this.keywords[arg] == this.keywords[this.sortedKeywords[this.nextKeyword - 1]]) {
                        mbuf.append("duplicated keyword '");
                    } else {
                        mbuf.append("unexpected keyword '");
                    }
                    mbuf.append(this.keywords[arg]);
                    mbuf.append('\'');
                }
                throw new IllegalArgumentException(mbuf.toString());
            }
            if (code == -655360) {
                throw new IllegalArgumentException("guard evaluated to false");
            }
            throw new WrongType(this.proc, (int)arg, arg >= 0 ? this.getArgAsObject(arg) : null);
        }
        if (this.matchState == 1 || this.matchState == 2) {
            this.matchState = code;
        }
    }

    public boolean haveArg() {
        return this.next < this.count && (this.next != this.firstKeyword || this.numKeywords == 0);
    }

    public void checkKeywordsDone() {
        if (this.next == this.count) {
            return;
        }
        if (this.nextKeyword < this.numKeywords) {
            short keywordIndex = this.sortedKeywords == null ? (short)0 : this.sortedKeywords[this.nextKeyword];
            this.matchError(0xFFF50000 | keywordIndex);
            this.nextKeyword = this.numKeywords;
        }
        if (this.numKeywords > 0) {
            this.next = this.firstKeyword + this.numKeywords;
        }
    }

    public int checkDone() {
        if (this.numKeywords > 0) {
            this.checkKeywordsDone();
        }
        if (this.next != this.count) {
            this.matchError(0xFFF20000 | this.next);
        } else if (this.matchState == 0 || this.matchState == 1) {
            return 0;
        }
        return this.matchState;
    }

    public int getArgCount() {
        return this.count;
    }

    public Object getNextArg() {
        if (this.next >= this.count) {
            this.matchError(0xFFF10000 | this.next);
            return null;
        }
        if (this.next == this.firstKeyword && this.numKeywords != 0) {
            this.matchError(-720896);
            return null;
        }
        return this.getArgAsObject(this.next++);
    }

    public Object getNextArg(Object defaultValue) {
        if (!this.haveArg()) {
            return defaultValue;
        }
        return this.getArgAsObject(this.next++);
    }

    public final Object[] getRestPlainArray() {
        int numKeys = this.numKeywords();
        int firstKey = this.firstKeyword();
        if (this.next >= firstKey + numKeys || numKeys == 0) {
            return this.getRestArgsArray();
        }
        if (this.next <= firstKey) {
            Object[] args = new Object[firstKey - this.next];
            int i = 0;
            while (this.next < firstKey) {
                args[i++] = this.getArgAsObject(this.next++);
            }
            return args;
        }
        return new Object[0];
    }

    public final Object[] getRestArgsArray() {
        Object[] arr = this.getRestArgsArray(this.next);
        this.next = this.count;
        return arr;
    }

    public final Object[] getRestArgsArray(int next) {
        int numKeys = this.numKeywords();
        int skipKeys = next - this.firstKeyword();
        if (skipKeys > 0 && skipKeys <= numKeys) {
            numKeys -= skipKeys;
        }
        int sz = this.count - next;
        Object[] args = new Object[this.count - next + numKeys];
        int i = 0;
        while (next < this.count) {
            String key = this.getKeyword(next);
            if (key != null) {
                args[i++] = Keyword.make(key);
            }
            args[i++] = this.getArgAsObject(next++);
        }
        return args;
    }

    public final LList peekRestArgsList() {
        return this.getRestArgsList(this.next);
    }

    public final ArgListVector getRestArgsVector() {
        ArgListVector args = this.getRestArgsVector(this.next);
        this.next = this.count;
        this.nextKeyword = this.numKeywords;
        return args;
    }

    public final LList getRestArgsList() {
        LList lst = this.getRestArgsList(this.next);
        this.next = this.count;
        this.nextKeyword = this.numKeywords;
        return lst;
    }

    public final LList getRestArgsList(int next) {
        if (this.numKeywords == 0) {
            return this.getRestPlainList(next);
        }
        return ArgListPair.valueOf(this.getRestArgsVector(next));
    }

    public final LList getRestPlainList(int next) {
        EmptyList nil;
        LList list = nil = LList.Empty;
        Pair last = null;
        while (next < this.count) {
            Pair pair = new Pair(this.getArgAsObject(next++), nil);
            if (last == null) {
                list = pair;
            } else {
                last.setCdr(pair);
            }
            last = pair;
        }
        return list;
    }

    public ArgListVector getRestArgsVector(int next) {
        int size = this.count - next;
        if (next >= this.firstKeyword + this.numKeywords) {
            Object[] args = new Object[size];
            System.arraycopy(this.values, next, args, 0, size);
            return new ArgListVector(args, 0, 0);
        }
        Object[] args = new Object[size += this.numKeywords];
        int j = 0;
        for (int i = next; i < this.count; ++i) {
            String key = this.getKeyword(i);
            if (key != null) {
                args[j++] = Keyword.make(key);
            }
            args[j++] = this.getArgAsObject(i);
        }
        return new ArgListVector(args, this.firstKeyword - next, this.numKeywords);
    }

    public void lastArg() {
        if (this.next < this.count) {
            throw new WrongArguments(null, this.count);
        }
    }

    public Object[] getArgs() {
        Object[] args = new Object[this.count];
        System.arraycopy(this.values, 0, args, 0, this.count);
        return args;
    }

    public static short[] getSortedKeywords(String[] keywords2, int nkeys) {
        short[] sorted = new short[nkeys];
        short i = (short)nkeys;
        while ((i = (short)(i - 1)) >= 0) {
            sorted[i] = i;
        }
        keywordSorter.heapSort(sorted, nkeys, keywords2);
        return sorted;
    }

    public int nextKeyword(String keyword) {
        return this.nextKeywordIndex(keyword, false);
    }

    public int nextKeywordAllowOthers(String keyword) {
        return this.nextKeywordIndex(keyword, true);
    }

    public int nextKeywordIndex(String keyword, boolean allowOthers) {
        int klen = this.numKeywords;
        if (klen == 0) {
            return -1;
        }
        if (this.sortedKeywords == null) {
            this.sortedKeywords = CallContext.getSortedKeywords(this.keywords, klen);
        }
        int i = this.nextKeyword;
        while (true) {
            if (i >= klen) {
                this.nextKeyword = i;
                return -1;
            }
            short keywordIndex = this.sortedKeywords[i];
            String argkey = this.keywords[keywordIndex];
            if (argkey == keyword) {
                this.nextKeyword = i + 1;
                return this.firstKeyword + keywordIndex;
            }
            if (!allowOthers || argkey.compareTo(keyword) >= 0) {
                this.nextKeyword = i;
                return -1;
            }
            ++i;
        }
    }

    public Object nextKeyword(String keyword, Object dfault) {
        int index = this.nextKeywordIndex(keyword, false);
        return index >= 0 ? this.values[index] : dfault;
    }

    public Object nextKeywordAllowOthers(String keyword, Object dfault) {
        int index = this.nextKeywordIndex(keyword, true);
        return index >= 0 ? this.values[index] : dfault;
    }

    public void setupApply(Procedure proc) {
        this.setNextProcedure(proc);
        super.setArgs();
        this.rewind(0);
    }

    public void setupApply(Procedure proc, Object arg0) {
        this.setNextProcedure(proc);
        super.setArgs(arg0);
        this.rewind(0);
    }

    public void setupApply(Procedure proc, Object arg0, Object arg1) {
        this.setNextProcedure(proc);
        super.setArgs(arg0, arg1);
        this.rewind(0);
    }

    public void setupApply(Procedure proc, Object arg0, Object arg1, Object arg2) {
        this.setNextProcedure(proc);
        super.setArgs(arg0, arg1, arg2);
        this.rewind(0);
    }

    public void setupApply(Procedure proc, Object arg0, Object arg1, Object arg2, Object arg3) {
        this.setNextProcedure(proc);
        super.setArgs(arg0, arg1, arg2, arg3);
        this.rewind(0);
    }

    public void setupApplyAll(Procedure proc, Object[] args) {
        this.setNextProcedure(proc);
        super.setArgsAll(args);
        this.rewind(0);
    }

    public void setupApplyAll(Procedure proc, Object[] args, int fromIndex, int toIndex) {
        this.setNextProcedure(proc);
        super.setArgsAll(args, fromIndex, toIndex);
        this.rewind(0);
    }

    public void addArg(Object arg) {
        super.add(arg);
    }

    public void addArg(Object arg0, Object arg1, Object arg2, Object arg3) {
        super.add(arg0, arg1, arg2, arg3);
    }

    public void runUntilDone() throws Throwable {
        MethodHandle handle;
        while ((handle = this.applyMethod) != null) {
            this.applyMethod = null;
            this.rewind(0);
            Object object2 = handle.invokeExact(this.proc, this);
        }
    }

    public final int startFromContext() {
        if (this.vstack.gapStart == this.vstack.gapStartOnPush && this.consumer == this.vstack && this.vstack.lastObject == this.vstack) {
            return -1;
        }
        this.vstack.push();
        this.vstack.consumerOnPush = this.consumer;
        this.vstack.oindexOnPush = this.vstack.oindex;
        this.vstack.gapStartOnPush = this.vstack.gapStart;
        this.consumer = this.vstack;
        return this.vstack.gapStart;
    }

    public final Object getFromContext(int saved) throws Throwable {
        this.runUntilDone();
        Object result = ((ValueStack)this.consumer).getValue();
        this.cleanupFromContext(saved);
        return result;
    }

    public final void cleanupFromContext(int saved) {
        this.vstack.gapStart = this.vstack.gapStartOnPush;
        int oindexOnPush = this.vstack.oindexOnPush;
        int i = this.vstack.oindex;
        while (--i >= oindexOnPush) {
            this.vstack.objects[i] = null;
        }
        this.vstack.oindex = oindexOnPush;
        this.vstack.lastObject = this.vstack;
        if (saved >= 0) {
            this.consumer = this.vstack.consumerOnPush;
            this.vstack.pop(saved);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object runUntilValue() throws Throwable {
        if (this.proc != null && this.applyMethod == Procedure.applyToConsumerDefault) {
            this.applyMethod = null;
            return this.proc.applyToObjectMethod.invokeExact(this.proc, this);
        }
        Consumer consumerSave = this.consumer;
        ValueStack vst = this.vstack;
        this.consumer = vst;
        Object lastSave = vst.lastObject;
        vst.lastObject = vst;
        int dindexSave = vst.gapStart;
        int gapStartOnPushSave = vst.gapStartOnPush;
        this.vstack.gapStartOnPush = vst.gapStart;
        int oindexSave = vst.oindex;
        try {
            this.runUntilDone();
            Object object2 = vst.getValue();
            return object2;
        }
        finally {
            this.consumer = consumerSave;
            vst.gapStart = dindexSave;
            vst.oindex = oindexSave;
            vst.gapStartOnPush = gapStartOnPushSave;
            vst.lastObject = lastSave;
        }
    }

    public final void runUntilValue(Consumer out) throws Throwable {
        Consumer consumerSave = this.consumer;
        this.consumer = out;
        try {
            this.runUntilDone();
        }
        finally {
            this.consumer = consumerSave;
        }
    }

    public void writeValue(Object value) {
        Values.writeValues(value, this.consumer);
    }

    public final void pushArgState() {
        this.vstack.pushArgState(this);
    }

    public final void popArgState() {
        this.vstack.popArgState(this);
    }

    static class KeywordSorter
    extends HeapSort<short[], String[]> {
        KeywordSorter() {
        }

        @Override
        protected void swap(short[] a, int i, int j) {
            short t = a[i];
            a[i] = a[j];
            a[j] = t;
        }

        @Override
        protected int compare(short[] a, int i, int j, String[] keywords2) {
            int cmp = keywords2[a[i]].compareTo(keywords2[a[j]]);
            return cmp != 0 ? cmp : (i > j ? 1 : (i < j ? -1 : 0));
        }
    }
}

