<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
// 
// Copyright (C) 2003 - 2007 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------


$menu_section = "blog";

include_once ("config/blg.config.php");
include_once ("inc/blg_initiate.inc.php");

if ($output_participation['participation_permission'] & $blog_config['resource']['user']['manage_participants']) {
	
	require_once ("components/core/class/File.class.php");
	$file = new File($db, $core_config['file']);
	$file->user_id = $_SESSION['user_id'];
	$file->module_id = 0; // core
	$file->no_image = $core_config['file']['image']['thumb'][1]['no_image'];
	$user->file = $file;
	
	
	if (isset($_POST['update_user_participation'])) {
	
		if (isset($_POST['permission']['user'])) {
			$permission_count = "0";
					
			foreach ($_POST['permission']['user'] as $key => $i):
				$permission_count = $permission_count+$i;
			endforeach;
					
			$_POST['participation_permission'] = $permission_count;
		}
		
		$participation->user_id = $_POST['user_id'];
		
		$participation->updateParticipant($_POST);
		
		unset($_REQUEST['status_id'], $_REQUEST['role_id']);
		
	}
	elseif (isset($_REQUEST['set_default_user_permission'])) {
		$query = "
			SELECT * 
			FROM " . $db->prefix . "_blog 
			WHERE 
			blog_id=" . $output_blog['blog_id']
		;
		
		$result = $db->Execute($query);
			
		if (isset($result->fields)) {
			$rec = array();
			if (isset($_POST['permission']['user'])) {
				$permission_count = "0";
					
				foreach ($_POST['permission']['user'] as $key => $i):
					$permission_count = $permission_count+$i;
				endforeach;
					
				$rec['default_user_permission'] = $permission_count;
				
				$output_blog['default_user_permission'] = $permission_count;
				$body->set('blog', $output_blog);
			}
			
			$query = $db->GetUpdateSQL($result, $rec, false, get_magic_quotes_gpc());
			$result = $db->Execute($query);
		}
	}
	elseif (isset($_POST['sub_set_hold'])) {
		$participation->setUserStatus($_POST['identity_ids'], $blog_config['user']['status']['hold']);
		$_REQUEST['status_id'] = $blog_config['user']['status']['hold'];
	}
	elseif (isset($_POST['sub_set_barred'])) {
		$participation->setUserStatus($_POST['identity_ids'], $blog_config['user']['status']['barred']);
		$_REQUEST['status_id'] = $blog_config['user']['status']['barred'];
	}
	elseif (isset($_POST['sub_set_active'])) {
		$participation->setUserStatus($_POST['identity_ids'], $blog_config['user']['status']['active']);
		$_REQUEST['status_id'] = $blog_config['user']['status']['active'];
	}
	
	if (isset($_REQUEST['status_id'])) {
		$output_participants = $participation->selParticipants($_REQUEST['status_id']);
	}
	elseif (isset($_REQUEST['role_id'])) {
		$output_participants = $participation->selParticipants(null, $_REQUEST['role_id']);
	}
	elseif (isset($_REQUEST['resource'])) {
		// selecting using bitflags is poor, so we select all and use PHP to filter
		$tmp_participants = $participation->selParticipants();
		
		if (!empty($tmp_participants)) {
			$output_participants = array();
			
			foreach ($tmp_participants as $key => $i):
				if ($_REQUEST['resource'] & intval($i['participation_permission'])) {
					array_push($output_participants, $i);
				}
			endforeach;
			
			$body->set('participants', $output_participants);
		}
		
	}
	elseif (isset($_REQUEST['identity_id'])) {
		$output_participant = $participation->selParticipation(null, $_REQUEST['identity_id']);
		
		if (!empty($output_participant)) {
			
			$output_participant['identity'] = $user->selUserIdentity(null, $output_participant['identity_id']);
			
			$body->set('participant', $output_participant);
			
			// if we are the blog owner we select editors 
			if (($output_participant['user_id'] == $output_blog['user_id']) && ($_SESSION['user_id'] == $output_blog['user_id'])) { // set owner only
				
				$output_authors = $participation->selParticipants(null, $blog_config['role']['author']);
				
				if (!empty($output_authors)) {
					foreach ($output_authors as $key => $i):
						$user->identity_ids[] = $i['identity_id'];
					endforeach;
					
					$user->identity_ids = array_unique($user->identity_ids);
					
					if (!empty($user->identity_ids)) {
						$output_identities = $user->selUserIdentities();
						
						// we place the identities against the participants
						if (!empty($output_identities)) {
							foreach ($output_authors as $keyp => $p):
								foreach ($output_identities as $keyi => $i):
									if ($p['identity_id'] == $i['identity_id']) {
										$output_authors[$keyp]['identity'] = $i;
										break;
									}
								endforeach;
							endforeach;
						}
						
						$body->set('authors', $output_authors);
					}
				}
			}
			
		}
	}
	
	
	// SELECT PARTICIPANTS IDENTITIES ---------------------------------------------
	if (!empty($output_participants)) {
		// get their ids
		if (!empty($output_participants)) {
			foreach ($output_participants as $key => $i):
				$user->identity_ids[] = $i['identity_id'];
			endforeach;
			
			$user->identity_ids = array_unique($user->identity_ids);
			
			if (!empty($user->identity_ids)) {
				$output_identities = $user->selUserIdentities();
				
				// we place the identities against the participants
				if (!empty($output_identities)) {
					foreach ($output_participants as $keyp => $p):
						foreach ($output_identities as $keyi => $i):
							if ($p['identity_id'] == $i['identity_id']) {
								$output_participants[$keyp]['identity'] = $i;
								break;
							}
						endforeach;
					endforeach;
				}
				
				$body->set('participants', $output_participants);
			}
		}
	}
}
else { // we do not have permissions to be here
	header("Location: index.php?amn=blg_page&entry_id=" . $output_set['blog_id'] . "&" . strip_tags(SID));
	exit;
}

?>
