<?php

// -----------------------------------------------------------------------
// This file is part of aroundme
// 
// Copyright (C) 2003, 2005 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.
// -----------------------------------------------------------------------

include "inc/header_group.inc.php";


//append language setup
require_once($languageArrayPath . 'arr_activity.lang.php');


//ACS check
if (!$group_acs->checkPermission($c_acs['arr_acs']['resource']['group_activity'], $c_acs['arr_acs']['privilege']['allow_edit'])) { //resourece_id, Priv_id
	header("Location: g_group.php?group_id=" . $group_id."&".SID);
	exit;
}


//append language setup
require_once($languageArrayPath . 'arr_activity.lang.php');
require_once($languageArrayPath . 'arr_task_user_status.lang.php');
require_once($languageArrayPath . 'arr_user.lang.php');


//setup activity
require_once($c_node['dir']['class_path'] . 'Activity.class.php');
$activity = new Activity($db, $c_acs['arr_section']['group'], $date, $file);
$activity->section_item_id = $group_id;
$activity->task_user_status_ids = $c_node['activity']['task_user_status'];


if (isset($_POST['edit_activity_schedule'])) {
	$output_activity = $data;
	$output_activity['activity_id'] = $_REQUEST['activity_id'];
	
	$display = "edit_activity_schedule";
	
}
elseif (isset($_POST['insert_activity'])) {
	$activity->user_id = $user_id;
	$activity->frequency_ids = $c_node['activity']['frequency'];
	$activity->activity_id = $_REQUEST['activity_id'];
	
	$activity->insertactivity($data);
	
	if (empty($GLOBALS['am_error_log'])) {
		//setup cms
		require_once($c_node['dir']['class_path'] . 'Cms.class.php');
		$cms = new Cms($db, $c_acs['arr_section']['group']);
		$cms->section_item_id = $group_id;
		$cms->cms_item_type_id = $c_node['cms']['item_type']['group_activity'];
		$cms->user_id = $user_id;
		$temp['language_id'] = $output_group['language_id'];
		$temp['genre_id'] = $output_group['genre_id'];
		$temp['item_id'] = $activity->activity_id;
		
		//insert node cms entry
		if (isset($data['cms_node'])) {
			$temp['level_id'] = $c_node['cms']['cms_level']['group']['home'];
		
		   	if($c_node['cms']['node']['auto_publish'] == 1) {
				$temp['status_id'] = $c_node['cms']['status']['live'];
			}
			else {
				$temp['status_id'] = $c_node['cms']['status']['pending'];
			}
			
			$cms->insertCmsItem($temp);
		}
		
		//insert group cms entry
		if (isset($data['cms_group'])) {
		    $temp['level_id'] = $c_node['cms']['cms_level']['node'];
			
			if ($group['group_cms_auto_publish'] == 1) {
		    	$temp['status_id'] = $c_node['cms']['status']['live'];
			}
			else {
				$temp['status_id'] = $c_node['cms']['status']['pending'];
			}
			
			$cms->insertCmsItem($temp);
		}
	
		header("Location: g_activity.php?group_id=" . $group_id . "&activity_id=" . $activity->activity_id . "&".SID);
		exit;
	}
	else {
		$output_activity = $data;
	}
}
elseif (isset($_POST['update_activity'])) {

	$activity->updateActivity($data);

	if (empty($GLOBALS['am_error_log'])) {
		header("Location: g_activity.php?group_id=" . $group_id . "&amp;activity_id=" . $activity->activity_id . "&".SID);
		exit;
	}
}
elseif (isset($_POST['delete_activity'])) {
	$activity->deleteActivity($_REQUEST['activity_id']);

	if (empty($GLOBALS['am_error_log'])) {
		header("Location: g_calendar.php?group_id=" . $group_id . "&amp;".SID);
		exit;
	}
}
elseif (isset($_REQUEST['activity_id'])) {
	
	$activity_id = $_REQUEST['activity_id'];
	$activity->activity_id = $activity_id;
	$output_activity = $activity->getActivity();
	
	$output_tasks = $activity->getTasks();
	
	//figure out if we can edit or not based on confirmed tasks
	$total_applicants = 0;
	
	foreach($output_tasks as $key => $i):
		$total_applicants = $total_applicants + $i['task_confirmed'];
		$total_applicants = $total_applicants + $i['task_applicants'];
	endforeach;
			
	if ($total_applicants == 0) {
	    $display = "edit_activity";
	}
	else {
	    $display = "no_edit_allowed";
	}

} //else we add


//setup file
	$file->noimage = $c_node['file']['image']['thumb'][2]['noimage'];
	$file->thumb = $c_node['file']['image']['thumb'][2]['name'];
	$file->type_ids[] = $c_node['file']['mime'][1]['suffix']; //jpg
	$file->type_ids[] = $c_node['file']['mime'][2]['suffix']; //png
	$file->type_ids[] = $c_node['file']['mime'][3]['suffix']; //gif
	
	$output_images = $file->getFiles();

//move to template
if (!empty($c_node['activity']['frequency'])) {
   $body->set('frequency_ids', $c_node['activity']['frequency']);
}

if (!empty($output_activity)) {
   $body->set('activity', $output_activity);
}

if (!empty($output_tasks)) {
   $body->set('tasks', $output_tasks);
}

if (isset($display)) {
   $body->set('display', $display);
}

if (!empty($output_images)) {
	$body->set('images', $output_images);
}

if (!empty($output_activity['activity_start_datetime'])) {
   $body->set('start_datedropdown', $date->dateDropdown($output_activity['activity_start_datetime'], 1, 'start', 10, 20));
}
else {
   $body->set('start_datedropdown', $date->dateDropdown(date("Y-m-d H:00:00"), 1, 'start', 10, 20));
}

if (!empty($output_activity['activity_end_datetime'])) {
   $body->set('end_datedropdown', $date->dateDropdown($output_activity['activity_end_datetime'], 1, 'end', 10, 20));
}
else {
   $body->set('end_datedropdown', $date->dateDropdown(date("Y-m-d H:00:00"), 1, 'end', 10, 20));
}

if (!empty($output_activity['activity_start_day'])) {
   if($output_activity['activity_frequency']==3)
	   $activity_start_daytime = date("Y-m-d", mktime(0,0,0, 1, $output_activity['activity_start_day'], 1999));
   else
	   $activity_start_daytime = date("Y-m-d", mktime(0,0,0, $output_activity['activity_start_month'], $output_activity['activity_start_day'], 1999));
   $body->set('start_monthlydropdown', $date->dateDropdown($activity_start_daytime, 1, 'activity_start', 10, 20, $output_activity['activity_frequency']));
}
else {
   $body->set('start_monthlydropdown', $date->dateDropdown(date("Y-m-d H:00:00"), 1, 'activity_start', 10, 20));
}

if (!empty($output_activity['activity_end_day'])) {
   if($output_activity['activity_frequency']==3)
	   $activity_end_daytime = date("Y-m-d", mktime(0,0,0, 1, $output_activity['activity_end_day'], 1999));
   else
	   $activity_end_daytime = date("Y-m-d", mktime(0,0,0, $output_activity['activity_end_month'], $output_activity['activity_end_day'], 1999));

   $body->set('end_monthlydropdown', $date->dateDropdown($activity_end_daytime, 1, 'activity_end', 10, 20, $output_activity['activity_frequency']));
}
else {
   $body->set('end_monthlydropdown', $date->dateDropdown(date("Y-m-d H:00:00"), 1, 'activity_end', 10, 20));
}

if (!empty($output_group)) {
	$body->set('group', $output_group);
}

$body->set('cms_node_auto_publish', $c_node['cms']['node']['auto_publish']);

include "inc/footer.inc.php";

?>
