<?php

// -----------------------------------------------------------------------
// This file is part of aroundme
// 
// Copyright (C) 2003, 2005 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.
// -----------------------------------------------------------------------

include "inc/header_group.inc.php";
require_once($c_node['dir']['class_path'] . 'Schedule.class.php');


//append language setup
require_once($languageArrayPath . 'arr_activity.lang.php');
require_once($languageArrayPath . 'arr_task_user_status.lang.php');
require_once($languageArrayPath . 'arr_user.lang.php');



//setup activities
require_once($c_node['dir']['class_path'] . 'Activity.class.php');
$activity = new Activity($db, $c_acs['arr_section']['group'], $date, $file);
$activity->section_item_id = $group_id;
$activity->task_user_status_ids = $c_node['activity']['task_user_status'];

$output_activities = $activity->getActivities();
$output_tasks = $activity->getTasks();
	


//setup calendar
if(!isset($_REQUEST["time"])) {
	$time = mktime();
}
else {
	$time = $_REQUEST["time"];
}

$now = getdate($time);

$sched = new Schedule($db, $now, $me['user_id']);


//get date
$sched->setScheduleBase();


if (!empty($output_activities)) {
	foreach($output_activities as $index => $activity_tmp):
		if(isset($activity_tmp)) {
			$activities[] = $sched->modifyActivityDate($activity_tmp);
		}
	endforeach;
}



$schedule = $sched->getSchedule();  // Get the schedule array
$todo     = $sched->getToDo();      // Get the todo array



// Get last and next months timestamp
$links["last"] = $date->getDayTime($time, -1);
$links["next"] = $date->getDayTime($time, 1);

// Get the calendar view month name
$today = $date->getDayString($time);
$name["last"] = $date->getDayString($time, -1);
$name["next"] = $date->getDayString($time, 1);

// Get the maximum number of activities at one hour
$nr = floor($sched->getMax());

//move to template
if (!empty($time)) {
	$body->set('time', $time);
}

if (!empty($schedule)) {
	$body->set('calendar', $schedule);
}

if (!empty($todo)) {
	$body->set('todo', $todo);
}

if (!empty($today)) {
	$body->set('today', $today);
}

if (!empty($links)) {
	$body->set('links', $links);
}

if (!empty($nr)) {
	$body->set('nr', $nr);
}

if (!empty($name)) {
	$body->set('name', $name);
}

if (!empty($output_group)) {
	$body->set('group', $output_group);
}

$template_pageLink = "activities";
include "inc/footer.inc.php";

?>
