<?php

// -----------------------------------------------------------------------
// This file is part of aroundme
//
// Copyright (C) 2003, 2005 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.
// -----------------------------------------------------------------------


include "inc/header_pre_login.inc.php";
include "config/config_acs.inc.php";


if (!empty($_REQUEST['http_referer'])) {
    $http_referer = $_REQUEST['http_referer'];
}


//set up user
require_once($c_node['dir']['class_path'] . 'User.class.php');
$user = new User($db, $date);
$user->status_ids = $c_node['user']['status'];

//if the session is timed out we destroy it
if(isset($_SESSION['s_user_id'])) {
	session_unset();
	session_destroy();

	session_start();
	$_SESSION['s_language_id'] = $language_id;
}


//form actions
if (isset($_POST['login'])) {

	if (isset($_POST['email']) && $_POST['email'] && isset($_POST['password']) && $_POST['password']) {
		$user->relation_type = $c_node['user']['relation_type']['approved'];

		require_once($c_node['dir']['class_path'] . 'Statistic.class.php');
		$statistic = new Statistic($db, null);
		$user->statistic = $statistic;
		$user->total_login_stat_id = $c_node['statistic']['user']['total_logins'];

		$user->checkLogin($_REQUEST['email'],$_REQUEST['password']);

		if (empty($GLOBALS['am_error_log'])) {
			//setup social network
			require_once($c_node['dir']['class_path'] . 'SocialNetwork.class.php');
			$sn = new SocialNetwork(null, $db, $c_node['node']['node_id'], $c_node['sn']['max_degree']);
			$sn->relation_type_ids = $c_node['user']['relation_type'];
			$sn->status_ids = $c_node['user']['status'];
			$user->sn = $sn;
			if (isset($http_referer)) {
			    $user->http_referer = $http_referer;
			}
			$user->loginUser($_REQUEST['email'],$_REQUEST['password'], $c_node['node']['node_id']);

		}
	}
	else {
		$GLOBALS['am_error_log'][] = array(20, null, null);
	}

}
elseif (isset($_REQUEST['registration_complete'])) {
	$display = "registration_complete";
}

//CONTENT
require_once($c_node['dir']['class_path'] . 'File.class.php');


//setup file
$file = new File($db, null, $c_node['file'], $c_node['dir']);
$file->noimage = $c_node['file']['image']['thumb'][2]['noimage'];
$file->thumb = $c_node['file']['image']['thumb'][2]['name'];
$file->config_ids = $c_node['file'];


//get blogs -----------------------------------------------------
require_once($c_node['dir']['class_path'] . 'Blog.class.php');
$blog = new Blog($db, $c_node['rsp']['item_type']['blog'], $date, $file);
$blog->rsp_level_id = $c_node['rsp']['rsp_level']['public'];
$blog->rsp_status_id = $c_node['rsp']['status']['live'];
$blog->limit = 10;
$output_blogs = $blog->selRspBlogs();


//get group poll ids -----------------------------------------------------
require_once($c_node['dir']['class_path'] . 'Poll.class.php');
$poll = new Poll($db, $c_node['rsp']['item_type']['poll'], $date);
$poll->order_by = "poll_start_datetime desc";
$poll->rsp_level_id = $c_node['rsp']['rsp_level']['public'];
$poll->rsp_status_id = $c_node['rsp']['status']['live'];
$poll->limit = 10;
$output_polls = $poll->selRspPolls();


//get library items -----------------------------------------------------
require_once($c_node['dir']['class_path'] . 'Library.class.php');
$library = new Library($db, $c_node['rsp']['item_type']['library'], $date, $file);
$library->rsp_level_id = $c_node['rsp']['rsp_level']['public'];
$library->rsp_status_id = $c_node['rsp']['status']['live'];
$library->limit = 10;
$output_library_items = $library->selRspLibraryItems();

//setup forum -----------------------------------------------------
require_once($c_node['dir']['class_path'] . 'Forum.class.php');
$forum = new Forum($db, $c_node['rsp']['item_type']['forum'], $date, $file);
$forum->rsp_level_id = $c_node['rsp']['rsp_level']['public'];
$forum->rsp_status_id = $c_node['rsp']['status']['live'];
$forum->limit = 10;
$output_subjects = $forum->selRspSubjects();


//TEMPLATE
if (!empty($output_blogs)) {
	$body->set('blogs', $output_blogs);
}

if (!empty($output_subjects)) {
	$body->set('subjects', $output_subjects);
}

if (!empty($output_polls)) {
	$body->set('polls', $output_polls);
}

if (!empty($output_library_items)) {
	$body->set('library_items', $output_library_items);
}

$body->set('language_available', $c_node['node']['language']['pack']);

if (!empty($http_referer)) {
	$body->set('http_referer', $http_referer);
}


if (isset($display)) {
	$body->set('display', $display);
}

$pagename = "index";
include "inc/footer_pre_login.inc.php";
?>
