<?php

// -----------------------------------------------------------------------
// This file is part of aroundme
// 
// Copyright (C) 2003, 2005 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.
// -----------------------------------------------------------------------


$core = "user";
include "inc/header.inc.php";

//ACS check
if (!$user_acs->checkPermission($c_acs['arr_acs']['resource']['administration'], $c_acs['arr_acs']['privilege']['allow_access'])) { //resourece_id, Priv_id
	header("Location: " . $_SESSION['s_homepage'] . "?" . SID);
	exit;
}

//append language setup
require_once($languageArrayPath . 'arr_language_name.lang.php');


// SETUP NEWSLETTER -----------------------------------------------------
if (isset($_POST['send_newsletter'])) {

	require_once($c_node['dir']['class_path'] . 'Newsletter.class.php');
	$nl = new Newsletter($db, $c_node['newsletter']);
	$nl->insertNewsletter($frmdata);
	
	if (empty($GLOBALS['am_error_log'])) {
		//send newsletter
		if($c_node['cron']['bulk_email'] != 1) {
			//we send email directly 
			unset($_SESSION["newsletter_id"]);
			$_SESSION["newsletter_id"] = $nl->message_id;
			header("Location: nlt_send.php");
			exit;
		}
	}
}
elseif (isset($_REQUEST['complete'])) {
	if ($_REQUEST['complete'] < 1) {
		$_REQUEST['complete'] = 0;
	}
}


//move to template
if (isset($_REQUEST['complete'])) {
    $body->set('total_emails_sent', $_REQUEST['complete']);
}

$body->set('language_id', $me['language_id']);
$body->set('newsletter_type_ids', $c_node['newsletter']['type']);
$body->set('total_members', getCountUsers($c_node['user']['status']['active']));
$body->set('total_pending_members', getCountUsers($c_node['user']['status']['pending']));
$body->set('total_invited', getCountInvitedUsers());

function getCountUsers($status_id = null) {
	
	global $db;
	$total = 0;
	
	$query = "
		SELECT count(user_id) as total  
		FROM " . $db->prefix . "_user 
		WHERE "
	;
	
	if (isset($status_id)) {
		$query .= "status_id=". $status_id . " AND ";
	}
	
	$query .= "1=1";
	
	$result = $db->Execute($query);
	
	if (isset($result)) {
		$total = $result->fields['total'];
	}
	
	return $total;
}

function getCountInvitedUsers() {
	
	global $db;
	$total = 0;
	
	$query = "
		SELECT count(invited_email) as total 
		FROM " . $db->prefix . "_user_invited"
	;
	
	$result = $db->Execute($query);
	
	if (isset($result)) {
		$total = $result->fields['total'];
	}
	
	return $total;
}

include "inc/footer.inc.php";

?>
