<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
// 
// Copyright (C) 2003 - 2006 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------
$menu_section = "structure";
include "inc/header.inc.php";

//ACS check
if (!$user_acs->checkPermission($c_acs['arr_acs']['resource']['node']['administration'], $c_acs['arr_acs']['privilege']['allow_abuse_reports'])) { //resourece_id, Priv_id
	header("Location: " . $_SESSION['user_homepage'] . "?" . strip_tags(SID));
	exit;
}


// SETUP LANGUAGE --------------------------------------------------------
require_once($languagePath . 'common.lang.php');
require_once($languageArrayPath . 'arr_language_name.lang.php');
require_once($languageArrayPath . 'arr_abuse_status.lang.php');


//process requests
if (isset($_REQUEST['update_report'])) {

	updateReport($frmdata);
}
elseif (isset($_REQUEST['abuse_id'])) {
	$output_report = getReport($_REQUEST['abuse_id']);
	$display = "edit_report";
}


$output_reports = getReports();

//we will list reports, then have a detailed screen
//plus link to send email to reportee



//move to template
if (!empty($output_reports)) {
	$body->set('reports', $output_reports);
}

if (!empty($output_report)) {
	$body->set('report', $output_report);
}

if (isset($display)) {
	$body->set('display', $display);
}


include "inc/footer.inc.php";



/*
* getReports
* Tom Calthrop 9th November 2004
*/
function getReports() {

	global $db, $error, $date;

	$query = "
		SELECT ar.*, u.user_firstname, u.user_surname 
		FROM " . $db->prefix . "_abuse ar 
		LEFT JOIN " . $db->prefix . "_user u ON ar.reportee_user_id=u.user_id 
		order by ar.report_status_id desc, ar.report_datetime"
	;

	$result = $db->Execute($query);

	if (isset($result->fields)) {
	
		$temp = array();

		while (!$result->EOF) {
			$temp1 = $result->fields;
			$temp1['report_datetime'] = $date->formatDate($temp1['report_datetime']);

			array_push($temp, $temp1);
			$result->MoveNext();
		}

		$result->Close();
		return $temp;
	}
	else {
		$error_info = "function=getReports class=node_abuse_reports.php -- " . $query . " -- " . $db->ErrorMsg();
		$GLOBALS['am_error_log'][] = array(1, 1, $error_info);
	}
}//EO getReports();



/*
* getReports
* Tom Calthrop 9th November 2004
*/
function getReport($abuse_id) {

	global $db, $error, $date;

	$query = "
		SELECT ar.*, u.user_firstname, u.user_surname, 
		u1.user_firstname as assigned_firstname, u1.user_surname as assigned_surname 
		FROM " . $db->prefix . "_abuse ar 
		LEFT JOIN " . $db->prefix . "_user u ON ar.reportee_user_id=u.user_id 
		LEFT JOIN " . $db->prefix . "_user u1 ON ar.assigned_user_id=u1.user_id 
		WHERE ar.abuse_id=" . $abuse_id
	;
	
	$result = $db->Execute($query);

	if (isset($result->fields)) {
	
		$temp = $result->fields;
		$temp['report_datetime'] = $date->formatDate($temp['report_datetime'], 1);

		$result->Close();
		return $temp;
	}
	else {
		$error_info = "function=getReport class=node_abuse_reports.php -- " . $query . " -- " . $db->ErrorMsg();
		$GLOBALS['am_error_log'][] = array(1, 1, $error_info);
	}
}//EO getReport();


/*
* updateReport
* Tom Calthrop 9th November 2004
*/
function updateReport($frmdata) {
	
	global $db, $error, $me;
	
	$query = "
		SELECT * FROM " . $db->prefix . "_abuse 
		WHERE 
		abuse_id=" . $frmdata['abuse_id']
	;
	
	$result = $db->Execute($query);
	
	$rec = array();
	$rec['assigned_user_id'] = $me['user_id'];
	$rec['report_status_id'] = $frmdata['report_status_id'];
	
	$query = $db->GetUpdateSQL($result, $rec, false, get_magic_quotes_gpc());
	$result = $db->Execute($query);
	
	return true;
}//EO updateReport();
?>
