<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
// 
// Copyright (C) 2003 - 2007 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------



class Comment {
	
	
	// Comment --------------------------------------------------------------------
	// the constuctor
	// tom calthrop - 23rd December 2004
	//
	function Comment($db, $module_id = null, $item_id = null, $core_config = null) {
		$this->db = $db;
		$this->module_id = $module_id;
		$this->item_id = $item_id;
		$this->core_config = $core_config;
	}//EO Comment

	
	
	// selComments --------------------------------------------------------------------
	// returns a count if a particular item
	// tom calthrop - 23rd December 2004
	//	
	function selComments($inner_item_id = null, $search=null) {
		
		$query = "
			SELECT c.comment_id, c.comment_parent_id, c.comment_body, c.user_id, c.item_id, 
			c.comment_create_datetime, c.module_id, c.item_id, c.inner_item_id, 
			i.identity_id, i.identity_nic, l.location_name, p.participation_create_datetime, 
			c.inner_item_revision  
			FROM " . $this->db->prefix . "_user_identity i, " . $this->db->prefix . "_comment c, 
			" . $this->db->prefix . "_participation p, " . $this->db->prefix . "_user u
			LEFT JOIN " . $this->db->prefix . "_user_location l ON u.location_id=l.location_id AND l.language_id=" . $_SESSION['language_id'] . " 
			WHERE 
			c.user_id=p.user_id AND 
			c.module_id=" . $this->module_id . " AND 
			c.module_id=p.module_id AND 
			c.item_id=p.item_id AND 
			p.identity_id=i.identity_id AND 
			c.user_id=u.user_id AND "
		;			
		
		if (isset($this->item_id)) {
		    $query .= "c.item_id=" . $this->item_id . " AND ";
		}
			
		if (isset($inner_item_id)) {
		    $query .= "c.inner_item_id=" . $inner_item_id . " AND ";
		}
			
		if (isset($this->inner_item_revision)) {
		    $query .= "c.inner_item_revision=" . $this->inner_item_revision . " AND ";
		}

		if (isset($this->comment_type)) {
		    $query .= "c.comment_type=" . $this->comment_type . " AND ";
		}
		
		if (isset($this->user_id)) {
		    $query .= "c.user_id=" . $this->user_id . " AND ";
		}
		elseif (isset($this->user_ids)) {
			$user_ids = "";
			foreach($this->user_ids as $key => $i):
				$user_ids .= $i;
				if (count($this->user_ids) > $key+1) {
				    $user_ids .=",";
				}
			endforeach;
			$query .="c.user_id in (" . $user_ids . ") AND ";
		}
		
		if (isset($search)) {
			$query .= "
				c.comment_body like " . $this->db->qstr("%" . $search . "%", get_magic_quotes_gpc()) . " AND "
			;
		}
		
		if (isset($this->search_from_date)) {
			$query .= "
				c.comment_create_datetime>" . $this->db->DBTimeStamp($this->search_from_date) . " AND "
			;
		}
		
		$query .= "1=1 ";
		
		
		if (isset($this->order_by)) {
			$query .= "order by " . $this->order_by;
		}
		else {
			$query .= "order by c.comment_create_datetime";
		}
// 		echo $query;
		if (isset($this->limit)) {
			$result = $this->db->SelectLimit($query, $this->limit);
		} else {
			$result = $this->db->Execute($query);
		}

		if (isset($result->fields)) {
			$temp = array();

			while (!$result->EOF) {
				$temp1 = $result->fields;
				
				$temp1['comment_body_raw'] = $temp1['comment_body'];
				
				//format search results
				if (isset($search)) {
					$temp1['comment_body'] = searchTextFormat($search, $temp1['comment_body']);
				}
				
				if (isset($this->core_config['xhtml_markup']['format']['nl2br']) && $this->core_config['xhtml_markup']['format']['nl2br'] == 1) {
					$temp1['comment_body'] = nl2br($temp1['comment_body']);
				}
				
				array_push($temp, $temp1);
				$result->MoveNext();
			}

			$result->Close();
			return $temp;
			
		}
		else {
			$error_info = "method=selComments class=Comment.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['am_error_log'][] = array('db_error', $error_info);
		}
	}//EO selComments
	
	
	
	// insertComment --------------------------------------------------------------------
	// inserts a comment
	// tom calthrop - 24th December 2004
	//
	function insertComment($data) {
		if (empty($data['comment_body'])) {
		    $GLOBALS['am_error_log'][] = array(12, null, null);
		}
		
		if (empty($GLOBALS['am_error_log'])) {
	
			if (empty($data['comment_parent_id'])) {
				$data['comment_parent_id'] = "null";
			}
			
			// we add a check for duplicate entries
			$query = "
				SELECT comment_id 
				FROM " . $this->db->prefix . "_comment 
				WHERE 
				user_id=" . $this->user_id . " AND 
				comment_body=" . $this->db->qstr("%" . $data['comment_body'] . "%", get_magic_quotes_gpc()) . " AND 
				item_id=" . $this->item_id
			;
			
			if (isset($this->inner_item_id)) {
				$query .= " AND inner_item_id=" . $this->item_id;
			}
			
			$result = $this->db->SelectLimit($query, 1);
			
			if (!isset($result->fields['comment_id'])) {
				
				$rec = array();
				$rec['item_id'] = $this->item_id;
				$rec['module_id'] = $this->module_id;
				$rec['comment_body'] = $data['comment_body'];
				$rec['comment_create_datetime'] = time();
				$rec['user_id'] = $this->user_id;
				$rec['item_user_id'] = $this->item_user_id;
				$rec['comment_parent_id'] = $data['comment_parent_id'];
				
				if (isset($this->inner_item_id)) {
					$rec['inner_item_id'] = $this->inner_item_id;
				}
				
				if (isset($this->inner_item_revision)) {
					$rec['inner_item_revision'] = $this->inner_item_revision;
				}
				
				if (isset($this->comment_type)) {
					$rec['comment_type'] = $this->comment_type;
				}
				
				$table = $this->db->prefix . "_comment";
				
				$query = $this->db->GetInsertSQL($table, $rec, get_magic_quotes_gpc());
				$result = $this->db->Execute($query);
				
				if (empty($result)) {
					$error_info = "function=insertComment class=Comment.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
					$GLOBALS['am_error_log'][] = array(1, 1, $error_info);
				}
			}
		}
	}//EO insertComment

	
	
	// countComments --------------------------------------------------------------------
	// returns a count if a particular item - typically used for statistics counts
	// tom calthrop - 23rd December 2004
	//
	function countComments($lastviewdate = null) {
		
		$query = "
			SELECT count(comment_id) as total 
			FROM " . $this->db->prefix . "_comment 
			WHERE "
		;
		
		if (isset($this->module_id)) {
			$query .= "module_id=" . $this->module_id . " AND ";
		}
		
		if (isset($this->item_id)) {
			$query .= "item_id=" . $this->item_id . " AND ";
		}
		
		if (isset($this->inner_item_id)) {
			$query .= "inner_item_id=" . $this->inner_item_id . " AND ";
		}
		
		if (isset($this->user_id)) {
			$query .= "user_id=" . $this->user_id . " AND ";
		}
		
		if (isset($this->item_user_id)) {
			$query .= "item_user_id=" . $this->item_user_id . " AND ";
		}
		
		if (isset($lastviewdate)) {
			$query .= "comment_create_datetime > " . $this->db->DBTimeStamp($lastviewdate) . " AND ";
		}
		
		$query .= "1=1";
		
		$result = $this->db->Execute($query);

		if (isset($result->fields['total'])) {
			return $result->fields['total'];
		}
		else {
			$error_info = "method=countComments class=Comment.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['am_error_log'][] = array(1, 1, $error_info);
		}
	}//EO countComments
}
?>
