<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
// 
// Copyright (C) 2003 - 2007 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------

$menu_section = "me";


//set up user class and destroy any sessions
require_once('class/User.class.php');
require_once('class/UserAdmin.class.php');
$user = new UserAdmin($db, $core_config['user']);


//form actions
if (isset($_POST['newpassword'])) {
	// Checks the email and the password
	$catpcha = strtoupper($_POST['captchastring']);
	if (empty($catpcha) || empty($_SESSION['CAPTCHAString']) || $_SESSION['CAPTCHAString'] != $catpcha) {
		$GLOBALS['am_error_log'][] = array('captcha_wrong');
	}
	
	if (empty($GLOBALS['am_error_log'])) {
		$dob = $_POST['year']."-".$_POST['month']."-".$_POST['day'];

		$query = "
			SELECT user_id, user_firstname, user_email, user_password 
			FROM " . $db->prefix . "_user 
			WHERE 
			user_email=" . $db->qstr($_POST['email'], get_magic_quotes_gpc()) . " AND 
			user_dob=" . $db->qstr($dob, get_magic_quotes_gpc())
		;
		
		$result = $db->Execute($query);
	
		if (isset($result->fields)) {
			$temp = $result->fields;
	
			//update the password and send email
			$password = $user->createPassword();
			
			$rec = array();
			$rec['user_password'] = md5($password);
		
			$query = $db->GetUpdateSQL($result, $rec, false, get_magic_quotes_gpc());
			$result = $db->Execute($query);
			
			//get file to send
			$body_file_txt = readTxtFile($language_path . "texts/email_new_password.txt.php");
			
			$body_file_txt = str_replace("SYS_KEYWORD_NAME", $temp['user_firstname'], $body_file_txt);
			$body_file_txt = str_replace("SYS_KEYWORD_PASSWORD", $password, $body_file_txt);
			
			//create URL
			$url = "http://" . $_SERVER['HTTP_HOST'];
			$url .= dirname ($_SERVER['PHP_SELF']);
			//sometimes the server adds / as the last characture - we need to check.
			if (substr($url, -1, 1) != "/") {
			    $url .= "/";
			}
			
			$body_file_txt = str_replace("SYS_KEYWORD_URL", $url, $body_file_txt);
			
			
			//setup email
			require_once('class/Mail/class.phpmailer.php');
			$mail = new PHPMailer($core_config['mail']);
			
			$mail->AddReplyTo($core_config['mail']['no_reply_address'], $lang['subject_noreply']);
			$mail->Subject = 	$lang['txt_email_subject_new_pass'];
			$mail->AddAddress($temp['user_email'], $temp['user_firstname']);
			
			// HTML-version of the mail
			$html  = "<HTML><HEAD><TITLE></TITLE></HEAD>";
			$html .= "<BODY>";
			$html .= utf8_decode($body_file_txt);
			$html .= "</BODY></HTML>";
			
			$alt_body = strip_tags($body_file_txt);
			
			//send email
			$mail->Body = nl2br($html);
			$mail->AltBody   = utf8_decode($alt_body);
			
			if(!$mail->Send()) {
				$GLOBALS['am_error_log'][] = array('mail_error', $mail->ErrorInfo);
			}
		}
		else {
			$GLOBALS['am_error_log'][] = array('error_no_match');
		}
	
		$display = "sent_pass";
		
		if (!empty($GLOBALS['am_error_log'])) {
			$display = "lost_pass";
		}
	}
}

//TEMPLATE
if (isset($core_config['language']['pack'])) {
	$body->set('language_available', $core_config['language']['pack']);
}

if (isset($display)) {
	$body->set('display', $display);
}

$body->set('datedropdown', $date->dateDropdown());


?>
