<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
// 
// Copyright (C) 2003-2007 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; see the file COPYING.txt.  If not, see
// <http://www.gnu.org/licenses/>
// -----------------------------------------------------------------------

if(isset($_SESSION['connection_permission']) && checkPermission('wiki', 'edit_wikipage', $_SESSION['connection_permission'])) {
	
	include_once($language_path . 'common.lang.php');
	
	if (isset($_POST['insert_revision'])) {
		if (empty($_POST['revision_body'])) {
			$GLOBALS['am_error_log'][] = array('body_empty');
		}

		// we look for incorrectly formatted wikipage links
		$pattern = "/<wikilink name=\"(.*?)\">(.*?)<\/wikilink>/";

		$revision_body = stripslashes($_POST['revision_body']);
		
		if(preg_match_all($pattern, $revision_body, $wikilinks, PREG_PATTERN_ORDER)) {

			if (!empty($wikilinks[1])) {
				foreach ($wikilinks[1] as $key => $i):
					// strip off any anchors
					$anchor_position = strrpos($i, "#");

					if ($anchor_position > 0 ) {
						$i = substr($i, 0, $anchor_position);
					}
					
					$pattern = "/^[a-zA-Z0-9]*$/";
					
					if (!preg_match($pattern, $i)) {
						$GLOBALS['am_error_log'][] = array('wikilink_bad_chars', $i);
					}
					
					
					if (strlen($i) > 30) { // link too long
						$GLOBALS['am_error_log'][] = array('wikilink_too_long', $i);
					}

					$anchor_position = strrpos($i, "#");
				endforeach;
			}
		}



		if (empty($GLOBALS['am_error_log'])) {
			// If it is a first revision we will not have a wiki_page
			if (empty($_POST['wikipage_id'])) {
				// we want to double check this against the name
				$query = "
					SELECT wikipage_id 
					FROM " . $db->prefix . "_plugin_wiki_page 
					WHERE
					webspace_id=" . $output_webspace['webspace_id'] . " AND
					wikipage_name=" . $db->qstr($_POST['wikipage_name'])
				;
				
				$result = $db->Execute($query);
				
				if (isset($result[0])) {
					$_POST['wikipage_id'] = $result[0]['wikipage_id'];
				}
				else {
					// we insert the wiki_page
					$rec = array();
					$rec['webspace_id'] = $_SESSION['webspace_id'];
					$rec['wikipage_name'] = $_POST['wikipage_name'];
					
					if (!empty($_REQUEST['wp'])) {
						$rec['webpage_id'] = $_REQUEST['wp'];
					}
			
					$table = $db->prefix . "_plugin_wiki_page";
			
					$db->insertDb($rec, $table);
			
					$_POST['wikipage_id'] = $db->insertID();
				}
			}
	
	
			// We insert the revision
			$_POST['revision_body'] = am_parse($_POST['revision_body']);
	
	
			$rec = array();
			$rec['revision_body'] = $_POST['revision_body'];
			$rec['connection_id'] = $_SESSION['connection_id'];
			$rec['revision_create_datetime'] = time();
			$rec['wikipage_id'] = $_POST['wikipage_id'];
	
			$table = $db->prefix . "_plugin_wiki_revision";
	
			$db->insertDb($rec, $table);
			$revision_id = $db->insertID();
	
			// we update the wiki_page with the current_revision_id
			if (!empty($revision_id)) {
				$query = "
					UPDATE " . $db->prefix . "_plugin_wiki_page
					SET
					current_revision_id=" . $revision_id . "
					WHERE
					wikipage_id=" . $_POST['wikipage_id']
				;
	
				$db->Execute($query);
			}
				
			$_REQUEST['wikipage_id'] = $_POST['wikipage_id'];
	
			$_SESSION['am_message_log'][] = array($lang['message']['revision_added']);
		}
		else {
			$_POST['revision_body'] = stripslashes($_POST['revision_body']);
			
			$body->set('revision', $_POST);
			unset($_REQUEST['wikipage_id']);
		}
	}

	
	if (!empty($_REQUEST['wikipage_id'])) { // we are editing a page
		$query = "
			SELECT wip.wikipage_id, wip.wikipage_name, r.revision_body
			FROM " . $db->prefix . "_plugin_wiki_page wip, " . $db->prefix . "_plugin_wiki_revision r
			WHERE
			wip.current_revision_id=revision_id AND
			wip.webspace_id=" . $output_webspace['webspace_id'] . " AND
			wip.wikipage_id=" . $_REQUEST['wikipage_id']
		;
		
		$result = $db->Execute($query);
		
		if (isset($result[0])) {
			$output_revision = $result[0];
			$output_revision['revision_body'] = am_render($output_revision['revision_body']);
		}
		
		
	}
	
	if (!isset($output_revision) && !empty($_REQUEST['wikipage_name']) && empty($_POST)) {
		
		$output_revision['wikipage_name'] = $_REQUEST['wikipage_name'];
	}
	
	if (!empty($output_revision)) {
		$body->set('revision', $output_revision);
		
		$lang['txt_wiki_pages'] = str_replace('SYS_KEYWORD_WIKIPAGE_NAME', $output_revision['wikipage_name'], $lang['txt_wiki_pages']);
	}
	
	
	$query = "
		SELECT *
		FROM " . $db->prefix . "_file
		WHERE webspace_id=" . $_SESSION['webspace_id'] . " AND
		file_type LIKE 'image/%'"
	;
	
	$output_images = $db->Execute($query);
	if (!empty($output_images)) {
		$body->set('images', $output_images);
	}
	
	$query = "
		SELECT *
		FROM " . $db->prefix . "_file
		WHERE webspace_id=" . $_SESSION['webspace_id'] . " AND
		file_type NOT LIKE 'image/%'"
	;
	
	$output_files = $db->Execute($query);
	if (!empty($output_files)) {
		$body->set('files', $output_files);
	}
	
	$query = "
		SELECT *
		FROM " . $db->prefix . "_webpage
		WHERE webspace_id=" . $_REQUEST['ws']
	;
	
	$output_pages = $db->Execute($query);
	if (!empty($output_pages)) {
		$body->set('pages', $output_pages);
	}
}
else { // no permission to be here
	header("Location: index.php?ws=" . $_REQUEST['ws']);
	exit;
}
?>