<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
// 
// Copyright (C) 2003-2007 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; see the file COPYING.txt.  If not, see
// <http://www.gnu.org/licenses/>
// -----------------------------------------------------------------------


// MAIN INCLUDES ---------------------------------------------------------
include ("components/core/config/core.config.php");
include ("components/core/inc/functions.inc.php");


// SESSION HANDLER -------------------------------------------------------
// sets up all session and global vars 
session_name($core_config['node']['php_session_name']);
session_start();


if (isset($_REQUEST['logoff']) || (isset($_SESSION['webspace_id']) && empty($_SESSION['webspace_id']))) {
	// if you have not completed creating a webspace and you go to another webspace you will have
	// a webspace_id session of NULL, hence we need to kill your session
	session_unset();
	session_destroy();
	session_write_close();
	header("Location: index.php?ws=" . $_REQUEST['ws']);
	exit;
}


// ERROR HANDLING
// this is accessed and updated with all errors thoughtout this build
// processing regularly checks if empty before continuing
$GLOBALS['am_error_log'] = array();


// SETUP DATABASE ------------------------------------------------------
require_once('components/core/class/Db.class.php');
$db = new Database($core_config['db']);



// SETUP WEBSPACE --------------------------------------------
require_once('components/core/class/Webspace.class.php');
$ws = new Webspace($db); // outer template


if ($core_config['am']['mode'] > 0) { // we always go to a single webspace_id
	$ws->webspace_id = $core_config['am']['mode'];

	if (!empty($_REQUEST['wp'])) { //webpage_id
		$ws->webpage_id = $_REQUEST['wp'];
	}
	elseif (!empty($_REQUEST['wpn'])) { //webpage_name
		$ws->webpage_name = $_REQUEST['wpn'];
	}
}
else { // we use the url to direct to a webspace
	if (isset($_REQUEST['webspace_unix_name'])) {
		$ws->webspace_unix_name = $_REQUEST['webspace_unix_name'];
	}
	elseif (!empty($_REQUEST['ws'])) { //webspace_id
		$ws->webspace_id = $_REQUEST['ws'];
	
		if (!empty($_REQUEST['wp'])) { //webpage_id
			$ws->webpage_id = $_REQUEST['wp'];
		}
		elseif (!empty($_REQUEST['wpn'])) { //webpage_name
			$ws->webpage_name = $_REQUEST['wpn'];
		}
	}
}


if (isset($ws->webpage_name) || isset($ws->webpage_id) || isset($ws->webspace_id) || isset($ws->webspace_unix_name)) {
	$output_webspace = $ws->selWebSpace();
}

if (!isset($_SESSION['language_code'])) {
	if (isset($output_webspace['language_code'])) {
		$_SESSION['language_code'] = $output_webspace['language_code'];
	}
	else {
		$_SESSION['language_code'] = $core_config['language']['pack'][$core_config['language']['default_pack_id']];
	}
}


if (array_key_exists(strtoupper($_SESSION['language_code']), $installed_server_language_packs)) {
	$locale_code = $installed_server_language_packs[strtoupper($_SESSION['language_code'])];

	setlocale(LC_ALL, $locale_code);
}

if (!empty($output_webspace)) {
	// SECURITY CHECK ------------------------------------------
	// is this the webspace that I connected to?
	if (isset($_SESSION['webspace_id'])) {

		if ($_SESSION['webspace_id'] != $output_webspace['webspace_id']) {
			session_unset();
			session_destroy();
			session_write_close();
			header("Location: index.php?ws=" . $output_webspace['webspace_id']);
			exit;
		}
	}

	// is the webspace pending?
	if ($output_webspace['status_id'] != $core_config['webspace']['status']['active'] && !isset($_SESSION['1maintainer']) && (!isset($_REQUEST['t']) || isset($_REQUEST['t'])&& $_REQUEST['t'] != "lock")) {
		header("Location: index.php?ws=" . $output_webspace['webspace_id'] . "&t=lock");
		exit;
	}
	
	// is this webspace locked?
	if (!isset($_SESSION['connection_id']) && $output_webspace['webspace_locked'] == 1 && (!isset($_REQUEST['t']) || isset($_REQUEST['t']) && $_REQUEST['t'] != "lock")) {
		header("Location: index.php?ws=" . $output_webspace['webspace_id'] . "&t=lock");
		exit;
	}
	elseif (isset($_SESSION['connection_id'])) { // I am connected so update my last time used
		$query = "
			UPDATE " . $db->prefix . "_connection
			SET connection_last_datetime=" . $db->dbTime() . "
			WHERE
			connection_id=" . $_SESSION['connection_id']
		;

		$db->Execute($query);
	}
}


// SETUP LANGUAGE ------------------------------------------
$lang = array();
$language_path_core = "components/core/language/" . $_SESSION['language_code'] . "/";
include_once($language_path_core . 'common.lang.php');



// SETUP TEMPLATE -------------------------------------------
$template_path = "template/";
$template_path_core = "components/core/" . $template_path;
	
require_once('components/core/class/Template.class.php');
$tpl = new Template();
$body = new Template();


// check to see if we are we getting a preset template page
if (isset($_REQUEST['t'])) {

	if (!isset($_REQUEST['c'])) {
		$_REQUEST['c'] = "core";
	}

	$language_path = "components/" . strtolower($_REQUEST['c']) . "/language/" . $_SESSION['language_code'] . "/";
	$script_name = strtolower($_REQUEST['t']);
	$component_path = "components/" . strtolower($_REQUEST['c']) . "/";
	$template_file = $component_path . $script_name;

	if (is_file($component_path . $script_name .'.php')) {
		include_once($component_path . $script_name .'.php');

		if ($_REQUEST['c'] != "core" && is_file($component_path . $language_path_core . 'common.lang.php')) {
			include_once($component_path . $language_path_core . 'common.lang.php');
		}

		$tpl->set('script_name', $script_name);
		$body->set('template_path', $component_path);
	}
	else {
		unset ($script_name, $component_path, $template_file, $template_path);
	}
}


if (isset($script_name) || isset($output_webspace)) {
	$tpl->set('lang', $lang);
	$body->set('lang', $lang);
	$tpl->set('template_path_core', $template_path_core);
	$body->set('template_path_core', $template_path_core);
	$body->set('core_config', $core_config);
	$tpl->set('core_config', $core_config);

	if (isset($output_webspace)) {
		$tpl->set('webspace', $output_webspace);
		$body->set('webspace', $output_webspace);
	}
	
	
	// BUILD AND OUTPUT TEMPLATE
	if (!isset($script_name)) {
		$tpl->set('content', $body->makeTemplate($output_webspace, $ws));
	}
	else {
 		unset($tpl->vars['webspace']['webspace_css']);
		$template_file = $script_name . ".tpl.php";
		$tpl->set('content', $body->fetch($component_path . $template_path . $template_file));
	}

	//$tpl->set('content', $content);

	echo $tpl->fetch($template_path_core . 'wrapper.tpl.php');
}
else {
	// error no webspace
	header("Location: " . $core_config['am']['overview_url']);
	exit;
}