<?php

// -----------------------------------------------------------------------
// This file is part of beacon
//
// Copyright (C) 2003, 2005 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.
// -----------------------------------------------------------------------

include "inc/header.inc.php";

if (!isset($_SESSION['user_id'])) {
	if (isset($_REQUEST['item_id'])) {
		$url = "register.php?item_id=" . $_REQUEST['item_id'];
	}
	else {
		$url = "register.php";
	}
	return header("Location: " . $url);
	exit;
}




// SETUP LANGUAGE FILES ---------------------------------------------------
$languageFile = $c_node['node']['language']['pack'][$_SESSION['language_id']][2] . "_admin.lang.php";
require_once($languagePath . $languageFile);





// ITEM --------------------------------------------------------------------
if (isset($frmdata['preview_item'])) {
	
	$frmdata['item_title'] = htmlspecialchars($frmdata['item_title']);
	$frmdata['item_body'] = stripslashes($frmdata['item_body']);
	$frmdata['item_title'] = stripslashes($frmdata['item_title']);
	
	$pages = $item->selPages();
	$wiki->setRenderConf('xhtml', 'wikilink', 'pages', $pages);

	$frmdata['item_body_preview'] = $wiki->transform($frmdata['item_body'], 'Xhtml');
	
	$output_item = $frmdata;
	$output_categories = $item->selCategories();
	$output_wikipagenames = $item->selWikiPageNames();
	$output_filenames = $file->getFiles();
	
	$display = "edit_item";
}
elseif (isset($frmdata['save_item']) || isset($frmdata['save_item_go'])) {
	
	if (empty($frmdata['item_title'])) {
		$GLOBALS['am_error_log'][] = array(3, null);
	}
	
	if (empty($GLOBALS['am_error_log'])) {
		//
		$item->insertItem($frmdata);
		
		if (empty($GLOBALS['am_error_log'])) {
			
			if (isset($frmdata['save_item_go'])) {
				header("Location: index.php");
				exit;
			}
			else {
				header("Location: admin.php?item_id=" . $item->item_id);
				exit;
			}
		}
	}
	else { // something errored
		$output_item = $frmdata;
	}
}
elseif (isset($_REQUEST['list_item']) && $user->checkPermission($c_node['permission']['edit_item'])) {
	unset($item->item_wiki_page);
	$item->order_by = "i.item_wiki_page, i.item_create_datetime desc";
	$output_items = $item->selItems(1);
	
	$display = "list_items";
}
elseif (isset($_REQUEST['item_id']) && $user->checkPermission($c_node['permission']['edit_item'])) {
	$item->item_id = $_REQUEST['item_id'];
	$output_item = $item->selItem();
	$output_categories = $item->selCategories();
	$output_wikipagenames = $item->selWikiPageNames();
	$output_filenames = $file->getFiles();
	
	$display = "edit_item";
}
elseif (isset($_REQUEST['add_item']) && $user->checkPermission($c_node['permission']['edit_item'])) {
	$output_categories = $item->selCategories();
	
	if (isset($_REQUEST['page'])) {
		$output_item['item_wiki_page'] = $_REQUEST['page'];
	}
	
	$display = "edit_item";
}
// FILE --------------------------------------------------------------------

elseif (isset($frmdata['delete_file'])) {
	$file->file_id = $frmdata['file_id'];
	$delete_file = $file->getFileRecord();
	
	if (isset($delete_file)) {
		$file->deleteFile($delete_file['file_name'], $delete_file['file_suffix']);
	}
	
	$file->deleteFileRecord($frmdata['file_id']);

	if (empty($GLOBALS['am_error_log'])) {
		return header("Location: admin.php?list_files=1&" . SID);
		exit;
	}
}
elseif (isset($frmdata['update_file'])) {
	
	if (isset($_FILES['upload_file']) && $_FILES['upload_file']['size'] > 0) {
		$file_upload = $_FILES['upload_file'];
		$file_upload['file_suffix'] = substr($_FILES['upload_file']['name'], -3);
		$file_upload['file_name'] = substr($_FILES['upload_file']['name'], 0, -4);
		//we will only allow file names of 10 characters for easy filing
		if (strlen($file_upload['file_name']) > 10) {
		    $file_upload['file_name'] = substr($file_upload['file_name'], 0, 10);
		}
		//remove any spaces
		$file_upload['file_name'] = str_replace(" ", "", $file_upload['file_name']);
		
		//add 3 random number to end (reduces chances of duplicate naming)
		$file_upload['file_name'] .= rand(100,999);
		
		
		
		$file->file_id = $frmdata['file_id'];
		$file->arr_file_upload = $file_upload;
		
		if ($file->checkFile()) {
			$file->deleteFile($frmdata['file_name'], $frmdata['file_suffix']);
			$file->updateFileRecord();
			$file->moveFile();
		}
		
		if (empty($GLOBALS['am_error_log'])) {
			return header("Location: admin.php?list_files=1&" . SID);
			exit;
		}
	}
	else {
		return header("Location: admin.php?list_files=1&" . SID);
		exit;
	}
}
elseif ((isset($_REQUEST['list_files']) || isset($_REQUEST['file_id'])) && $user->checkPermission($c_node['permission']['edit_file'])) {
	if (isset($_REQUEST['file_id'])) {
		$file->file_id = $_REQUEST['file_id'];
		$output_file = $file->getFileRecord();
	}
	
	$file->thumb = $c_node['file']['image']['thumb'][1]['name'];
	$output_files = $file->getFiles();
	
	$display = "list_files";
}
elseif (isset($frmdata['insert_file'])) {
	
	if ($_FILES['upload_file']['size'] > 0) {
		$file_upload = $_FILES['upload_file'];
			
		if (!empty($c_node['file']['mime']['browser_path'])) {
			foreach($c_node['file']['mime']['browser_path'] as $i):
				if ($i['from'] == $file_upload['type']) {
					$file_upload['type'] = $i['to'];
				}
			endforeach;
		}
		
		$file->arr_file_upload = $file_upload;
		if ($file->checkFile()) {
			$file->insertFileRecord();
			$file->moveFile();
		}
		
		if (empty($GLOBALS['beacon_error_log'])) {
			return header("Location: admin.php?list_files=1&" . SID);
			exit;
		}
	}
	else {
		return header("Location: admin.php?list_files=1&" . SID);
		exit;
	}
}
// MENU --------------------------------------------------------------------
elseif (isset($frmdata['save_menu']) || isset($frmdata['save_go_menu'])) {
	
	if (empty($frmdata['menu_title'])) {
		$GLOBALS['am_error_log'][] = array(3, null);
	}
	
	if (empty($GLOBALS['am_error_log'])) {
		//
		$menu->user_id = $_SESSION['user_id'];
		
		if (isset($frmdata['menu_id']) && $frmdata['menu_id'] > 0) {
			 //we update the event
			$menu->updateMenuItem($frmdata);
		}
		else { //we insert record
			$menu->insertMenuItem($frmdata);
		}
		
		if (empty($GLOBALS['am_error_log'])) {
			
			if (isset($frmdata['save_go_menu'])) {
				header("Location: index.php?".SID);
				exit;
			}
			else {
				if (isset($frmdata['menu_id']) && $frmdata['menu_id'] > 0) {
					$location = "admin.php?menu_id=" . $frmdata['menu_id'];
				}
				else {
					$location = "admin.php?list_menu=1";	
				}
				header("Location: " . $location . "&".SID);
				exit;
			}
		}
		else { // something errored
			$output_menu = $frmdata;
		}
	}
}
elseif (isset($frmdata['delete_menu']) && isset($frmdata['menu_id'])) {
	$menu->deleteMenuItem($frmdata['menu_id']);
	
	header("Location: admin.php?edit_menu=1&".SID);
	exit;
}
elseif ((isset($_REQUEST['list_menu'])) && $user->checkPermission($c_node['permission']['edit_menu'])) {
	
	$output_menu = $menu->SelMenu();
	
	$display = "edit_menu";
}
elseif ((isset($_REQUEST['edit_menu']) || isset($_REQUEST['menu_id'])) && $user->checkPermission($c_node['permission']['edit_menu'])) {
	if (isset($_REQUEST['menu_id'])) {
		$menu->menu_id = $_REQUEST['menu_id'];
		$output_menu_item = $menu->SelMenuItem();
	}
	
	$output_menu = $menu->SelMenu();
	$output_categories = $item->selCategories();
	$output_wikipagenames = $item->selWikiPageNames();
	
	$display = "edit_menu";
}
// CATEGORIES --------------------------------------------------------------
elseif (isset($frmdata['insert_category'])) {
	$item->user_id = $_SESSION['user_id'];
	$item->language_id = $_SESSION['language_id'];
	$item->insertCategory($frmdata);
	
	if (empty($GLOBALS['beacon_error_log'])) {
		return header("Location: admin.php?list_categories=1&" . SID);
		exit;
	}
}
elseif (isset($frmdata['update_category'])) {
	$item->user_id = $_SESSION['user_id'];
	$item->language_id = $_SESSION['language_id'];
	$item->updateCategory($frmdata);
	
	if (empty($GLOBALS['beacon_error_log'])) {
		return header("Location: admin.php?list_categories=1&" . SID);
		exit;
	}
}
elseif ((isset($_REQUEST['list_categories']) || isset($_REQUEST['category_parent']) || isset($_REQUEST['category_id'])) && $user->checkPermission($c_node['permission']['edit_category'])) {
	$output_categories = $item->selCategories();
	
	if (isset($_REQUEST['category_parent'])) {
		$output_category = array("parent_id" => $_REQUEST['category_parent']);
		$output_category['parent'] = $item->selCategory($_REQUEST['category_parent']);
	}
	
	if (isset($_REQUEST['category_id'])) {
		$output_category = $item->selCategory($_REQUEST['category_id']);
	}
	
	$display = "edit_categories";
}
// USERS --------------------------------------------------------------
elseif (isset($frmdata['arr_user_permission'])) {
	$user->user_id = $frmdata['user_id'];
	$user->updateUserPermissions($frmdata['arr_user_permission']);
	
	if (isset($frmdata['user_id'])) {
		$output_user_permissions = $user->selUserPermissions();
		$body->set('user_id', $frmdata['user_id']);
	}
	
	$output_users = $user->selUsers();
	
	$display = "list_users";
}
elseif ((isset($_REQUEST['list_users']) || isset($_REQUEST['user_id'])) && $user->checkPermission($c_node['permission']['edit_user'])) {
	$output_users = $user->selUsers();
	
	if (isset($_REQUEST['user_id'])) {
		$output_user_permissions = $user->selUserPermissions();
		$body->set('user_id', $_REQUEST['user_id']);
	}
	
	$display = "list_users";
}



//TEMPLATE
if (!empty($output_items)) {
	$body->set('items', $output_items);
}

if (!empty($output_item)) {
	$body->set('item', $output_item);
}

if (!empty($output_files)) {
	$body->set('files', $output_files);
}

if (!empty($output_wikipagenames)) {
	$body->set('wikipagenames', $output_wikipagenames);
}

if (!empty($output_file)) {
	$body->set('out_file', $output_file);
}

if (isset($display)) {
	$body->set('display', $display);
}

if (isset($_REQUEST['page'])) {
	$body->set('page', $_REQUEST['page']);
}

if (!empty($output_menu)) {
	$body->set('menu', $output_menu);
	$body->set('menus', $c_node['menu']['menu']);
	$body->set('menu_link_types', $c_node['menu']['link_type']);
}

if (!empty($output_menu_item)) {
	$body->set('menu_item', $output_menu_item);
}

if (!empty($output_categories)) {
	$body->set('categories', $output_categories);
}

if (!empty($output_category)) {
	$body->set('category', $output_category);
}

if (!empty($output_users)) {
	$body->set('users', $output_users);
}

if (!empty($output_user_permissions)) {
	$body->set('user_permissions', $output_user_permissions);
}

if (!empty($output_filenames)) {
	$body->set('filenames', $output_filenames);
}


$template_file = "admin.tpl.php";
include "inc/footer.inc.php";

?>
