<?php

// -----------------------------------------------------------------------
// This file is part of Beacon
//
// Copyright (C) 2003, 2005 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//

// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------

class User {
	// CLASS FUNCTIONS
	// User
	// loginUser
	// selUser
	// registerUser
	// sendPassword
	// getPermission
	// selUsers
	// selUserPermissions
	// updateUserPermissions
	// sendNewPassword
	// _verifyEmailAddress
	// _createPassword
	// updateUser
	// confirmationRegistration
	// _setLocale



	// User ------------------------------------------------------------------
	// the constuctor
	// tom calthrop - 28th May 2005
	//
	function User($db) {
		$this->db = $db;
	}//EO User



	// loginUser -------------------------------------------------------------
	// logs in the user
	// tom calthrop - 28th May 2005
	//
	function loginUser($email, $password) {
		
		if (empty($email) || empty($password)) {
			$GLOBALS['beacon_error_log'][] = array(4, null);
		}
		
		if (empty($GLOBALS['beacon_error_log'])) {
			$query = "SELECT
				u.user_id, u.user_email, u.user_name, u.language_id, u.role_id 
				FROM " . $this->db->prefix . "_user u 
				WHERE 
				u.user_email=" . $this->db->qstr($email, get_magic_quotes_gpc()) . " AND 
  				u.user_password=" . $this->db->qstr(MD5($password), get_magic_quotes_gpc()) . " AND 
				u.status_id=" . $this->user_status_ids['live']
			;
			//echo $query;
			$result = $this->db->Execute($query);
	
			if (isset($result->fields['user_id'])){
				
				$this->user_id = $result->fields['user_id'];
	
				// Sets the session variables
				$_SESSION['s_user_id'] = 		$result->fields['user_id'];
				$_SESSION['user_name'] = 		$result->fields['user_name'];
				$_SESSION['user_email'] = 		$result->fields['user_email'];
				$_SESSION['language_id'] = 		$result->fields['language_id'];
				$_SESSION['role_id'] = 			$result->fields['role_id'];
				$_SESSION['installation_name'] = $this->installation_name;
				
				
				$query = "
				  SELECT *
				  FROM " . $this->db->prefix . "_user u
				  WHERE u.user_id=" . $result->fields['user_id']
				;
				
				$result = $this->db->Execute($query);
				
				$rec = array();
				$rec['user_last_login_datetime'] = time();
				
				$query = $this->db->GetUpdateSQL($result, $rec, false, get_magic_quotes_gpc());
				
				$result1 = $this->db->Execute($query);
				
				//set locale
				if (isset($result->fields['language_id'])) {
				    $this->_setLocale($result->fields['language_id']);
				}
				
			}
			else {
				$GLOBALS['beacon_error_log'][] = array(5, null);
			}
		}
	}//EO loginUser



	// selUser ---------------------------------------------------------------
	// retrieves single DB row for user
	// tom calthrop - 28th May 2005
	//
	function selUser($user_id = null) {
		if (empty($user_id) && isset($this->user_id)) {
			$user_id = $this->user_id;
		}

		$query = "
			SELECT u.user_id, u.user_name, u.user_email, 
			u.allow_correspondence, u.show_email, u.status_id  
			FROM " . $this->db->prefix . "_user u
			WHERE 
			u.user_id=" . $user_id
		;
		
		$result = $this->db->Execute($query);

		if (isset($result->fields['user_id'])) {
			$temp = $result->fields;
			$this->user_id = $temp['user_id'];

			$result->Close();
			return $temp;
		}
	}//EO selUser


	
	// registerUser ---------------------------------------------------------------
	// inserts row into user table
	// tom calthrop - 28th May 2005
	//
	function registerUser($data, $message_file) {
		
		if (empty($data['user_email']) || empty($data['user_password'])) {
			$GLOBALS['beacon_error_log'][] = array(15, null);
		}
		
		if (isset($data['user_password']) && strlen($data['user_password']) < 5) {
			$GLOBALS['beacon_error_log'][] = array(6, null);
		}
		
		if (empty($GLOBALS['beacon_error_log'])) {
			
			if (!empty($data['allow_correspondence'])) {
				$allow_correspondence = 1;
			}
			else {
				$allow_correspondence = "null";
			}
			
			if (!empty($data['show_email'])) {
				$show_email = 1;
			}
			else {
				$show_email = "null";
			}
			
			$password = md5($data['user_password']);
			
			$rec = array();
			$rec['user_name'] = $data['user_name'];
			$rec['user_email'] = $data['user_email'];
			$rec['language_id'] = $data['language_id'];
			$rec['allow_correspondence'] = $allow_correspondence;
			$rec['show_email'] = $show_email;
			$rec['user_password'] = $password;
			$rec['user_create_datetime'] = time();
			$rec['status_id'] = $this->user_status_ids['pending'];
			$rec['role_id'] = $this->role_id;
			
			$table = $this->db->prefix . "_user";
			$query = $this->db->GetInsertSQL($table, $rec, get_magic_quotes_gpc());
			//echo $query;
			$result = $this->db->Execute($query);
			
			if (!empty($result)) {
				$user_id = $this->db->Insert_ID();
				//send email with details and link to complete registration
				$body_file_txt = readTxtFile($message_file);
				$body_file_txt = str_replace("\\\"", "\"", $body_file_txt);
				$body_file_txt = str_replace("USERNAME", $data['user_name'], $body_file_txt);
				$body_file_txt = str_replace("PASSWORD", $data['user_password'], $body_file_txt);
				//create URL
				$url = "http://" . $_SERVER['HTTP_HOST'];
				$url .= dirname ($_SERVER['PHP_SELF']);
				//sometimes the server adds / as the last character - we check.
				if (substr($url, -1, 1) != "/") {
					$url .= "/";
				}
				
				$confirmation = $user_id . "-" . substr($password, 2,8);
				$url .= "splash.php?confirmation=" . $confirmation;
				
				$body_file_txt = str_replace("URL", $url, $body_file_txt);
				
				//send email to user
				$this->mail->Body = $body_file_txt;
				$this->mail->AddAddress($data['user_email'], $data['user_name']);
				
				if(!$this->mail->Send()) {
					$error_info = "function=registerUser class=User.class.php - Mailer Error: " . $this->mail->ErrorInfo;
					$GLOBALS['beacon_error_log'][] = array(16, $error_info);
				}
			}
		}
	}//EO registerUser
	
	
	
	// checkPermission --------------------------------------------------------
	// returns true if permission is set.
	// tom calthrop - 28th May 2005
	//
	function checkPermission($permission_id) {
		if (!isset($this->user_id)) {
			return 0;
			break;
		}
		
		$query = "
			SELECT user_id 
			FROM " . $this->db->prefix . "_permission 
			WHERE 
			user_id=" . $this->user_id . " AND 
			permission_id=" . $permission_id
		;
		
		$result = $this->db->Execute($query);
			
		if (!empty($result->fields['user_id'])) {
			return 1;
			$result->Close();
		}
		else{
			return 0;
		}
	} //EO checkPermission
	
	
	
	// selUsers --------------------------------------------------------------------
	// returns multiple rows of items from DB
	// tom calthrop - 31st May 2005
	//
	function selUsers($search=null) {
		$query = "
			SELECT u.user_id, u.user_name, u.user_email, u.status_id, u.role_id 
			FROM " . $this->db->prefix . "_user u  
			WHERE "
		;
		
		if (isset($this->status_id)) {
			$query .= "u.status_id=" . $this->db->qstr($this->status_id, get_magic_quotes_gpc()) . " AND ";
		}
		
		if (isset($this->role_id)) {
			$query .= "u.role_id=" . $this->db->qstr($this->role_id, get_magic_quotes_gpc()) . " AND ";
		}
		
		if (isset($search)) {
			$searchStr = "%". $search . "%";
			
			$query .= "(
				u.user_name like " . $this->db->qstr($searchStr, get_magic_quotes_gpc()) . " OR 
				u.user_email like " . $this->db->qstr($searchStr, get_magic_quotes_gpc()) . ") AND "
			;
		}
		
		$query .="1=1 ";

		if (isset($this->order_by)) {
		    $query .= "order by u." . $this->order_by;
		}
		else {
			$query .= "order by u.user_id";
		}
		
		$result = $this->db->Execute($query);
		
		if (isset($result->fields)) {
			$temp = array();

			while (!$result->EOF) {

				$temp1 = $result->fields;
				$temp1['user_email'] = formatEmail($temp1['user_email']);
				//format search results
				if (isset($search)) {
					$temp1['user_name'] = searchTextFormat($search, $temp1['user_name']);
					$temp1['user_email'] = searchTextFormat($search, $temp1['user_email']);
				}
				array_push($temp, $temp1);

				$result->MoveNext();
			}

			$result->Close();
			return $temp;
		}
		else {
			$error_info = "function=selUsers class=User.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['beacon_error_log'][] = array(1, $error_info);
		}
	} //EO selUsers()
	
	
	// updateUserRole --------------------------------------------------------
	// update users role
	// tom calthrop - 28th May 2005
	//
	function updateUserRole($role_arr) {
		if (!empty($role_arr)) {
			foreach($role_arr as $key => $i):
				$query = "
					SELECT role_id, user_id 
					FROM " . $this->db->prefix . "_user 
					WHERE 
					user_id=" . $key
				;
				
				$result = $this->db->SelectLimit($query, 1);
				
				$rec = array();
				$rec['role_id'] = $i;
				
				$query = $this->db->GetUpdateSQL($result, $rec, false, get_magic_quotes_gpc());
				$result = $this->db->Execute($query);
			endforeach;
		}
	} // EO updateUserRole
	
	
	// updateUserStatus --------------------------------------------------------
	// update users status
	// tom calthrop - 28th May 2005
	//
	function updateUserStatus($status_arr) {
		
		if (!empty($status_arr)) {
			foreach($status_arr as $key => $i):
				$query = "
					SELECT status_id, user_id 
					FROM " . $this->db->prefix . "_user 
					WHERE 
					user_id=" . $key
				;
				
				$result = $this->db->SelectLimit($query, 1);
				//echo $key;
				$rec = array();
				$rec['status_id'] = $i;
				
				$query = $this->db->GetUpdateSQL($result, $rec, false, get_magic_quotes_gpc());
				$result = $this->db->Execute($query);
			endforeach;
		}
	} // EO updateUserStatus
	
	
	// sendNewPassword --------------------------------------------------------
	// update user permissions
	// tom calthrop - 28th May 2005
	//
	function sendNewPassword($data, $messageIncPath) {
		// is the email/pass valid?
		if (!$this->_verifyEmailAddress($data['user_email'])) {
			$GLOBALS['beacon_error_log'][] = array(15, null);
		}
		
		
		// check that the email is a valid user.
		$query = "
			SELECT *
			FROM " . $this->db->prefix . "_user 
			WHERE 
			user_email=" . $this->db->qstr($data['user_email'], get_magic_quotes_gpc())
		;
		
		$result = $this->db->SelectLimit($query, 1);
		
		if (isset($result->fields['user_id'])) {
			$user_email = $result->fields['user_email'];
			$user_name = $result->fields['user_name'];
			
			// we make a new password
			$password = $this->_createPassword();
			
			//we update the db with the new password
			$rec = array();
			$rec['user_password'] = md5($password);
			$query = $this->db->GetUpdateSQL($result, $rec, false, get_magic_quotes_gpc());
			$result = $this->db->Execute($query);
			
			if (!empty($result)) {
				// we send the new password to the user
				$body_file_txt = readTxtFile($messageIncPath);
				$body_file_txt = str_replace("\\\"", "\"", $body_file_txt);
				$body_file_txt = str_replace("USERNAME", $user_name, $body_file_txt);
				$body_file_txt = str_replace("PASSWORD", $password, $body_file_txt);
				//create URL
				$url = "http://" . $_SERVER['HTTP_HOST'];
				$url .= dirname ($_SERVER['PHP_SELF']);
				//sometimes the server adds / as the last character - we check.
				if (substr($url, -1, 1) != "/") {
					$url .= "/";
				}
				$body_file_txt = str_replace("URL", $url, $body_file_txt);
				
				//send email to user
				$this->mail->Body = $body_file_txt;
				$this->mail->AddAddress($user_email, $user_name);
				
				if(!$this->mail->Send()) {
					$error_info = "function=sendNewPassword class=User.class.php - Mailer Error: " . $this->mail->ErrorInfo;
					$GLOBALS['beacon_error_log'][] = array(16, $error_info);
				}
			}
			else {
				$error_info = "function=sendNewPassword class=User.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
				$GLOBALS['beacon_error_log'][] = array(1, $error_info);
			}
		}
		else { // email does not exist
			$GLOBALS['beacon_error_log'][] = array(5, null);
		}
	} // EO sendNewPassword
	
	
	
	// _verifyEmailAddress --------------------------------------------------------
	// check if an email address is formatted correctly
	// tom calthrop - 8th June 2005
	//
	function _verifyEmailAddress($email) {
		if (!empty($email)) {
			return true;
			break;
		}
		elseif(preg_match('/^[-A-Za-z0-9_.]+[@][A-Za-z0-9_-]+([.][A-Za-z0-9_-]+)*[.][A-Za-z]{2,8}$/', $email)) {
			return true;
			break;
		}
		else {
			return false;
		}
	} // EO _verifyEmailAddress
	
	
	
	// _createPassword --------------------------------------------------------
	// creates a password
	// tom calthrop - 8th June 2005
	//
	function _createPassword() {
		$totallength = 8;
		$salt = "abcdefghijklmnpqrstuvwxyzABCDEFGHIJKLMNPQRSTUVWXYZ123456789";
		srand((double)microtime()*1000000);
		$password = "";
		for ($i = 0; $i < $totallength; $i++) {
			$password .= substr ($salt, rand() % strlen($salt), 1);
		}
		
		return $password;
	} // EO _createPassword


	
	// updateUser ---------------------------------------------------------------
	// inserts row into user table
	// tom calthrop - 28th May 2005
	//
	function updateUser($data) {
		
		if (!empty($data['allow_correspondence'])) {
			$allow_correspondence = 1;
		}
		else {
			$allow_correspondence = "null";
		}
			
		if (!empty($data['show_email'])) {
			$show_email = 1;
		}
		else {
			$show_email = "null";
		}
		
		if (!empty($data['password'])) {
			$password = md5($data['password']);
		}
		
		$query = "
			SELECT * 
			FROM " . $this->db->prefix . "_user
			WHERE 
			user_id=" . $_SESSION['s_user_id']
		;
		
		$result = $this->db->SelectLimit($query, 1);
		
		if (!empty($result)) {
			$rec = array();
			$rec['user_name'] = $data['user_name'];
			$rec['language_id'] = $data['language_id'];
			$rec['allow_correspondence'] = round($allow_correspondence);
			$rec['show_email'] = $show_email;
			if (isset($password)) {
				$rec['user_password'] = $password;
			}
			
			$table = $this->db->prefix . "_user";
			$query = $this->db->GetUpdateSQL($result, $rec, false, get_magic_quotes_gpc());
			
			$result = $this->db->Execute($query);
			
			$_SESSION['user_name'] = $data['user_name'];
			
		}
		else {
			$error_info = "function=updateUser class=User.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['beacon_error_log'][] = array(1, $error_info);
		}
	}//EO updateUser
	
	
	// confirmationRegistration ---------------------------------------------------------------
	// inserts row into user table
	// tom calthrop - 28th May 2005
	//
	function confirmationRegistration($confirmationID) {
		$confirmation_arr = explode("-", $confirmationID);
		
		$user_id = $confirmation_arr[0];
		$user_code = $confirmation_arr[1];
		
		if ($user_id > 0 && strlen($user_code) == 8) {
			// select user
			$query = "
				SELECT * 
				FROM " . $this->db->prefix . "_user
				WHERE 
				user_id=" . $user_id
			;
			//echo $query;
			$result = $this->db->SelectLimit($query, 1);
			
			if (isset($result->fields['user_id'])) {
				//check user_code against password
				$check_pass = substr($result->fields['user_password'], 2,8);
				
				if ($result->fields['status_id'] == $this->user_status_ids['live']) {
					//already confiirmed
					$GLOBALS['beacon_error_log'][] = array(21, null);
				}
				elseif ($user_code == $check_pass) {
					
					$this->user_email = $result->fields['user_email'];
					
					//update user status
					$rec = array();
					$rec['status_id'] = $this->user_status_ids['live'];
					
					$table = $this->db->prefix . "_user";
					$query = $this->db->GetUpdateSQL($result, $rec, false, get_magic_quotes_gpc());
					
					$result = $this->db->Execute($query);
					
				}
				else { //error
					$GLOBALS['beacon_error_log'][] = array(19, null);
				}
			}
			else { //error
				$GLOBALS['beacon_error_log'][] = array(19, null);
			}
		}
		else { //error
			$GLOBALS['beacon_error_log'][] = array(19, null);
		}
	}//EO confirmationRegistration
	
	
	// updateUserAdmin ------------------------------------------------------
	// updates user by system admins
	// tom calthrop - 8th June 2005
	//
	function updateUserAdmin($data) {
	
	$query = "
			SELECT * 
			FROM " . $this->db->prefix . "_user
			WHERE 
			user_id=" . $this->user_id
		;
		
		$result = $this->db->SelectLimit($query, 1);
		
		if (isset($result->fields['user_id'])) {
			
			$rec = array();
			$rec['status_id'] = $data['status_id'];
			
			$table = $this->db->prefix . "_user";
			$query = $this->db->GetUpdateSQL($result, $rec, false, get_magic_quotes_gpc());
					
			$result = $this->db->Execute($query);
		}
	} // EO updateUserAdmin



	// _setLocale --------------------------------------------------------------------
	// setup local language for date setting etc
	// tom calthrop - 19th April 2004
	//
	function _setLocale($language_id = null) {

		if (isset($language_id) && isset($this->language_arr['pack'][$language_id][0])) {
		    setlocale(LC_ALL,$this->language_arr['pack'][$language_id][0]);
		}
		else { //We default to English
		    setlocale(LC_ALL,"eng");
		}
	} // EO _setLocale
	
}
