<?php

// -----------------------------------------------------------------------
// This file is part of Beacon
// 
// Copyright (C) 2003, 2005 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------

?>

<?php
if (isset($display) && $display == "edit") {
?>

<form action="newsletter.php" method="post">

<div class="box">
	<div class="box_top">
		<?php echo $lang['hdr_newsletter'];?><br />
	</div>
	
	<div class="box_mid">
		<div class="content">
			<p>
				<?php echo $lang['txt_newsletter_intro'];?><br />
			</p>

			<p>
			<label for="id_subject"><?php echo $lang['form_label_subject'];?></label>
			<input type="text" id="id_subject" name="subject"  size="40" value="" />
			
			<p>
			<label for="id_message"><?php echo $lang['form_label_newsletter'];?></label>
			<textarea for="id_message" name="message" rows="15" cols="60"></textarea>
			</p>
			
			<?php
			if(count($lang['language'] == 1)) {
			?>
				<input type="hidden" name="language_id" value="<?php echo $_SESSION['language_id'];?>" />
			<?php
			}
			else {
			?>
			<p>
			<label for="id_language"><?php echo $lang['form_label_language'];?></label>
			<select id="id_language" name="language_id">
			<?php
			foreach($lang['language'] as $key => $i):
			?>
			<option value="<?php echo $key;?>"><?php echo $i;?></option>
			<?php endforeach; ?>
			</select>
			</p>
			<?php }?>
			
			<p align="right">
			<?php if (isset($allow_spellcheck)) {?>
				<input type="button" value="<?php echo $lang['form_submit_spelling'];?>" class="button" onClick="openSpellChecker();" />&nbsp;&nbsp;
			<?php }?>
							
			<input type="submit" name="send_newsletter" value="<?php echo $lang['sub_send'];?>" class="button" /><br />
			</p>
		</div>
	</div>
</div>
	
<div class="box_bottom">
	<span class="box_bottom_right"></span>
	<span class="box_bottom_left"></span>
</div>
</form>

<?php
}
else {
?>

<div class="col_main">
	<div class="box">
		<div class="box_top">
			<?php
			if (isset($newsletter)) {
				echo $this->date->formatDate($newsletter['message_create_datetime'], 1);
			}
			else {
				echo $lang['hdr_newsletters'];
			}
			?>
			<br />
		</div>
		
		<div class="box_mid">
			<div class="content">
				<?php
				if (isset($newsletter)) {
				?>
				<p class="txt_item_title">
					<?php echo $newsletter['message_subject'];?><br />
				</p>
				
				<p>
				<?php echo $newsletter['message_body'];?><br />
				</p>
				<?php
				}
				elseif (isset($newsletters)) { //list view
				?>
				
				<table width="100%" cellpadding="4" cellspacing="0" border="0">
					<?php
					foreach($newsletters as $key => $i):
					?>
					<tr>
						<td>
							<a href="nlt_view.php?message_id=<?php echo $i['message_id'];?>"><?php echo $i['message_subject'];?></a><br />
						</td>
						<td>
							<?php echo $i['message_status'];?><br />
						</td
					</tr>
					<?php
					endforeach;
					?>
				</table>
				<?php
				}
				else  { //error - no newsletters
					echo $lang['err_no_newsletters'] . "<br />";
				}?>
			</div>
		</div>
	</div>
		
	<div class="box_bottom">
		<span class="box_bottom_right"></span>
		<span class="box_bottom_left"></span>
	</div>
</div>

<div class="col_side">
	<form action="newsletter.php" method="post" name="frm_view" id="id_frm_view">
	<input type="hidden" name="message_id" value="<?php if(isset($newsletter['message_id'])) { echo $newsletter['message_id'];}?>" />
	
	<div class="box">
		<div class="box_top">
			<?php echo $lang['hdr_options'];?><br />
		</div>
		
		<div class="box_mid">
			<div class="content">
				<select name="options" class="options_select">
					<?php
					if (isset($newsletter)) {
					?>
					<option value="list" selected="selected"><?php echo $lang['txt_option_list'];?></option>
					<?php
					if ($this->user_acs->checkPermission($resource_ids['newsletter'], $privilege_ids['allow_edit'])) { //resourece_id, Priv_id
					?>
					<option value="item_edit"><?php echo $lang['txt_option_edit'];?></option>
					<?php }?>
					<option> </option>
					<?php }?>
					<?php
					if ($this->user_acs->checkPermission($resource_ids['newsletter'], $privilege_ids['allow_edit'])) { //resourece_id, Priv_id
					?>
					<option value="item_add"><?php echo $lang['txt_option_add'];?></option>
					<?php }?>
				</select>
				<input type="image" src="<?php echo $templatePath;?>img/go.png" name="option_action" value="1" class="go" /><br />
			</div>
		</div>
	</div>
		
	<div class="box_bottom">
		<span class="box_bottom_right"></span>
		<span class="box_bottom_left"></span>
	</div>
	</form>
</div>
<?php }?>
