<?php

// -----------------------------------------------------------------------
// This file is part of Beacon
//
// Copyright (C) 2003, 2005 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------

include "inc/header.inc.php";


// SETUP TAGS
require_once($c_node['dir']['class_path'] . 'Tag.class.php');
$tag = new Tag($db);
$output_tags = $tag->selTags();

if (!empty($_REQUEST['tag'])) {
	$item->tag = $_REQUEST['tag'];
	$output_items = $item->selItems(1,null);
	
	$lang['txt_list_intro'] = $lang['txt_intro_tag'];
	$lang['txt_list_intro'] = str_replace("TAGNAME", $_REQUEST['tag'], $lang['txt_list_intro']);
}
elseif (isset($frmdata['search_text']) && strlen(trim($frmdata['search_text'])) >= 3) {
   $search_text = trim($frmdata['search_text']);
   
   if ($frmdata['search_version'] == 1) {
	   $output_items = $item->selItems(1,$search_text);
   }
   else {
	   $output_items = $item->selItems(null,$search_text);
   }

}
elseif (isset($frmdata['search_text'])) {
	$GLOBALS['beacon_error_log'][] = array(12, null);
}
elseif (isset($_REQUEST['contents'])) {
	$output_items = $item->selItems();
}
elseif (isset($_REQUEST['wiki_id'])) { // we get the items history
	$item->wiki_id = $_REQUEST['wiki_id'];
	$wikipage = $item->selWikiPage();
	
	$output_items = $item->selItems(1);
	
	$lang['txt_list_intro'] = $lang['txt_intro_history'];
	$lang['txt_list_intro'] = str_replace("WIKIPAGE", $wikipage['wiki_page'], $lang['txt_list_intro']);
}

//get the tags for each item
if (!empty($output_items)) {
	foreach ($output_items as $key => $i):
		$tag->item_id = $i['item_id'];
		$output_items[$key]['tags'] = $tag->selTags();
	endforeach;
}
	
	
//move to template
if (!empty($output_items)) {
    $body->set('items', $output_items);
}

if (!empty($_REQUEST['tag'])) {
	$body->set('tag', $_REQUEST['tag']);
}
elseif (!empty($search_text)) {
    $tpl->set('search_text', $search_text);
}

if (!empty($output_tags)) {
	$body->set('node_tags', $output_tags);
}

include "inc/footer.inc.php";

?>
