/*
 * BMovieReviewer Copyright (C) 2009 Michael J. Beer
 * 
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program. If not, see <http://www.gnu.org/licenses/>.
 */
package gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumn;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;

import data.Bogen;
import data.Wrappers;
import data.Wrappers.Link;
import data.Wrappers.LinkList;

public class Gui extends JPanel {

	private static final long serialVersionUID = 1L;

	public final static String TITEL = "BMovieCreator";

	public final static int mainWidth = 800;

	public final static int mainHeight = 800;

	public final static int borderWidth = 4;

	public final static int punktHeight = 40;

	//	protected int labelColWidth = 30;
	//	protected int pointColWidth = 30;
	//	protected int noteColWidth = 30;
	//	protected int pointLineHeight = 30;

	public final static int ANMERKUNGEN_WIDTH = 200;

	public final static int FSK_WIDTH = 30;

	protected JFrame mainFrame;

	protected Bogen bogen;

	/** 
	 * Art der Anwendung:
	 * 0    Stand-alone
	 * 1    Applet
	 * 2    Servlet
	 */
	protected int appType = 0;

	protected JTextComponent[] textfelder;

	protected JTextComponent[] anmerkungen;

	protected PunktListener[] punkteListener;

	//protected JComboBox[] punktWertungen;
	protected List<BogenListener> bogenListeners;

	protected JList zitate;
	protected JTable links;
	protected JTextField cover;
	protected JComboBox cbCellEditor;

	protected int textHeight = 20;

	/**
	 * erzeugt den huaptframe neu, so dass er anschlieszend die geforderte
	 * gestalt hat
	 */
	
	protected void terminate() {
		System.out.println(TITEL + " beendet");
		if (appType == 1) { // je nachdem: applet oder applikation
			// abwuergen
			// die unterscheidung ist eigentlich nicht SOO
			// notwendig
			// hauptFrame.dispose();
			mainFrame.setVisible(false);
		} else {
			System.exit(0);
		}
	}
	
	
	protected void erzeugeFrame(String titel) {

		if (mainFrame != null)
			mainFrame.dispose();

		mainFrame = new JFrame(titel);

		mainFrame.addWindowListener(new WindowAdapter() { // implementiert die
					// reaktion des fensters auf einen klick auf "x" in
					// titelleiste
					public void windowClosing(WindowEvent e) {
						terminate();
					}
				});

		//int punktwertungHoehe = 8 * punktHeight + 2* borderWidth;

		setLayout(new BoxLayout(this, BoxLayout.X_AXIS));

		//CardLayout cards = new CardLayout();
		JTabbedPane haupt = new JTabbedPane();

		// Hier muss der bogen noch abstrahiert werden...
		JPanel panel = erzeugeAllgPanel();
		panel.setVisible(true);
		haupt.add(panel, "Allgemein");

		panel = erzeugeTextPanel(Bogen.I_TECHNISCH);
		panel.setVisible(true);
		haupt.add(panel, "Technische Fehler");

		panel = erzeugeTextPanel(Bogen.I_INHALT);
		panel.setVisible(true);
		haupt.add(panel, "Inhaltliche Fehler");

		panel = erzeugeTextPanel(Bogen.I_WISSENSCHAFT);
		panel.setVisible(true);
		haupt.add(panel, "Wissenschaftlich");

		panel = erzeugeTextPanel(Bogen.I_BILD);
		panel.setVisible(true);
		haupt.add(panel, "Bild");

		panel = erzeugeTextPanel(Bogen.I_HANDLUNG);
		panel.setVisible(true);
		haupt.add(panel, "Handlung");
		haupt.setVisible(true);

		panel = erzeugeTextPanel(Bogen.I_BEMERKUNGEN);
		panel.setVisible(true);
		haupt.add(panel, "Bemerkungen");

		panel = erzeugeZitatPanel();
		panel.setVisible(true);
		haupt.add(panel, "Zitate");

		panel = erzeugeLinkPanel(haupt.getWidth());
		panel.setVisible(true);
		haupt.add(panel, "Links");

		haupt.setVisible(true);

		erzeugeMenue();
		mainFrame.getContentPane().add(haupt);

		setBogen(bogen);

		//mainFrame.setSize(mainWidth, mainHeight);
		mainFrame.pack();
		mainFrame.setResizable(false);

		mainFrame.setVisible(true);
	}

	protected JPanel erzeugeTextPanel(int index) {
		JPanel panel = new JPanel();
		panel.setLayout(new BorderLayout());

		textfelder[index] = new JTextArea();
		((JTextArea) textfelder[index]).setLineWrap(true);
		((JTextArea) textfelder[index]).setWrapStyleWord(true);
		textfelder[index].setVisible(true);
		panel.add(new JScrollPane(textfelder[index]), BorderLayout.CENTER);

		return panel;

	}

	protected void erzeugeMenue() {
		HauptMenue menue = new HauptMenue(this, appType);
		mainFrame.setJMenuBar(menue);

	}

	public void setBogen(Bogen bogen) {
		if (bogen == null) {
			throw new IllegalArgumentException();
		}

		this.bogen = bogen;

		// Bogendokumente an Textfelder anhaengen
		Wrappers.StringWrapper[] wrappers = bogen.getTextWrappers();
		for (int i = 0; i < Bogen.I_MAX_DOCUMENT; i++) {
			textfelder[i].setDocument(wrappers[i]);
		}

		// Punkte/Komponenten ebenfalls mit neuem Bogen verbinden
		for (int i = 0; i < Bogen.kategorien.length; i++) {
			punkteListener[i].setBogen(bogen);
			//punktWertungen[i].setSelectedIndex(bogen.getPunkt(i));
			anmerkungen[i].setDocument(bogen.getAnmerkungWrapper(i));
		}

		// verbleibende BogenListener mit neuem Bogen bekannt machen...
		Iterator<BogenListener> it = bogenListeners.iterator();
		while(it.hasNext()){
			it.next().setBogen(bogen);
		}
		
		zitate.setModel(bogen.getZitate());
		links.setModel(bogen.getLinks());
		cover.setDocument(bogen.getCover());
		
		refreshLinkTable();
		
	}

	protected JPanel erzeugeAllgPanel() {
		JPanel p = new JPanel();
		GridBagLayout gridbag = new GridBagLayout();
		GridBagConstraints consts = new GridBagConstraints();
		consts.gridwidth = GridBagConstraints.REMAINDER;
		consts.gridheight = 2;
		consts.anchor = GridBagConstraints.NORTHWEST;
		consts.fill = GridBagConstraints.HORIZONTAL;

		p.setLayout(gridbag);

		JPanel panel = erzeugeAllgemeinesPanel();
		panel.setVisible(true);
		p.add(panel, consts);

		panel = erzeugePunktPanel();
		panel.setVisible(true);
		p.add(panel, consts);

		return p;
	}

	protected JPanel erzeugeAllgemeinesPanel() {
		JPanel allg = new JPanel();
		allg.setLayout(new BoxLayout(allg, BoxLayout.Y_AXIS));
		allg.setBorder(BorderFactory.createTitledBorder(BorderFactory
				.createLineBorder(Color.BLACK), "Allgemeines"));

		JPanel panel = new JPanel();
		panel.setLayout(new BoxLayout(panel, BoxLayout.X_AXIS));

		Dimension dim;

		JTextField textField = new JTextField();
		FontMetrics fm = textField.getFontMetrics(textField.getFont());
		int xWidth = fm.charWidth('x');
		textHeight = (fm.getHeight() * 2) / 3;
		
		textfelder[Bogen.I_TITEL] = textField;
		dim = textfelder[Bogen.I_TITEL].getPreferredSize();
		JLabel label = new JLabel("Titel: ");
		dim.width = label.getPreferredSize().width;
		label.setMinimumSize(dim);
		label.setMaximumSize(dim);
		label.setVisible(true);
		panel.add(label);
		//dim.width = ANMERKUNGEN_WIDTH;
		panel.add(textfelder[Bogen.I_TITEL]);

		label = new JLabel(" FSK: ");
		dim = new Dimension(dim);
		dim.width = label.getPreferredSize().width;
		//label.setPreferredSize(dim);
		label.setMinimumSize(dim);
		label.setMaximumSize(dim);
		label.setVisible(true);
		panel.add(label);
		
		JComboBox fsk = new JComboBox(Bogen.FSK_TYPES);	
		BogenListener bl = new FSKListener(bogen, fsk);
		bogenListeners.add(bl);
		fsk.addActionListener(bl);
		fsk.setVisible(true);
		panel.add(fsk);
		
//		textfelder[Bogen.I_FSK] = new JTextField();
//		dim = new Dimension(dim);
//		dim.width = 3 * xWidth;
//		textfelder[Bogen.I_FSK].setPreferredSize(dim);
//		textfelder[Bogen.I_FSK].setMinimumSize(dim);
//		textfelder[Bogen.I_FSK].setMaximumSize(dim);
//		textfelder[Bogen.I_FSK].setVisible(true);
//		panel.add(textfelder[Bogen.I_FSK]);

		panel.setVisible(true);
		allg.add(panel);

		panel = new JPanel();
		panel.setLayout(new BoxLayout(panel, BoxLayout.X_AXIS));

		label = new JLabel(" Originaltitel: ");
		dim = new Dimension(dim);
		dim.width = label.getPreferredSize().width;
		label.setMinimumSize(dim);
		label.setMaximumSize(dim);
		label.setVisible(true);
		panel.add(label);
		textfelder[Bogen.I_ORIGINALTITEL] = new JTextField();
		dim = new Dimension(dim);
		dim.width = ANMERKUNGEN_WIDTH;
		textfelder[Bogen.I_ORIGINALTITEL].setMinimumSize(dim);
		textfelder[Bogen.I_ORIGINALTITEL].setVisible(true);
		panel.add(textfelder[Bogen.I_ORIGINALTITEL]);

		label = new JLabel(" Jahr: ");
		dim = new Dimension(dim);
		dim.width = label.getPreferredSize().width;
		label.setMinimumSize(dim);
		label.setMaximumSize(dim);
		label.setVisible(true);
		panel.add(label);
		textfelder[Bogen.I_JAHR] = new JTextField();
		dim = new Dimension(dim);
		dim.width = 6 * xWidth;
		textfelder[Bogen.I_JAHR].setPreferredSize(dim);
		textfelder[Bogen.I_JAHR].setMinimumSize(dim);
		textfelder[Bogen.I_JAHR].setMaximumSize(dim);
		textfelder[Bogen.I_JAHR].setVisible(true);
		panel.add(textfelder[Bogen.I_JAHR]);
		panel.setVisible(true);
		allg.add(panel);

		panel = new JPanel();
		panel.setLayout(new BoxLayout(panel, BoxLayout.X_AXIS));

		label = new JLabel(" Land: ");
		dim = new Dimension(dim);
		dim.width = label.getPreferredSize().width;
		label.setMaximumSize(dim);
		label.setMinimumSize(dim);
		label.setVisible(true);
		panel.add(label);
		textfelder[Bogen.I_LAND] = new JTextField();
		dim = new Dimension(dim);
		dim.width = (ANMERKUNGEN_WIDTH * 2) / 3;
		textfelder[Bogen.I_LAND].setPreferredSize(dim);
		textfelder[Bogen.I_LAND].setMinimumSize(dim);
		textfelder[Bogen.I_LAND].setVisible(true);
		panel.add(textfelder[Bogen.I_LAND]);

		textfelder[Bogen.I_GENRE] = new JTextField();
		dim = new Dimension(dim);
		textfelder[Bogen.I_GENRE].setPreferredSize(dim);
		textfelder[Bogen.I_GENRE].setMinimumSize(dim);
		label = new JLabel(" Genre: ");
		dim = new Dimension(dim);
		dim.width = label.getPreferredSize().width;
		label.setMaximumSize(dim);
		label.setMinimumSize(dim);
		label.setVisible(true);
		panel.add(label);
		textfelder[Bogen.I_GENRE].setVisible(true);
		panel.add(textfelder[Bogen.I_GENRE]);
		panel.setVisible(true);
		allg.add(panel);
		return allg;
	}

	protected JPanel erzeugePunktPanel() {
		JPanel punktwertungen = new JPanel();
		punktwertungen
				.setLayout(new BoxLayout(punktwertungen, BoxLayout.Y_AXIS));
		punktwertungen.setBorder(BorderFactory.createTitledBorder(BorderFactory
				.createLineBorder(Color.BLACK), "Punktwertungen"));

		JLabel laengstesLabel = new JLabel(Bogen.kategorien[Bogen
				.getLaengsteKategorie()]);
		JLabel punkteLabel = new JLabel("Punkte ");
		String[] p = { Bogen.PUNKT_KEIN, Bogen.PUNKT_EIN, Bogen.PUNKT_ZWEI,
				Bogen.PUNKT_DREI, Bogen.PUNKT_VIER, Bogen.PUNKT_FUENF };
		JComboBox punkte = new JComboBox(p);

		Dimension dimKategorie = laengstesLabel.getPreferredSize();
		Dimension dimPunkte = punkte.getPreferredSize();
		dimKategorie.height = dimPunkte.height;
		dimPunkte.width = punkteLabel.getPreferredSize().width;

		JPanel panel;
		JLabel beschriftung;

		for (int index = 0; index < Bogen.kategorien.length; index++) {
			panel = new JPanel();
			panel.setLayout(new BoxLayout(panel, BoxLayout.X_AXIS));
			beschriftung = new JLabel(Bogen.kategorien[index]);
			beschriftung.setPreferredSize(dimKategorie);
			beschriftung.setMinimumSize(dimKategorie);
			beschriftung.setVisible(true);
			panel.add(beschriftung);
			punkte = new JComboBox(p);
			//punktWertungen[index] = punkte;
			punkteListener[index] = new PunktListener(index, bogen, punkte);
			punkte.addActionListener(punkteListener[index]);
			punkte.setPreferredSize(dimPunkte);
			punkte.setMinimumSize(dimPunkte);
			punkte.setVisible(true);
			panel.add(punkte);
			panel.setVisible(true);

			punktwertungen.add(panel);
			anmerkungen[index] = new JTextField();
			anmerkungen[index].setVisible(true);
			panel.add(anmerkungen[index]);
			punktwertungen.add(panel);
		}

		return punktwertungen;
	}

	protected JPanel erzeugeZitatPanel() {
		JPanel panel = new JPanel();
		panel.setLayout(new BoxLayout(panel, BoxLayout.Y_AXIS));

		zitate = new JList();
		zitate.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
		panel.add(new JScrollPane(zitate));

		JTextArea text = new JTextArea();
		text.setLineWrap(true);
		text.setWrapStyleWord(true);

		JPanel p = new JPanel();
		p.setLayout(new BoxLayout(p, BoxLayout.X_AXIS));
		JButton button = new JButton("Löschen");
		button.setMaximumSize(button.getPreferredSize());
		button.addActionListener(new LoeschenListener<String>(zitate));
		p.add(button, BorderLayout.WEST);
		button = new JButton("Hinzufügen");
		button.setMaximumSize(button.getPreferredSize());
		button.addActionListener(new ZitatHinzuListener(text, zitate));

		p.add(button, BorderLayout.EAST);
		panel.add(new JScrollPane(text));
		panel.add(p);

		return panel;
	}

	protected JPanel erzeugeLinkPanel(int hauptWidth) {
		JPanel panel = new JPanel();
		panel.setLayout(new BoxLayout(panel, BoxLayout.Y_AXIS));
		panel.add(erzeugeWWWLinkPanel());
		panel.add(erzeugeCoverPanel(hauptWidth));
		return panel;

	}

	protected void refreshLinkTable(){
		TableColumn colTyp = links.getColumnModel().getColumn(0);
		colTyp.setCellEditor(new DefaultCellEditor(cbCellEditor));
		FontMetrics fm = links.getFontMetrics(links.getFont());
		int xWidth = fm.charWidth('x');
		colTyp.setPreferredWidth(Bogen.getLaengsterLinkTyp() * xWidth * 3);	
		colTyp.setMaxWidth(colTyp.getPreferredWidth());
	}
	
	protected JPanel erzeugeWWWLinkPanel() {
		JPanel panel = new JPanel();

		panel.setLayout(new BoxLayout(panel, BoxLayout.Y_AXIS));
		panel.setBorder(BorderFactory.createTitledBorder(BorderFactory
				.createLineBorder(Color.BLACK), "Links"));
		links = new JTable();
		links.setModel(bogen.getLinks());
		links.setRowHeight((textHeight * 2));
		cbCellEditor = new JComboBox();
		for(int i = 0; i < Bogen.LINK_TYPES.length; i++) {
			cbCellEditor.addItem(Bogen.LINK_TYPES[i]);
		}
		refreshLinkTable();
		panel.add(new JScrollPane(links));

		JPanel p = new JPanel();
		p.setLayout(new BoxLayout(p, BoxLayout.X_AXIS));
		JButton b = new JButton("Hinzufügen");
		b.addActionListener(new LinkHinzuListener(links));
		Dimension dim = b.getPreferredSize();
		b.setMinimumSize(dim);
		b.setMaximumSize(dim);
		p.add(b);
		
		b = new JButton("Löschen");
		b.addActionListener(new LinkLoeschenListener(links));
		dim = b.getPreferredSize();
		b.setMinimumSize(dim);
		b.setMaximumSize(dim);
		p.add(b);

		panel.add(p);
		return panel;
	}

	protected JPanel erzeugeCoverPanel(int hauptWidth) {
		JPanel panel = new JPanel();

		panel.setLayout(new BoxLayout(panel, BoxLayout.X_AXIS));
		panel.setBorder(BorderFactory.createTitledBorder(BorderFactory
				.createLineBorder(Color.BLACK), "Bilddatei"));

		cover = new JTextField();
		cover.setVisible(true);

		JButton b = new JButton("Durchsuchen");
		Dimension dim = b.getPreferredSize();
		b.setMinimumSize(dim);
		b.setMaximumSize(dim);
		b.addActionListener(new DurchsuchenListener(cover, this));
		panel.add(cover);
		panel.add(b);

		return panel;
	}

	public Gui(String titel, Bogen bogen, int type) {
		if (bogen == null || type > 3 || type < 0) {
			throw new IllegalArgumentException();
		}
		this.bogen = bogen;
		appType = type;
		initialize();
		erzeugeFrame(titel);
	}

	protected void initialize() {
		bogenListeners = new LinkedList<BogenListener>();
		textfelder = new JTextComponent[Bogen.I_MAX_INDEX];
		punkteListener = new PunktListener[Bogen.kategorien.length];
		anmerkungen = new JTextComponent[Bogen.kategorien.length];
		//punktWertungen = new JComboBox[Bogen.kategorien.length];
	}

	public Gui() {
		this(TITEL, new Bogen(), 0);
	}

	public Bogen getBogen() {
		return bogen;
	}

	
	public static interface BogenListener extends ActionListener{
		public void setBogen(Bogen b);
	}
	
	protected static class PunktListener implements BogenListener {

		protected Bogen bogen;
		protected JComboBox cb;

		protected int index;

		public PunktListener(int index, Bogen bogen, JComboBox cb) {
			if (index < 0 || index > Bogen.kategorien.length || bogen == null || cb == null) {
				throw new IllegalArgumentException();
			}
			this.bogen = bogen;
			this.index = index;
			this.cb = cb;
		}

		public void actionPerformed(ActionEvent e) {
			JComboBox cb = (JComboBox) e.getSource();
			String punkt = (String) cb.getSelectedItem();

			int val = Integer.parseInt(punkt);
			bogen.setPunkt(index, val);
		}

		public void setBogen(Bogen bogen) {
			if (bogen == null) {
				throw new IllegalArgumentException();
			}
			this.bogen = bogen;
			cb.setSelectedIndex(bogen.getPunkt(index));
		}
	}
	
	protected static class FSKListener implements BogenListener {

		protected Bogen bogen;
		protected JComboBox cb;
		
		
		public FSKListener(Bogen bogen, JComboBox cb){
			if (bogen == null || cb == null) {
				throw new IllegalArgumentException();
			}
			this.bogen = bogen;
			this.cb = cb;
		}
		
		
		public void setBogen(Bogen b) {
			if(b == null) {
				throw new IllegalArgumentException();
			}
			this.bogen = b;
			cb.setSelectedItem(bogen.getText(Bogen.I_FSK));			
		}

		
		public void actionPerformed(ActionEvent e) {
			JComboBox cb = (JComboBox) e.getSource();
			String fsk = (String) cb.getSelectedItem();
			bogen.setText(Bogen.I_FSK, fsk);
		}
		
	}

	protected static class ZitatHinzuListener implements ActionListener {

		JTextComponent text;

		JList list;

		public ZitatHinzuListener(JTextComponent text, JList list) {
			if (text == null || list == null) {
				throw new IllegalArgumentException();
			}

			this.text = text;
			this.list = list;
		}

		public void actionPerformed(ActionEvent e) {
			Document doc = text.getDocument();
			Wrappers.ListWrapper<String> zitatList = (Wrappers.ListWrapper<String>) list
					.getModel();
			String str;
			try {
				str = doc.getText(0, doc.getLength());
			} catch (BadLocationException ex) {
				throw new RuntimeException();
			}
			zitatList.add(str);
			List<ListDataListener> listeners = zitatList.getListeners();

			Iterator<ListDataListener> it = listeners.iterator();
			ListDataEvent ev = new ListDataEvent(this,
					ListDataEvent.CONTENTS_CHANGED, zitatList.getSize() - 1,
					zitatList.getSize() - 1);
			while (it.hasNext()) {
				it.next().contentsChanged(ev);
			}

		}
	}

	protected static class LinkHinzuListener implements ActionListener {

		JTable list;

		public LinkHinzuListener(JTable list) {
			if (list == null) {
				throw new IllegalArgumentException();
			}
			this.list = list;
		}

		public void actionPerformed(ActionEvent e) {
			LinkList linkList =  (LinkList)list.getModel();
			linkList.add(new Link(""));
			List<ListDataListener> listeners = linkList.getListeners();

			Iterator<ListDataListener> it = listeners.iterator();
			ListDataEvent ev = new ListDataEvent(this,
					ListDataEvent.CONTENTS_CHANGED, linkList.getSize() - 1,
					linkList.getSize() - 1);
			while (it.hasNext()) {
				it.next().contentsChanged(ev);
			}

		}
	}


	protected static class LinkLoeschenListener implements ActionListener {

		JTable list;

		public LinkLoeschenListener(JTable list) {
			if (list == null) {
				throw new IllegalArgumentException();
			}
			this.list = list;
		}

		public void actionPerformed(ActionEvent e) {
			LinkList linkList =  (LinkList)list.getModel();
			int sel = list.getSelectedRow();
			linkList.remove(sel);
			List<TableModelListener> listeners = linkList.getTableListeners();

			Iterator<TableModelListener> it = listeners.iterator();
			TableModelEvent ev = new TableModelEvent(linkList, sel, linkList.size()); //, linkList.size() - 1); 
			while (it.hasNext()) {
				it.next().tableChanged(ev);
			}

		}
	}

	
	protected static class LoeschenListener<T> implements ActionListener {

		JList list;

		public LoeschenListener(JList list) {
			if (list == null) {
				throw new IllegalArgumentException();
			}
			this.list = list;
		}

		public void actionPerformed(ActionEvent e) {
			Wrappers.ListWrapper<T> zitatList = (Wrappers.ListWrapper<T>) list
					.getModel();
			int sel = list.getMinSelectionIndex();
			if (sel > -1) {
				zitatList.remove(sel);
				List<ListDataListener> listeners = (List<ListDataListener>) zitatList
						.getListeners();
				Iterator<ListDataListener> it = listeners.iterator();
				ListDataEvent ev = new ListDataEvent(this,
						ListDataEvent.CONTENTS_CHANGED,
						zitatList.getSize() - 1, zitatList.getSize() - 1);
				while (it.hasNext()) {
					it.next().contentsChanged(ev);
				}
			}

		}
	}
	
	protected static class DurchsuchenListener implements ActionListener {

		JTextField text;
		Gui gui;

		public DurchsuchenListener(JTextField text, Gui gui) {
			if (text == null || gui == null) {
				throw new IllegalArgumentException();
			}
			this.text = text;
			this.gui = gui;
		}

		public void actionPerformed(ActionEvent e) {
			JFileChooser chooser = new JFileChooser();
			int returnVal = chooser.showOpenDialog(gui);
		    if(returnVal == JFileChooser.APPROVE_OPTION) {
		    	try{
		         text.getDocument().insertString(0, chooser.getSelectedFile().getAbsolutePath(), null);
		    	}catch(BadLocationException ex) {
		    		System.err.println("Fehler bei Coverauswahl!");
		    		return;
		    	}
		    }
		}
	}
}
