/*
 * Decompiled with CFR 0.152.
 */
package com.coi.tools.os.win;

import com.coi.tools.os.win.MSWinConstants;
import java.io.Serializable;

public class RegDataContainer
implements Cloneable,
Serializable,
MSWinConstants {
    private static final long serialVersionUID = 3979265850388066865L;
    private static final int[] VALID_TYPES = new int[]{0, 1, 2, 3, 4, 6, 7};
    private long dwordData = 0L;
    private String stringData = null;
    private String[] multiStringData = null;
    private byte[] binData = null;
    private int type = 0;

    public RegDataContainer() {
    }

    public RegDataContainer(int n) throws IllegalArgumentException {
        if (!this.isValidType(n)) {
            throw new IllegalArgumentException("Type is not valid");
        }
        this.type = n;
    }

    public RegDataContainer(long l) {
        this.type = 4;
        this.dwordData = l;
    }

    public RegDataContainer(String string) {
        if (this.containsPlaceholder(string)) {
            this.setType(2);
        } else {
            this.setType(1);
        }
        this.stringData = string;
    }

    public RegDataContainer(String[] stringArray) {
        this.type = 7;
        this.multiStringData = stringArray;
    }

    public RegDataContainer(byte[] byArray) {
        this.type = 3;
        this.binData = byArray;
    }

    public byte[] getBinData() {
        return this.binData;
    }

    public long getDwordData() {
        return this.dwordData;
    }

    public String[] getMultiStringData() {
        return this.multiStringData;
    }

    public String getStringData() {
        return this.stringData;
    }

    public int getType() {
        return this.type;
    }

    public void setBinData(byte[] byArray) {
        this.binData = byArray;
    }

    public void setDwordData(long l) {
        this.dwordData = l;
    }

    public void setMultiStringData(String[] stringArray) {
        this.multiStringData = stringArray;
    }

    public void setStringData(String string) {
        this.stringData = string;
    }

    public void setType(int n) {
        this.type = n;
    }

    public boolean isValidType(int n) {
        for (int n2 : VALID_TYPES) {
            if (n != n2) continue;
            return true;
        }
        return false;
    }

    public Object getDataAsObject() {
        switch (this.type) {
            case 1: 
            case 2: {
                return this.getStringData();
            }
            case 3: {
                return this.getBinData();
            }
            case 4: {
                return this.getDwordData();
            }
            case 7: {
                return this.getMultiStringData();
            }
        }
        return null;
    }

    public Object clone() throws CloneNotSupportedException {
        RegDataContainer regDataContainer = (RegDataContainer)super.clone();
        if (this.multiStringData != null) {
            regDataContainer.multiStringData = new String[this.multiStringData.length];
            System.arraycopy(this.multiStringData, 0, regDataContainer.multiStringData, 0, this.multiStringData.length);
        }
        if (this.binData != null) {
            regDataContainer.binData = new byte[this.binData.length];
            System.arraycopy(this.binData, 0, regDataContainer.binData, 0, this.binData.length);
        }
        return regDataContainer;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof RegDataContainer) {
            RegDataContainer regDataContainer = (RegDataContainer)object;
            if (regDataContainer.type != this.type) {
                return false;
            }
            switch (this.type) {
                case 4: {
                    return regDataContainer.dwordData == this.dwordData;
                }
                case 1: 
                case 2: {
                    if (this.stringData == null) {
                        return regDataContainer.stringData == null;
                    }
                    return this.stringData.equals(regDataContainer.stringData);
                }
                case 3: {
                    if (this.binData == null) {
                        return regDataContainer.binData == null;
                    }
                    if (regDataContainer.binData != null && this.binData.length == regDataContainer.binData.length) {
                        for (int i = 0; i < this.binData.length; ++i) {
                            if (this.binData[i] == regDataContainer.binData[i]) continue;
                            return false;
                        }
                        return true;
                    }
                    return false;
                }
                case 7: {
                    if (this.multiStringData == null) {
                        return regDataContainer.multiStringData == null;
                    }
                    if (regDataContainer.multiStringData != null && this.multiStringData.length == regDataContainer.multiStringData.length) {
                        for (int i = 0; i < this.multiStringData.length; ++i) {
                            if (!(this.multiStringData[i] != null ? !this.multiStringData[i].equals(regDataContainer.multiStringData[i]) : regDataContainer.multiStringData[i] == null)) continue;
                            return false;
                        }
                        return true;
                    }
                    return false;
                }
            }
        }
        return false;
    }

    public int hashCode() {
        int n = (int)(this.dwordData ^ this.dwordData >>> 32);
        n = 29 * n + (this.stringData != null ? this.stringData.hashCode() : 0);
        n = 29 * n + this.type;
        return n;
    }

    private boolean containsPlaceholder(String string) {
        return string.indexOf("%") >= 0;
    }
}

