<?php
/*
 * DasForum - a PHP BulletinBoardSystem
 * Copyright 2005 Heiko Rothkranz <heiko_rothkranz (at) arcor (dot) de>
 * 
 * This file is part of DasForum
 * 
 * DasForum is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * DasForum is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with DasForum; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

if ($rechte["admin"] == false) fehler("Sie besitzen nicht gengend Zugriffsrechte, um diese Seite zu betreten!");

if (!isset($_POST["kategorie_erstellen"]) and !isset($_POST["kategorie_bearbeiten"]) and !isset($_POST["kategorie_loeschen"]) and !isset($_POST["board_erstellen"]) and !isset($_POST["board_bearbeiten"]) and !isset($_POST["board_loeschen"]))
{
  ?>
  <h3>Boards und Kategorien verwalten</h3>
  <table class="maintable">
  <form method="POST" action="index.php?action=admincp&amp;show=boards">
  <tr class="rowberschrift">
    <td colspan="2">Kategorie erstellen</td>
  </tr>
  <tr class="row2">
    <td>Titel:</td><td><input class="inputtext" name="kat_titel" type="text" size="40" /></td>
  </tr>
  <tr class="row2">
    <td>&nbsp;</td><td><input name="kategorie_erstellen" type="submit" value="erstellen" /></td>
  </tr>
  <tr class="rowberschrift">
    <td colspan="2">Kategorie bearbeiten/lschen</td>
  </tr>
  <tr class="row2">
    <td>Kategorie:</td>
    <td>
    <select class="inputtext" name="edit_kategorie" size="1">
    <?php
    $result = sql_select("*", "kategorien", "ORDER BY sort ASC");
    while ($ergebnis = sql_fetch_assoc($result))
    {
      echo "<option value=\"".$ergebnis["id"]."\" />".$ergebnis["id"]." - ".$ergebnis["titel"]."</option>";
    }
    ?>
    </select>
    </td>
  </tr>
  <tr class="row2">
    <td>&nbsp;</td><td><input name="kategorie_bearbeiten" type="submit" value="bearbeiten" /> <input name="kategorie_loeschen" type="submit" value="lschen" /></td>
  </tr>
  <tr class="rowberschrift">
    <td colspan="2">Board erstellen</td>
  </tr>
  <tr class="row2">
    <td>Titel:</td><td><input class="inputtext" name="brd_titel" type="text" size="40" /></td>
  </tr>
  <tr class="row2">
    <td>Beschreibung:</td><td><input class="inputtext" name="brd_beschreibung" type="text" size="40" /></td>
  </tr>
  <tr class="row2">
    <td>Kategorie:</td><td><select class="inputtext" name="brd_kategorie" size="1">
    <?php
    $result = sql_select("*", "kategorien", "ORDER BY sort ASC");
    while ($ergebnis = sql_fetch_assoc($result))
    {
      echo "<option value=\"".$ergebnis["id"]."\" />".$ergebnis["id"]." - ".$ergebnis["titel"]."</option>";
    }
    ?>
    </select></td>
  </tr>
  <tr class="row2">
    <td>&nbsp</td><td><input name="board_erstellen" type="submit" value="erstellen" /></td>
  </tr>
  <tr class="rowberschrift">
    <td colspan="2">Board bearbeiten/lschen</td>
  </tr>
  <tr class="row2">
    <td>Board:</td>
    <td><select class="inputtext" name="edit_board" size="1">
    <?php
    $result = sql_select("*", "boards", "ORDER BY kategorie, sort ASC");
    while ($ergebnis = sql_fetch_assoc($result))
    {
      echo "<option value=\"".$ergebnis["id"]."\" />".$ergebnis["id"]." - ".$ergebnis["titel"]."</option>";
    }
    ?>
    </select></td>
  </tr>
  <tr class="row2">
    <td>&nbsp;</td><td><input name="board_bearbeiten" type="submit" value="bearbeiten" /> <input name="board_loeschen" type="submit" value="lschen" /></td>
  </tr>
  </form>
  </table>
  <?php
}

//************************** kategorie_erstellen ********************************
if(isset($_POST["kategorie_erstellen"]))
{
  // neue kategorie erstellen
  if(trim($_POST["kat_titel"]) == "") fehler("Sie mssen einen Titel fr die Kategorie angeben!");
  // hchsten sort-wert erausfinden
  $maxsort = sql_num_rows(sql_select("id", "kategorien", ""));

  $werte = array(
      "titel" => htmlspecialchars($_POST["kat_titel"]),
      "sort"  => $maxsort + 1
      );
  sql_insert("kategorien", $werte);
  ?>
  <h3>Kategorie erstellen</h3>
  <?php
  redir("index.php?action=admincp&show=boards", "Die Kategorie wurde erfolgreich erstellt!");
}

//************************ kategorie_bearbeiten *********************************
if(isset($_POST["kategorie_bearbeiten"]))
{
  $kategorie = sql_fetch_assoc(sql_select("*", "kategorien", "WHERE id=".$_POST["edit_kategorie"]));
  ?><h3>Kategorie bearbeiten</h3><?php
  // kategorie bearbeiten
  if(!isset($_POST["bearbeiten_knopf2"]) and !isset($_POST["move_up"]) and !isset($_POST["move_down"]))
  {
    // formular anzeigen
    ?>
    <form method="POST" action="index.php?action=admincp&amp;show=boards">
    <input name="kategorie_bearbeiten" type="hidden" value="1" />
    <input name="edit_kategorie" type="hidden" value="<?php echo $_POST["edit_kategorie"] ?>" />
    <table class="maintable">
    <tr class="rowberschrift">
      <td colspan="2">Kategorie bearbeiten</td>
    </tr>
    <tr class="row2">
      <td>Titel:</td><td><input class="inputtext" name="titel" type="text" size="40" value="<?php echo $kategorie["titel"] ?>" /></td>
    </tr>
    <tr class="row2">
      <td>&nbsp;</td><td><input name="bearbeiten_knopf2" type="submit" value="bearbeiten" /></td>
    </tr>
    <tr class="row2">
      <td>Sortierung:</td><td><input name="move_up" type="submit" value="nach oben" /> <input name="move_down" type="submit" value="nach unten" /></td>
    </tr>
    </table>
    </form>
    <?php
  }
  if(isset($_POST["bearbeiten_knopf2"]))
  {
    // nderungen speichern
    if(trim($_POST["titel"]) == "") fehler("Sie mssen einen Titel fr die Kategorie angeben!");
    $werte = array("titel" => htmlspecialchars($_POST["titel"]));
    sql_update("kategorien", $werte, "WHERE id=".$kategorie["id"]);
    redir("index.php?action=admincp&show=boards", "Die Kategorie wurde bearbeitet!");
  }
  if(isset($_POST["move_up"]))
  {
    // kategorie nach oben bewegen
    if($kategorie["sort"] == 1)
    {
      redir("index.php?action=admincp&show=boards", "Die Kategorie ist bereits ganz oben!", false);
    }
    else
    {
      $tauschkategorie = sql_fetch_assoc(sql_select("id", "kategorien", "WHERE sort=".($kategorie["sort"] - 1)));
      $werte = array("sort" => $kategorie["sort"] - 1);
      sql_update("kategorien", $werte, "WHERE id=".$kategorie["id"]);
      $werte = array("sort" => $kategorie["sort"]);
      sql_update("kategorien", $werte, "WHERE id=".$tauschkategorie["id"]);
      redir("index.php?action=admincp&show=boards", "Die Kategorie wurde nach oben bewegt!");
    }
  }
  if(isset($_POST["move_down"]))
  {
    // kategorie nach unten bewegen
    $maxsort = sql_num_rows(sql_select("id", "kategorien", ""));
    if($kategorie["sort"] == $maxsort)
    {
      redir("index.php?action=admincp&show=boards", "Die Kategorie ist bereits ganz unten!", false);
    }
    else
    {
      $tauschkategorie = sql_fetch_assoc(sql_select("id", "kategorien", "WHERE sort=".($kategorie["sort"] + 1)));
      $werte = array("sort" => $kategorie["sort"] + 1);
      sql_update("kategorien", $werte, "WHERE id=".$kategorie["id"]);
      $werte = array("sort" => $kategorie["sort"]);
      sql_update("kategorien", $werte, "WHERE id=".$tauschkategorie["id"]);
      redir("index.php?action=admincp&show=boards", "Die Kategorie wurde nach unten bewegt!");
    }
  }
}

//************************ kategorie_loeschen ***********************************
if(isset($_POST["kategorie_loeschen"]))
{
  $kategorie = sql_fetch_assoc(sql_select("*", "kategorien", "WHERE id=".$_POST["edit_kategorie"]));
  ?><h3>Kategorie lschen</h3><?php
  if(!isset($_POST["loeschen_bestaetigen"]))
  {
    // sicher ?
    ?>
    Sind Sie sicher, dass Sie die Kategorie <b>"<?php echo $kategorie["titel"] ?>"</b>
    (ID: <?php echo $kategorie["id"] ?>) lschen wollen?<br />
    Alle enthaltenen Fragen werden gelscht!<br />
    <form method="POST" action="index.php?action=admincp&amp;show=boards">
    <input name="kategorie_loeschen" type="hidden" value="1" />
    <input name="edit_kategorie" type="hidden" value="<?php echo $kategorie["id"] ?>" />
    <input name="loeschen_bestaetigen" type="submit" value="lschen" />
    </form>
    <?php
  }
  else
  {
    // kategorie aus der db lschen
    // alle boards der kategorie lschen
    $delboards = sql_select("id", "boards", "WHERE kategorie=".$kategorie["id"]);
    // alle threads und umfragen aus den boards lschen
    while($delboard = sql_fetch_assoc($delboards))
    {
      //ids der threads im board holen
      //ids der posts und umfragen in den threads holen
      //posts, threads und umfragen lschen
      $delthreadsresult = sql_select("*", "threads", "WHERE board=".$delboard["id"], NULL, NULL);
      while($delthread = sql_fetch_assoc($delthreadsresult))
      {
        sql_delete("posts", "WHERE thread=".$delthread["id"]);
        // evtl. umfrage lschen
        $delumfrageresult = sql_select("*", "umfragen", "WHERE thread=".$delthread["id"], NULL, NULL);
        if(sql_num_rows($delumfrageresult) != 0)
        {
          $delumfrage = sql_fetch_assoc($delumfrageresult);
          sql_delete("antworten", "WHERE umfrage=".$delumfrage["id"]);
          sql_delete("umfragen", "WHERE thread=".$delthread["id"]);
        }
      }
      sql_delete("threads", "WHERE board=".$delboard["id"]);
    }
    sql_delete("boards", "WHERE kategorie=".$kategorie["id"]);
    // kategorie lschen
    sql_delete("kategorien", "WHERE id=".$kategorie["id"]);
    // nachfolgende sort-werte aufrcken
    $sql = "UPDATE ".$conf["sql_prefix"]."_kategorien SET sort=sort-1 WHERE sort>".$kategorie["sort"].";";
    if($conf["sql_typ"] == "mysql") mysql_query($sql, $link) or dbfehler();
    if($conf["sql_typ"] == "postgresql") pg_query($link, $sql) or dbfehler();
    redir("index.php?action=admincp&show=boards", "Die Kategorie und alle enthaltenen Fragen wurden gelscht!");
  }
}

//*************************** board_erstellen ***********************************
if(isset($_POST["board_erstellen"]))
{
  if(trim($_POST["brd_titel"])=="") fehler("Jedes Board muss einen Titel haben!");
  //erst board erzeugen, dann bearbeiten-seite aufrufen
  // hchsten sort-wert erausfinden
  $maxsort = sql_num_rows(sql_select("id", "boards", "WHERE kategorie=".$_POST["brd_kategorie"]));

  $werte = array(
      "kategorie"    => $_POST["brd_kategorie"],
      "titel"        => htmlspecialchars($_POST["brd_titel"]),
      "beschreibung" => htmlspecialchars($_POST["brd_beschreibung"]),
      "sort"         => $maxsort + 1
      );
  sql_insert("boards", $werte);

  //id des neuen eintrags?
  $result = sql_select("id", "boards", "ORDER BY id DESC", NULL, NULL);
  $ergebnis = sql_fetch_assoc($result);

  ?>
  <h3>Board erstellen</h3>
  Das Board wurde erfolgreich erstellt!<br />
  Klicken Sie jetzt auf "bearbeiten" um die Einstellungen fr das Board zu bearbeiten.<br />
  <form method="POST" action="index.php?action=admincp&amp;show=boards">
  <input name="edit_board" type="hidden" value="<?php echo $ergebnis["id"] ?>" />
  <input name="board_bearbeiten" type="submit" value="bearbeiten" />
  </form>
  <?php
}

//*************************** board_bearbeiten ********************************
if(isset($_POST["board_bearbeiten"]))
{
  //bisherige einstellungen abfragen:
  $boardresult = sql_select("*", "boards", "WHERE id=".$_POST["edit_board"], NULL, NULL);
  $board = sql_fetch_assoc($boardresult);

  if(!isset($_POST["bearbeiten_knopf"]) and !isset($_POST["move_up"]) and !isset($_POST["move_down"]))
  {
    $lesen = array();
    $posts = array();
    $threads = array();
    $moderieren = array();

    //bearbeiten-formular

    $boardrechteresult = sql_select("*", "boardrechte", "WHERE board_id=".$board["id"], NULL, NULL);
    while($boardrechte = sql_fetch_assoc($boardrechteresult))
    {
      if($boardrechte["lesen"]      == 1) $lesen[]      = $boardrechte["gruppe_id"];
      if($boardrechte["posts"]      == 1) $posts[]      = $boardrechte["gruppe_id"];
      if($boardrechte["threads"]    == 1) $threads[]    = $boardrechte["gruppe_id"];
      if($boardrechte["moderieren"] == 1) $moderieren[] = $boardrechte["gruppe_id"];
    }
    ?>
    <h3>Board bearbeiten</h3>
    <form method="POST" action="index.php?action=admincp&amp;show=boards&amp;type=bearbeiten">
    <input name="edit_board" type="hidden" value="<?php echo $_POST["edit_board"] ?>" />
    <input name="board_bearbeiten" type="hidden" value="1" />
    <table class="maintable">
    <tr class="rowberschrift">
      <td colspan="2"><b>Allgemeines:</b></td>
    </tr>
    <tr class="row2">
      <td>Titel:</td><td><input class="inputtext" name="titel" type="text" value="<?php echo $board["titel"] ?>" size="40" /></td>
    </tr>
    <tr class="row2">
      <td>Beschreibung:</td><td><input class="inputtext" name="beschreibung" type="text" value="<?php echo $board["beschreibung"] ?>" size="40" /></td>
    </tr>
    <tr class="row2">
      <td>Kategorie:</td><td><select class="inputtext" name="kategorie" size="1">
      <?php
      $result = sql_select("*", "kategorien", "ORDER BY id ASC", NULL, NULL);
      while ($ergebnis = sql_fetch_assoc($result))
      {
        ?><option value="<?php echo $ergebnis["id"] ?>" <?php if($ergebnis["id"] == $board["kategorie"]) echo "selected " ?>/><?php echo $ergebnis["id"]." - ".$ergebnis["titel"] ?></option><?php
      }
      ?>
      </select></td>
    </tr>
    <tr class="rowberschrift">
      <td colspan="2"><b>Rechte:</b></td>
    </tr>
    <tr class="row2">
      <td>Lesen:</td><td><select multiple class="inputtext" name="lesen[]" size="5">
      <?php
      // welche gruppen gibt es?
      $gruppenresult = sql_select("id, titel", "gruppen", "ORDER BY id ASC", NULL, NULL);
      while($gruppen = sql_fetch_assoc($gruppenresult))
      {
        echo "<option value=\"".$gruppen["id"]."\"";
        if(in_array($gruppen["id"],$lesen))
        {
          echo "selected";
        }
          echo ">".$gruppen["titel"]."</option>";
        }
        ?>
      </select></td>
    </tr>
    <tr class="row2">
      <td>Threads erstellen:</td><td><select multiple class="inputtext" name="threads[]" size="5">
      <?php
      // welche gruppen gibt es?
      $gruppenresult = sql_select("id, titel", "gruppen", "ORDER BY id ASC", NULL, NULL);
      while($gruppen = sql_fetch_assoc($gruppenresult))
      {
        echo "<option value=\"".$gruppen["id"]."\"";
        if(in_array($gruppen["id"],$threads))
        {
          echo "selected";
        }
        echo ">".$gruppen["titel"]."</option>";
      }
      ?>
      </select></td>
    </tr>
    <tr class="row2">
      <td>Posts erstellen:</td><td><select multiple class="inputtext" name="posts[]" size="5">
      <?php
      // welche gruppen gibt es?
      $gruppenresult = sql_select("id, titel", "gruppen", "ORDER BY id ASC", NULL, NULL);
      while($gruppen = sql_fetch_assoc($gruppenresult))
      {
        echo "<option value=\"".$gruppen["id"]."\"";
        if(in_array($gruppen["id"],$posts))
        {
          echo "selected";
        }
        echo ">".$gruppen["titel"]."</option>";
      }
      ?>
      </select></td>
    </tr>
    <tr class="row2">
      <td>Moderieren:</td><td><select multiple class="inputtext" name="moderieren[]" size="5">
      <?php
      // welche gruppen gibt es?
      $gruppenresult = sql_select("id, titel", "gruppen", "ORDER BY id ASC", NULL, NULL);
      while($gruppen = sql_fetch_assoc($gruppenresult))
      {
        echo "<option value=\"".$gruppen["id"]."\"";
        if(in_array($gruppen["id"],$moderieren))
        {
          echo "selected";
        }
        echo ">".$gruppen["titel"]."</option>";
      }
      ?>
      </select></td>
    </tr>
    <tr class="row2">
      <td>&nbsp</td><td><input name="bearbeiten_knopf" type="submit" value="bearbeiten" /></td>
    </tr>
    <tr class="row2">
      <td>Sortierung:</td><td><input name="move_up" type="submit" value="nach oben" /> <input name="move_down" type="submit" value="nach unten" /></td>
    </tr>
    </table>
    </form>
    <?php
  }
  if(isset($_POST["bearbeiten_knopf"]))
  {
    if(trim($_POST["titel"])=="") fehler("Jedes Board muss einen Titel haben!");

    // wurde die kategorie gendert?
    if($_POST["kategorie"] != $board["kategorie"])
    {
      // ja -> als letztes sort-element anhngen und elemente aus der alten kategorie aufrcken
      $maxsort = sql_num_rows(sql_select("id", "boards", "WHERE kategorie=".$_POST["kategorie"]));
      $sort = $maxsort + 1;
      $sql = "UPDATE ".$conf["sql_prefix"]."_boards SET sort=sort-1 WHERE sort>".$board["sort"]." and kategorie=".$board["kategorie"].";";
      if($conf["sql_typ"] == "mysql") mysql_query($sql, $link) or dbfehler();
      if($conf["sql_typ"] == "postgresql") pg_query($link, $sql) or dbfehler();
    }
    else
    {
      $sort = $board["sort"];
    }

    // wenn eine gruppe, die in $_POST["lesen"] ist, noch nicht in der tabelle ist -> hinzufgen
    function checkgroups($value, $key)
    {
      if(sql_num_rows(sql_select("gruppe_id", "boardrechte", "WHERE board_id=".$_POST["edit_board"]." AND gruppe_id=".$value, NULL, NULL)) == 0)
      {
        $werte = array("gruppe_id" => $value, "board_id" => $_POST["edit_board"]);
        sql_insert("boardrechte", $werte);
      }
    }
    @array_walk($_POST["lesen"], 'checkgroups');
    @array_walk($_POST["posts"], 'checkgroups');
    @array_walk($_POST["threads"], 'checkgroups');
    @array_walk($_POST["moderieren"], 'checkgroups');

    // jede gruppe durchgehen
    $alterechteresult = sql_select("*", "boardrechte", "WHERE board_id=".$_POST["edit_board"], NULL, NULL);
    function checkrechte($recht, $alterechte)
    {
      global $alterechte;
      // wenn diese gruppe ein recht hat -> aktualisieren
      if(in_array($alterechte["gruppe_id"],$_POST[$recht]))
      {
        $werte = array($recht => 1);
        sql_update("boardrechte", $werte, "WHERE gruppe_id=".$alterechte["gruppe_id"]." AND board_id=".$_POST["edit_board"]);
      }
      else
      {
        $werte = array($recht => 0);
        sql_update("boardrechte", $werte, "WHERE gruppe_id=".$alterechte["gruppe_id"]." AND board_id=".$_POST["edit_board"]);
      }
    }
    while($alterechte = sql_fetch_assoc($alterechteresult))
    {
      @checkrechte("lesen", $alterechte);
      @checkrechte("posts", $alterechte);
      @checkrechte("threads", $alterechte);
      @checkrechte("moderieren", $alterechte);
    }
    $werte = array("kategorie" => $_POST["kategorie"], "titel" => htmlspecialchars($_POST["titel"]), "beschreibung" => htmlspecialchars($_POST["beschreibung"]), "sort" => $sort);
    sql_update("boards", $werte, "WHERE id=".$_POST["edit_board"]);

    redir("index.php?action=admincp&show=boards", "Die Einstellungen wurden bearbeitet!");
  }
  if(isset($_POST["move_up"]))
  {
    // board nach oben bewegen
    if($board["sort"] == 1)
    {
      redir("index.php?action=admincp&show=boards", "Das Board ist bereits ganz oben!", false);
    }
    else
    {
      $tauschboard = sql_fetch_assoc(sql_select("id", "boards", "WHERE sort=".($board["sort"] - 1)));
      $werte = array("sort" => $board["sort"] - 1);
      sql_update("boards", $werte, "WHERE id=".$board["id"]);
      $werte = array("sort" => $board["sort"]);
      sql_update("boards", $werte, "WHERE id=".$tauschboard["id"]);
      redir("index.php?action=admincp&show=boards", "Das Board wurde nach oben bewegt!");
    }
  }
  if(isset($_POST["move_down"]))
  {
    // board nach unten bewegen
    $maxsort = sql_num_rows(sql_select("id", "boards", "WHERE kategorie=".$board["kategorie"]));
    if($board["sort"] == $maxsort)
    {
      redir("index.php?action=admincp&show=boards", "Das Board ist bereits ganz unten!", false);
    }
    else
    {
      $tauschboard = sql_fetch_assoc(sql_select("id", "boards", "WHERE sort=".($board["sort"] + 1)));
      $werte = array("sort" => $board["sort"] + 1);
      sql_update("boards", $werte, "WHERE id=".$board["id"]);
      $werte = array("sort" => $board["sort"]);
      sql_update("boards", $werte, "WHERE id=".$tauschboard["id"]);
      redir("index.php?action=admincp&show=boards", "Das Board wurde nach unten bewegt!");
    }
  }
}

//**************************** board_loeschen **********************************
if(isset($_POST["board_loeschen"]))
{
  //sicherheitsabfrage, dann lschen
  $result = sql_select("*", "boards", "WHERE id=".$_POST["edit_board"], NULL, NULL);
  $ergebnis = sql_fetch_assoc($result);
  
  if(!isset($_POST["bestaetigen_knopf"]))
  {
    //formular mit besttigungsknopf anzeigen
    ?>
    <h3>Board lschen</h3>
    <form method="POST" action="index.php?action=admincp&amp;show=boards&amp;type=bearbeiten">
    <input name="edit_board" type="hidden" value="<?php echo $_POST["edit_board"] ?>" />
    <input name="board_loeschen" type="hidden" value="1" />
    Sind Sie sicher, dass Sie das Board "<?php echo $ergebnis["titel"] ?>" lschen wollen?<br />
    Die enthaltenen Threads, Posts und Umfragen:<br />
    <input class="inputtext" name="move" type="radio" value="1" />Verschieben in dieses Board:
    <select class="inputtext" name="moveid" size="1">
    <?php
    $result = sql_select("*", "boards", "", NULL, NULL);
    while ($ergebnis = sql_fetch_assoc($result))
    {
      if($ergebnis["id"] == $_POST["edit_board"]) continue;
      echo "<option value=\"".$ergebnis["id"]."\" />".$ergebnis["id"]." - ".$ergebnis["titel"];
    }
    ?>
    </select><br />
    <input class="inputtext" name="move" type="radio" value="0" checked />Lschen<br />
    <input name="bestaetigen_knopf" type="submit" value="lschen" />
    </form>
    <?php
  }
  else
  {
    //board aus der datenbank lschen
    if($_POST["move"]==1)
    {
      //alle enthaltenen threads verschieben
      $werte = array("board" => $_POST["moveid"]);
      sql_update("threads", $werte, "WHERE board=".$ergebnis["id"]);
    }
    else
    {
      //ids der threads im board holen
      //ids der posts und umfragen in den threads holen
      //posts, threads und umfragen lschen
      $delthreadsresult = sql_select("*", "threads", "WHERE board=".$ergebnis["id"], NULL, NULL);
      while($delthread = sql_fetch_assoc($delthreadsresult))
      {
        sql_delete("posts", "WHERE thread=".$delthread["id"]);
        // evtl. umfrage lschen
        $delumfrageresult = sql_select("*", "umfragen", "WHERE thread=".$delthread["id"], NULL, NULL);
        if(sql_num_rows($delumfrageresult) != 0)
        {
          $delumfrage = sql_fetch_assoc($delumfrageresult);
          sql_delete("antworten", "WHERE umfrage=".$delumfrage["id"]);
          sql_delete("umfragen", "WHERE thread=".$delthread["id"]);
        }
      }
      sql_delete("threads", "WHERE board=".$ergebnis["id"]);
    }
    // die eintrge aus tabelle forum_boardrechte lschen
    sql_delete("boardrechte", "WHERE board_id=".$ergebnis["id"]);
    // board lschen
    sql_delete("boards", "WHERE id=".$ergebnis["id"]);
    // nachfolgende sort-werte aufrcken
    $sql = "UPDATE ".$conf["sql_prefix"]."_boards SET sort=sort-1 WHERE sort>".$ergebnis["sort"]." AND kategorie=".$ergebnis["kategorie"].";";
    if($conf["sql_typ"] == "mysql") mysql_query($sql, $link) or dbfehler();
    if($conf["sql_typ"] == "postgresql") pg_query($link, $sql) or dbfehler();
    redir("index.php?action=admincp&show=boards", "Das Board wurde gelscht!");
  }
}
?>
