<?php
/*
 * DasForum - a PHP BulletinBoardSystem
 * Copyright 2005 Heiko Rothkranz <heiko_rothkranz (at) arcor (dot) de>
 * 
 * This file is part of DasForum
 * 
 * DasForum is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * DasForum is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with DasForum; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

$boardrechte = getboardrechte($aktboard["id"]);
if($boardrechte["lesen"] == false) fehler("Sie besitzen nicht gengend Zugriffsrechte, um diese Seite zu betreten!");

// BB-Code-Parser laden
include("./bbcode_parser.php");
$parser = new HTML_BBCodeParser;

// Smilie-Parser
include("./smilie_parser.php");

$announcements = sql_select("*", "announcements", "WHERE boards!=''");
$t = 0;
$m = 0;
while($announcement = sql_fetch_assoc($announcements))
{
  // alle announcements fr dieses board je nach typ in ein array stecken
  if(in_array($aktboard["id"], explode(";", $announcement["boards"])))
  {
    // mini- oder thread-typ?
    if($announcement["typ"] == 0)
    {
      $threadannouncements[$t]["id"] = $announcement["id"];
      $threadannouncements[$t]["titel"] = $announcement["titel"];
      $threadannouncements[$t]["link"] = "index.php?action=announcement&amp;board=".$aktboard["id"]."&amp;id=".$announcement["id"];
      $t++;
    }
    else
    {
      $miniannouncements[$m]["id"] = $announcement["id"];
      $miniannouncements[$m]["titel"] = $announcement["titel"];
      if($announcement["bbcode"] == 1)
      {
        $parser->setText($announcement["nachricht"]);
        $parser->parse();
        $nachricht = $parser->getParsed();
      }
      else
      {
        $nachricht = $announcement["nachricht"];
      }
      if($announcement["smilies"] == 1)
      {
        $nachricht = parse_smilies($nachricht);
      }
      $miniannouncements[$m]["nachricht"] = str_replace("\n", "<br />\n", $nachricht);
      $m++;
    }
  }
}

// start und end werte fr LIMIT feststellen
if(!isset($_GET["seite"]))
{
  $seite = 1;
  $threadstart = 0;
}
else
{
  $seite = $_GET["seite"];
  $threadstart = ($seite - 1) * $einstellungen["threadsperpage"];
}
$threadzahl = sql_num_rows(sql_select("id", "threads", "WHERE board=".$aktboard["id"], NULL, NULL));

// seiten-navigationsleiste
$seitenzahl = ceil($threadzahl/$einstellungen["threadsperpage"]);
$startausgeblendet = false;
$endeausgeblendet = false;
for($n = 1; $n <= $seitenzahl; $n++)
{
  if($n < ($seite - 2))
  {
    if($startausgeblendet == false) $startausgeblendet = true;
  }
  if($n <= ($seite + 2) and $n >= ($seite - 2))
  {
    if($n != $seite)
    {
      $seitenlink[$n] = "index.php?action=viewboard&amp;id=".$aktboard["id"]."&amp;seite=".$n;
    }
    else
    {
      $seitenlink[$n] = "";
    }
  }
  if($n > ($seite + 2))
  {
    if($endeausgeblendet == false)
    {
      $seitenlink["letzte"] = "index.php?action=viewboard&amp;id=".$aktboard["id"]."&amp;seite=".$seitenzahl;
      $endeausgeblendet = true;
    }
  }
}

// array mit allen ausgabefertigen boards erstellen
$result = sql_select("*", "threads", "WHERE board=".$aktboard["id"]." ORDER BY sticky DESC, id DESC", $threadstart, $einstellungen["threadsperpage"]);

$numthreads = sql_num_rows($result);

for($i = 1; $i <= $numthreads; $i++)
{
  $ergebnis = sql_fetch_assoc($result);

  $threads[$i]["id"] = $ergebnis["id"];

  if($boardrechte["posts"] == true and $ergebnis["status"] == 1)
  {
    $threads[$i]["status"] = "offen";
  }
  else
  {
    $threads[$i]["status"] = "geschlossen";
  }

  // hat der Thread eine Umfrage?
  $umfragen = sql_select("*", "umfragen", "WHERE thread=".$ergebnis["id"], NULL, NULL);
  if(sql_num_rows($umfragen)!=0) $threads[$i]["umfrage"] = true; else $threads[$i]["umfrage"] = false;

  if($ergebnis["sticky"] == 1) $threads[$i]["sticky"] = true; else $threads[$i]["sticky"] = false;

  // wieviele seiten hat der thread?
  $anzahlposts = sql_num_rows(sql_select("*", "posts", "WHERE thread=".$ergebnis["id"], NULL, NULL));
  $threadseiten = ceil($anzahlposts / $einstellungen["postsperpage"]);
  if($threadseiten > 1)
  {
    for($n = 1; $n <= $threadseiten; $n++)
    {
      if($n <= $einstellungen["threadsperpage"] )
      {
        $threads[$i]["seitenlink"][$n] = "index.php?action=viewthread&amp;id=".$ergebnis["id"]."&amp;seite=".$n;
      }
      else
      {
        $threads[$i]["seitenlink"]["letzte"] = "index.php?action=viewthread&amp;id=".$ergebnis["id"]."&amp;seite=".$threadseiten;
        break;
      }
    }
  }

  $threads[$i]["titellink"] = "index.php?action=viewthread&amp;id=".$ergebnis["id"];

  $threads[$i]["titel"] = $ergebnis["titel"];

  $threads[$i]["erstellt"] = date("d.m.Y - H:i:s",$ergebnis["created"] + $zeitoffset);

  $userresult = sql_select("*", "users", "WHERE id=".$ergebnis["autor_id"], NULL, NULL);
  $user = sql_fetch_assoc($userresult);
  if($user["id"]!=1 and sql_num_rows($userresult)!=0)
  {
    if($rechte["memberlist"] == true) { $threads[$i]["autorlink"] = "index.php?action=userinfo&amp;id=".$ergebnis["autor_id"]; }
  }
  else
  {
    $threads[$i]["autorlink"] == "";
  }
  $threads[$i]["autorname"] = htmlspecialchars($ergebnis["autor_name"]);

  $postsresult = sql_select("id", "posts", "WHERE thread=".$ergebnis["id"], NULL, NULL);
  $numposts = sql_num_rows($postsresult);
  $threads[$i]["posts"] = $numposts;

  $threads[$i]["hits"] = $ergebnis["hits"];

  if($numposts!=0)
  {
    $lastpostresult = sql_select("*", "posts", "WHERE thread=".$ergebnis["id"]." ORDER BY id DESC", NULL, NULL);
    $lastpost = sql_fetch_assoc($lastpostresult);
    $threads[$i]["lastpostlink"] = "index.php?action=viewthread&amp;id=".$lastpost["thread"]."#".$lastpost["id"];
    $threads[$i]["lastpostdatum"] = date("d.m.Y - H:i:s",$lastpost["created"] + $zeitoffset);
    $userresult = sql_select("*", "users", "WHERE id=".$lastpost["autor_id"], NULL, NULL);
    if($lastpost["autor_id"]!=1 and sql_num_rows($userresult)!=0)
    {
      if($rechte["memberlist"] == true) { $threads[$i]["lastpostautorlink"] = "index.php?action=userinfo&amp;id=".$lastpost["autor_id"]; }
    }
    else
    {
      $threads[$i]["lastpostautorlink"] = "";
    }
    $threads[$i]["lastpostautor"] = htmlspecialchars($lastpost["autor_name"]);
  }
  else
  {
    $threads[$i]["lastpostlink"] = "";
    $threads[$i]["lastpostdatum"] = "";
    $threads[$i]["lastpostautorlink"] = "";
    $threads[$i]["lastpostautor"] = "";
  }
}
if($boardrechte["threads"] == true or $boardrechte["moderieren"] == true)
{
  $neuerthreadlink = "index.php?action=newpost&amp;type=thread&amp;boardid=".$aktboard["id"];
}

include("./layouts/".$layout."/viewboard.php");
?>