<?PHP
/* vim: set expandtab tabstop=4 shiftwidth=4: */
// +----------------------------------------------------------------------------+
// | <G a n e s h a> - Free Web Based Training System                           |
// +----------------------------------------------------------------------------+
// | <G a n e s h a> - Plate-forme de tlformation gratuite et en open source  |
// +----------------------------------------------------------------------------|
// | Copyright (C) 2001-2003  Anma Formation  <http://www.anema.fr/>           |
// +----------------------------------------------------------------------------+
// |           Developer : Georges CALDEIRA <gcaldeira@anemalab.org>            |
// +----------------------------------------------------------------------------+
// |              Infos on project <http://anemalab.org/>                       |
// +----------------------------------------------------------------------------+
// | This program is free software; you can redistribute it and/or modify       |
// | it under the terms of the GNU General Public License as published by       |
// | the Free Software Foundation; either version 2 of the License, or          |
// | (at your option) any later version.                                        |
// |                                                                            |
// | This program is distributed in the hope that it will be useful,            |
// | but WITHOUT ANY WARRANTY; without even the implied warranty of             |
// | MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the              |
// | GNU General Public License for more details.                               |
// |                                                                            |
// | You should have received a copy of the GNU General Public License          |
// | along with this program; if not, write to the Free Software                |
// | Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA   |
// +----------------------------------------------------------------------------+

/**
* Gestion des messages Webmail
*
* @author		Georges Caldeira <gcaldeira@anemalab.org>
* @package		GaneshaInc
*/

	/**
	* Affiche une liste avec les membres d'un groupe
	* @param	integer	$idu	Id du membre
	* @param	integer	$idg	Id du groupe
	* @access	public
	*/
	function ListMembres($idu,$idg) {
	 global $ClsMembre ;
	 global $st_form ;
		put("<select name=\"LDestinataire\" size=1>");
		put('<option value="-2">'.$st_form['lestuteurs'].'</option>');
		// Get the tutors groupe 
		$ClsMembre->InitListTutor($idg);
		while ( $row = $ClsMembre->NextItem() ) {
			if ( $idu != $row['id'] ) {
				put('<option value="'.$row['id'].'" >  '.Unreplace($row['prenom']." ".$row['nom']).'</option>');
			}
		}
		put('<option value="-1" selected>'.$st_form['legroupe'].'</option>');
		// Get the users groupe 
		$ClsMembre->InitListGroupe($idg);
		while ( $row = $ClsMembre->NextItem() ) {
			if ( $idu != $row['id'] ) {
				put('<option value="'.$row['id'].'" >'.Unreplace($row['prenom']." ".$row['nom']).'</option>');
			}
		}
		put("</select>");
	}

	/**
	* Affiche la liste des membres avec un membre selectionne
	* @param	integer	$idu	Id du membre
	* @param	integer	$idg	Id du groupe
	* @param	integer	$id		Id du membre selectionne
	* @access	public
	*/
	function ListMembresWithId($idu,$idg,$id) {
	 global $ClsMembre ;
	 global $st_form ;
		put("<select name=\"LDestinataire\" size=1>");
		put('<option value="-2">'.$st_form['lestuteurs'].'</option>');
		// Get the tutors groupe 
		$ClsMembre->InitListTutor($idg);
		while ( $row = $ClsMembre->NextItem() ) {
			$selected = ( $id == $row['id'] ? "selected":"");
			if ( $idu != $row['id'] ) {
				$name = Unreplace($row['prenom']." ".$row['nom']) ;
				put('<option value="'.$row['id'].'" '.$selected.'>  '.$name.'</option>');
			}
		}
		put('<option value="-1" >'.$st_form['legroupe'].'</option>');
		// Get the users groupe 
		$ClsMembre->InitListGroupe($idg);
		while ( $row = $ClsMembre->NextItem() ) {
			$selected = ( $id == $row['id'] ? "selected":"");
			if ( $idu != $row['id'] ) {
				$name = Unreplace($row['prenom']." ".$row['nom']) ;
				put('<option value="'.$row['id'].'" '.$selected.'>'.$name.'</option>');
			}
		}
		put("</select>");
	}

	/**
	* Affiche le menu de la page WebMail
	* @access	public
	*/
	function MenuWebmail() {
	 global $color1, $cmd_wm, $ext, $gconnexionid, $groupe, $menu, $ClsGroupe, $gusertype ;
	 global $st_menu, $st_titre ;
		$lcmd = "index".$ext."?connexion=".$gconnexionid."&groupe=".$groupe."&menu=".$menu;
		$name_groupe = $ClsGroupe->Name($groupe) ;
		Title( $st_menu['mess'].' ['.CSS($name_groupe).']');

		put('<table width="95%" border="0" cellspacing="0" cellpadding="5">');
		put('  <tr>');
		put('    <td width="5%" >&nbsp;</td>');

		$color = ($cmd_wm==CMD_WM_INBOX?$color1:"#FFFFFF") ;
		$status = Status($st_titre["reception"]);
		$image = '<img align="absmiddle" alt="'.$st_titre["reception"].'" border="0" src="'.HTTP_IMAGES.'boxin.gif">';
		$link  = '<a class="student" href="'.$lcmd.'&cmd_wm='.CMD_WM_INBOX.'" '.$status.'>'.$image.$st_titre["reception"].'</a>';
		put('    <td width="30%" align="middle" valign="middle" bgcolor="'.$color.'">'.$link.'</td>');

		$color = ($cmd_wm==CMD_WM_OUTBOX?$color1:"#FFFFFF") ;
		$status = Status($st_titre["emission"]);
		$image = '<img align="absmiddle" alt="'.$st_titre["emission"].'" border="0" src="'.HTTP_IMAGES.'boxout.gif">';
		$link  = '<a class="student" href="'.$lcmd.'&cmd_wm='.CMD_WM_OUTBOX.'" '.$status.'>'.$image.$st_titre["emission"].'</a>';
		put('    <td width="30%" align="middle" valign="middle" bgcolor="'.$color.'")">'.$link.'</td>');

		if ( $groupe != 0 ) {
			$color = ($cmd_wm==CMD_WM_POST?$color1:"#FFFFFF") ;
			$status = Status($st_titre['nvmessages']);
			$image = '<img align="absmiddle" alt="'.$st_titre['nvmessages'].'" border="0" ';
			$image.= 'src="'.HTTP_IMAGES.'compose.gif">' ;
			$link  = '<a class="student" href="'.$lcmd.'&cmd_wm='.CMD_WM_POST.'" '.$status.'>'.$image.$st_titre['nvmessages'].'</a>';
			put('<td width="25%" align="middle" valign="middle" bgcolor="'.$color.'">'.$link.'</td>');
		} else {
			put('<td width="25%">&nbsp;</td>');
		}

		put('    <td width="10%" >&nbsp;</td>');
		put('  </tr>');
		put('</table>');
		put('<br>');
	}

	/**
	* Affiche un formulaire pour envoyer un nouveau message
	* @access	public
	*/
	function FrmNewWebMail() {
	 global $ext, $gconnexionid, $groupe, $menu, $color2, $color3, $guserid, $ClsMembre ;
	 global $reply, $forward, $ClsWebMail ;
	 global $st_form, $st_titre, $st_table ;
		$name_user = $ClsMembre->GetPrenom($guserid)." ".$ClsMembre->GetNom($guserid) ;
		if ( (isset($reply) && $reply!="") || (isset($forward) && $forward!="") )
		$ret = $ClsWebMail->GetMessageReplyForward(($reply!=""?$reply:$forward)) ;
		$message = (isset($ret['message'])?$ret['message']:'') ;
		$id_user = (isset($ret['id_user'])?$ret['id_user']:'') ;

		BeginBorder("50%",$color2);
		put('      <form action="index'.$ext.'?connexion='.$gconnexionid.'" method="POST" enctype="multipart/form-data" >');
		put('        <input type="hidden" name="groupe" value="'.$groupe.'" >');
		put('        <input type="hidden" name="cmd_wm" value="'.CMD_WM_POST.'" >');
		put('        <input type="hidden" name="poster" value="1" >');
		put('        <input type="hidden" name="menu" value="'.$menu.'" >');
		put('        <input type="hidden" name="De" value="'.$name_user.'" >');
		put('        <table border="0" width="100%" cellpadding="3" cellspacing="0" align="left" bgColor="'.$color3.'">');
		put('          <tr>');
		put('            <td colspan="2" bgColor="'.$color2.'" class="title2">'.$st_titre['entrermess'].'</td>');
		put('          </tr>');
		put('          <tr>');
		put('            <td>'.$st_table['dest'].'</td>');
		put('            <td>');
		// listBox des destinataires
		if ($reply != "" ) {
			ListMembresWithId($guserid,$groupe,$id_user);
		} else {
			ListMembres($guserid,$groupe);
		}
		put('            </td>');
		put('          </tr>');
		put('          <tr>');
		put('            <td valign="top"> '.$st_table['objet'].'</td>');
		put('            <td><input type="text" size="40" name="object_wm" value="'.$object.'" /></td>');
		put('          </tr>');		
		put('          <tr>');
		put('            <td valign="top">'.$st_form['votremess'].'</td>');
		put('            <td><textarea name="Message" cols="40" rows="10" wrap="virtual" >'.$message.'</textarea></td>');
		put('          </tr>');
		
		if ( OPT_UPLOAD_ACTIVE ) {
			put('      <tr>');
			put('        <td valign="top">'.$st_form['selectfichier'].'</td>');
			put('        <td><input type="hidden" class="bouton" name="MAX_FILE_SIZE" value="'.MAX_FILE_SIZE.'">');
			put('            <input type="file" class="bouton" name="fichier" size="30" maxlength="250">');
			put('        </td>');
			put('      </tr>');
		} else {
			put('     <input type="hidden" name="file" value="none" >');
		}

		put('      <tr>');
		put('        <td valign="top">&nbsp;</td>');
		put('        <td><input type="checkbox" class="bouton" name="AR" >'.$st_form['avertir']);

		if ( OPT_MAIL_ACTIVE ) {
			put('<br><input type="checkbox" class="bouton" name="email" >'.$st_form['envoyermail']);
		} else {
			put('<input type="hidden" name="email" value="" >');
		}

		put('            </td>');
		put('          </tr>');
		put('          <tr>');
		put('            <td>&nbsp;</td>');
		put('            <td align="middle"><input type="button" class="bouton" name="OK" value='.$st_form['envoyer'].' onclick="ValiderFormMsg(this.form);"></td> ');	
		put('          </tr>');
		put('        </table>');
		put('      </form>');
		put('      <p>&nbsp;</p><p>&nbsp;</p><p>&nbsp;</p><p>&nbsp;</p>');
		CloseBorder();
	}

	/**
	* Affiche le contenu de la boite emission/reception
	* @access	public
	*/
	function WebMail(){ 
	 global $color2, $color2a, $guserid, $gusertype, $guser, $cmd_wm, $groupe, $menu, $gconnexionid ;
	 global $ClsGroupe, $ClsWebMail, $ext ;
	 global $st_texte, $st_titre, $st_table, $st_menu, $header ;
		$http = ($gusertype==STAGIAIRE?HTTP_STAGIAIRE:HTTP_TUTEUR);
		if ( ! (isset($cmd_wm)) || $cmd_wm == '' ) {
			$cmd_wm=CMD_WM_INBOX;
		}
		if ( $cmd_wm == CMD_WM_INBOX) {
			$txt = $st_table['de']	;
		} else {
			$txt = $st_table['dest'];
		}
		$rep  =  $ClsGroupe->Directory($groupe) ;
		$ClsWebMail->InitList($guserid,$cmd_wm,$groupe);
		$ret = $ClsWebMail->NbMessage($guserid,$cmd_wm,$groupe) ;
		$nb  = $ret['nb'];
		$nb2 = $ret['nb2'];

		Anchor("Top");

		BeginBorder("90%",$color2);
		put('<table align="center" border="0" cellPadding="1" cellSpacing="1" width="100%">');
		put('  <tr bgColor="'.$color2.'">');
		put('    <td valign="top" align="middle" colSpan="5">');
		put('      <table border="0" cellPadding="0" cellSpacing="0" width="100%">');
		put('        <tr>');
		$status = Status('Refresh');
		$click  = 'onclick="window.location.reload()" ';
		$image = '<img border="0" hspace="2" src="'.HTTP_IMAGES.'reload.gif" alt="'.$header['refresh'].'" '.$click.$status.'>';
		put('          <td align=left width="1%"><A href="#">'.$image.'</A></td>');
		put('          <td align=left width="59%" class="title2">'.$st_titre['messperso'].' '.CSS($guser).'</td>');

		if ($cmd_wm==CMD_WM_INBOX) { 
			put('<td align=right width="40%" class="title2">'.$nb.' '.$st_titre['message'].' | '.$nb2.' '.$st_titre['nonlu'].'</td>');
		} else { 
			put('<td align=right width="40%" class="title2"><B>'.$nb.' '.$st_titre['message'].'</td>');
		} 

		put('        </tr>');
		put('      </table>');
		put('    </td>');
		put('  </tr>');
		put('  <tr>');
		put('    <td bgColor="'.$color2a.'" colSpan="5">&nbsp;</td>');
		put('  </tr>');
		put('</tr>');
		put('</table>');
		CloseBorder();
		BR();

		BeginBorder("90%",$color2);
		put('<table valign="top" align="center" border="0" cellPadding="1" cellSpacing="1" width="100%">');
		put('<tr valign="top" bgColor="'.$color2.'">');
		put('      <td valign="top" align="left" noWrap width="5%" class="title2">&nbsp;</td>');
		put('      <td valign="top" align="left" noWrap width="12%" class="title2">'.$st_table['date'].'</td>');
		put('      <td valign="top" align="left" noWrap width="28%" class="title2">'.$txt.'</td>');
		put('      <td valign="top" align="left" noWrap width="45%" class="title2">'.$st_table['Message'].'</td>');
		put('      <td valign="top" align="right" width="10%" class="title2"><CENTER>'.$st_table['action'].'</CENTER></td>');
		put('</tr>');
		
		$i = 0 ;
		while ( $msg = $ClsWebMail->NextItem() ) {
			$id      = $msg['id']		;
			$user    = $msg['user']		;
			$objet   = nl2br(CSS($msg['objet']))	;
			$message = nl2br(CSS($msg['message']))	;
			$date    = $msg['date']		;
			$lu      = $msg['lu']		;
			$type    = $msg['type']		;
			$file    = $msg['file']		;

			$ar = ($AR == 0? "" : "+") ;
			put('  <tr valign="top"  bgColor="'.GetColor($i++).'">');
			if ( $cmd_wm==CMD_WM_OUTBOX ) {
				put('    <td width="5%"><NOBR>&nbsp;&nbsp;&nbsp;'.$ar.'</NOBR></td>');
			} else {
				if ($lu==0) {
					$href = 'href="index'.$ext.'?menu='.$menu.'&groupe='.$groupe.'&connexion='.$gconnexionid;
					$href.= '&lire='.$id.'&AR='.$AR.'"';
					$status = Status($st_texte['wmlu']);
					$image  = '<img border="0" alt="['.$st_texte['wmlu'].']" src="'.HTTP_IMAGES.'newmail.gif">';
					$link   = '<a '.$href.$status.' >'.$image.'</a>' ;
					put('    <td width="5%"><NOBR>'.$link.'&nbsp;'.$ar.'</NOBR></td>');
				} else {
					put('    <td width="5%"><NOBR>&nbsp;'.$ar.'</NOBR></td>');
				}
			}
			put('    <td width="12%"> '.$date.'</td>');
		
			// Source
			put('    <td width="28%"> '.CSS($user).'</td>');
			$mess = '';
			if ( $type == 1 ) {
				$mess= $st_texte['tousmembres'].'<br>';
			} elseif  ( $type == 2 ) {
				$mess= $st_texte['tousgroupes'].'<br>';
			}

			if ( $cmd_wm==CMD_WM_OUTBOX ) {
				put('    <td width="50%">'.$objet.'<br><b><i>'.$mess.'</i></b>'.$message.'</td>');								
			} else {
				$url   = HTTP_COMMUN."p_webmail".$ext."?connexion=".$gconnexionid.'&id_wm='.$id.'&groupe='.$groupe ;
				$click = "onClick=\"openWindow('".$url."','webmail','scrollbars=yes,width=620,height=400')\" ";
				$status = Status($st_menu['mess']);
				$lobj = '<a class="student" href="#" '.$click.' '.$status.'>'.$objet.'</a>' ;
				if ( OPT_ONLY_OBJECT_WM_ACTIVE && strlen(trim($lobj))!=0 ) {
					put('    <td width="50%">'.$lobj.'</td>') ;
				} else {
					put('    <td width="50%">'.$lobj.'<br><b><i>'.$mess.'</i></b>'.CouperTexte($message,MAX_CAR_MSG_WM).'</td>');
				}
			}

			// Actions : delete, read file, reply, forward
			$lfile = "" ;
			if ( $file != "" ) {
				$dir  = RP_GROUPES.$rep.'/messages/' ;
				$href = 'href="'.HTTP_COMMUN.'download.php?connexion='.$gconnexionid ;
				$href.= '&dir='.urlencode($dir).'&filename='.urlencode($file).'"' ;
				$status = Status($st_texte['wmfichieratt']) ;
				$image  = '<IMG border="0" alt="['.$st_texte['wmfichieratt'].']" src="'.HTTP_IMAGES.'file.gif">' ;
				$lfile = '&nbsp;<A '.$href.' target="_blank" '.$status.'>'.$image.'</A>' ;
			}

			$href = 'href="javascript:DeleteMessage(\''.$http.'index'.$ext.'?menu='.$menu.'&groupe='.$groupe ;
			$href.= '&connexion='.$gconnexionid.'&delete='.$id.'&cmd_wm='.$cmd_wm.'\');" ';
			$status = Status($st_texte['wmsupprimer']);
			$image  = '<IMG border="0" alt="['.$st_texte['wmsupprimer'].']" src="'.HTTP_IMAGES.'maildelete.gif">';
			$ldelete='&nbsp;<A '.$href.' '.$status.'>'.$image.'</A>';

			if ( $cmd_wm == CMD_WM_INBOX ) { 
				//reception
				$href = 'href="index'.$ext.'?menu='.$menu.'&groupe='.$groupe;
				$href.= '&connexion='.$gconnexionid.'&reply='.$id.'&cmd_wm='.CMD_WM_POST.'"'	;
				$status = Status($st_texte['wmrepondre']);
				$image  = '<IMG border="0" alt="['.$st_texte['wmrepondre'].']" src="'.HTTP_IMAGES.'reply.gif">';
				$lreply = '&nbsp;<A '.$href.' target="FrmMain" '.$status.'>'.$image.'</A>' ;

				$href = 'href="index'.$ext.'?menu='.$menu.'&groupe='.$groupe ;
				$href.= '&connexion='.$gconnexionid.'&forward='.$id.'&cmd_wm='.CMD_WM_POST.'"'	 ;
				$status = Status($st_texte['wmsuivre']);
				$image  = '<IMG border="0" alt="['.$st_texte['wmsuivre'].']" src="'.HTTP_IMAGES.'forward.gif">';
				$lforward = '&nbsp;<A '.$href.' target="FrmMain" '.$status.'>'.$image.'</A>' ;
			}
			put('    <td align="left" width="10%">'.$ldelete.$lreply.$lforward.$lfile.'</td>');
			put('  </tr>');
		} // while
		put('</table>');
		CloseBorder();
		LinkAnchor("Top","Top",true);
		}

	/**
	* Envoie un message
	* @param	integer	$LDest	Id du destinataire
	* @param	string	$object	objet du message
	* @param	string	$Message	valeur du message
	* @param	boolean	$AR	avec AR ou pas.
	* @param	integer	$groupe	Id du groupe
	* @param	string	$server_fichier	no mdu fichier sur le serveur
	* @param	string	$fichier_name	nom du fichier a copier
	* @access	public
	*/
	function EnvoyerMsg($LDest,$object,$Message,$AR,$groupe,$server_fichier,$fichier_name) {
	 global $ClsMembre, $ClsGroupe, $ClsMail, $ClsWebMail, $color1, $color2, $guserid, $email, $st_form, $st_texte ;
		$name_groupe = $ClsGroupe->Name($groupe);
		$name_user   = $ClsMembre->GetPrenom($guserid)." ".$ClsMembre->GetNom($guserid) ;
		$myMessage = trim($Message)			;
		$myObject = trim($object)			;
//		$myMessage = htmlentities($myMessage)	;
		$dest = ""							;
		$ret  = false						;
		if ( $LDest == -1) {
			// Groupe
			if ( $email == "on" ) {
				$dest = $ClsMembre->GetEmailGroupe($groupe);
			}
			$ret = $ClsWebMail->SendGroupe($guserid,$myObject,$myMessage,$groupe,$server_fichier,$AR) ;
		} elseif ( $LDest == -2 ){ 
			// Tuteurs
			if ( $email == "on" ) {
				$dest = $ClsMembre->GetEmailTuteur($groupe) ;
			}
			$ret = $ClsWebMail->SendTutor($guserid,$myObject,$myMessage,$groupe,$server_fichier,$AR) ;
		} else {
			//Membre
			if ( $email == "on" ) {
				$dest = $ClsMembre->GetEmail($LDest);
			}
			$ret = $ClsWebMail->SendUser($guserid,$LDest,$myObject,$myMessage,$groupe,$server_fichier,$AR) ;
		}
		if ( $dest != "" && $ret && OPT_MAIL_ACTIVE ) {
			$ClsMail->SetSubject(MAIL_TUTEUR,"") ;
			$ClsMail->SetBody(MAIL_TUTEUR,$name_user,$name_groupe,UnReplace($myMessage),"") ;
			if ( $fichier_name != "" ) {
				$msg = sprintf($st_texte['wmfichier'],$fichier_name);
				$ClsMail->AddToBody($msg) ;
			}
			$ClsMail->SetBcc($dest);
			$ret = $ClsMail->Send($st_form['legroupe']." ".EMAIL_GROUPE);
		}
		return $ret ;
	}

	/**
	* Affiche la page principale du WebMail
	* @access	public
	*/
	function page_WebMail() {
	 global $lire, $AR, $delete, $cmd_wm, $groupe, $ClsWebMail, $st_texte ;
	 global $guserid, $fichier, $fichier_name, $LDestinataire, $Message, $poster, $object_wm;
	 global $HTTP_POST_FILES ;
		$ret = false ;
		$AR = ($AR==""?0:1);
		if ( $cmd_wm == CMD_WM_POST) {
			// Nouveau Webmail
			if ( isset($poster) ) { 
				if ( strlen($HTTP_POST_FILES['fichier']['name']) > 0 && 
					 $HTTP_POST_FILES['fichier']['name'] != "none"   && 
					 OPT_UPLOAD_ACTIVE 
				   ) {
					$server_fichier = CopyFileGroupe($guserid, $groupe, $HTTP_POST_FILES );
				}
				$ret = EnvoyerMsg($LDestinataire,Replace($object_wm),Replace($Message),$AR,$groupe,$server_fichier,$fichier_name) ;
				// Afficher la liste des msg envoyes
				$cmd_wm = CMD_WM_OUTBOX ;
				MenuWebmail();
				if ( !$ret ) {
					message ($st_texte['wmmerror']) ;
				}
				WebMail();
			} else {
				MenuWebmail();
				FrmNewWebMail();
			}
		} else {
			// reception/Emission
			MenuWebmail();
			if ( isset($lire) && $lire != '' ) {
				$ClsWebMail->ReadWebMail($lire);
			}
			if ( isset($delete) && $delete != '' ) {
				$ClsWebMail->DeleteWebMail($delete);
			}
			WebMail();
		}
	}


	/**
	* Affiche un message
	* @param	integer	$idg	Id du groupe
	* @param	integer	$idm	id du message
	* @access	public
	*/
	function DisplayWebMail($idg,$idm) {	
		global $color1, $st_table, $ClsWebMail ;
		$ret = $ClsWebMail->ReadMessage($idm) ;
		BeginBorder("80%",$color1);
		put('<table width="100%" border="0" cellspacing="1" cellpadding="2" bgcolor="#FFFFFF">')	;
		put('  <tr valign="top"><td width="20%">&nbsp;<b>'.$st_table['date'].'</b></td><td width="80%">'.$ret['date'].'</td></tr>')		;				
		put('  <tr valign="top"><td>&nbsp;<b>'.$st_table['de'].'</b></td><td>'.$ret['source'].'</td></tr>')		;		
		put('  <tr valign="top"><td>&nbsp;<b>'.$st_table['objet'].'</b></td><td>'.CSS($ret['objet']).'</td></tr>')		;
		put('  <tr valign="top"><td>&nbsp;<b>'.$st_table['Message'].'</b></td><td>'.nl2br(CSS($ret['text'])).'</td></tr>')		;
		put('</table>')	;
		CloseBorder();
	}
	
?>