/*
 * Decompiled with CFR 0.152.
 */
package org.linphone.jlinphone.gui;

import java.util.Timer;
import java.util.TimerTask;
import net.rim.device.api.applicationcontrol.ApplicationPermissions;
import net.rim.device.api.applicationcontrol.ApplicationPermissionsManager;
import net.rim.device.api.i18n.ResourceBundle;
import net.rim.device.api.system.Application;
import net.rim.device.api.system.ApplicationDescriptor;
import net.rim.device.api.system.Audio;
import net.rim.device.api.system.Bitmap;
import net.rim.device.api.system.EventLogger;
import net.rim.device.api.system.KeyListener;
import net.rim.device.api.system.RadioListener;
import net.rim.device.api.system.WLANInfo;
import net.rim.device.api.system.WLANListener;
import net.rim.device.api.ui.Field;
import net.rim.device.api.ui.Font;
import net.rim.device.api.ui.MenuItem;
import net.rim.device.api.ui.Screen;
import net.rim.device.api.ui.UiApplication;
import net.rim.device.api.ui.component.Dialog;
import net.rim.device.api.ui.component.LabelField;
import net.rim.device.api.ui.component.ListField;
import net.rim.device.api.ui.component.Status;
import net.rim.device.api.ui.container.MainScreen;
import net.rim.device.api.ui.container.VerticalFieldManager;
import net.rim.device.api.ui.decor.BackgroundFactory;
import org.linphone.bb.LogHandler;
import org.linphone.bb.NetworkManager;
import org.linphone.core.CallDirection;
import org.linphone.core.LinphoneAddress;
import org.linphone.core.LinphoneCall;
import org.linphone.core.LinphoneCallLog;
import org.linphone.core.LinphoneChatRoom;
import org.linphone.core.LinphoneCore;
import org.linphone.core.LinphoneCoreException;
import org.linphone.core.LinphoneCoreFactory;
import org.linphone.core.LinphoneCoreListener;
import org.linphone.core.LinphoneFriend;
import org.linphone.core.LinphoneProxyConfig;
import org.linphone.jlinphone.gui.AboutScreen;
import org.linphone.jlinphone.gui.CallLogsField;
import org.linphone.jlinphone.gui.DialerField;
import org.linphone.jlinphone.gui.LinphoneResource;
import org.linphone.jlinphone.gui.SelectableListField;
import org.linphone.jlinphone.gui.SettingField;
import org.linphone.jlinphone.gui.SettingsScreen;
import org.linphone.jlinphone.gui.TabField;
import org.linphone.jortp.JOrtpFactory;
import org.linphone.jortp.Logger;

public class LinphoneScreen
extends MainScreen
implements LinphoneCoreListener,
LinphoneResource {
    private LabelField mStatus;
    private static Logger sLogger = JOrtpFactory.instance().createLogger("Linphone");
    private LinphoneCore mCore;
    private Timer mTimer;
    private SettingsScreen mSettingsScreen;
    private ListField mCallLogs;
    private DialerField mDialer;
    private TabField mTabField;
    private final int HISTORY_TAB_INDEX;
    private final int DIALER_TAB_INDEX;
    private final int SETTINGS_TAB_INDEX;
    static int[] sPermissions = new int[]{7, 21, 16, 17, 19, 8, 9, 15};
    private static ResourceBundle mRes = ResourceBundle.getBundle((long)-8981235513634632902L, (String)"org.linphone.jlinphone.gui.Linphone");

    LinphoneScreen() {
        this.HISTORY_TAB_INDEX = 0;
        this.DIALER_TAB_INDEX = 1;
        this.SETTINGS_TAB_INDEX = 2;
        LinphoneCoreFactory.setFactoryClassName("org.linphone.jlinphone.core.LinphoneFactoryImpl");
        LinphoneCoreFactory.instance().setLogHandler(new LogHandler());
        LinphoneCoreFactory.instance().setDebugMode(true);
        sLogger.warn(" Starting version " + ApplicationDescriptor.currentApplicationDescriptor().getVersion());
        ApplicationPermissions lCurentPermission = ApplicationPermissionsManager.getInstance().getApplicationPermissions();
        boolean lPermissionRequestNeeded = false;
        int i = 0;
        while (i < sPermissions.length) {
            if (!lCurentPermission.containsPermissionKey(sPermissions[i]) || lCurentPermission.getPermission(sPermissions[i]) != 999) {
                lPermissionRequestNeeded = true;
            }
            ++i;
        }
        if (lPermissionRequestNeeded) {
            ApplicationPermissions lLinphonePermission = new ApplicationPermissions();
            int i2 = 0;
            while (i2 < sPermissions.length) {
                lLinphonePermission.addPermission(sPermissions[i2]);
                ++i2;
            }
            if (!ApplicationPermissionsManager.getInstance().invokePermissionsRequest(lLinphonePermission)) {
                sLogger.error("permission refused");
                UiApplication.getUiApplication().invokeLater(new Runnable(){

                    public void run() {
                        Dialog.alert((String)mRes.getString(22));
                        LinphoneScreen.this.close();
                    }
                });
                return;
            }
        }
        this.addKeyListener(new KeyListener(){
            static final int GREEN_BUTTON_KEY = 0x110000;
            static final int RED_BUTTON_KEY = 0x120000;
            static final int VOLUME_DOWN = 0x10010000;
            static final int VOLUME_UP = 0x10000000;
            private int mLastVolumeEvent;

            public boolean keyChar(char key, int status, int time) {
                return false;
            }

            public boolean keyDown(int keycode, int time) {
                if (keycode == 0x110000 || keycode == 0x120000) {
                    return true;
                }
                if (time != this.mLastVolumeEvent && (keycode == 0x10010000 || keycode == 0x10000000)) {
                    this.mLastVolumeEvent = time;
                    int lLeveltoDisplay = 100;
                    if (LinphoneScreen.this.mCore.isIncall()) {
                        if (keycode == 0x10010000 && LinphoneScreen.this.mCore.getPlayLevel() >= 0) {
                            lLeveltoDisplay = Math.max(0, LinphoneScreen.this.mCore.getPlayLevel() - 10);
                        } else if (keycode == 0x10000000) {
                            lLeveltoDisplay = Math.min(100, LinphoneScreen.this.mCore.getPlayLevel() + 10);
                        }
                        LinphoneScreen.this.mCore.setPlayLevel(lLeveltoDisplay);
                    } else {
                        if (keycode == 0x10010000) {
                            lLeveltoDisplay = Math.max(0, Audio.getVolume() - 10);
                        } else if (keycode == 0x10000000) {
                            lLeveltoDisplay = Math.min(100, Audio.getVolume() + 10);
                        }
                        Audio.setVolume((int)lLeveltoDisplay);
                    }
                    Status.show((String)("Volume [" + lLeveltoDisplay + "]"), (int)500);
                    return true;
                }
                return false;
            }

            public boolean keyRepeat(int keycode, int time) {
                return false;
            }

            public boolean keyStatus(int keycode, int time) {
                return false;
            }

            public boolean keyUp(int keycode, int time) {
                if (keycode == 0x110000) {
                    return LinphoneScreen.this.callButtonPressed();
                }
                if (keycode == 0x120000) {
                    LinphoneScreen.this.hangupButtonPressed();
                    return true;
                }
                return false;
            }
        });
        this.mStatus = new LabelField((Object)"", 0x800000000L);
        this.mStatus.setFont(Font.getDefault().derive(2, 20));
        this.setTitle((Field)this.mStatus);
        try {
            this.mCore = LinphoneCoreFactory.instance().createLinphoneCore(this, null, null, this);
        }
        catch (LinphoneCoreException e) {
            UiApplication.getUiApplication().invokeLater(new Runnable(){

                public void run() {
                    Dialog.alert((String)e.getMessage());
                    LinphoneScreen.this.close();
                }
            });
            return;
        }
        ((VerticalFieldManager)this.getMainManager()).setBackground(BackgroundFactory.createSolidBackground((int)0xD3D3D3));
        this.mTabField = new TabField();
        this.add((Field)this.mTabField);
        this.mCallLogs = new CallLogsField(this.mCore, new SelectableListField.Listener(){

            public void onSelected(Object selected) {
                LinphoneAddress lAddress = ((LinphoneCallLog)selected).getDirection() == CallDirection.Incoming ? ((LinphoneCallLog)selected).getFrom() : ((LinphoneCallLog)selected).getTo();
                LinphoneScreen.this.mDialer.setAddress(lAddress.getUserName());
                LinphoneScreen.this.mDialer.setDisplayName(lAddress.getDisplayName());
                LinphoneScreen.this.mTabField.display(1);
            }
        });
        this.mTabField.addTab(Bitmap.getBitmapResource((String)"history_orange.png"), (Field)this.mCallLogs);
        this.mDialer = new DialerField(this.mCore);
        this.mTabField.addTab(Bitmap.getBitmapResource((String)"dialer_orange.png"), (Field)this.mDialer);
        this.mSettingsScreen = new SettingsScreen(this.mCore);
        this.mTabField.addTab(Bitmap.getBitmapResource((String)"settings_orange.png"), (Field)new SettingField(this.mSettingsScreen.createSettingsFields()));
        this.mTabField.setDefault(1);
        this.addMenuItem(new MenuItem(mRes.getString(1), 110, 10){

            public void run() {
                UiApplication.getUiApplication().pushScreen((Screen)LinphoneScreen.this.mSettingsScreen);
            }
        });
        this.addMenuItem(new MenuItem(mRes.getString(2), 110, 10){

            public void run() {
                EventLogger.startEventLogViewer();
            }
        });
        this.addMenuItem(new MenuItem(mRes.getString(3), 110, 10){

            public void run() {
                UiApplication.getUiApplication().pushScreen((Screen)new AboutScreen());
            }
        });
        this.mTimer = new Timer();
        TimerTask task = new TimerTask(){

            public void run() {
                LinphoneScreen.this.mCore.iterate();
            }
        };
        this.mTimer.scheduleAtFixedRate(task, 0L, 200L);
        NetworkManager lNetworkManager = new NetworkManager(this.mCore);
        lNetworkManager.handleCnxStateChange();
        Application.getApplication().addRadioListener(3, (RadioListener)lNetworkManager);
        WLANInfo.addListener((WLANListener)lNetworkManager);
    }

    public void close() {
        try {
            Dialog.alert((String)mRes.getString(0));
            if (this.mCore != null) {
                this.mCore.destroy();
            }
        }
        finally {
            super.close();
        }
    }

    private boolean callButtonPressed() {
        sLogger.info("Call button pressed.");
        try {
            if (this.mCore.isInComingInvitePending()) {
                this.mCore.acceptCall(this.mCore.getCurrentCall());
                return true;
            }
        }
        catch (LinphoneCoreException e) {
            sLogger.error("call error", e);
            UiApplication.getUiApplication().invokeLater(new Runnable(){

                public void run() {
                    Dialog.alert((String)e.getMessage());
                }
            });
        }
        return false;
    }

    public void hangupButtonPressed() {
        sLogger.info("Hangup button pressed");
        this.mCore.terminateCall(this.mCore.getCurrentCall());
    }

    public void authInfoRequested(LinphoneCore lc, String realm, String username) {
    }

    public void displayMessage(LinphoneCore lc, String message) {
    }

    public void displayStatus(LinphoneCore lc, final String message) {
        UiApplication.getUiApplication().invokeLater(new Runnable(){

            public void run() {
                LinphoneScreen.this.mStatus.setText((Object)("Linphone  " + message));
            }
        });
    }

    public void displayWarning(LinphoneCore lc, String message) {
    }

    public void show(LinphoneCore lc) {
    }

    public void callState(LinphoneCore lc, LinphoneCall call, final LinphoneCall.State state, String message) {
        UiApplication.getUiApplication().invokeLater(new Runnable(){

            public void run() {
                if (state == LinphoneCall.State.IncomingReceived && !UiApplication.getUiApplication().isForeground()) {
                    UiApplication.getUiApplication().requestForeground();
                }
                if (state == LinphoneCall.State.OutgoingInit || state == LinphoneCall.State.IncomingReceived) {
                    LinphoneScreen.this.mDialer.enableIncallFields();
                } else if (state == LinphoneCall.State.CallEnd | state == LinphoneCall.State.Error) {
                    LinphoneScreen.this.mDialer.enableOutOfCallFields();
                }
            }
        });
    }

    public void globalState(LinphoneCore lc, LinphoneCore.GlobalState state, String message) {
    }

    public void registrationState(LinphoneCore lc, LinphoneProxyConfig cfg, LinphoneCore.RegistrationState cstate, String smessage) {
        sLogger.info("new registration state [" + cstate + "]");
    }

    public void newSubscriptionRequest(LinphoneCore lc, LinphoneFriend lf, String url) {
    }

    public void notifyPresenceReceived(LinphoneCore lc, LinphoneFriend lf) {
    }

    public void textReceived(LinphoneCore lc, LinphoneChatRoom cr, LinphoneAddress from, String message) {
    }
}

