/*
 * Decompiled with CFR 0.152.
 */
package org.linphone.jlinphone.sal.jsr180;

import java.util.Vector;
import org.linphone.jortp.JOrtpFactory;
import org.linphone.jortp.Logger;
import org.linphone.jortp.PayloadType;
import org.linphone.sal.SalException;
import org.linphone.sal.SalFactory;
import org.linphone.sal.SalMediaDescription;
import org.linphone.sal.SalStreamDescription;
import sip4me.gov.nist.core.ParseException;
import sip4me.gov.nist.javax.sdp.MediaDescription;
import sip4me.gov.nist.javax.sdp.SdpException;
import sip4me.gov.nist.javax.sdp.SdpFactory;
import sip4me.gov.nist.javax.sdp.SdpParseException;
import sip4me.gov.nist.javax.sdp.SessionDescription;
import sip4me.gov.nist.javax.sdp.fields.AttributeField;
import sip4me.gov.nist.javax.sdp.fields.ConnectionField;
import sip4me.gov.nist.javax.sdp.fields.MediaField;
import sip4me.gov.nist.javax.sdp.fields.OriginField;
import sip4me.gov.nist.javax.sdp.fields.SessionNameField;
import sip4me.gov.nist.javax.sdp.fields.TimeField;

public class SdpUtils {
    static Logger sLogger = Logger.getLogger("Sal");

    public static SalMediaDescription toSalMediaDescription(SessionDescription sd) throws SalException {
        SalMediaDescription md = SalFactory.instance().createSalMediaDescription();
        try {
            ConnectionField c;
            if (sd.getConnection() == null && sd.getMediaDescriptions(false).size() > 0 && (c = ((MediaDescription)sd.getMediaDescriptions(false).elementAt(0)).getConnection()) != null) {
                sd.setConnection(c);
            }
            if ((c = sd.getConnection()) == null) {
                throw new SalException("no  cline");
            }
            Vector mlines = sd.getMediaDescriptions(false);
            md.setAddress(c.getAddress());
            int i = 0;
            while (i < mlines.size()) {
                MediaDescription mline = (MediaDescription)mlines.elementAt(i);
                SalStreamDescription ssd = SdpUtils.toStreamDescription(mline);
                if (ssd.getAddress() == null) {
                    ssd.setAddress(c.getAddress());
                }
                if (ssd != null) {
                    md.addStreamDescription(ssd);
                }
                ++i;
            }
        }
        catch (Throwable e) {
            throw new SalException("Could parse sdp", e);
        }
        return md;
    }

    public static SessionDescription toSessionDescription(SalMediaDescription md) {
        SessionDescription sd = null;
        try {
            sd = SdpFactory.getInstance().createSessionDescription();
            SessionNameField sessionName = SdpFactory.getInstance().createSessionName("Phone call");
            OriginField origin = SdpFactory.getInstance().createOrigin("blackberry", md.getAddress());
            ConnectionField c = SdpFactory.getInstance().createConnection(md.getAddress());
            TimeField t = SdpFactory.getInstance().createTime();
            sd.setSessionName(sessionName);
            sd.setOrigin(origin);
            sd.setConnection(c);
            sd.addField(t);
            Vector<MediaDescription> mlines = new Vector<MediaDescription>();
            int i = 0;
            while (i < md.getNumStreams()) {
                MediaDescription mline = SdpUtils.toMLine(md.getStream(i));
                mlines.addElement(mline);
                ++i;
            }
            sd.setMediaDescriptions(mlines);
        }
        catch (SdpException e) {
            e.printStackTrace();
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return sd;
    }

    private static MediaDescription toMLine(SalStreamDescription sd) {
        Vector<AttributeField> attrs = new Vector<AttributeField>();
        PayloadType[] pts = sd.getPayloadTypes();
        int[] payloads = new int[pts.length];
        int i = 0;
        while (i < pts.length) {
            PayloadType pt = pts[i];
            StringBuffer rtpmap = new StringBuffer();
            rtpmap.append(pt.getNumber());
            rtpmap.append(' ');
            rtpmap.append(pt.getMimeType());
            rtpmap.append('/');
            rtpmap.append(pt.getClockRate());
            if (pt.getNumChannels() > 0) {
                rtpmap.append('/');
                rtpmap.append(pt.getNumChannels());
            }
            AttributeField attr = null;
            try {
                attr = SdpFactory.getInstance().createAttribute("rtpmap", rtpmap.toString());
                attrs.addElement(attr);
                if (pt.getRecvFmtp() != null) {
                    attr = SdpFactory.getInstance().createAttribute("fmtp", String.valueOf(pt.getNumber()) + " " + pt.getRecvFmtp());
                    attrs.addElement(attr);
                }
            }
            catch (SdpException e) {
                sLogger.error("enable to create sdp attribute for codec [" + pt.getMimeType() + "]", e);
            }
            payloads[i] = pt.getNumber();
            ++i;
        }
        MediaDescription mline = null;
        try {
            mline = SdpFactory.getInstance().createMediaDescription(sd.getType() == SalStreamDescription.Type.Audio ? "audio" : "video", sd.getPort(), 0, sd.getProto() == SalStreamDescription.Proto.RtpAvp ? "RTP/AVP" : "RTP/SAVP", payloads);
            mline.setAttributes(attrs);
        }
        catch (IllegalArgumentException e) {
            sLogger.error("Could not create mline", e);
        }
        catch (SdpException e) {
            sLogger.error("Could not create mline", e);
        }
        return mline;
    }

    private static SalStreamDescription toStreamDescription(MediaDescription mline) {
        SalStreamDescription.Type mt;
        SalStreamDescription ssd = new SalStreamDescription();
        MediaField mf = mline.getMedia();
        try {
            mt = mf.getMediaType().equals("audio") ? SalStreamDescription.Type.Audio : (mf.getMediaType().equals("video") ? SalStreamDescription.Type.Video : SalStreamDescription.Type.Other);
        }
        catch (SdpParseException e) {
            sLogger.error("Could not get mediatype", e);
            return null;
        }
        ssd.setType(mt);
        if (mf.getProto().equals("RTP/AVP")) {
            ssd.setProto(SalStreamDescription.Proto.RtpAvp);
        } else if (mf.getProto().equals("RTP/SAVP")) {
            ssd.setProto(SalStreamDescription.Proto.RtpSavp);
        } else {
            sLogger.error("Unsupported proto" + mf.getProto(), null);
            return null;
        }
        ssd.setPort(mf.getPort());
        try {
            String ptime = mline.getAttribute("ptime");
            if (ptime != null) {
                ssd.setPtime(Integer.parseInt(ptime));
            }
        }
        catch (SdpParseException sdpParseException) {
            // empty catch block
        }
        SdpUtils.fillCodecs(ssd, mline);
        return ssd;
    }

    private static void extractRtpmap(PayloadType pt, String value) {
        int space = value.indexOf(32);
        String number = value.substring(0, space);
        int n = Integer.parseInt(number);
        if (n == pt.getNumber()) {
            int i = space;
            while (value.charAt(i) == ' ') {
                ++i;
            }
            String rtpmap = value.substring(i);
            int slash = rtpmap.indexOf(47);
            pt.setMimeType(rtpmap.substring(0, slash));
            int slash2 = rtpmap.indexOf(47, slash + 1);
            String rate = slash2 > 0 ? rtpmap.substring(slash + 1, slash2) : rtpmap.substring(slash + 1);
            pt.setClockRate(Integer.parseInt(rate));
            if (slash2 > 0) {
                String chans = rtpmap.substring(slash2 + 1);
                pt.setNumChannels(Integer.parseInt(chans));
            }
        }
    }

    private static void fillPayloadType(PayloadType pt, MediaDescription mline) {
        Vector attrs = mline.getAttributeFields();
        int i = 0;
        while (i < attrs.size()) {
            AttributeField attr = (AttributeField)attrs.elementAt(i);
            try {
                if (attr.getName().equals("rtpmap")) {
                    SdpUtils.extractRtpmap(pt, attr.getValue());
                } else if (attr.getName().equals("fmtp")) {
                    pt.appendSendFmtp(attr.getValue());
                }
            }
            catch (SdpParseException e) {
                sLogger.error("Cannot get rtpmap value for " + attr, null);
            }
            ++i;
        }
    }

    private static void fillCodecs(SalStreamDescription ssd, MediaDescription mline) {
        MediaField mf = mline.getMedia();
        Vector payloadNumbers = mf.getFormats();
        Vector<PayloadType> payLoadTypes = new Vector<PayloadType>();
        int i = 0;
        while (i < payloadNumbers.size()) {
            String numstr = (String)payloadNumbers.elementAt(i);
            PayloadType pt = JOrtpFactory.instance().createPayloadType();
            pt.setNumber(Integer.parseInt(numstr));
            SdpUtils.fillPayloadType(pt, mline);
            payLoadTypes.addElement(pt);
            ++i;
        }
        Object[] payloadTypeArray = new PayloadType[payLoadTypes.size()];
        payLoadTypes.copyInto(payloadTypeArray);
        ssd.setPayloadTypes((PayloadType[])payloadTypeArray);
    }
}

