/*
 * Decompiled with CFR 0.152.
 */
package sip4me.gov.nist.siplite.header;

import sip4me.gov.nist.core.GenericObject;
import sip4me.gov.nist.core.NameValueList;
import sip4me.gov.nist.siplite.header.Header;

public class CSeqHeader
extends Header {
    public static Class clazz = new CSeqHeader().getClass();
    public static final String NAME = "CSeq";
    protected Integer seqno;
    protected String method;

    public CSeqHeader() {
        super(NAME);
    }

    public CSeqHeader(int seqno, String method) {
        this();
        this.seqno = new Integer(seqno);
        this.method = method;
    }

    public boolean equals(Object other) {
        if (!other.getClass().equals(this.getClass())) {
            return false;
        }
        CSeqHeader that = (CSeqHeader)other;
        if (!this.seqno.equals(that.seqno)) {
            return false;
        }
        return GenericObject.equalsIgnoreCase(this.method, that.method);
    }

    public String encodeBody() {
        return this.seqno + " " + this.method.toUpperCase();
    }

    public String getMethod() {
        return this.method.toUpperCase();
    }

    public void setSequenceNumber(int sequenceNumber) {
        if (sequenceNumber < 0) {
            throw new IllegalArgumentException("the sequence number parameter is < 0");
        }
        this.seqno = new Integer(sequenceNumber);
    }

    public void setMethod(String meth) {
        if (meth == null) {
            throw new NullPointerException("parameter is null");
        }
        this.method = meth;
    }

    public int getSequenceNumber() {
        if (this.seqno == null) {
            return 0;
        }
        return this.seqno;
    }

    public Object clone() {
        CSeqHeader retval = new CSeqHeader();
        if (this.seqno != null) {
            retval.seqno = new Integer(this.seqno);
        }
        retval.method = this.method;
        return retval;
    }

    public Object getValue() {
        return this.seqno;
    }

    public NameValueList getParameters() {
        return null;
    }
}

