/*
 * Decompiled with CFR 0.152.
 */
package sip4me.gov.nist.siplite.message;

import java.util.Hashtable;
import sip4me.gov.nist.siplite.header.ContactHeader;
import sip4me.gov.nist.siplite.header.ContactList;
import sip4me.gov.nist.siplite.header.ExtensionHeader;
import sip4me.gov.nist.siplite.header.Header;
import sip4me.gov.nist.siplite.header.HeaderList;
import sip4me.gov.nist.siplite.header.ProxyAuthenticateHeader;
import sip4me.gov.nist.siplite.header.ProxyAuthenticateList;
import sip4me.gov.nist.siplite.header.RecordRouteHeader;
import sip4me.gov.nist.siplite.header.RecordRouteList;
import sip4me.gov.nist.siplite.header.RouteHeader;
import sip4me.gov.nist.siplite.header.RouteList;
import sip4me.gov.nist.siplite.header.ViaHeader;
import sip4me.gov.nist.siplite.header.ViaList;
import sip4me.gov.nist.siplite.header.WWWAuthenticateHeader;
import sip4me.gov.nist.siplite.header.WWWAuthenticateList;

class ListMap {
    private static Hashtable headerListTable;

    static {
        ListMap.initializeListMap();
    }

    ListMap() {
    }

    private static void initializeListMap() {
        headerListTable = new Hashtable();
        headerListTable.put(ExtensionHeader.clazz, new HeaderList().getClass());
        headerListTable.put(ContactHeader.clazz, new ContactList().getClass());
        headerListTable.put(ViaHeader.clazz, new ViaList().getClass());
        headerListTable.put(WWWAuthenticateHeader.clazz, new WWWAuthenticateList().getClass());
        headerListTable.put(RouteHeader.clazz, new RouteList().getClass());
        headerListTable.put(ProxyAuthenticateHeader.clazz, new ProxyAuthenticateList().getClass());
        headerListTable.put(RecordRouteHeader.clazz, new RecordRouteList().getClass());
    }

    protected static boolean hasList(Header sipHeader) {
        if (sipHeader instanceof HeaderList) {
            return false;
        }
        Class<?> headerClass = sipHeader.getClass();
        return headerListTable.get(headerClass) != null;
    }

    protected static boolean hasList(Class sipHdrClass) {
        return headerListTable.get(sipHdrClass) != null;
    }

    protected static Class getListClass(Class sipHdrClass) {
        return (Class)headerListTable.get(sipHdrClass);
    }

    protected static HeaderList getList(Header sipHeader) {
        try {
            Class<?> headerClass = sipHeader.getClass();
            Class listClass = (Class)headerListTable.get(headerClass);
            HeaderList shl = (HeaderList)listClass.newInstance();
            shl.setHeaderName(sipHeader.getHeaderName());
            return shl;
        }
        catch (InstantiationException ex) {
            ex.printStackTrace();
        }
        catch (IllegalAccessException ex) {
            ex.printStackTrace();
        }
        return null;
    }
}

