/*
 * Decompiled with CFR 0.152.
 */
package sip4me.gov.nist.siplite.message;

import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import sip4me.gov.nist.core.GenericObject;
import sip4me.gov.nist.core.InternalErrorHandler;
import sip4me.gov.nist.core.ParseException;
import sip4me.gov.nist.siplite.address.URI;
import sip4me.gov.nist.siplite.header.CSeqHeader;
import sip4me.gov.nist.siplite.header.CallIdHeader;
import sip4me.gov.nist.siplite.header.ContentTypeHeader;
import sip4me.gov.nist.siplite.header.FromHeader;
import sip4me.gov.nist.siplite.header.Header;
import sip4me.gov.nist.siplite.header.RecordRouteList;
import sip4me.gov.nist.siplite.header.StatusLine;
import sip4me.gov.nist.siplite.header.ToHeader;
import sip4me.gov.nist.siplite.header.ViaHeader;
import sip4me.gov.nist.siplite.header.ViaList;
import sip4me.gov.nist.siplite.message.Message;
import sip4me.gov.nist.siplite.message.Request;

public final class Response
extends Message {
    protected StatusLine statusLine;
    public static final int TRYING = 100;
    public static final int RINGING = 180;
    public static final int CALL_IS_BEING_FORWARDED = 181;
    public static final int QUEUED = 182;
    public static final int SESSION_PROGRESS = 183;
    public static final int OK = 200;
    public static final int ACCEPTED = 202;
    public static final int MULTIPLE_CHOICES = 300;
    public static final int MOVED_PERMANENTLY = 301;
    public static final int MOVED_TEMPORARILY = 302;
    public static final int USE_PROXY = 305;
    public static final int ALTERNATIVE_SERVICE = 380;
    public static final int BAD_REQUEST = 400;
    public static final int UNAUTHORIZED = 401;
    public static final int PAYMENT_REQUIRED = 402;
    public static final int FORBIDDEN = 403;
    public static final int NOT_FOUND = 404;
    public static final int METHOD_NOT_ALLOWED = 405;
    public static final int NOT_ACCEPTABLE = 406;
    public static final int PROXY_AUTHENTICATION_REQUIRED = 407;
    public static final int REQUEST_TIMEOUT = 408;
    public static final int GONE = 410;
    public static final int REQUEST_ENTITY_TOO_LARGE = 413;
    public static final int REQUEST_URI_TOO_LONG = 414;
    public static final int UNSUPPORTED_MEDIA_TYPE = 415;
    public static final int UNSUPPORTED_URI_SCHEME = 416;
    public static final int BAD_EXTENSION = 420;
    public static final int EXTENSION_REQUIRED = 421;
    public static final int SESSION_INTERVAL_TOO_SMALL = 422;
    public static final int INTERVAL_TOO_BRIEF = 423;
    public static final int TEMPORARILY_UNAVAILABLE = 480;
    public static final int CALL_OR_TRANSACTION_DOES_NOT_EXIST = 481;
    public static final int LOOP_DETECTED = 482;
    public static final int TOO_MANY_HOPS = 483;
    public static final int ADDRESS_INCOMPLETE = 484;
    public static final int AMBIGUOUS = 485;
    public static final int BUSY_HERE = 486;
    public static final int REQUEST_TERMINATED = 487;
    public static final int NOT_ACCEPTABLE_HERE = 488;
    public static final int BAD_EVENT = 489;
    public static final int REQUEST_PENDING = 491;
    public static final int UNDECIPHERABLE = 493;
    public static final int SERVER_INTERNAL_ERROR = 500;
    public static final int NOT_IMPLEMENTED = 501;
    public static final int BAD_GATEWAY = 502;
    public static final int SERVICE_UNAVAILABLE = 503;
    public static final int SERVER_TIMEOUT = 504;
    public static final int VERSION_NOT_SUPPORTED = 505;
    public static final int MESSAGE_TOO_LARGE = 513;
    public static final int BUSY_EVERYWHERE = 600;
    public static final int DECLINE = 603;
    public static final int DOES_NOT_EXIST_ANYWHERE = 604;
    public static final int SESSION_NOT_ACCEPTABLE = 606;

    public static String getReasonPhrase(int rc) {
        String retval = null;
        switch (rc) {
            case 100: {
                retval = "Trying";
                break;
            }
            case 180: {
                retval = "Ringing";
                break;
            }
            case 181: {
                retval = "Call is being forwarded";
                break;
            }
            case 182: {
                retval = "Queued";
                break;
            }
            case 183: {
                retval = "Session progress";
                break;
            }
            case 200: {
                retval = "OK";
                break;
            }
            case 202: {
                retval = "Accepted";
                break;
            }
            case 300: {
                retval = "Multiple choices";
                break;
            }
            case 301: {
                retval = "Moved permanently";
                break;
            }
            case 302: {
                retval = "Moved Temporarily";
                break;
            }
            case 305: {
                retval = "Use proxy";
                break;
            }
            case 380: {
                retval = "Alternative service";
                break;
            }
            case 400: {
                retval = "Bad request";
                break;
            }
            case 401: {
                retval = "Unauthorized";
                break;
            }
            case 402: {
                retval = "Payment required";
                break;
            }
            case 403: {
                retval = "Forbidden";
                break;
            }
            case 404: {
                retval = "Not found";
                break;
            }
            case 405: {
                retval = "Method not allowed";
                break;
            }
            case 406: {
                retval = "Not acceptable";
                break;
            }
            case 407: {
                retval = "Proxy Authentication required";
                break;
            }
            case 408: {
                retval = "Request timeout";
                break;
            }
            case 410: {
                retval = "Gone";
                break;
            }
            case 480: {
                retval = "Temporarily Unavailable";
                break;
            }
            case 413: {
                retval = "Request entity too large";
                break;
            }
            case 414: {
                retval = "Request-URI too large";
                break;
            }
            case 415: {
                retval = "Unsupported media type";
                break;
            }
            case 416: {
                retval = "Unsupported URI Scheme";
                break;
            }
            case 420: {
                retval = "Bad extension";
                break;
            }
            case 421: {
                retval = "Etension Required";
                break;
            }
            case 422: {
                retval = "Session interval too small";
                break;
            }
            case 423: {
                retval = "Interval too brief";
                break;
            }
            case 481: {
                retval = "Call leg/Transaction does not exist";
                break;
            }
            case 482: {
                retval = "Loop detected";
                break;
            }
            case 483: {
                retval = "Too many hops";
                break;
            }
            case 484: {
                retval = "Address incomplete";
                break;
            }
            case 485: {
                retval = "Ambiguous";
                break;
            }
            case 486: {
                retval = "Busy here";
                break;
            }
            case 487: {
                retval = "Request Terminated";
                break;
            }
            case 488: {
                retval = "Not Acceptable here";
                break;
            }
            case 489: {
                retval = "Bad Event";
                break;
            }
            case 491: {
                retval = "Request Pending";
                break;
            }
            case 500: {
                retval = "Server Internal Error";
                break;
            }
            case 493: {
                retval = "Undecipherable";
                break;
            }
            case 501: {
                retval = "Not implemented";
                break;
            }
            case 502: {
                retval = "Bad gateway";
                break;
            }
            case 503: {
                retval = "Service unavailable";
                break;
            }
            case 504: {
                retval = "Gateway timeout";
                break;
            }
            case 505: {
                retval = "SIP version not supported";
                break;
            }
            case 513: {
                retval = "Message Too Large";
                break;
            }
            case 600: {
                retval = "Busy everywhere";
                break;
            }
            case 603: {
                retval = "Decline";
                break;
            }
            case 604: {
                retval = "Does not exist anywhere";
                break;
            }
            case 606: {
                retval = "Session Not acceptable";
                break;
            }
            default: {
                retval = null;
            }
        }
        return retval;
    }

    public void setStatusCode(int statusCode) throws ParseException {
        if (statusCode < 100 || statusCode > 800) {
            throw new ParseException("bad status code", 0);
        }
        if (this.statusLine == null) {
            this.statusLine = new StatusLine();
        }
        this.statusLine.setStatusCode(statusCode);
    }

    public StatusLine getStatusLine() {
        return this.statusLine;
    }

    public int getStatusCode() {
        return this.statusLine.getStatusCode();
    }

    public void setReasonPhrase(String reasonPhrase) throws IllegalArgumentException {
        if (reasonPhrase == null) {
            throw new IllegalArgumentException("Bad reason phrase");
        }
        if (this.statusLine == null) {
            this.statusLine = new StatusLine();
        }
        this.statusLine.setReasonPhrase(reasonPhrase);
    }

    public String getReasonPhrase() {
        if (this.statusLine == null || this.statusLine.getReasonPhrase() == null) {
            return "";
        }
        return this.statusLine.getReasonPhrase();
    }

    public static boolean isFinalResponse(int rc) {
        return rc >= 200 && rc < 700;
    }

    public boolean isFinalResponse() {
        return Response.isFinalResponse(this.statusLine.getStatusCode());
    }

    public static boolean isSuccessfulResponse(int rc) {
        return rc >= 200 && rc < 300;
    }

    public boolean isSuccessfulResponse() {
        return Response.isSuccessfulResponse(this.statusLine.getStatusCode());
    }

    public void setStatusLine(StatusLine sl) {
        this.statusLine = sl;
    }

    protected void checkHeaders() throws ParseException {
        if (this.getCSeqHeader() == null) {
            throw new ParseException("CSeq", 0);
        }
        if (this.getTo() == null) {
            throw new ParseException("To", 0);
        }
        if (this.getFromHeader() == null) {
            throw new ParseException("From", 0);
        }
        if (this.getViaHeaders() == null) {
            throw new ParseException("Via", 0);
        }
    }

    public String encode() {
        String retval = this.statusLine != null ? String.valueOf(this.statusLine.encode()) + super.encode() : super.encode();
        return retval;
    }

    public Object clone() {
        Response retval = (Response)super.clone();
        retval.statusLine = (StatusLine)this.statusLine.clone();
        return retval;
    }

    public boolean equals(Object other) {
        if (!this.getClass().equals(other.getClass())) {
            return false;
        }
        Response that = (Response)other;
        return this.statusLine.equals(that.statusLine) && super.equals(other);
    }

    public byte[] encodeAsBytes() {
        byte[] slbytes = null;
        if (this.statusLine != null) {
            try {
                slbytes = this.statusLine.encode().getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException ex) {
                InternalErrorHandler.handleException(ex);
            }
        }
        byte[] superbytes = super.encodeAsBytes();
        byte[] retval = new byte[slbytes.length + superbytes.length];
        int i = 0;
        if (slbytes != null) {
            i = 0;
            while (i < slbytes.length) {
                retval[i] = slbytes[i];
                ++i;
            }
        }
        int j = 0;
        while (j < superbytes.length) {
            retval[i] = superbytes[j];
            ++j;
            ++i;
        }
        return retval;
    }

    public String getDialogId(boolean isServer) {
        CallIdHeader cid = this.getCallId();
        FromHeader from = this.getFromHeader();
        ToHeader to = this.getTo();
        StringBuffer retval = new StringBuffer(cid.getCallId());
        if (!isServer) {
            retval.append(":").append(from.getUserAtHostPort());
            if (from.getTag() != null) {
                retval.append(":");
                retval.append(from.getTag());
            }
            retval.append(":").append(to.getUserAtHostPort());
            if (to.getTag() != null) {
                retval.append(":");
                retval.append(to.getTag());
            }
        } else {
            retval.append(":").append(to.getUserAtHostPort());
            if (to.getTag() != null) {
                retval.append(":");
                retval.append(to.getTag());
            }
            retval.append(":").append(from.getUserAtHostPort());
            if (from.getTag() != null) {
                retval.append(":");
                retval.append(from.getTag());
            }
        }
        return retval.toString().toLowerCase();
    }

    public String getDialogId(boolean isServer, String toTag) {
        CallIdHeader cid = this.getCallId();
        FromHeader from = this.getFromHeader();
        ToHeader to = this.getTo();
        StringBuffer retval = new StringBuffer(cid.getCallId());
        if (!isServer) {
            retval.append(":").append(from.getUserAtHostPort());
            if (from.getTag() != null) {
                retval.append(":");
                retval.append(from.getTag());
            }
            retval.append(":").append(to.getUserAtHostPort());
            if (toTag != null) {
                retval.append(":");
                retval.append(toTag);
            }
        } else {
            retval.append(":").append(to.getUserAtHostPort());
            if (toTag != null) {
                retval.append(":");
                retval.append(toTag);
            }
            retval.append(":").append(from.getUserAtHostPort());
            if (from.getTag() != null) {
                retval.append(":");
                retval.append(from.getTag());
            }
        }
        return retval.toString().toLowerCase();
    }

    public Request createRequest(URI requestURI, ViaHeader via, CSeqHeader cseq) {
        Request newRequest = new Request();
        String method = cseq.getMethod();
        newRequest.setMethod(method);
        newRequest.setRequestURI(requestURI);
        if ((GenericObject.equalsIgnoreCase(method, "ACK") || GenericObject.equalsIgnoreCase(method, "CANCEL")) && this.getTopmostVia().getBranch() != null) {
            via.setBranch(this.getTopmostVia().getBranch());
        }
        newRequest.setHeader(via);
        newRequest.setHeader(cseq);
        Enumeration headerIterator = this.getHeaders();
        while (headerIterator.hasMoreElements()) {
            Header nextHeader = (Header)headerIterator.nextElement();
            if (Message.isResponseHeader(nextHeader) || nextHeader instanceof ViaList || nextHeader instanceof CSeqHeader || nextHeader instanceof ContentTypeHeader || nextHeader instanceof RecordRouteList) continue;
            if (nextHeader instanceof ToHeader) {
                nextHeader = (Header)nextHeader.clone();
            } else if (nextHeader instanceof FromHeader) {
                nextHeader = (Header)nextHeader.clone();
            }
            newRequest.attachHeader(nextHeader, false);
        }
        return newRequest;
    }

    public String getFirstLine() {
        if (this.statusLine == null) {
            return null;
        }
        return this.statusLine.encode();
    }

    public void setSIPVersion(String sipVersion) {
        this.statusLine.setSipVersion(sipVersion);
    }

    public String getSIPVersion() {
        return this.statusLine.getSipVersion();
    }

    public String toString() {
        return String.valueOf(this.statusLine.encode()) + super.encode();
    }
}

