/*
 * Decompiled with CFR 0.152.
 */
package sip4me.gov.nist.siplite.parser;

import java.io.UnsupportedEncodingException;
import java.util.Vector;
import sip4me.gov.nist.core.Debug;
import sip4me.gov.nist.core.Host;
import sip4me.gov.nist.core.HostNameParser;
import sip4me.gov.nist.core.HostPort;
import sip4me.gov.nist.core.LogWriter;
import sip4me.gov.nist.core.ParseException;
import sip4me.gov.nist.core.ParserCore;
import sip4me.gov.nist.core.StringTokenizer;
import sip4me.gov.nist.siplite.address.Address;
import sip4me.gov.nist.siplite.address.SipURI;
import sip4me.gov.nist.siplite.address.TelephoneNumber;
import sip4me.gov.nist.siplite.address.URI;
import sip4me.gov.nist.siplite.header.ExtensionHeader;
import sip4me.gov.nist.siplite.header.Header;
import sip4me.gov.nist.siplite.header.NameMap;
import sip4me.gov.nist.siplite.header.RequestLine;
import sip4me.gov.nist.siplite.header.StatusLine;
import sip4me.gov.nist.siplite.message.Message;
import sip4me.gov.nist.siplite.message.Request;
import sip4me.gov.nist.siplite.message.Response;
import sip4me.gov.nist.siplite.parser.AddressParser;
import sip4me.gov.nist.siplite.parser.HeaderParser;
import sip4me.gov.nist.siplite.parser.Lexer;
import sip4me.gov.nist.siplite.parser.ParseExceptionListener;
import sip4me.gov.nist.siplite.parser.ParserFactory;
import sip4me.gov.nist.siplite.parser.RequestLineParser;
import sip4me.gov.nist.siplite.parser.StatusLineParser;
import sip4me.gov.nist.siplite.parser.URLParser;

public class StringMsgParser {
    protected boolean readBody = true;
    private String rawMessage;
    private String rawMessage1;
    private String currentMessage;
    private ParseExceptionListener parseExceptionListener;
    private Vector messageHeaders = new Vector(10, 10);
    private int bufferPointer = 0;
    private boolean bodyIsString;
    private byte[] currentMessageBytes;
    protected int contentLength;
    private boolean debugFlag;
    private int currentLine = 0;
    private String currentHeader;

    public StringMsgParser() {
    }

    public StringMsgParser(ParseExceptionListener exhandler) {
        this();
        this.parseExceptionListener = exhandler;
    }

    protected String getMessageBody() {
        if (this.contentLength == 0) {
            return null;
        }
        String body = this.currentMessage.substring(this.bufferPointer);
        this.bufferPointer = this.currentMessage.length();
        this.contentLength = 0;
        return body;
    }

    protected byte[] getBodyAsBytes() {
        if (this.contentLength == 0) {
            return null;
        }
        int endIndex = this.bufferPointer + this.contentLength;
        if (endIndex > this.currentMessageBytes.length) {
            endIndex = this.currentMessageBytes.length;
        }
        byte[] body = new byte[endIndex - this.bufferPointer];
        System.arraycopy(this.currentMessageBytes, this.bufferPointer, body, 0, body.length);
        this.bufferPointer = endIndex;
        this.contentLength = 0;
        return body;
    }

    protected String readToEnd() {
        String body = this.currentMessage.substring(this.bufferPointer);
        this.bufferPointer += body.length();
        return body;
    }

    protected byte[] readBytesToEnd() {
        byte[] body = new byte[this.currentMessageBytes.length - this.bufferPointer];
        int endIndex = this.currentMessageBytes.length;
        int i = this.bufferPointer;
        int k = 0;
        while (i < endIndex) {
            body[k] = this.currentMessageBytes[i];
            ++i;
            ++k;
        }
        this.bufferPointer = endIndex;
        this.contentLength = 0;
        return body;
    }

    public void setParseExceptionListener(ParseExceptionListener pexhandler) {
        this.parseExceptionListener = pexhandler;
    }

    protected boolean isBodyString() {
        return this.bodyIsString;
    }

    public Message parseSIPMessage(byte[] msgBuffer) throws ParseException {
        this.bufferPointer = 0;
        this.bodyIsString = false;
        Vector retval = new Vector();
        this.currentMessageBytes = msgBuffer;
        int s = this.bufferPointer;
        while (s < msgBuffer.length) {
            if ((char)msgBuffer[s] != '\r' && (char)msgBuffer[s] != '\n' && (char)msgBuffer[s] != '\u0000') break;
            ++s;
        }
        if (s == msgBuffer.length) {
            return null;
        }
        int f = s;
        while (f < msgBuffer.length - 4) {
            if ((char)msgBuffer[f] == '\r' && (char)msgBuffer[f + 1] == '\n' && (char)msgBuffer[f + 2] == '\r' && (char)msgBuffer[f + 3] == '\n') break;
            ++f;
        }
        if (f < msgBuffer.length) {
            f += 4;
        } else {
            f = s;
            while (f < msgBuffer.length - 2) {
                if ((char)msgBuffer[f] == '\n' && (char)msgBuffer[f + 1] == '\n') break;
                ++f;
            }
            if (f < msgBuffer.length) {
                f += 2;
            } else {
                throw new ParseException("Message not terminated", 0);
            }
        }
        String messageString = null;
        try {
            messageString = new String(msgBuffer, s, f - s, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new ParseException("Bad message encoding!", 0);
        }
        this.bufferPointer = f;
        StringBuffer message = new StringBuffer(messageString);
        int length = message.length();
        int k = 0;
        while (k < length) {
            if (message.charAt(k) == '\r') {
                message.deleteCharAt(k);
                --length;
            }
            ++k;
        }
        if (ParserCore.debug) {
            k = 0;
            while (k < length) {
                this.rawMessage1 = String.valueOf(this.rawMessage1) + "[" + message.charAt(k) + "]";
                ++k;
            }
        }
        StringTokenizer tokenizer = new StringTokenizer(message.toString(), '\n');
        StringBuffer cooked_message = new StringBuffer();
        while (tokenizer.hasMoreChars()) {
            String nexttok = tokenizer.nextToken();
            if (nexttok.trim().equals("")) {
                cooked_message.append("\n");
                continue;
            }
            cooked_message.append(nexttok);
        }
        String message1 = cooked_message.toString();
        length = message1.indexOf("\n\n") + 2;
        int k2 = 0;
        while (k2 < length - 1) {
            if (cooked_message.charAt(k2) == '\n') {
                if (cooked_message.charAt(k2 + 1) == '\t' || cooked_message.charAt(k2 + 1) == ' ') {
                    cooked_message.deleteCharAt(k2);
                    cooked_message.deleteCharAt(k2);
                    --length;
                    if (k2 != --length) continue;
                    break;
                }
                if (cooked_message.charAt(k2 + 1) == '\n') {
                    cooked_message.insert(k2, '\n');
                    ++length;
                    ++k2;
                }
            }
            ++k2;
        }
        cooked_message.append("\n\n");
        this.currentMessage = cooked_message.toString();
        Message sipmsg = this.parseMessage(this.currentMessage);
        if (this.readBody && sipmsg.getContentLengthHeader() != null && sipmsg.getContentLengthHeader().getContentLength() != 0) {
            this.contentLength = sipmsg.getContentLengthHeader().getContentLength();
            byte[] body = this.getBodyAsBytes();
            sipmsg.setMessageContent(body);
        }
        return sipmsg;
    }

    public Message parseSIPMessage(String sipMessages) throws ParseException {
        this.rawMessage = sipMessages;
        String pmessage = sipMessages.trim();
        this.bodyIsString = true;
        this.contentLength = 0;
        if (pmessage.trim().equals("")) {
            return null;
        }
        pmessage = String.valueOf(pmessage) + "\n\n";
        StringBuffer message = new StringBuffer(pmessage);
        while (message.charAt(0) == '\r' || message.charAt(0) == '\n') {
            ++this.bufferPointer;
            message.deleteCharAt(0);
        }
        String message1 = message.toString();
        int length = message1.indexOf("\r\n\r\n");
        if (length > 0) {
            length += 4;
        }
        if (length == -1) {
            length = message1.indexOf("\n\n");
            if (length == -1) {
                throw new ParseException("no trailing crlf", 0);
            }
        } else {
            length += 2;
        }
        int k = 0;
        while (k < length) {
            if (message.charAt(k) == '\r') {
                message.deleteCharAt(k);
                --length;
            }
            ++k;
        }
        if (LogWriter.needsLogging) {
            LogWriter.logMessage(32, "[StringMsgParser]-> Parsing SIP Message:\n" + pmessage + "\n---END---\n");
        }
        if (this.debugFlag) {
            k = 0;
            while (k < length) {
                this.rawMessage1 = String.valueOf(this.rawMessage1) + "[" + message.charAt(k) + "]";
                ++k;
            }
        }
        StringTokenizer tokenizer = new StringTokenizer(message.toString(), '\n');
        StringBuffer cooked_message = new StringBuffer();
        while (tokenizer.hasMoreChars()) {
            String nexttok = tokenizer.nextToken();
            if (nexttok.trim().equals("")) {
                cooked_message.append("\n");
                continue;
            }
            cooked_message.append(nexttok);
        }
        message1 = cooked_message.toString();
        length = message1.indexOf("\n\n") + 2;
        int k2 = 0;
        while (k2 < length - 1) {
            if (cooked_message.charAt(k2) == '\n') {
                if (cooked_message.charAt(k2 + 1) == '\t' || cooked_message.charAt(k2 + 1) == ' ') {
                    cooked_message.deleteCharAt(k2);
                    cooked_message.deleteCharAt(k2);
                    --length;
                    if (k2 != --length) continue;
                    break;
                }
                if (cooked_message.charAt(k2 + 1) == '\n') {
                    cooked_message.insert(k2, '\n');
                    ++length;
                    ++k2;
                }
            }
            ++k2;
        }
        cooked_message.append("\n\n");
        this.currentMessage = cooked_message.toString();
        if (ParserCore.debug) {
            Debug.println(this.currentMessage);
        }
        this.bufferPointer = this.currentMessage.indexOf("\n\n") + 3;
        Message sipmsg = this.parseMessage(this.currentMessage);
        if (this.readBody && sipmsg.getContentLengthHeader() != null && sipmsg.getContentLengthHeader().getContentLength() != 0) {
            this.contentLength = sipmsg.getContentLengthHeader().getContentLength();
            String body = this.getMessageBody();
            sipmsg.setMessageContent(body);
        }
        return sipmsg;
    }

    private Message parseMessage(String currentMessage) throws ParseException {
        int sip_message_size = 0;
        Message sipmsg = null;
        StringTokenizer tokenizer = new StringTokenizer(currentMessage, '\n');
        this.messageHeaders = new Vector();
        while (tokenizer.hasMoreChars()) {
            String nexttok = tokenizer.nextToken();
            if (nexttok.equals("\n")) {
                String nextnexttok = tokenizer.nextToken();
                if (nextnexttok.equals("\n")) break;
                this.messageHeaders.addElement(nextnexttok);
            } else {
                this.messageHeaders.addElement(nexttok);
            }
            ++sip_message_size;
        }
        this.currentLine = 0;
        String firstLine = this.currentHeader = (String)this.messageHeaders.elementAt(this.currentLine);
        if (!firstLine.startsWith("SIP/2.0")) {
            sipmsg = new Request();
            try {
                RequestLine rl = new RequestLineParser(String.valueOf(firstLine) + "\n").parse();
                ((Request)sipmsg).setRequestLine(rl);
            }
            catch (ParseException ex) {
                if (this.parseExceptionListener != null) {
                    this.parseExceptionListener.handleException(ex, sipmsg, new RequestLine().getClass(), firstLine, currentMessage);
                }
                throw ex;
            }
        } else {
            sipmsg = new Response();
            try {
                StatusLine sl = new StatusLineParser(String.valueOf(firstLine) + "\n").parse();
                ((Response)sipmsg).setStatusLine(sl);
            }
            catch (ParseException ex) {
                if (this.parseExceptionListener != null) {
                    this.parseExceptionListener.handleException(ex, sipmsg, new StatusLine().getClass(), firstLine, currentMessage);
                }
                throw ex;
            }
        }
        int i = 1;
        while (i < this.messageHeaders.size()) {
            block18: {
                String hdrstring = (String)this.messageHeaders.elementAt(i);
                if (hdrstring != null && !hdrstring.trim().equals("")) {
                    HeaderParser hdrParser = null;
                    try {
                        hdrParser = ParserFactory.createParser(String.valueOf(hdrstring) + "\n");
                    }
                    catch (ParseException ex) {
                        this.parseExceptionListener.handleException(ex, sipmsg, null, hdrstring, currentMessage);
                        break block18;
                    }
                    try {
                        Header sipHeader = hdrParser.parse();
                        sipmsg.attachHeader(sipHeader, false);
                    }
                    catch (ParseException ex) {
                        ex.printStackTrace();
                        if (this.parseExceptionListener == null) break block18;
                        String hdrName = Lexer.getHeaderName(hdrstring);
                        Class hdrClass = NameMap.getClassFromName(hdrName);
                        if (hdrClass == null) {
                            hdrClass = ExtensionHeader.clazz;
                        }
                        this.parseExceptionListener.handleException(ex, sipmsg, hdrClass, hdrstring, currentMessage);
                    }
                }
            }
            ++i;
        }
        return sipmsg;
    }

    public Address parseAddress(String address) throws ParseException {
        AddressParser addressParser = new AddressParser(address);
        return addressParser.address();
    }

    public HostPort parseHostPort(String hostport) throws ParseException {
        Lexer lexer = new Lexer("charLexer", hostport);
        return new HostNameParser(lexer).hostPort();
    }

    public Host parseHost(String host) throws ParseException {
        Lexer lexer = new Lexer("charLexer", host);
        return new HostNameParser(lexer).host();
    }

    public TelephoneNumber parseTelephoneNumber(String telephone_number) throws ParseException {
        return new URLParser(telephone_number).parseTelephoneNumber();
    }

    public SipURI parseSIPUrl(String url) throws ParseException {
        try {
            return (SipURI)new URLParser(url).parse();
        }
        catch (ClassCastException ex) {
            throw new ParseException(String.valueOf(url) + " Not a SIP URL ", 0);
        }
    }

    public URI parseUrl(String url) throws ParseException {
        return new URLParser(url).parse();
    }

    public Header parseHeader(String header) throws ParseException {
        header = String.valueOf(header) + "\n\n";
        String nmessage = "";
        boolean counter = false;
        int i = 0;
        while (header.charAt(i) == '\n' || header.charAt(i) == '\t' || header.charAt(i) == ' ') {
            ++i;
        }
        while (i < header.length()) {
            if (i < header.length() - 1 && header.charAt(i) == '\n' && (header.charAt(i + 1) == '\t' || header.charAt(i + 1) == ' ')) {
                nmessage = String.valueOf(nmessage) + ' ';
                ++i;
            } else {
                nmessage = String.valueOf(nmessage) + header.charAt(i);
            }
            ++i;
        }
        HeaderParser hp = ParserFactory.createParser(nmessage = String.valueOf(nmessage) + "\n");
        if (hp == null) {
            throw new ParseException("could not create parser", 0);
        }
        return hp.parse();
    }

    public RequestLine parseRequestLine(String requestLine) throws ParseException {
        requestLine = String.valueOf(requestLine) + "\n";
        return new RequestLineParser(requestLine).parse();
    }

    public StatusLine parseSIPStatusLine(String statusLine) throws ParseException {
        statusLine = String.valueOf(statusLine) + "\n";
        return new StatusLineParser(statusLine).parse();
    }

    public String getCurrentHeader() {
        return this.currentHeader;
    }

    public int getCurrentLineNumber() {
        return this.currentLine;
    }
}

