/*
 * Decompiled with CFR 0.152.
 */
package sip4me.gov.nist.siplite;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import sip4me.gov.nist.core.LogWriter;
import sip4me.gov.nist.siplite.EventWrapper;
import sip4me.gov.nist.siplite.RequestEvent;
import sip4me.gov.nist.siplite.ResponseEvent;
import sip4me.gov.nist.siplite.SipEvent;
import sip4me.gov.nist.siplite.SipListener;
import sip4me.gov.nist.siplite.SipProvider;
import sip4me.gov.nist.siplite.SipStack;
import sip4me.gov.nist.siplite.TimeoutEvent;
import sip4me.gov.nist.siplite.message.Request;
import sip4me.gov.nist.siplite.stack.ClientTransaction;
import sip4me.gov.nist.siplite.stack.Dialog;
import sip4me.gov.nist.siplite.stack.ServerTransaction;
import sip4me.gov.nist.siplite.stack.Transaction;

public class EventScanner
implements Runnable {
    private SipStack sipStack;
    private Vector pendingEvents;
    private SipListener sipListener;
    private boolean isStopped;

    public EventScanner(SipStack sipStack) {
        this.sipStack = sipStack;
        this.pendingEvents = new Vector();
    }

    public void start() {
        Thread myThread = new Thread((Runnable)this, "EventScannerThread");
        myThread.setPriority(10);
        myThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        if (LogWriter.needsLogging) {
            LogWriter.logMessage("Stopping EventScanner Thread");
        }
        Vector vector = this.pendingEvents;
        synchronized (vector) {
            this.isStopped = true;
            this.pendingEvents.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEvent(EventWrapper eventWrapper) {
        if (LogWriter.needsLogging) {
            LogWriter.logMessage("Adding event to EventScanner queue: " + eventWrapper.transaction);
        }
        Vector vector = this.pendingEvents;
        synchronized (vector) {
            this.pendingEvents.addElement(eventWrapper);
            this.pendingEvents.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (true) {
            SipEvent sipEvent = null;
            EventWrapper eventWrapper = null;
            Vector vector = this.pendingEvents;
            synchronized (vector) {
                block21: {
                    if (this.pendingEvents.isEmpty() && !this.isStopped) {
                        try {
                            if (LogWriter.needsLogging) {
                                LogWriter.logMessage("EventScanner going to sleep!");
                            }
                            this.pendingEvents.wait();
                            if (!LogWriter.needsLogging) break block21;
                            LogWriter.logMessage("EventScanner waking up!");
                        }
                        catch (InterruptedException ex) {
                            LogWriter.logMessage("Interrupted!");
                            continue;
                        }
                    }
                }
                if (this.isStopped) {
                    return;
                }
                SipListener sipListener = this.sipStack.getSipListener();
                Enumeration iterator = this.pendingEvents.elements();
                while (iterator.hasMoreElements()) {
                    eventWrapper = (EventWrapper)iterator.nextElement();
                    sipEvent = eventWrapper.sipEvent;
                    if (LogWriter.needsLogging) {
                        LogWriter.logMessage("Processing " + sipEvent + " nevents " + this.pendingEvents.size());
                    }
                    if (sipEvent instanceof RequestEvent) {
                        Transaction tr;
                        Request sipRequest = ((RequestEvent)sipEvent).getRequest();
                        if (this.sipStack.isDialogCreated(sipRequest.getMethod())) {
                            SipProvider sipProvider = (SipProvider)sipEvent.getSource();
                            sipProvider.currentTransaction = (ServerTransaction)eventWrapper.transaction;
                            ServerTransaction tr2 = (ServerTransaction)this.sipStack.findTransaction(sipRequest, true);
                            Dialog dialog = this.sipStack.getDialog(sipRequest.getDialogId(true));
                            if (tr2 != null && !tr2.passToListener()) {
                                if (!LogWriter.needsLogging) continue;
                                LogWriter.logMessage("transaction already exists for Dialog-creating request!");
                                continue;
                            }
                        }
                        if (sipRequest.getMethod().equals("CANCEL") && (tr = this.sipStack.findTransaction(sipRequest, true)) != null && tr.getState() == 6) {
                            if (LogWriter.needsLogging) {
                                LogWriter.logMessage("Too late to cancel Transaction");
                            }
                            try {
                                tr.sendMessage(sipRequest.createResponse(200));
                            }
                            catch (IOException iOException) {}
                            continue;
                        }
                        if (LogWriter.needsLogging) {
                            LogWriter.logMessage("EventScanner passes event " + sipRequest.getMethod() + " to listener");
                        }
                        sipListener.processRequest((RequestEvent)sipEvent);
                        continue;
                    }
                    if (sipEvent instanceof ResponseEvent) {
                        sipListener.processResponse((ResponseEvent)sipEvent);
                        ClientTransaction ct = ((ResponseEvent)sipEvent).getClientTransaction();
                        ct.clearEventPending();
                        continue;
                    }
                    if (sipEvent instanceof TimeoutEvent) {
                        sipListener.processTimeout((TimeoutEvent)sipEvent);
                        if (eventWrapper.transaction == null || !(eventWrapper.transaction instanceof ClientTransaction)) continue;
                        ((ClientTransaction)eventWrapper.transaction).clearEventPending();
                        continue;
                    }
                    if (!LogWriter.needsLogging) continue;
                    LogWriter.logMessage("bad event" + sipEvent);
                }
                this.pendingEvents.removeAllElements();
            }
        }
    }
}

