/*
 * Decompiled with CFR 0.152.
 */
package sip4me.gov.nist.siplite.parser;

import sip4me.gov.nist.core.ParseException;
import sip4me.gov.nist.core.ParserCore;
import sip4me.gov.nist.siplite.address.Address;
import sip4me.gov.nist.siplite.address.URI;
import sip4me.gov.nist.siplite.parser.Lexer;
import sip4me.gov.nist.siplite.parser.Parser;
import sip4me.gov.nist.siplite.parser.URLParser;

public class AddressParser
extends Parser {
    protected AddressParser(Lexer lexer) {
        this.lexer = lexer;
        this.lexer.selectLexer("charLexer");
    }

    public AddressParser(String address) {
        this.lexer = new Lexer("charLexer", address);
    }

    protected Address nameAddr() throws ParseException {
        if (ParserCore.debug) {
            this.dbg_enter("nameAddr");
        }
        try {
            if (this.lexer.lookAhead(0) == '<') {
                this.lexer.match(60);
                this.lexer.selectLexer("sip_urlLexer");
                this.lexer.SPorHT();
                URLParser uriParser = new URLParser((Lexer)this.lexer);
                URI uri = uriParser.uriReference();
                Address retval = new Address();
                retval.setAddressType(1);
                retval.setURI(uri);
                this.lexer.SPorHT();
                this.lexer.match(62);
                Address address = retval;
                return address;
            }
            Address addr = new Address();
            addr.setAddressType(1);
            String name = null;
            if (this.lexer.lookAhead(0) == '\"') {
                name = this.lexer.quotedString();
                this.lexer.SPorHT();
            } else {
                name = this.lexer.getNextToken('<');
            }
            addr.setDisplayName(name.trim());
            this.lexer.match(60);
            this.lexer.SPorHT();
            URLParser uriParser = new URLParser((Lexer)this.lexer);
            URI uri = uriParser.uriReference();
            addr.setAddressType(1);
            addr.setURI(uri);
            this.lexer.SPorHT();
            this.lexer.match(62);
            Address address = addr;
            return address;
        }
        finally {
            if (ParserCore.debug) {
                this.dbg_leave("nameAddr");
            }
        }
    }

    public Address address() throws ParseException {
        if (ParserCore.debug) {
            this.dbg_enter("address");
        }
        Address retval = null;
        try {
            int k = 0;
            while (this.lexer.hasMoreChars()) {
                if (this.lexer.lookAhead(k) == '<' || this.lexer.lookAhead(k) == '\"' || this.lexer.lookAhead(k) == ':' || this.lexer.lookAhead(k) == '/') break;
                if (this.lexer.lookAhead(k) == '\u0000') {
                    throw this.createParseException("unexpected EOL");
                }
                ++k;
            }
            if (this.lexer.lookAhead(k) == '<' || this.lexer.lookAhead(k) == '\"') {
                retval = this.nameAddr();
            } else if (this.lexer.lookAhead(k) == ':' || this.lexer.lookAhead(k) == '/') {
                retval = new Address();
                URLParser uriParser = new URLParser((Lexer)this.lexer);
                URI uri = uriParser.uriReference();
                retval.setAddressType(2);
                retval.setURI(uri);
            } else {
                throw this.createParseException("Bad address spec");
            }
            Address address = retval;
            return address;
        }
        finally {
            if (ParserCore.debug) {
                this.dbg_leave("address");
            }
        }
    }
}

