/*
 * Decompiled with CFR 0.152.
 */
package sip4me.gov.nist.siplite.parser;

import java.util.Vector;
import sip4me.gov.nist.core.HostNameParser;
import sip4me.gov.nist.core.HostPort;
import sip4me.gov.nist.core.LexerCore;
import sip4me.gov.nist.core.NameValue;
import sip4me.gov.nist.core.NameValueList;
import sip4me.gov.nist.core.ParseException;
import sip4me.gov.nist.core.ParserCore;
import sip4me.gov.nist.core.StringTokenizer;
import sip4me.gov.nist.core.Token;
import sip4me.gov.nist.siplite.address.SipURI;
import sip4me.gov.nist.siplite.address.TelURL;
import sip4me.gov.nist.siplite.address.TelephoneNumber;
import sip4me.gov.nist.siplite.address.URI;
import sip4me.gov.nist.siplite.parser.Lexer;
import sip4me.gov.nist.siplite.parser.Parser;

public class URLParser
extends Parser {
    public URLParser(String url) {
        this.lexer = new Lexer("sip_urlLexer", url);
    }

    URLParser(Lexer lexer) {
        this.lexer = lexer;
        this.lexer.selectLexer("sip_urlLexer");
    }

    protected static boolean isMark(char next) {
        return next == '-' || next == '_' || next == '.' || next == '!' || next == '~' || next == '*' || next == '\'' || next == '(' || next == ')';
    }

    protected static boolean isUnreserved(char next) {
        return StringTokenizer.isAlpha(next) || StringTokenizer.isDigit(next) || URLParser.isMark(next);
    }

    protected static boolean isReservedNoSlash(char next) {
        return next == ';' || next == '?' || next == ':' || next == '@' || next == '&' || next == '+' || next == '$' || next == ',';
    }

    protected static boolean isUserUnreserved(char la) {
        return la == '&' || la == '?' || la == '+' || la == '$' || la == '#' || la == '/' || la == ',' || la == ';' || la == '=';
    }

    protected String unreserved() throws ParseException {
        char next = this.lexer.lookAhead(0);
        if (URLParser.isUnreserved(next)) {
            this.lexer.consume(1);
            return "" + next;
        }
        throw this.createParseException("unreserved");
    }

    protected String paramNameOrValue() throws ParseException {
        int startIdx = this.lexer.getPtr();
        while (this.lexer.hasMoreChars()) {
            char next = this.lexer.lookAhead(0);
            if (next == '[' || next == ']' || next == '/' || next == ':' || next == '&' || next == '+' || next == '$' || URLParser.isUnreserved(next)) {
                this.lexer.consume(1);
                continue;
            }
            if (!this.isEscaped()) break;
            this.lexer.consume(3);
        }
        return this.lexer.getBuffer().substring(startIdx, this.lexer.getPtr());
    }

    protected NameValue uriParam() throws ParseException {
        if (ParserCore.debug) {
            this.dbg_enter("uriParam");
        }
        try {
            String pvalue = null;
            String pname = this.paramNameOrValue();
            char next = this.lexer.lookAhead(0);
            if (next == '=') {
                this.lexer.consume(1);
                pvalue = this.paramNameOrValue();
            }
            NameValue nameValue = new NameValue(pname, pvalue);
            return nameValue;
        }
        finally {
            if (ParserCore.debug) {
                this.dbg_leave("uriParam");
            }
        }
    }

    protected static boolean isReserved(char next) {
        return next == ';' || next == '/' || next == '?' || next == ':' || next == '@' || next == '&' || next == '+' || next == '$' || next == '=' || next == ',';
    }

    protected String reserved() throws ParseException {
        char next = this.lexer.lookAhead(0);
        if (URLParser.isReserved(next)) {
            this.lexer.consume(1);
            return "" + next;
        }
        throw this.createParseException("reserved");
    }

    protected boolean isEscaped() {
        try {
            char next = this.lexer.lookAhead(0);
            char next1 = this.lexer.lookAhead(1);
            char next2 = this.lexer.lookAhead(2);
            return next == '%' && StringTokenizer.isHexDigit(next1) && StringTokenizer.isHexDigit(next2);
        }
        catch (Exception ex) {
            return false;
        }
    }

    protected String escaped() throws ParseException {
        if (ParserCore.debug) {
            this.dbg_enter("escaped");
        }
        try {
            StringBuffer retval = new StringBuffer();
            char next = this.lexer.lookAhead(0);
            char next1 = this.lexer.lookAhead(1);
            char next2 = this.lexer.lookAhead(2);
            if (next != '%' || !StringTokenizer.isHexDigit(next1) || !StringTokenizer.isHexDigit(next2)) {
                throw this.createParseException("escaped");
            }
            this.lexer.consume(3);
            retval.append(next);
            retval.append(next1);
            retval.append(next2);
            String string = retval.toString();
            return string;
        }
        finally {
            if (ParserCore.debug) {
                this.dbg_leave("escaped");
            }
        }
    }

    protected String mark() throws ParseException {
        if (ParserCore.debug) {
            this.dbg_enter("mark");
        }
        try {
            char next = this.lexer.lookAhead(0);
            if (URLParser.isMark(next)) {
                this.lexer.consume(1);
                String string = "" + next;
                return string;
            }
            throw this.createParseException("mark");
        }
        finally {
            if (ParserCore.debug) {
                this.dbg_leave("mark");
            }
        }
    }

    protected String uric() {
        if (ParserCore.debug) {
            this.dbg_enter("uric");
        }
        try {
            char la = this.lexer.lookAhead(0);
            if (URLParser.isUnreserved(la)) {
                this.lexer.consume(1);
                String string = LexerCore.charAsString(la);
                return string;
            }
            if (URLParser.isReserved(la)) {
                this.lexer.consume(1);
                String string = LexerCore.charAsString(la);
                return string;
            }
            if (this.isEscaped()) {
                String retval = this.lexer.charAsString(3);
                this.lexer.consume(3);
                String string = retval;
                return string;
            }
            return null;
        }
        catch (Exception ex) {
            return null;
        }
        finally {
            if (ParserCore.debug) {
                this.dbg_leave("uric");
            }
        }
    }

    protected String uricNoSlash() {
        if (ParserCore.debug) {
            this.dbg_enter("uricNoSlash");
        }
        try {
            char la = this.lexer.lookAhead(0);
            if (this.isEscaped()) {
                String retval = this.lexer.charAsString(3);
                this.lexer.consume(3);
                String string = retval;
                return string;
            }
            if (URLParser.isUnreserved(la)) {
                this.lexer.consume(1);
                String string = LexerCore.charAsString(la);
                return string;
            }
            if (URLParser.isReservedNoSlash(la)) {
                this.lexer.consume(1);
                String string = LexerCore.charAsString(la);
                return string;
            }
            return null;
        }
        catch (ParseException ex) {
            return null;
        }
        finally {
            if (ParserCore.debug) {
                this.dbg_leave("uricNoSlash");
            }
        }
    }

    protected String uricString() {
        String next;
        StringBuffer retval = new StringBuffer();
        while ((next = this.uric()) != null) {
            retval.append(next);
        }
        return retval.toString();
    }

    public URI uriReference() throws ParseException {
        URI retval;
        block11: {
            if (ParserCore.debug) {
                this.dbg_enter("uriReference");
            }
            retval = null;
            Vector vect = this.lexer.peekNextToken(2);
            Token t1 = (Token)vect.elementAt(0);
            Token t2 = (Token)vect.elementAt(1);
            try {
                if (t1.getTokenType() == 2051) {
                    if (t2.getTokenType() == 58) {
                        retval = this.sipURL();
                        break block11;
                    }
                    throw this.createParseException("Expecting ':'");
                }
                if (t1.getTokenType() == 2105) {
                    if (t2.getTokenType() == 58) {
                        retval = this.telURL();
                        break block11;
                    }
                    throw this.createParseException("Expecting ':'");
                }
                String urlString = this.uricString();
                try {
                    retval = new URI(urlString);
                }
                catch (ParseException ex) {
                    throw this.createParseException(ex.getMessage());
                }
            }
            finally {
                if (ParserCore.debug) {
                    this.dbg_leave("uriReference");
                }
            }
        }
        return retval;
    }

    private String base_phone_number() throws ParseException {
        StringBuffer s = new StringBuffer();
        if (ParserCore.debug) {
            this.dbg_enter("base_phone_number");
        }
        try {
            int lc = 0;
            while (this.lexer.hasMoreChars()) {
                char w = this.lexer.lookAhead(0);
                if (StringTokenizer.isDigit(w) || w == '-' || w == '.' || w == '(' || w == ')') {
                    this.lexer.consume(1);
                    s.append(w);
                    ++lc;
                    continue;
                }
                if (lc > 0) break;
                throw this.createParseException("unexpected " + w);
            }
            String string = s.toString();
            return string;
        }
        finally {
            if (ParserCore.debug) {
                this.dbg_leave("base_phone_number");
            }
        }
    }

    private String local_number() throws ParseException {
        StringBuffer s = new StringBuffer();
        if (ParserCore.debug) {
            this.dbg_enter("local_number");
        }
        try {
            int lc = 0;
            while (this.lexer.hasMoreChars()) {
                char la = this.lexer.lookAhead(0);
                if (la == '*' || la == '#' || la == '-' || la == '.' || la == '(' || la == ')' || StringTokenizer.isDigit(la)) {
                    this.lexer.consume(1);
                    s.append(la);
                    ++lc;
                    continue;
                }
                if (lc > 0) break;
                throw this.createParseException("unexepcted " + la);
            }
            String string = s.toString();
            return string;
        }
        finally {
            if (ParserCore.debug) {
                this.dbg_leave("local_number");
            }
        }
    }

    public final TelephoneNumber parseTelephoneNumber() throws ParseException {
        if (ParserCore.debug) {
            this.dbg_enter("telephone_subscriber");
        }
        this.lexer.selectLexer("charLexer");
        try {
            TelephoneNumber tn;
            char c = this.lexer.lookAhead(0);
            if (c == '+') {
                tn = this.global_phone_number();
            } else if (StringTokenizer.isAlpha(c) || StringTokenizer.isDigit(c) || c == '-' || c == '*' || c == '.' || c == '(' || c == ')' || c == '#') {
                tn = this.local_phone_number();
            } else {
                throw this.createParseException("unexpected char " + c);
            }
            TelephoneNumber telephoneNumber = tn;
            return telephoneNumber;
        }
        finally {
            if (ParserCore.debug) {
                this.dbg_leave("telephone_subscriber");
            }
        }
    }

    private final TelephoneNumber global_phone_number() throws ParseException {
        if (ParserCore.debug) {
            this.dbg_enter("global_phone_number");
        }
        try {
            char tok;
            TelephoneNumber tn = new TelephoneNumber();
            tn.setGlobal(true);
            NameValueList nv = null;
            this.lexer.match(43);
            String b = this.base_phone_number();
            tn.setPhoneNumber(b);
            if (this.lexer.hasMoreChars() && (tok = this.lexer.lookAhead(0)) == ';') {
                this.lexer.consume(1);
                nv = this.tel_parameters();
                tn.setParameters(nv);
            }
            TelephoneNumber telephoneNumber = tn;
            return telephoneNumber;
        }
        finally {
            if (ParserCore.debug) {
                this.dbg_leave("global_phone_number");
            }
        }
    }

    private TelephoneNumber local_phone_number() throws ParseException {
        if (ParserCore.debug) {
            this.dbg_enter("local_phone_number");
        }
        TelephoneNumber tn = new TelephoneNumber();
        tn.setGlobal(false);
        NameValueList nv = null;
        String b = null;
        try {
            b = this.local_number();
            tn.setPhoneNumber(b);
            if (this.lexer.hasMoreChars()) {
                Token tok = this.lexer.peekNextToken();
                switch (tok.getTokenType()) {
                    case 59: {
                        this.lexer.consume(1);
                        nv = this.tel_parameters();
                        tn.setParameters(nv);
                        break;
                    }
                    default: {
                        break;
                    }
                }
            }
        }
        finally {
            if (ParserCore.debug) {
                this.dbg_leave("local_phone_number");
            }
        }
        return tn;
    }

    private NameValueList tel_parameters() throws ParseException {
        char tok;
        NameValueList nvList = new NameValueList();
        do {
            NameValue nv = this.nameValue('=');
            nvList.add(nv);
            tok = this.lexer.lookAhead(0);
        } while (tok == ';');
        return nvList;
    }

    public TelURL telURL() throws ParseException {
        this.lexer.match(2105);
        this.lexer.match(58);
        TelephoneNumber tn = this.parseTelephoneNumber();
        TelURL telUrl = new TelURL();
        telUrl.setTelephoneNumber(tn);
        return telUrl;
    }

    public SipURI sipURL() throws ParseException {
        if (ParserCore.debug) {
            this.dbg_enter("sipURL");
        }
        SipURI retval = new SipURI();
        try {
            NameValue parms;
            this.lexer.match(2051);
            this.lexer.match(58);
            retval.setScheme("SIP");
            int m = this.lexer.markInputPosition();
            try {
                String user = this.user();
                char la = this.lexer.lookAhead(0);
                this.lexer.match(58);
                String password = this.password();
                this.lexer.match(64);
                HostNameParser hnp = new HostNameParser(this.getLexer());
                HostPort hp = hnp.hostPort();
                retval.setUser(user);
                retval.setUserPassword(password);
                retval.setHostPort(hp);
            }
            catch (ParseException ex) {
                HostPort hp;
                HostNameParser hnp;
                try {
                    this.lexer.rewindInputPosition(m);
                    String user = this.user();
                    this.lexer.match(64);
                    hnp = new HostNameParser(this.getLexer());
                    hp = hnp.hostPort();
                    retval.setUser(user);
                    retval.setHostPort(hp);
                }
                catch (ParseException e) {
                    this.lexer.rewindInputPosition(m);
                    hnp = new HostNameParser(this.getLexer());
                    hp = hnp.hostPort();
                    retval.setHostPort(hp);
                }
            }
            this.lexer.selectLexer("charLexer");
            while (this.lexer.hasMoreChars()) {
                if (this.lexer.lookAhead(0) != ';') break;
                this.lexer.consume(1);
                parms = this.uriParam();
                retval.setUriParameter(parms);
            }
            if (this.lexer.hasMoreChars() && this.lexer.lookAhead(0) == '?') {
                this.lexer.consume(1);
                while (this.lexer.hasMoreChars()) {
                    parms = this.qheader();
                    retval.setQHeader(parms);
                    if (this.lexer.hasMoreChars() && this.lexer.lookAhead(0) != '&') break;
                    this.lexer.consume(1);
                }
            }
            SipURI sipURI = retval;
            return sipURI;
        }
        finally {
            if (ParserCore.debug) {
                this.dbg_leave("sipURL");
            }
        }
    }

    public String peekScheme() throws ParseException {
        Vector tokens = this.lexer.peekNextToken(1);
        if (tokens.size() == 0) {
            return null;
        }
        String scheme = ((Token)tokens.elementAt(0)).getTokenValue();
        return scheme;
    }

    protected NameValue qheader() throws ParseException {
        String name = this.lexer.getNextToken('=');
        this.lexer.consume(1);
        String value = this.hvalue();
        return new NameValue(name, value);
    }

    protected String hvalue() throws ParseException {
        StringBuffer retval = new StringBuffer();
        while (this.lexer.hasMoreChars()) {
            char la = this.lexer.lookAhead(0);
            if (la == '+' || la == '?' || la == ':' || la == '@' || la == '[' || la == ']' || la == '/' || la == '$' || la == '_' || la == '-' || la == '\"' || la == '!' || la == '~' || la == '*' || la == '.' || la == '(' || la == ')' || StringTokenizer.isAlpha(la) || StringTokenizer.isDigit(la)) {
                this.lexer.consume(1);
                retval.append(la);
                continue;
            }
            if (la != '%') break;
            retval.append(this.escaped());
        }
        return retval.toString();
    }

    protected String urlString() throws ParseException {
        StringBuffer retval = new StringBuffer();
        this.lexer.selectLexer("charLexer");
        while (this.lexer.hasMoreChars()) {
            char la = this.lexer.lookAhead(0);
            if (la == ' ' || la == '\t' || la == '\n' || la == '>' || la == '<') break;
            this.lexer.consume(0);
            retval.append(la);
        }
        return retval.toString();
    }

    protected String user() throws ParseException {
        if (ParserCore.debug) {
            this.dbg_enter("user");
        }
        try {
            StringBuffer retval = new StringBuffer();
            while (this.lexer.hasMoreChars()) {
                char la = this.lexer.lookAhead(0);
                if (URLParser.isUnreserved(la) || URLParser.isUserUnreserved(la)) {
                    retval.append(la);
                    this.lexer.consume(1);
                    continue;
                }
                if (!this.isEscaped()) break;
                String esc = this.lexer.charAsString(3);
                this.lexer.consume(3);
                retval.append(esc);
            }
            String string = retval.toString();
            return string;
        }
        finally {
            if (ParserCore.debug) {
                this.dbg_leave("user");
            }
        }
    }

    protected String password() throws ParseException {
        StringBuffer retval = new StringBuffer();
        while (true) {
            char la;
            if (URLParser.isUnreserved(la = this.lexer.lookAhead(0)) || la == '&' || la == '=' || la == '+' || la == '$' || la == ',') {
                retval.append(la);
                this.lexer.consume(1);
                continue;
            }
            if (!this.isEscaped()) break;
            String esc = this.lexer.charAsString(3);
            retval.append(esc);
            this.lexer.consume(3);
        }
        return retval.toString();
    }

    public URI parse() throws ParseException {
        return this.uriReference();
    }
}

