/*
 * Decompiled with CFR 0.152.
 */
package sip4me.gov.nist.siplite.stack;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import sip4me.gov.nist.core.Host;
import sip4me.gov.nist.core.HostPort;
import sip4me.gov.nist.core.InternalErrorHandler;
import sip4me.gov.nist.core.LogWriter;
import sip4me.gov.nist.core.ParseException;
import sip4me.gov.nist.core.Utils;
import sip4me.gov.nist.core.net.DefaultNetworkLayer;
import sip4me.gov.nist.core.net.NetworkLayer;
import sip4me.gov.nist.siplite.address.Address;
import sip4me.gov.nist.siplite.address.Hop;
import sip4me.gov.nist.siplite.address.Router;
import sip4me.gov.nist.siplite.address.SipURI;
import sip4me.gov.nist.siplite.header.RouteHeader;
import sip4me.gov.nist.siplite.message.Request;
import sip4me.gov.nist.siplite.message.Response;
import sip4me.gov.nist.siplite.stack.IOHandler;
import sip4me.gov.nist.siplite.stack.MessageChannel;
import sip4me.gov.nist.siplite.stack.MessageProcessor;
import sip4me.gov.nist.siplite.stack.SIPServerRequestInterface;
import sip4me.gov.nist.siplite.stack.SIPServerResponseInterface;
import sip4me.gov.nist.siplite.stack.SIPStackMessageFactory;
import sip4me.gov.nist.siplite.stack.ServerLog;
import sip4me.gov.nist.siplite.stack.TCPMessageProcessor;
import sip4me.gov.nist.siplite.stack.UDPMessageProcessor;

public abstract class SIPMessageStack {
    protected boolean tcpFlag;
    protected boolean udpFlag;
    protected NetworkLayer networkLayer;
    protected String outboundProxy;
    protected int outboundPort;
    protected boolean toExit = false;
    protected String badMessageLog;
    protected boolean debugFlag;
    protected String stackName;
    protected String stackAddress;
    protected SIPStackMessageFactory sipMessageFactory;
    public static final int DEFAULT_PORT = 5060;
    protected Router router;
    protected int threadPoolSize = -1;
    protected int maxConnections = -1;
    private final Vector messageProcessors = new Vector();
    protected int readTimeout = -1;
    protected IOHandler ioHandler = new IOHandler(this);

    public void logBadMessage(String message) {
        if (this.badMessageLog != null) {
            LogWriter.logMessage(2, message);
        }
    }

    public String getBadMessageLog() {
        return this.badMessageLog;
    }

    public void setSingleThreaded() {
        this.threadPoolSize = 1;
    }

    public void setThreadPoolSize(int size) {
        this.threadPoolSize = size;
    }

    public void setMaxConnections(int nconnections) {
        this.maxConnections = nconnections;
    }

    public Enumeration getNextHop(Request sipRequest) {
        return this.router.getNextHops(sipRequest);
    }

    public SIPMessageStack(SIPStackMessageFactory messageFactory, String stackAddress, String stackName) throws IllegalArgumentException {
        this();
        this.sipMessageFactory = messageFactory;
        if (stackAddress == null) {
            throw new IllegalArgumentException("stack Address not set");
        }
        ServerLog.description = stackName;
        ServerLog.stackIpAddress = stackAddress;
    }

    public void setStackMessageFactory(SIPStackMessageFactory messageFactory) {
        this.sipMessageFactory = messageFactory;
    }

    public void setStackName(String stackName) {
        this.stackName = stackName;
        ServerLog.setDescription(stackName);
        ServerLog.stackIpAddress = this.stackAddress;
    }

    public String getStackName() {
        return this.stackName;
    }

    public void setHostAddress(String stackAddress) {
        this.stackAddress = stackAddress.indexOf(58) != stackAddress.lastIndexOf(58) && stackAddress.trim().charAt(0) != '[' ? String.valueOf('[') + stackAddress + ']' : stackAddress;
    }

    public String getHostAddress() {
        return this.stackAddress;
    }

    public Hop getNextHop() {
        return this.router.getOutboundProxy();
    }

    public int getPort(String transport) throws IllegalArgumentException {
        Vector vector = this.messageProcessors;
        synchronized (vector) {
            Enumeration it = this.messageProcessors.elements();
            while (it.hasMoreElements()) {
                MessageProcessor mp = (MessageProcessor)it.nextElement();
                if (!Utils.equalsIgnoreCase(mp.getTransport(), transport)) continue;
                return mp.getPort();
            }
            throw new IllegalArgumentException("Transport not supported " + transport);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isTransportEnabled(String transport) {
        Vector vector = this.messageProcessors;
        synchronized (vector) {
            MessageProcessor mp;
            Enumeration it = this.messageProcessors.elements();
            do {
                if (it.hasMoreElements()) continue;
                return false;
            } while (!Utils.equalsIgnoreCase((mp = (MessageProcessor)it.nextElement()).getTransport(), transport));
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isTransportEnabled(String transport, int port) {
        Vector vector = this.messageProcessors;
        synchronized (vector) {
            MessageProcessor mp;
            Enumeration it = this.messageProcessors.elements();
            do {
                if (it.hasMoreElements()) continue;
                return false;
            } while (!Utils.equalsIgnoreCase((mp = (MessageProcessor)it.nextElement()).getTransport(), transport) || mp.getPort() != port);
            return true;
        }
    }

    public SIPMessageStack() {
    }

    protected SIPServerRequestInterface newSIPServerRequest(Request siprequest, MessageChannel msgchan) {
        return this.sipMessageFactory.newSIPServerRequest(siprequest, msgchan);
    }

    protected SIPServerResponseInterface newSIPServerResponse(Response sipresponse, MessageChannel msgchan) {
        return this.sipMessageFactory.newSIPServerResponse(sipresponse, msgchan);
    }

    public void setRouter(Router router) {
        this.router = router;
    }

    public Router getRouter() {
        return this.router;
    }

    public Hop getDefaultRoute() {
        return this.router.getOutboundProxy();
    }

    public RouteHeader getRouteHeader(Hop hop) {
        HostPort hostPort = new HostPort();
        Host h = new Host(hop.getHost());
        hostPort.setHost(h);
        hostPort.setPort(hop.getPort());
        SipURI uri = new SipURI();
        uri.setHostPort(hostPort);
        uri.setScheme("sip");
        try {
            uri.setTransportParam(hop.getTransport());
        }
        catch (ParseException ex) {
            InternalErrorHandler.handleException(ex);
        }
        Address address = new Address();
        address.setURI(uri);
        RouteHeader route = new RouteHeader();
        route.setAddress(address);
        return route;
    }

    public RouteHeader getDefaultRouteHeader() {
        if (this.router.getOutboundProxy() != null) {
            Hop hop = this.router.getOutboundProxy();
            return this.getRouteHeader(hop);
        }
        return null;
    }

    public synchronized boolean isAlive() {
        return !this.toExit;
    }

    public NetworkLayer getNetworkLayer() {
        if (this.networkLayer == null) {
            return DefaultNetworkLayer.SINGLETON;
        }
        return this.networkLayer;
    }

    public void setNetworkLayer(NetworkLayer nl) {
        this.networkLayer = nl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopStack() {
        if (LogWriter.needsLogging) {
            LogWriter.logMessage("Stopping SIPMessageStack!" + this);
        }
        Vector vector = this.messageProcessors;
        synchronized (vector) {
            this.toExit = true;
            int i = 0;
            while (i < this.messageProcessors.size()) {
                MessageProcessor mp = (MessageProcessor)this.messageProcessors.elementAt(i);
                mp.stop();
                mp.setListeningPoint(null);
                ++i;
            }
            this.messageProcessors.removeAllElements();
        }
        this.ioHandler.closeAll();
        if (LogWriter.needsLogging) {
            LogWriter.logMessage("SIPMessageStack stopped" + this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMessageProcessor(MessageProcessor newMessageProcessor) throws IOException {
        if (LogWriter.needsLogging) {
            LogWriter.logMessage("addMessageProcessor " + newMessageProcessor.getPort() + " / " + newMessageProcessor.getTransport());
        }
        Vector vector = this.messageProcessors;
        synchronized (vector) {
            this.messageProcessors.addElement(newMessageProcessor);
        }
        newMessageProcessor.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMessageProcessor(MessageProcessor oldMessageProcessor) {
        Vector vector = this.messageProcessors;
        synchronized (vector) {
            if (this.messageProcessors.removeElement(oldMessageProcessor)) {
                oldMessageProcessor.stop();
                oldMessageProcessor.setListeningPoint(null);
                if (LogWriter.needsLogging) {
                    LogWriter.logMessage("Stopped and removed MessageProcessor " + oldMessageProcessor);
                }
            }
        }
    }

    public Vector getMessageProcessors() {
        return this.messageProcessors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageProcessor getMessageProcessor(String transport) {
        Vector vector = this.messageProcessors;
        synchronized (vector) {
            Enumeration it = this.messageProcessors.elements();
            while (it.hasMoreElements()) {
                MessageProcessor mp = (MessageProcessor)it.nextElement();
                if (!Utils.equalsIgnoreCase(mp.getTransport(), transport)) continue;
                return mp;
            }
            return null;
        }
    }

    public MessageProcessor createMessageProcessor(int port, String transport) throws IOException, IllegalArgumentException {
        if (LogWriter.needsLogging) {
            LogWriter.logMessage("createMessageProcessor : " + port + " / " + transport);
        }
        if (Utils.equalsIgnoreCase(transport, "udp")) {
            UDPMessageProcessor udpMessageProcessor = new UDPMessageProcessor(this, port);
            this.addMessageProcessor(udpMessageProcessor);
            this.udpFlag = true;
            return udpMessageProcessor;
        }
        if (Utils.equalsIgnoreCase(transport, "tcp")) {
            TCPMessageProcessor tcpMessageProcessor = new TCPMessageProcessor(this, port);
            this.addMessageProcessor(tcpMessageProcessor);
            this.tcpFlag = true;
            return tcpMessageProcessor;
        }
        throw new IllegalArgumentException("bad transport");
    }

    protected void setMessageFactory(SIPStackMessageFactory messageFactory) {
        this.sipMessageFactory = messageFactory;
    }

    public MessageChannel createMessageChannel(Hop nextHop) {
        Host targetHost = new Host();
        targetHost.setHostname(nextHop.getHost());
        HostPort targetHostPort = new HostPort();
        targetHostPort.setHost(targetHost);
        targetHostPort.setPort(nextHop.getPort());
        MessageChannel newChannel = null;
        Enumeration processorIterator = this.messageProcessors.elements();
        while (processorIterator.hasMoreElements() && newChannel == null) {
            MessageProcessor nextProcessor = (MessageProcessor)processorIterator.nextElement();
            if (!Utils.equalsIgnoreCase(nextHop.getTransport(), nextProcessor.getTransport())) continue;
            try {
                if (LogWriter.needsLogging) {
                    LogWriter.logMessage("createMessageChannel " + nextHop + " processor " + nextProcessor);
                }
                newChannel = nextProcessor.createMessageChannel(targetHostPort);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return newChannel;
    }
}

