// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
// Mobius Forensic Toolkit
// Copyright (C) 2008,2009,2010,2011,2012,2013,2014,2015,2016,2017 Eduardo Aguiar
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any later
// version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General
// Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program. If not, see <http://www.gnu.org/licenses/>.
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief  C++ API module wrapper
//!\author Eduardo Aguiar
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
#include <Python.h>
#include <stdexcept>
#include "api_partition.h"

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief api.partition: prototypes
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static void api_partition_tp_dealloc (api_partition_o *);
static PyObject *api_partition_get_starting_sector (api_partition_o *);
static PyObject *api_partition_get_ending_sector (api_partition_o *);
static PyObject *api_partition_get_starting_address (api_partition_o *);
static PyObject *api_partition_get_ending_address (api_partition_o *);
static PyObject *api_partition_get_name (api_partition_o *);
static PyObject *api_partition_get_type (api_partition_o *);
static PyObject *api_partition_get_is_primary (api_partition_o *);
static PyObject *api_partition_get_is_extended (api_partition_o *);
static PyObject *api_partition_get_is_logical (api_partition_o *);
static PyObject *api_partition_get_is_bootable (api_partition_o *);
static PyObject *api_partition_get_is_writeable (api_partition_o *);
static PyObject *api_partition_get_is_readable (api_partition_o *);
static PyObject *api_partition_get_is_hidden (api_partition_o *);
static PyObject *api_partition_get_is_deleted (api_partition_o *);

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief api.partition: getters and setters structure
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyGetSetDef api_partition_getsetters[] =
{
  {
    (char *) "starting_sector",
    (getter) api_partition_get_starting_sector,
    (setter) 0,
    (char *) "starting sector", NULL
  },
  {
    (char *) "ending_sector",
    (getter) api_partition_get_ending_sector,
    (setter) 0,
    (char *) "endind sector", NULL
  },
  {
    (char *) "starting_address",
    (getter) api_partition_get_starting_address,
    (setter) 0,
    (char *) "starting address", NULL
  },
  {
    (char *) "ending_address",
    (getter) api_partition_get_ending_address,
    (setter) 0,
    (char *) "endind address", NULL
  },
  {
    (char *) "name",
    (getter) api_partition_get_name,
    (setter) 0,
    (char *) "partition name", NULL
  },
  {
    (char *) "type",
    (getter) api_partition_get_type,
    (setter) 0,
    (char *) "partition type", NULL
  },
  {
    (char *) "is_primary",
    (getter) api_partition_get_is_primary,
    (setter) 0,
    (char *) "primary partition flag", NULL
  },
  {
    (char *) "is_extended",
    (getter) api_partition_get_is_extended,
    (setter) 0,
    (char *) "extended partition flag", NULL
  },
  {
    (char *) "is_logical",
    (getter) api_partition_get_is_logical,
    (setter) 0,
    (char *) "logical partition flag", NULL
  },
  {
    (char *) "is_bootable",
    (getter) api_partition_get_is_bootable,
    (setter) 0,
    (char *) "bootable partition flag", NULL
  },
  {
    (char *) "is_writeable",
    (getter) api_partition_get_is_writeable,
    (setter) 0,
    (char *) "writeable partition flag", NULL
  },
  {
    (char *) "is_readable",
    (getter) api_partition_get_is_readable,
    (setter) 0,
    (char *) "readable partition flag", NULL
  },
  {
    (char *) "is_hidden",
    (getter) api_partition_get_is_hidden,
    (setter) 0,
    (char *) "hidden partition flag", NULL
  },
  {
    (char *) "is_deleted",
    (getter) api_partition_get_is_deleted,
    (setter) 0,
    (char *) "deleted partition flag", NULL
  },
  {NULL} // sentinel
};

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief api.partition: type structure
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
PyTypeObject api_partition_t =
{
  PyObject_HEAD_INIT (0)
  0,                                       		// ob_size
  "api.partition",                         		// tp_name
  sizeof (api_partition_o),                		// tp_basicsize
  0,                                       		// tp_itemsize
  (destructor) api_partition_tp_dealloc,   		// tp_dealloc
  0,                                       		// tp_print
  0,                                       		// tp_getattr
  0,                                       		// tp_setattr
  0,                                       		// tp_compare
  0,                                       		// tp_repr
  0,                                       		// tp_as_number
  0,                                       		// tp_as_sequence
  0,                                       		// tp_as_mapping
  0,                                       		// tp_hash
  0,                                       		// tp_call
  0,                                       		// tp_str
  0,                                       		// tp_getattro
  0,                                       		// tp_setattro
  0,                                       		// tp_as_buffer
  Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,		// tp_flags
  "disk partition class",                  		// tp_doc
  0,                                       		// tp_traverse
  0,                                       		// tp_clear
  0,                                       		// tp_richcompare
  0,                                       		// tp_weaklistoffset
  0,                                       		// tp_iter
  0,                                       		// tp_iternext
  0,                                       		// tp_methods
  0,                                       		// tp_members
  api_partition_getsetters,                		// tp_getset
  0,                                       		// tp_base
  0,                                       		// tp_dict
  0,                                       		// tp_descr_get
  0,                                       		// tp_descr_set
  0,                                       		// tp_dictoffset
  0,                                       		// tp_init
  0,                                       		// tp_alloc
  0                                        		// tp_new
};

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief api.partition: tp_dealloc
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static void
api_partition_tp_dealloc (api_partition_o *self)
{
  delete self->obj;
  self->ob_type->tp_free ((PyObject*) self);
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief api.partition: starting_sector getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
api_partition_get_starting_sector (api_partition_o *self)
{
  return PyInt_FromLong (self->obj->get_starting_sector ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief api.partition: ending_sector getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
api_partition_get_ending_sector (api_partition_o *self)
{
  return PyInt_FromLong (self->obj->get_ending_sector ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief api.partition: starting_address getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
api_partition_get_starting_address (api_partition_o *self)
{
  return PyInt_FromLong (self->obj->get_starting_address ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief api.partition: ending_address getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
api_partition_get_ending_address (api_partition_o *self)
{
  return PyInt_FromLong (self->obj->get_ending_address ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief api.partition: name getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
api_partition_get_name (api_partition_o *self)
{
  return PyString_FromString (self->obj->get_name ().c_str ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief api.partition: type getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
api_partition_get_type (api_partition_o *self)
{
  return PyString_FromString (self->obj->get_type ().c_str ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief api.partition: is_primary getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
api_partition_get_is_primary (api_partition_o *self)
{
  return PyBool_FromLong (self->obj->is_primary ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief api.partition: is_extended getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
api_partition_get_is_extended (api_partition_o *self)
{
  return PyBool_FromLong (self->obj->is_extended ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief api.partition: is_logical getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
api_partition_get_is_logical (api_partition_o *self)
{
  return PyBool_FromLong (self->obj->is_logical ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief api.partition: is_bootable getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
api_partition_get_is_bootable (api_partition_o *self)
{
  return PyBool_FromLong (self->obj->is_bootable ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief api.partition: is_writeable getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
api_partition_get_is_writeable (api_partition_o *self)
{
  return PyBool_FromLong (self->obj->is_writeable ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief api.partition: is_readable getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
api_partition_get_is_readable (api_partition_o *self)
{
  return PyBool_FromLong (self->obj->is_readable ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief api.partition: is_hidden getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
api_partition_get_is_hidden (api_partition_o *self)
{
  return PyBool_FromLong (self->obj->is_hidden ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief api.partition: is_deleted getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
api_partition_get_is_deleted (api_partition_o *self)
{
  return PyBool_FromLong (self->obj->is_deleted ());
}
