// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
// Mobius Forensic Toolkit
// Copyright (C) 2008,2009,2010,2011,2012,2013,2014,2015,2016,2017,2018 Eduardo Aguiar
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any later
// version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General
// Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program. If not, see <http://www.gnu.org/licenses/>.
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief  C++ API mobius.forensics module wrapper
//! \author Eduardo Aguiar
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
#include <Python.h>
#include "registry.h"
#include "registry_file.h"
#include "registry_key.h"
#include "registry_value.h"
#include "registry_data.h"

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief functions prototypes
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief module methods
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyMethodDef module_methods[] =
{
  {
    NULL,
    NULL,
    0,
    NULL
  } // sentinel
};

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief create mobius.forensics.registry module
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
PyObject *
new_forensics_registry_module ()
{
  // initialize module mobius.forensics.registry
  PyObject* module = Py_InitModule3 (
    "registry",
    module_methods,
    "Mobius Forensic Toolkit mobius.forensics.registry module"
  );
  
  // build types
  if (PyType_Ready (&forensics_registry_registry_t) < 0)
    return nullptr;

  if (PyType_Ready (&forensics_registry_registry_file_t) < 0)
    return nullptr;

  if (PyType_Ready (&forensics_registry_registry_key_t) < 0)
    return nullptr;

  if (PyType_Ready (&forensics_registry_registry_value_t) < 0)
    return nullptr;

  if (PyType_Ready (&forensics_registry_registry_data_t) < 0)
    return nullptr;

  // add types
  Py_INCREF (&forensics_registry_registry_t);
  PyModule_AddObject (module, "registry", (PyObject *) &forensics_registry_registry_t);

  Py_INCREF (&forensics_registry_registry_file_t);
  PyModule_AddObject (module, "registry_file", (PyObject *) &forensics_registry_registry_file_t);

  Py_INCREF (&forensics_registry_registry_key_t);
  PyModule_AddObject (module, "registry_key", (PyObject *) &forensics_registry_registry_key_t);

  Py_INCREF (&forensics_registry_registry_value_t);
  PyModule_AddObject (module, "registry_value", (PyObject *) &forensics_registry_registry_value_t);

  Py_INCREF (&forensics_registry_registry_data_t);
  PyModule_AddObject (module, "registry_data", (PyObject *) &forensics_registry_registry_data_t);

  // return newly built module
  return module;
}
