// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
// Mobius Forensic Toolkit
// Copyright (C) 2008,2009,2010,2011,2012,2013,2014,2015,2016,2017,2018 Eduardo Aguiar
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any later
// version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General
// Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program. If not, see <http://www.gnu.org/licenses/>.
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief  C++ API module wrapper
//! \author Eduardo Aguiar
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
#include <Python.h>
#include "disk/disk.h"
#include "partition.h"
#include <mobius/partition/partition_system.h>

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief get_partitions function
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
PyObject*
func_get_partitions (PyObject *self, PyObject *args)
{
  // parse arguments
  PyObject *arg_disk;

  if (!PyArg_ParseTuple (args, "O!", &disk_disk_t, &arg_disk))
    return nullptr;

  mobius::disk::disk *disk_p = ((disk_disk_o *) arg_disk)->obj;

  // run C++ code
  PyObject *ret = nullptr;
  
  try
    {
      mobius::partition::partition_system psystem (*disk_p);            

      // create list
      ret = PyList_New (0);

      if (ret == nullptr)
        return nullptr;

      // populate list
      for (auto p : psystem.get_partitions ())
        {
          PyObject *item = PyMobius_Partition_Partition_from_cpp (p);
          
          if (item == nullptr)
            {
              Py_CLEAR (ret);
              return nullptr;
            }

          PyList_Append (ret, item);
        }
    }
  catch (const std::runtime_error& e)
    {
      Py_DECREF (self);
      PyErr_SetString (PyExc_Exception, e.what ());
      ret = NULL;
    }

  return ret;
}
