// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
// Mobius Forensic Toolkit
// Copyright (C) 2008,2009,2010,2011,2012,2013,2014,2015,2016,2017,2018,2019,2020 Eduardo Aguiar
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any later
// version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General
// Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program. If not, see <http://www.gnu.org/licenses/>.
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
#include "item.h"
#include "case.h"
#include "password_hash.h"

namespace mobius
{
namespace model
{
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief Create new password hash
//! \param type Type
//! \param value Value
//! \param description Description
//! \return Password hash
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
password_hash
item::new_password_hash (
  const std::string& type,
  const std::string& value,
  const std::string& description)
{
  auto db = get_database ();

  auto stmt = db.new_statement (
                "INSERT INTO password_hash "
                     "VALUES (NULL, ?, ?, ?, ?, NULL)");

  stmt.bind (1, get_uid ());
  stmt.bind (2, type);
  stmt.bind (3, value);
  stmt.bind (4, description);
  stmt.execute ();

  auto uid = db.get_last_insert_row_id ();
  return password_hash (get_case (), uid);
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief Get password hashes
//! \return Password hashes
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
std::vector <password_hash>
item::get_password_hashes () const
{
  auto db = get_database ();

  auto stmt = db.new_statement (
                "SELECT uid "
                  "FROM password_hash "
                 "WHERE item_uid = ?");

  stmt.bind (1, get_uid ());

  std::vector <password_hash> password_hashes;

  while (stmt.fetch_row ())
    {
      auto uid = stmt.get_column_int64 (0);
      password_hashes.emplace_back (get_case (), uid);
    }

  return password_hashes;
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief Remove password hashes
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
void
item::remove_password_hashes ()
{
  auto db = get_database ();

  auto stmt = db.new_statement (
                "DELETE FROM password_hash "
                      "WHERE item_uid = ?");

  stmt.bind (1, get_uid ());
  stmt.execute ();
}

} // namespace model
} // namespace mobius
