// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
// Mobius Forensic Toolkit
// Copyright (C) 2008,2009,2010,2011,2012,2013,2014,2015,2016,2017,2018,2019,2020 Eduardo Aguiar
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any later
// version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General
// Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program. If not, see <http://www.gnu.org/licenses/>.
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
#include "item.h"
#include "text_search.h"

namespace mobius
{
namespace model
{
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief Create new text_search
//! \param timestamp Timestamp
//! \param type Search type
//! \param text Text
//! \return text_search object
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
text_search
item::new_text_search (
  const mobius::datetime::datetime& timestamp,
  const std::string& type,
  const std::string& text)
{
  auto db = get_database ();

  auto stmt = db.new_statement (
                "INSERT INTO text_search "
                     "VALUES (NULL, ?, ?, ?, ?, NULL, NULL)");

  stmt.bind (1, get_uid ());
  stmt.bind (2, timestamp);
  stmt.bind (3, type);
  stmt.bind (4, text);
  stmt.execute ();

  auto uid = db.get_last_insert_row_id ();
  return text_search (*this, uid);
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief Get text_searches
//! \return Cookies
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
std::vector <text_search>
item::get_text_searches () const
{
  auto db = get_database ();

  auto stmt = db.new_statement (
                "SELECT uid "
                  "FROM text_search "
                 "WHERE item_uid = ?");

  stmt.bind (1, get_uid ());

  std::vector <text_search> text_searches;

  while (stmt.fetch_row ())
    {
      auto uid = stmt.get_column_int64 (0);
      text_searches.emplace_back (*this, uid);
    }

  return text_searches;
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief Remove text_searches
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
void
item::remove_text_searches ()
{
  auto db = get_database ();

  auto stmt = db.new_statement (
                "DELETE FROM text_search "
                      "WHERE item_uid = ?");

  stmt.bind (1, get_uid ());
  stmt.execute ();
}

} // namespace model
} // namespace mobius
