/*
 * Decompiled with CFR 0.152.
 */
package opale.m2d;

import java.io.IOException;
import java.io.PrintWriter;
import opale.m2d.Matrix2D;
import opale.m2d.OIJException;
import opale.tools.Debug;
import opale.tools.InvalidFormatException;
import opale.tools.OpaleObject;
import opale.tools.OpaleSet;
import opale.tools.StreamReader;

public final class OIJ
extends OpaleObject
implements Cloneable {
    public static final OIJ OIJ_ABSOLUTE = new OIJ();
    private static final double precision = 1.0E-15;
    private String name;
    private OIJ rep;
    private double oriX;
    private double oriY;
    private double[] I;
    private double[] J;
    private double normSqI;
    private double normSqJ;
    private double IJ;
    private double theta;
    private Matrix2D P;

    public OIJ() {
        this.name = new String("Sans nom");
        this.rep = OIJ_ABSOLUTE;
        this.oriY = 0.0;
        this.oriX = 0.0;
        this.I = new double[2];
        this.J = new double[2];
        this.I[0] = 1.0;
        this.I[1] = 0.0;
        this.J[0] = 0.0;
        this.J[1] = 1.0;
        this.IJ = 0.0;
        this.theta = 1.5707963267948966;
        this.normSqJ = 1.0;
        this.normSqI = 1.0;
        this.P = new Matrix2D();
    }

    public OIJ(double d, double d2, double d3, double d4, double d5, double d6) throws OIJException {
        this.name = new String("Sans nom");
        this.rep = OIJ_ABSOLUTE;
        this.oriX = d;
        this.oriY = d2;
        if (!(Math.abs(d3 * d6 - d4 * d5) > 1.0E-15)) {
            throw new OIJException("Erreur \u00e0 la construction d'un rep\u00e8re !");
        }
        this.I = new double[2];
        this.J = new double[2];
        this.I[0] = d3;
        this.I[1] = d4;
        this.J[0] = d5;
        this.J[1] = d6;
        this.normSqI = d3 * d3 + d4 * d4;
        this.normSqJ = d5 * d5 + d6 * d6;
        this.IJ = d3 * d5 + d4 * d6;
        this.theta = Math.acos(this.IJ / Math.sqrt(this.normSqI * this.normSqJ));
        this.P = new Matrix2D();
        OIJ.matPassageAbs(this, this.P);
    }

    public OIJ(OIJ oIJ, double d, double d2, double d3, double d4, double d5, double d6) throws OIJException {
        this.name = new String("Sans nom");
        this.rep = oIJ;
        this.oriX = d;
        this.oriY = d2;
        if (!(Math.abs(d3 * d6 - d4 * d5) > 1.0E-15)) {
            throw new OIJException("Erreur \u00e0 la construction d'un rep\u00e8re !");
        }
        this.I = new double[2];
        this.J = new double[2];
        this.I[0] = d3;
        this.I[1] = d4;
        this.J[0] = d5;
        this.J[1] = d6;
        this.P = new Matrix2D();
        OIJ.matPassageAbs(this, this.P);
        this.normSqI = oIJ.normSq(d3, d4);
        this.normSqJ = oIJ.normSq(d5, d6);
        this.IJ = d3 * d5 * oIJ.normSqI + d4 * d6 * oIJ.normSqJ + (d3 * d6 + d4 * d5) * oIJ.IJ;
        this.theta = Math.acos(this.IJ / Math.sqrt(this.normSqI * this.normSqJ));
    }

    public OIJ(OIJ oIJ) {
        this.name = oIJ.name;
        this.rep = oIJ.rep;
        this.oriX = oIJ.oriX;
        this.oriY = oIJ.oriY;
        this.I = new double[2];
        this.J = new double[2];
        this.I[0] = oIJ.I[0];
        this.I[1] = oIJ.I[1];
        this.J[0] = oIJ.J[0];
        this.J[1] = oIJ.J[1];
        this.P = new Matrix2D();
        OIJ.matPassageAbs(this, this.P);
        this.normSqI = oIJ.normSqI;
        this.normSqJ = oIJ.normSqJ;
        this.IJ = oIJ.IJ;
        this.theta = oIJ.theta;
    }

    public final String getName() {
        return this.name;
    }

    public final void setName(String string) {
        this.name = new String(string);
    }

    public boolean equals(Object object) {
        if (object instanceof OIJ) {
            OIJ oIJ = (OIJ)object;
            Matrix2D matrix2D = new Matrix2D();
            Matrix2D matrix2D2 = new Matrix2D();
            OIJ.matPassageAbs(oIJ, matrix2D);
            OIJ.matPassageAbs(this, matrix2D2);
            return matrix2D.equals(matrix2D2);
        }
        return false;
    }

    public final double normSqI() {
        return this.normSqI;
    }

    public final double normSqJ() {
        return this.normSqJ;
    }

    public final double getTheta() {
        return this.theta;
    }

    public final double normSq(double d, double d2) {
        return d * d * this.normSqI + 2.0 * d * d2 * this.IJ + d2 * d2 * this.normSqJ;
    }

    public final double norm(double d, double d2) {
        return Math.sqrt(this.normSq(d, d2));
    }

    public final double distSq(double d, double d2, double d3, double d4) {
        return this.normSq(d3 - d, d4 - d2);
    }

    public final double dist(double d, double d2, double d3, double d4) {
        return this.norm(d3 - d, d4 - d2);
    }

    public void matPassage(Matrix2D matrix2D) {
        matrix2D.set(0, 0, this.I[0]);
        matrix2D.set(1, 0, this.I[1]);
        matrix2D.set(0, 1, this.J[0]);
        matrix2D.set(1, 1, this.J[1]);
        matrix2D.setV(0, this.oriX);
        matrix2D.setV(1, this.oriY);
    }

    public void matPassage(OIJ oIJ, Matrix2D matrix2D) {
        Matrix2D matrix2D2 = new Matrix2D();
        Matrix2D matrix2D3 = new Matrix2D();
        double[][] dArray = new double[2][2];
        OIJ.matPassageAbs(oIJ, matrix2D2);
        OIJ.matPassageAbs(this, matrix2D3);
        double d = matrix2D2.get(1, 1) * matrix2D2.get(0, 0) - matrix2D2.get(0, 1) * matrix2D2.get(1, 0);
        dArray[0][0] = matrix2D2.get(1, 1) / d;
        dArray[0][1] = -matrix2D2.get(0, 1) / d;
        dArray[1][0] = -matrix2D2.get(1, 0) / d;
        dArray[1][1] = matrix2D2.get(0, 0) / d;
        matrix2D.setV(0, dArray[0][0] * (matrix2D3.getV(0) - matrix2D2.getV(0)) + dArray[0][1] * (matrix2D3.getV(1) - matrix2D2.getV(1)));
        matrix2D.setV(1, dArray[1][0] * (matrix2D3.getV(0) - matrix2D2.getV(0)) + dArray[1][1] * (matrix2D3.getV(1) - matrix2D2.getV(1)));
        matrix2D.set(0, 0, dArray[0][0] * matrix2D3.get(0, 0) + dArray[0][1] * matrix2D3.get(1, 0));
        matrix2D.set(0, 1, dArray[0][0] * matrix2D3.get(0, 1) + dArray[0][1] * matrix2D3.get(1, 1));
        matrix2D.set(1, 0, dArray[1][0] * matrix2D3.get(0, 0) + dArray[1][1] * matrix2D3.get(1, 0));
        matrix2D.set(1, 1, dArray[1][0] * matrix2D3.get(0, 1) + dArray[1][1] * matrix2D3.get(1, 1));
    }

    private static void matPassageAbs(OIJ oIJ, Matrix2D matrix2D) {
        if (oIJ != OIJ_ABSOLUTE) {
            matrix2D.set(0, 0, oIJ.I[0]);
            matrix2D.set(1, 0, oIJ.I[1]);
            matrix2D.set(0, 1, oIJ.J[0]);
            matrix2D.set(1, 1, oIJ.J[1]);
            matrix2D.setV(0, oIJ.oriX);
            matrix2D.setV(1, oIJ.oriY);
            if (oIJ.rep != OIJ_ABSOLUTE) {
                Matrix2D matrix2D2 = new Matrix2D();
                double[][] dArray = new double[2][2];
                dArray[0][0] = matrix2D.get(0, 0);
                dArray[0][1] = matrix2D.get(0, 1);
                dArray[1][0] = matrix2D.get(1, 0);
                dArray[1][1] = matrix2D.get(1, 1);
                OIJ.matPassageAbs(oIJ.rep, matrix2D2);
                matrix2D.set(0, 0, matrix2D2.get(0, 0) * dArray[0][0] + matrix2D2.get(0, 1) * dArray[1][0]);
                matrix2D.set(0, 1, matrix2D2.get(0, 0) * dArray[0][1] + matrix2D2.get(0, 1) * dArray[1][1]);
                matrix2D.set(1, 0, matrix2D2.get(1, 0) * dArray[0][0] + matrix2D2.get(1, 1) * dArray[1][0]);
                matrix2D.set(1, 1, matrix2D2.get(1, 0) * dArray[0][1] + matrix2D2.get(1, 1) * dArray[1][1]);
                dArray[0][0] = matrix2D.getV(0);
                matrix2D.setV(0, matrix2D2.get(0, 0) * matrix2D.getV(0) + matrix2D2.get(0, 1) * matrix2D.getV(1) + matrix2D2.getV(0));
                matrix2D.setV(1, matrix2D2.get(1, 0) * dArray[0][0] + matrix2D2.get(1, 1) * matrix2D.getV(1) + matrix2D2.getV(1));
            }
        } else {
            matrix2D.set(0, 0, 1.0);
            matrix2D.set(1, 0, 0.0);
            matrix2D.set(0, 1, 0.0);
            matrix2D.set(1, 1, 1.0);
            matrix2D.setV(0, 0.0);
            matrix2D.setV(1, 0.0);
        }
    }

    public String toString() {
        return this.name;
    }

    public String toLongString() {
        StringBuffer stringBuffer = new StringBuffer(this.name + "\n");
        stringBuffer.append(this.I[0]);
        stringBuffer.append("\t");
        stringBuffer.append(this.J[0]);
        stringBuffer.append("\t");
        stringBuffer.append(this.oriX + "\n");
        stringBuffer.append(this.I[1] + "\t");
        stringBuffer.append(this.J[1] + "\t");
        stringBuffer.append(this.oriY + "\n");
        stringBuffer.append("normSqI : ");
        stringBuffer.append(this.normSqI + "\n");
        stringBuffer.append("normSqJ : ");
        stringBuffer.append(this.normSqJ + "\n");
        stringBuffer.append("I.J : ");
        stringBuffer.append(this.IJ + "\n");
        stringBuffer.append("Theta : ");
        stringBuffer.append(this.theta + "\n");
        return stringBuffer.toString();
    }

    public final void setOrigin(double d, double d2) {
        this.oriX = d;
        this.oriY = d2;
    }

    public final double getOriginX() {
        return this.oriX;
    }

    public final double getOriginY() {
        return this.oriY;
    }

    public final void setI(double d, double d2) throws OIJException {
        if (!(Math.abs(d * this.J[1] - d2 * this.J[0]) > 1.0E-15)) {
            throw new OIJException("erreur");
        }
        this.I[0] = d;
        this.I[1] = d2;
        this.normSqI = this.rep.normSq(d, d2);
        this.IJ = d * this.J[0] * this.rep.normSqI + d2 * this.J[1] * this.rep.normSqJ + (d * this.J[1] + d2 * this.J[0]) * this.rep.IJ;
        this.theta = Math.acos(this.IJ / Math.sqrt(this.normSqI * this.normSqJ));
        OIJ.matPassageAbs(this, this.P);
    }

    public final void setJ(double d, double d2) throws OIJException {
        if (!(Math.abs(d * this.I[1] - d2 * this.I[0]) > 1.0E-15)) {
            throw new OIJException("erreur");
        }
        this.J[0] = d;
        this.J[1] = d2;
        this.normSqJ = this.rep.normSq(d, d2);
        this.IJ = d * this.I[0] * this.rep.normSqI + d2 * this.I[1] * this.rep.normSqJ + (d * this.I[1] + d2 * this.I[0]) * this.rep.IJ;
        this.theta = Math.acos(this.IJ / Math.sqrt(this.normSqI * this.normSqJ));
        OIJ.matPassageAbs(this, this.P);
    }

    public final double getIx() {
        return this.I[0];
    }

    public final double getIy() {
        return this.I[1];
    }

    public final double getJx() {
        return this.J[0];
    }

    public final double getJy() {
        return this.J[1];
    }

    public final void setOIJ(OIJ oIJ) {
        this.rep = oIJ;
        this.normSqI = oIJ.normSq(this.I[0], this.I[1]);
        this.normSqJ = oIJ.normSq(this.J[0], this.J[1]);
        this.IJ = this.I[0] * this.J[0] * oIJ.normSqI + this.I[1] * this.J[1] * oIJ.normSqJ + (this.I[0] * this.J[1] + this.I[1] * this.J[0]) * oIJ.IJ;
        this.theta = Math.acos(this.IJ / Math.sqrt(this.normSqI * this.normSqJ));
        OIJ.matPassageAbs(this, this.P);
    }

    public OIJ getOIJ() {
        return this.rep;
    }

    public void write(PrintWriter printWriter, OpaleSet opaleSet) throws InvalidFormatException {
        printWriter.println("{");
        if (this == OIJ_ABSOLUTE || this.rep == OIJ_ABSOLUTE) {
            printWriter.println("OIJ OIJ_ABSOLUTE");
        } else {
            if (!opaleSet.contains(this.getOIJ())) {
                throw new InvalidFormatException("Error writing the file " + printWriter + " : the OIJ " + this.getOIJ() + " doesn't exist !!");
            }
            printWriter.println("OIJ " + this.getOIJ().getId());
        }
        printWriter.println("O " + this.oriX + " " + this.oriY);
        printWriter.println("I " + this.I[0] + " " + this.I[1]);
        printWriter.println("J " + this.J[0] + " " + this.J[1]);
        printWriter.println("}");
    }

    /*
     * Unable to fully structure code
     */
    public void read(StreamReader var1_1, OpaleSet var2_2) throws IOException, InvalidFormatException {
        var3_3 = 1.0;
        var5_4 = 0.0;
        var7_5 = 0.0;
        var9_6 = 1.0;
        var12_7 = var1_1.next();
        if (var12_7.equals("{")) ** GOTO lbl32
        throw new InvalidFormatException("Stream of data non valid !!");
lbl-1000:
        // 1 sources

        {
            if (var12_7.equals("OIJ")) {
                var12_7 = var1_1.next();
                if (var12_7.equals("OIJ_ABSOLUTE")) {
                    this.rep = OIJ.OIJ_ABSOLUTE;
                    continue;
                }
                Debug.print("Dans OIJ : " + var2_2.contains(var12_7));
                Debug.print("Dans OIJ : " + var2_2.getObject(var12_7));
                if (!var2_2.contains(var12_7) || var2_2.getObject(var12_7) == null) {
                    throw new InvalidFormatException("Data file " + var1_1 + " is wrong  : the identifiant " + var12_7 + " doesn't exist !!");
                }
                if (var2_2.getObject(var12_7) instanceof OIJ) {
                    this.rep = (OIJ)var2_2.getObject(var12_7);
                    continue;
                }
                throw new InvalidFormatException("Data file " + var1_1 + " is non valid  : the identifiant " + var12_7 + " is not a OIJ !!");
            }
            if (var12_7.equals("O")) {
                this.oriX = var1_1.nextDouble();
                this.oriY = var1_1.nextDouble();
                continue;
            }
            if (var12_7.equals("I")) {
                var3_3 = var1_1.nextDouble();
                var5_4 = var1_1.nextDouble();
                continue;
            }
            if (!var12_7.equals("J")) continue;
            var7_5 = var1_1.nextDouble();
            var9_6 = var1_1.nextDouble();
lbl32:
            // 7 sources

            ** while (!(var12_7 = var1_1.next()).equals((Object)"}"))
        }
lbl33:
        // 1 sources

        try {
            this.setI(var3_3, var5_4);
            this.setJ(var7_5, var9_6);
        }
        catch (OIJException var13_8) {
            throw new InvalidFormatException("Impossible to construct this object OIJ.");
        }
    }

    public Object clone() {
        OIJ oIJ = (OIJ)super.clone();
        oIJ.name = this.name;
        oIJ.oriX = this.oriX;
        oIJ.oriY = this.oriY;
        oIJ.rep = this.rep;
        oIJ.I[0] = this.I[0];
        oIJ.I[1] = this.I[1];
        oIJ.J[0] = this.J[0];
        oIJ.J[1] = this.J[1];
        oIJ.P = new Matrix2D();
        OIJ.matPassageAbs(oIJ, oIJ.P);
        oIJ.normSqI = this.normSqI;
        oIJ.normSqJ = this.normSqJ;
        oIJ.IJ = this.IJ;
        oIJ.theta = this.theta;
        return oIJ;
    }

    public boolean isDirect() {
        return this.I[0] * this.J[1] - this.I[1] * this.J[0] > 0.0;
    }

    public static void main(String[] stringArray) throws OIJException {
        OIJ oIJ = new OIJ(0.0, 0.0, -3.0, 1.0, -2.0, 1.0);
        Debug.print("" + oIJ.isDirect());
    }

    static {
        OIJ_ABSOLUTE.setName("OIJ_ABSOLUTE");
    }
}

