/*
 * Decompiled with CFR 0.152.
 */
package opale.matrix.solver;

import opale.mathtools.DVect;
import opale.matrix.SymDecomposition;
import opale.matrix.SymMatrix;
import opale.matrix.SymSolver;

public class SolverCrout
implements SymSolver,
SymDecomposition {
    private double[] LD;
    private int[] pivot;
    private int n;
    private int signepermut;

    public void decomp(SymMatrix symMatrix) {
        this.n = symMatrix.getDim();
        this.LD = symMatrix.getInternalArray();
        int n = 0;
        while (n < this.n) {
            int n2;
            int n3;
            int n4 = n * (n + 1) / 2;
            int n5 = n4 + n;
            int n6 = 0;
            while (n6 < n) {
                n3 = n6 * (n6 + 1) / 2;
                n2 = n4 + n6;
                int n7 = 0;
                int n8 = n4;
                while (n7 < n6) {
                    int n9 = n2;
                    this.LD[n9] = this.LD[n9] - this.LD[n8] * this.LD[n3];
                    ++n7;
                    ++n8;
                    ++n3;
                }
                ++n6;
            }
            n3 = 0;
            while (n3 < n) {
                n2 = n4 + n3;
                double d = this.LD[n2] / this.LD[n3 * (n3 + 1) / 2 + n3];
                int n10 = n5;
                this.LD[n10] = this.LD[n10] - d * this.LD[n2];
                this.LD[n2] = d;
                ++n3;
            }
            ++n;
        }
    }

    public void solve(SymMatrix symMatrix, DVect dVect, DVect dVect2) {
        int n;
        int n2;
        double[] dArray = dVect.toArray();
        double[] dArray2 = dVect2.toArray();
        int n3 = 0;
        while (n3 < this.n) {
            n2 = n3 * (n3 + 1) / 2;
            dArray2[n3] = dArray[n3];
            n = 0;
            while (n < n3) {
                int n4 = n3;
                dArray2[n4] = dArray2[n4] - this.LD[n2++] * dArray2[n];
                ++n;
            }
            ++n3;
        }
        n = 0;
        while (n < this.n) {
            int n5 = n;
            dArray2[n5] = dArray2[n5] / this.LD[n * (n + 1) / 2 + n];
            ++n;
        }
        int n6 = this.n - 1;
        while (n6 >= 0) {
            n2 = (n6 + 1) * n6 / 2;
            int n7 = 0;
            while (n7 < n6) {
                int n8 = n7++;
                dArray2[n8] = dArray2[n8] - this.LD[n2] * dArray2[n6];
                ++n2;
            }
            --n6;
        }
    }

    public double determinant() {
        double d = 1.0;
        int n = 0;
        while (n < this.n) {
            d *= this.LD[n * (n + 1) / 2 + n];
            ++n;
        }
        return d;
    }

    public static void main(String[] stringArray) {
        SymMatrix symMatrix = new SymMatrix(3);
        DVect dVect = new DVect(3);
        DVect dVect2 = new DVect(3);
        symMatrix.set(0, 0, 2.0);
        symMatrix.set(1, 0, 1.0);
        symMatrix.set(1, 1, 1.0);
        symMatrix.set(2, 2, 3.0);
        dVect.set(0, 1.0);
        dVect.set(1, -1.5);
        dVect.set(2, 3.0);
        System.out.println(symMatrix);
        SolverCrout solverCrout = new SolverCrout();
        solverCrout.decomp(symMatrix);
        solverCrout.solve(null, dVect, dVect2);
        System.out.println(symMatrix);
        System.out.println(dVect2);
        System.out.println("det = " + solverCrout.determinant());
    }
}

