/*
 * Decompiled with CFR 0.152.
 */
package opale.ode.scheme;

import opale.mathtools.DVect;
import opale.ode.Equation;
import opale.ode.TimeScheme;

public final class RK
extends TimeScheme {
    public void forward(Equation equation) {
        DVect dVect = new DVect(this.present().size());
        double d = 0.5 * this.dt();
        int n = 0;
        while (n < this.present().size()) {
            dVect.set(n, this.past().get(n) + d * this.der_past().get(n));
            ++n;
        }
        DVect dVect2 = equation.derivs(this.time() + d, dVect);
        n = 0;
        while (n < this.present().size()) {
            dVect.set(n, this.past().get(n) + d * dVect2.get(n));
            ++n;
        }
        DVect dVect3 = equation.derivs(this.time() + d, dVect);
        n = 0;
        while (n < this.present().size()) {
            dVect.set(n, this.past().get(n) + this.dt() * dVect3.get(n));
            ++n;
        }
        DVect dVect4 = equation.derivs(this.time() + this.dt(), dVect);
        n = 0;
        while (n < this.present().size()) {
            this.present().set(n, this.past().get(n) + this.dt() * ((this.der_past().get(n) + dVect4.get(n)) / 6.0 + (dVect2.get(n) + dVect3.get(n)) / 3.0));
            ++n;
        }
    }

    public void advance() {
        Equation equation = this.getEquation();
        DVect dVect = new DVect(this.present().size());
        double d = 0.5 * this.dt();
        int n = 0;
        while (n < this.present().size()) {
            dVect.set(n, this.past().get(n) + d * this.der_past().get(n));
            ++n;
        }
        DVect dVect2 = equation.derivs(this.time() + d, dVect);
        n = 0;
        while (n < this.present().size()) {
            dVect.set(n, this.past().get(n) + d * dVect2.get(n));
            ++n;
        }
        DVect dVect3 = equation.derivs(this.time() + d, dVect);
        n = 0;
        while (n < this.present().size()) {
            dVect.set(n, this.past().get(n) + this.dt() * dVect3.get(n));
            ++n;
        }
        DVect dVect4 = equation.derivs(this.time() + this.dt(), dVect);
        n = 0;
        while (n < this.present().size()) {
            this.present().set(n, this.past().get(n) + this.dt() * ((this.der_past().get(n) + dVect4.get(n)) / 6.0 + (dVect2.get(n) + dVect3.get(n)) / 3.0));
            ++n;
        }
    }

    public String toString() {
        return "RK";
    }
}

