/*
 * OPALE is a scientific library under LGPL. Its main goal is to
 * develop mathematical tools for any scientist.
 *
 * Copyright (C) 2002 Opale Group
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * You can visit the web site http://opale.tuxfamily.org to obtain more
 * informations about this program and/or to contact the authors by mail
 * developers@opale.tuxfamily.org.
 */

package opale.cst.chemistry;
import java.util.*;

/** 
* This class has been automatically created by the program opale.tools.OTGC. 
*/
public class AllElements
{
private static String[] name = new String[89];
private static  HashMap thefields = new HashMap(4);
private static Field fSymbol = new Field("Symbol","Symbol",1);
private static Field fZ = new Field("Z","Atomic_number",2);
private static Field fA = new Field("A","Mass_number",2);
private static Field fMeltingPoint = new Field("MeltingPoint","Melting_point_K",3);

private AllElements() 
{}

static {
name[0] = new String("Actinium");
name[1] = new String("Aluminium");
name[2] = new String("Americium");
name[3] = new String("Antimony");
name[4] = new String("Argon");
name[5] = new String("Arsenic");
name[6] = new String("Astatine");
name[7] = new String("Barium");
name[8] = new String("Berkelium");
name[9] = new String("Beryllium");
name[10] = new String("Bismuth");
name[11] = new String("Boron");
name[12] = new String("Bromine");
name[13] = new String("Cadmium");
name[14] = new String("Caesium");
name[15] = new String("Calcium");
name[16] = new String("Californium");
name[17] = new String("Carbon");
name[18] = new String("Cerium");
name[19] = new String("Chlorine");
name[20] = new String("Chromium");
name[21] = new String("Cobalt");
name[22] = new String("Copper");
name[23] = new String("Curium");
name[24] = new String("Dysprosium");
name[25] = new String("Einsteinium");
name[26] = new String("Erbium");
name[27] = new String("Europium");
name[28] = new String("Fermium");
name[29] = new String("Fluorine");
name[30] = new String("Francium");
name[31] = new String("Gadolinium");
name[32] = new String("Gallium");
name[33] = new String("Germanium");
name[34] = new String("Gold");
name[35] = new String("Hafnium");
name[36] = new String("Helium");
name[37] = new String("Holmium");
name[38] = new String("Hydrogen");
name[39] = new String("Indium");
name[40] = new String("Iodine");
name[41] = new String("Iridium");
name[42] = new String("Iron");
name[43] = new String("Krypton");
name[44] = new String("Lanthanum");
name[45] = new String("Lawrencium");
name[46] = new String("Lead");
name[47] = new String("Lithium");
name[48] = new String("Lutetium");
name[49] = new String("Magnesium");
name[50] = new String("Manganese");
name[51] = new String("Mendelevium");
name[52] = new String("Mercury");
name[53] = new String("Molybdenum");
name[54] = new String("Neodymium");
name[55] = new String("Neon");
name[56] = new String("Neptunium");
name[57] = new String("Nickel");
name[58] = new String("Niobium");
name[59] = new String("Nitrogen");
name[60] = new String("Nobelium");
name[61] = new String("Osmium");
name[62] = new String("Oxygen");
name[63] = new String("Palladium");
name[64] = new String("Phosphorus");
name[65] = new String("Platinum");
name[66] = new String("Plutonium");
name[67] = new String("Polonium");
name[68] = new String("Potassium");
name[69] = new String("Praseodymium");
name[70] = new String("Promethium");
name[71] = new String("Protactinium");
name[72] = new String("Radium");
name[73] = new String("Radon");
name[74] = new String("Rhenium");
name[75] = new String("Rhodium");
name[76] = new String("Rubidium");
name[77] = new String("Ruthenium");
name[78] = new String("Samarium");
name[79] = new String("Scandium");
name[80] = new String("Selenium");
name[81] = new String("Silicon");
name[82] = new String("Silver");
name[83] = new String("Sodium");
name[84] = new String("Strontium");
name[85] = new String("Sulphur");
name[86] = new String("Tantalum");
name[87] = new String("Technetium");
name[88] = new String("Tellurium");
fSymbol.val = new Comparable[89];
fSymbol.val[0] = new String("Ac");
fSymbol.val[1] = new String("Al");
fSymbol.val[2] = new String("Am");
fSymbol.val[3] = new String("Sb");
fSymbol.val[4] = new String("Ar");
fSymbol.val[5] = new String("As");
fSymbol.val[6] = new String("At");
fSymbol.val[7] = new String("Ba");
fSymbol.val[8] = new String("Bk");
fSymbol.val[9] = new String("Be");
fSymbol.val[10] = new String("Bi");
fSymbol.val[11] = new String("B");
fSymbol.val[12] = new String("Br");
fSymbol.val[13] = new String("Cd");
fSymbol.val[14] = new String("Cs");
fSymbol.val[15] = new String("Ca");
fSymbol.val[16] = new String("Cf");
fSymbol.val[17] = new String("C");
fSymbol.val[18] = new String("Ce");
fSymbol.val[19] = new String("Cl");
fSymbol.val[20] = new String("Cr");
fSymbol.val[21] = new String("Co");
fSymbol.val[22] = new String("Cu");
fSymbol.val[23] = new String("Cm");
fSymbol.val[24] = new String("Dy");
fSymbol.val[25] = new String("Es");
fSymbol.val[26] = new String("Er");
fSymbol.val[27] = new String("Eu");
fSymbol.val[28] = new String("Fm");
fSymbol.val[29] = new String("F");
fSymbol.val[30] = new String("Fr");
fSymbol.val[31] = new String("Gd");
fSymbol.val[32] = new String("Ga");
fSymbol.val[33] = new String("Ge");
fSymbol.val[34] = new String("Au");
fSymbol.val[35] = new String("Hf");
fSymbol.val[36] = new String("He");
fSymbol.val[37] = new String("Ho");
fSymbol.val[38] = new String("H");
fSymbol.val[39] = new String("In");
fSymbol.val[40] = new String("I");
fSymbol.val[41] = new String("Ir");
fSymbol.val[42] = new String("Fe");
fSymbol.val[43] = new String("Kr");
fSymbol.val[44] = new String("La");
fSymbol.val[45] = new String("Lr");
fSymbol.val[46] = new String("Pb");
fSymbol.val[47] = new String("Li");
fSymbol.val[48] = new String("Lu");
fSymbol.val[49] = new String("Mg");
fSymbol.val[50] = new String("Mn");
fSymbol.val[51] = new String("Md");
fSymbol.val[52] = new String("Hg");
fSymbol.val[53] = new String("Mo");
fSymbol.val[54] = new String("Nd");
fSymbol.val[55] = new String("Ne");
fSymbol.val[56] = new String("Np");
fSymbol.val[57] = new String("Ni");
fSymbol.val[58] = new String("Nb");
fSymbol.val[59] = new String("N");
fSymbol.val[60] = new String("No");
fSymbol.val[61] = new String("Os");
fSymbol.val[62] = new String("O");
fSymbol.val[63] = new String("Pd");
fSymbol.val[64] = new String("P");
fSymbol.val[65] = new String("Pt");
fSymbol.val[66] = new String("Pu");
fSymbol.val[67] = new String("Po");
fSymbol.val[68] = new String("K");
fSymbol.val[69] = new String("Pr");
fSymbol.val[70] = new String("Pm");
fSymbol.val[71] = new String("Pa");
fSymbol.val[72] = new String("Ra");
fSymbol.val[73] = new String("Rn");
fSymbol.val[74] = new String("Re");
fSymbol.val[75] = new String("Rh");
fSymbol.val[76] = new String("Rb");
fSymbol.val[77] = new String("Ru");
fSymbol.val[78] = new String("Sm");
fSymbol.val[79] = new String("Sc");
fSymbol.val[80] = new String("Se");
fSymbol.val[81] = new String("Si");
fSymbol.val[82] = new String("Ag");
fSymbol.val[83] = new String("Na");
fSymbol.val[84] = new String("Sr");
fSymbol.val[85] = new String("S");
fSymbol.val[86] = new String("Ta");
fSymbol.val[87] = new String("Tc");
fSymbol.val[88] = new String("Te");
thefields.put("Symbol",fSymbol);
fZ.val = new Comparable[89];
fZ.val[0] = new Integer(89);
fZ.val[1] = new Integer(13);
fZ.val[2] = new Integer(95);
fZ.val[3] = new Integer(51);
fZ.val[4] = new Integer(18);
fZ.val[5] = new Integer(33);
fZ.val[6] = new Integer(85);
fZ.val[7] = new Integer(56);
fZ.val[8] = new Integer(97);
fZ.val[9] = new Integer(4);
fZ.val[10] = new Integer(83);
fZ.val[11] = new Integer(5);
fZ.val[12] = new Integer(35);
fZ.val[13] = new Integer(48);
fZ.val[14] = new Integer(55);
fZ.val[15] = new Integer(20);
fZ.val[16] = new Integer(98);
fZ.val[17] = new Integer(6);
fZ.val[18] = new Integer(58);
fZ.val[19] = new Integer(17);
fZ.val[20] = new Integer(24);
fZ.val[21] = new Integer(27);
fZ.val[22] = new Integer(29);
fZ.val[23] = new Integer(96);
fZ.val[24] = new Integer(66);
fZ.val[25] = new Integer(99);
fZ.val[26] = new Integer(68);
fZ.val[27] = new Integer(63);
fZ.val[28] = new Integer(100);
fZ.val[29] = new Integer(9);
fZ.val[30] = new Integer(87);
fZ.val[31] = new Integer(64);
fZ.val[32] = new Integer(31);
fZ.val[33] = new Integer(32);
fZ.val[34] = new Integer(79);
fZ.val[35] = new Integer(72);
fZ.val[36] = new Integer(2);
fZ.val[37] = new Integer(67);
fZ.val[38] = new Integer(1);
fZ.val[39] = new Integer(49);
fZ.val[40] = new Integer(53);
fZ.val[41] = new Integer(77);
fZ.val[42] = new Integer(26);
fZ.val[43] = new Integer(36);
fZ.val[44] = new Integer(57);
fZ.val[45] = new Integer(103);
fZ.val[46] = new Integer(82);
fZ.val[47] = new Integer(3);
fZ.val[48] = new Integer(71);
fZ.val[49] = new Integer(12);
fZ.val[50] = new Integer(25);
fZ.val[51] = new Integer(101);
fZ.val[52] = new Integer(80);
fZ.val[53] = new Integer(42);
fZ.val[54] = new Integer(60);
fZ.val[55] = new Integer(10);
fZ.val[56] = new Integer(93);
fZ.val[57] = new Integer(28);
fZ.val[58] = new Integer(41);
fZ.val[59] = new Integer(7);
fZ.val[60] = new Integer(102);
fZ.val[61] = new Integer(76);
fZ.val[62] = new Integer(8);
fZ.val[63] = new Integer(46);
fZ.val[64] = new Integer(15);
fZ.val[65] = new Integer(78);
fZ.val[66] = new Integer(94);
fZ.val[67] = new Integer(84);
fZ.val[68] = new Integer(19);
fZ.val[69] = new Integer(59);
fZ.val[70] = new Integer(61);
fZ.val[71] = new Integer(91);
fZ.val[72] = new Integer(88);
fZ.val[73] = new Integer(86);
fZ.val[74] = new Integer(75);
fZ.val[75] = new Integer(45);
fZ.val[76] = new Integer(37);
fZ.val[77] = new Integer(44);
fZ.val[78] = new Integer(62);
fZ.val[79] = new Integer(21);
fZ.val[80] = new Integer(34);
fZ.val[81] = new Integer(14);
fZ.val[82] = new Integer(47);
fZ.val[83] = new Integer(11);
fZ.val[84] = new Integer(38);
fZ.val[85] = new Integer(16);
fZ.val[86] = new Integer(73);
fZ.val[87] = new Integer(43);
fZ.val[88] = new Integer(52);
thefields.put("Z",fZ);
fA.val = new Comparable[89];
fA.val[0] = new Integer(227);
fA.val[1] = new Integer(27);
fA.val[2] = new Integer(243);
fA.val[3] = new Integer(122);
fA.val[4] = new Integer(40);
fA.val[5] = new Integer(75);
fA.val[6] = new Integer(210);
fA.val[7] = new Integer(137);
fA.val[8] = new Integer(249);
fA.val[9] = new Integer(9);
fA.val[10] = new Integer(209);
fA.val[11] = new Integer(11);
fA.val[12] = new Integer(80);
fA.val[13] = new Integer(112);
fA.val[14] = new Integer(133);
fA.val[15] = new Integer(40);
fA.val[16] = new Integer(251);
fA.val[17] = new Integer(12);
fA.val[18] = new Integer(140);
fA.val[19] = new Integer(35);
fA.val[20] = new Integer(52);
fA.val[21] = new Integer(59);
fA.val[22] = new Integer(63);
fA.val[23] = new Integer(247);
fA.val[24] = new Integer(162);
fA.val[25] = new Integer(254);
fA.val[26] = new Integer(167);
fA.val[27] = new Integer(152);
fA.val[28] = new Integer(257);
fA.val[29] = new Integer(19);
fA.val[30] = new Integer(223);
fA.val[31] = new Integer(157);
fA.val[32] = new Integer(70);
fA.val[33] = new Integer(72);
fA.val[34] = new Integer(197);
fA.val[35] = new Integer(178);
fA.val[36] = new Integer(4);
fA.val[37] = new Integer(165);
fA.val[38] = new Integer(1);
fA.val[39] = new Integer(115);
fA.val[40] = new Integer(127);
fA.val[41] = new Integer(192);
fA.val[42] = new Integer(56);
fA.val[43] = new Integer(84);
fA.val[44] = new Integer(139);
fA.val[45] = new Integer(260);
fA.val[46] = new Integer(207);
fA.val[47] = new Integer(7);
fA.val[48] = new Integer(175);
fA.val[49] = new Integer(24);
fA.val[50] = new Integer(55);
fA.val[51] = new Integer(256);
fA.val[52] = new Integer(201);
fA.val[53] = new Integer(96);
fA.val[54] = new Integer(144);
fA.val[55] = new Integer(20);
fA.val[56] = new Integer(237);
fA.val[57] = new Integer(59);
fA.val[58] = new Integer(93);
fA.val[59] = new Integer(14);
fA.val[60] = new Integer(259);
fA.val[61] = new Integer(190);
fA.val[62] = new Integer(16);
fA.val[63] = new Integer(106);
fA.val[64] = new Integer(31);
fA.val[65] = new Integer(195);
fA.val[66] = new Integer(242);
fA.val[67] = new Integer(210);
fA.val[68] = new Integer(39);
fA.val[69] = new Integer(141);
fA.val[70] = new Integer(145);
fA.val[71] = new Integer(231);
fA.val[72] = new Integer(226);
fA.val[73] = new Integer(222);
fA.val[74] = new Integer(186);
fA.val[75] = new Integer(103);
fA.val[76] = new Integer(85);
fA.val[77] = new Integer(101);
fA.val[78] = new Integer(150);
fA.val[79] = new Integer(45);
fA.val[80] = new Integer(79);
fA.val[81] = new Integer(28);
fA.val[82] = new Integer(108);
fA.val[83] = new Integer(23);
fA.val[84] = new Integer(88);
fA.val[85] = new Integer(32);
fA.val[86] = new Integer(181);
fA.val[87] = new Integer(99);
fA.val[88] = new Integer(128);
thefields.put("A",fA);
fMeltingPoint.val = new Comparable[89];
fMeltingPoint.val[0] = new Double(1323.0);
fMeltingPoint.val[1] = new Double(933.25);
fMeltingPoint.val[2] = new Double(1268.0);
fMeltingPoint.val[3] = new Double(904.0);
fMeltingPoint.val[4] = new Double(83.81);
fMeltingPoint.val[5] = new Double(1081.0);
fMeltingPoint.val[6] = new Double(575.0);
fMeltingPoint.val[7] = new Double(1002.0);
fMeltingPoint.val[8] = new Double(249.0);
fMeltingPoint.val[9] = new Double(1560.0);
fMeltingPoint.val[10] = new Double(544.52);
fMeltingPoint.val[11] = new Double(2300.0);
fMeltingPoint.val[12] = new Double(265.9);
fMeltingPoint.val[13] = new Double(594.18);
fMeltingPoint.val[14] = new Double(301.55);
fMeltingPoint.val[15] = new Double(1112.0);
fMeltingPoint.val[16] = new Double(900.0);
fMeltingPoint.val[17] = new Double(3550.0);
fMeltingPoint.val[18] = new Double(1071.0);
fMeltingPoint.val[19] = new Double(172.16);
fMeltingPoint.val[20] = new Double(2130.0);
fMeltingPoint.val[21] = new Double(1768.0);
fMeltingPoint.val[22] = new Double(1357.6);
fMeltingPoint.val[23] = new Double(1340.0);
fMeltingPoint.val[24] = new Double(1682.0);
fMeltingPoint.val[25] = new Double(254.0);
fMeltingPoint.val[26] = new Double(1795.0);
fMeltingPoint.val[27] = new Double(1090.0);
fMeltingPoint.val[28] = new Double(257.0);
fMeltingPoint.val[29] = new Double(53.48);
fMeltingPoint.val[30] = new Double(300.0);
fMeltingPoint.val[31] = new Double(1585.0);
fMeltingPoint.val[32] = new Double(302.9);
fMeltingPoint.val[33] = new Double(1210.4);
fMeltingPoint.val[34] = new Double(1337.5);
fMeltingPoint.val[35] = new Double(2500.0);
fMeltingPoint.val[36] = new Double(0.95);
fMeltingPoint.val[37] = new Double(1743.0);
fMeltingPoint.val[38] = new Double(14.025);
fMeltingPoint.val[39] = new Double(429.76);
fMeltingPoint.val[40] = new Double(386.7);
fMeltingPoint.val[41] = new Double(2716.0);
fMeltingPoint.val[42] = new Double(1809.0);
fMeltingPoint.val[43] = new Double(115.78);
fMeltingPoint.val[44] = new Double(1193.0);
fMeltingPoint.val[45] = new Double(260.0);
fMeltingPoint.val[46] = new Double(600.6);
fMeltingPoint.val[47] = new Double(453.7);
fMeltingPoint.val[48] = new Double(1936.0);
fMeltingPoint.val[49] = new Double(922.0);
fMeltingPoint.val[50] = new Double(1517.0);
fMeltingPoint.val[51] = new Double(256.0);
fMeltingPoint.val[52] = new Double(234.28);
fMeltingPoint.val[53] = new Double(2890.0);
fMeltingPoint.val[54] = new Double(1289.0);
fMeltingPoint.val[55] = new Double(24.553);
fMeltingPoint.val[56] = new Double(910.0);
fMeltingPoint.val[57] = new Double(1726.0);
fMeltingPoint.val[58] = new Double(2740.0);
fMeltingPoint.val[59] = new Double(63.14);
fMeltingPoint.val[60] = new Double(259.0);
fMeltingPoint.val[61] = new Double(3300.0);
fMeltingPoint.val[62] = new Double(50.35);
fMeltingPoint.val[63] = new Double(1825.0);
fMeltingPoint.val[64] = new Double(317.3);
fMeltingPoint.val[65] = new Double(2045.0);
fMeltingPoint.val[66] = new Double(913.0);
fMeltingPoint.val[67] = new Double(527.0);
fMeltingPoint.val[68] = new Double(336.35);
fMeltingPoint.val[69] = new Double(1204.0);
fMeltingPoint.val[70] = new Double(1204.0);
fMeltingPoint.val[71] = new Double(231.0);
fMeltingPoint.val[72] = new Double(973.0);
fMeltingPoint.val[73] = new Double(202.0);
fMeltingPoint.val[74] = new Double(3453.0);
fMeltingPoint.val[75] = new Double(2236.0);
fMeltingPoint.val[76] = new Double(312.64);
fMeltingPoint.val[77] = new Double(2523.0);
fMeltingPoint.val[78] = new Double(1345.0);
fMeltingPoint.val[79] = new Double(1812.0);
fMeltingPoint.val[80] = new Double(494.0);
fMeltingPoint.val[81] = new Double(1685.0);
fMeltingPoint.val[82] = new Double(1234.0);
fMeltingPoint.val[83] = new Double(371.0);
fMeltingPoint.val[84] = new Double(1041.0);
fMeltingPoint.val[85] = new Double(388.36);
fMeltingPoint.val[86] = new Double(3287.0);
fMeltingPoint.val[87] = new Double(2473.0);
fMeltingPoint.val[88] = new Double(722.65);
thefields.put("MeltingPoint",fMeltingPoint);
}

// search name index.
private static int search(String n)
{
for (int i=0;i<name.length;i++)
	{
	if (name[i].equalsIgnoreCase(n)) return i;
	}
return -1;
}

/** This method permits to get the value of a field for an element.
* <br>For instance <code>get("Actinium","Symbol")</code> returns the value of the field Symbol for the element Actinium.
* <p>The possible names of element are :
* <UL>
* <LI> Actinium
* <LI> Aluminium
* <LI> Americium
* <LI> Antimony
* <LI> Argon
* <LI> Arsenic
* <LI> Astatine
* <LI> Barium
* <LI> Berkelium
* <LI> Beryllium
* <LI> Bismuth
* <LI> Boron
* <LI> Bromine
* <LI> Cadmium
* <LI> Caesium
* <LI> Calcium
* <LI> Californium
* <LI> Carbon
* <LI> Cerium
* <LI> Chlorine
* <LI> Chromium
* <LI> Cobalt
* <LI> Copper
* <LI> Curium
* <LI> Dysprosium
* <LI> Einsteinium
* <LI> Erbium
* <LI> Europium
* <LI> Fermium
* <LI> Fluorine
* <LI> Francium
* <LI> Gadolinium
* <LI> Gallium
* <LI> Germanium
* <LI> Gold
* <LI> Hafnium
* <LI> Helium
* <LI> Holmium
* <LI> Hydrogen
* <LI> Indium
* <LI> Iodine
* <LI> Iridium
* <LI> Iron
* <LI> Krypton
* <LI> Lanthanum
* <LI> Lawrencium
* <LI> Lead
* <LI> Lithium
* <LI> Lutetium
* <LI> Magnesium
* <LI> Manganese
* <LI> Mendelevium
* <LI> Mercury
* <LI> Molybdenum
* <LI> Neodymium
* <LI> Neon
* <LI> Neptunium
* <LI> Nickel
* <LI> Niobium
* <LI> Nitrogen
* <LI> Nobelium
* <LI> Osmium
* <LI> Oxygen
* <LI> Palladium
* <LI> Phosphorus
* <LI> Platinum
* <LI> Plutonium
* <LI> Polonium
* <LI> Potassium
* <LI> Praseodymium
* <LI> Promethium
* <LI> Protactinium
* <LI> Radium
* <LI> Radon
* <LI> Rhenium
* <LI> Rhodium
* <LI> Rubidium
* <LI> Ruthenium
* <LI> Samarium
* <LI> Scandium
* <LI> Selenium
* <LI> Silicon
* <LI> Silver
* <LI> Sodium
* <LI> Strontium
* <LI> Sulphur
* <LI> Tantalum
* <LI> Technetium
* <LI> Tellurium
* </UL>
* <p>The fields of an element are :
* <UL>
* <LI> Symbol, "Symbol"
* <LI> Z, "Atomic_number"
* <LI> A, "Mass_number"
* <LI> MeltingPoint, "Melting_point_K"
* </UL><p>
* @param String the name of an element
* @param String the name of a field
* @return the value of the field
* @throws IllegalArgumentException if the arguments are not valid
*/
public static  String get(String aname, String afield)
	{
	int i = search(aname);
	Field f = (Field) thefields.get(afield);
	if(i==-1 || f==null) throw new IllegalArgumentException("non valid field!!");
	return f.val[i].toString();
	}

/**
* This method returns an instance of Element.
* @param String, the name of an Element
* @return Element, the object 
*/
public  static Element getElement(String aname)
	{
	int i = search(aname);
	if(i==-1) throw new IllegalArgumentException("non valid field!!");
	Element obj = new Element(name[i], ((String) (fSymbol).val[i]), ((Integer) (fZ.val[i])).intValue(), ((Integer) (fA.val[i])).intValue(), ((Double) (fMeltingPoint.val[i])).doubleValue());
		return obj;
	}

/**
* This method returns the number  of Element.
* @return int, the size 
*/
public  static int getSize()
	{
	return name.length;
	}
/**
* This method returns an instance of Element.
* @param int, the index of an Element
* @return Element, the object 
*/
public  static Element getElement(int index)
	{
	int i = index;
	if(i<0 || i>= name.length) throw new IllegalArgumentException("no valid index!!");
	Element obj = new Element(name[i], ((String) (fSymbol).val[i]), ((Integer) (fZ.val[i])).intValue(), ((Integer) (fA.val[i])).intValue(), ((Double) (fMeltingPoint.val[i])).doubleValue());
		return obj;
	}
public  static Element[] search(String field,String value)
	{
	Field f = (Field) thefields.get(field);
	if(f==null) throw new IllegalArgumentException("non valid field!!");
	Vector resu = new Vector();
	if(f.type == Field.STRING) 
		{
		for (int i=0;i<name.length;i++)
			{
			if (f.val[i].equals(value)) resu.add(AllElements.getElement(i));
			}
		}
	else if(f.type == Field.INT) 
		{
		for (int i=0;i<name.length;i++)
			{
			if ( (((Integer) f.val[i])).equals(new Integer(value)) ) resu.add(AllElements.getElement(i));
			}
		}
	else if(f.type == Field.DOUBLE) 
		{
		for (int i=0;i<name.length;i++)
			{
			if ( (((Double) f.val[i])).equals(new Double(value)) ) resu.add(AllElements.getElement(i));
			}
		}
	Element[] res = new Element[resu.size()];
	for(int i=0;i<resu.size();i++) res[i] = (Element) resu.elementAt(i);
	return res;
	}
}


class Field
{
final static int STRING=1, INT=2, DOUBLE=3;

public String name;
public String description;
public int type;
public Comparable[] val;

public Field(String n, String d, int t)
	{
	name = new String(n);
	description =  new String(d);
	type = t;
	}

public String toString()
	{
	return name+" "+description+" "+type;
	}

}


