/*
 * OPALE is a scientific library under LGPL. Its main goal is to
 * develop mathematical tools for any scientist.
 *
 * Copyright (C) 2002 Opale Group
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * You can visit the web site http://opale.tuxfamily.org to obtain more
 * informations about this program and/or to contact the authors by mail
 * developers@opale.tuxfamily.org.
 */

package opale.ode.scheme;

import opale.mathtools.*;
import opale.ode.*;


/**
* Cette classe implmente le theta schma qui consiste  avancer en temps de la facon suivante : yn+1=yn+f(t,theta*yn+(1-theta)*yn+1).
* @author O.C.
* @since Opale-ODE 0.12
*/
public  final class ThetaScheme extends TimeScheme
{
private double theta;
/**
* This value represents the precision for the fix point method.
*/
//public static double PRECISION = 1.e-16;

/**
* This value fixes the maximum number of iterations in the algorithm.
*/ 
//public static int MAXITERATION = 100;


/**
* Par dfaut theta = 0.5
*/	
public ThetaScheme()
	{
	theta=0.5;
	}	

/**
* Permet de spcifier la valeur de theta
* @param double t
*/
public ThetaScheme(double t)
	{
	theta=t;
	}	
	
/**
* Cette mthode dfinit l'avanc en temps par la theta mthode.
*/	
public void forward(Equation eq)
	{
	int i=0,sortie=0;
	double cvg;

	DVect sol = new DVect(past());	
	f.eq=eq;
//	f.tmp = new DVect(present().size());
	f.theta = theta;
	
	FixPoint.solve(f,present().size(),past(), sol);
	
	//initialisation des conditions initiales

	present().set(sol);	
	
	}

/**
* Cette mthode dfinit l'avanc en temps par la theta mthode.
*/	
public void advance()
	{
	Equation eq = getEquation();
	int i=0,sortie=0;
	double cvg;

	DVect sol = new DVect(past());	
	f.eq=eq;
//	f.tmp = new DVect(present().size());
	f.theta = theta;
	
	FixPoint.solve(f,present().size(),past(), sol);
	
	//initialisation des conditions initiales
/*	DVect x = new DVect(present());	
	DVect sol = new DVect(present());	
	
	
	
	while ( (i<MAXITERATION) && (sortie == 0) )
		{
		//x.get(tab);
		sol.set(eq.derivs(time(),x));
		sol.mul(dt());
		sol.add(present());
		
		x.sub(sol);
		cvg =   x.norm2Sq()/sol.norm2Sq();
		
		// prepare the next iteration
		x.set(sol);
		if ( cvg < PRECISION ) 
			sortie = 1;
		i++;
		}
	
	present().set(sol);*/
	present().set(sol);	
	
	}

public String toString()
	{
	return "theta Scheme";
	}


private class func implements IFnn
	{
	//DVect tmp;
	Equation eq;
	double theta;
	public  DVect val(DVect x)
		{
		double t1=1.-theta;
		for (int i =0;i<present().size();i++)
			{
			//tmp.set(i,present().get(i));
			x.set(i,theta*past().get(i)+t1*x.get(i));
			}
		x.set(eq.derivs(time(),x));
		for (int i =0;i<present().size();i++)
			x.set(i,past().get(i) + dt()*x.get(i));
		return x;
		}
	} 
private func f =new func();

}
