/*
 * OPALE is a scientific library under LGPL. Its main goal is to
 * develop mathematical tools for any scientist.
 *
 * Copyright (C) 2002 Opale Group
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * You can visit the web site http://opale.tuxfamily.org to obtain more
 * informations about this program and/or to contact the authors by mail
 * developers@opale.tuxfamily.org.
 */

package otests.m2d.Data2d;

import opale.tools.*;
import opale.m2d.*;
import opale.m2d.object2d.*;
import opale.tools.*;
import java.awt.*;
import java.awt.event.*;


public class Data2d extends Frame implements OTest
	{
	OIJ repere;
	LinLinCS vue;
	GAxis2D axes;
	GData2D data;
	
	public  void run(String path)
		{
		setSize(400,400);
		
		repere = new OIJ();
		vue = new LinLinCS(repere,25,25,350,350);
		
		axes = new GAxis2D(vue);
		((InfoAxis) axes.getInfo()).setTick(0,1,0,1);

		try
		{
		StreamReader fichier = new StreamReader(path+"data.o2d");
		data = new GData2D(repere);
		data.readData(fichier);
		data.getInfo().setColor(Color.red);
		}
		catch (java.io.IOException e)
		{
		System.out.println(e);
		System.exit(-1);
		}	

		catch (InvalidFormatException e)
		{
		System.out.println(e);
		System.exit(-1);
		}	

		
		addComponentListener(new ComponentAdapter()
		{
		public void componentResized(ComponentEvent e)
			{
			vue.setSize(25,25,getWidth()-50,getHeight()-50);
			vue.normadjust();
			repaint();
			}
		});

		show();

		}
		
	public void paint(Graphics g)
		{
		
		Pen2D c = new Pen2D(g,vue);
		axes.draw(c);

		data.draw(c);
	
		}
		
		
public void stop()
	{
	dispose();
	}
	
	
	
	}
