/*
 * OPALE is a scientific library under LGPL. Its main goal is to
 * develop mathematical tools for any scientist.
 *
 * Copyright (C) 2002 Opale Group
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * You can visit the web site http://opale.tuxfamily.org to obtain more
 * informations about this program and/or to contact the authors by mail
 * developers@opale.tuxfamily.org.
 */

import opale.m2d.*;
import opale.m2d.object2d.*;
import opale.m2d.component2d.*;
import opale.m2d.marktype.*;
import opale.mathtools.*;
import opale.tools.*;
import java.awt.*;
import java.awt.event.*;

	
public class transform extends JFrame2D
	{
	GPoint2D p,pp; 
	GVector2D v,vv;
	GData2D data, datat;
	public transform() 
		{
		OIJ repere = new OIJ();
		
		getAxis().drawScale(false);
		getCS().setOIJ(repere);

		try
		{
		StreamReader fichier = new StreamReader("data.txt");
		data = new GData2D(repere);
		data.readData(fichier);
		data.getInfo().setColor(Color.red);
		}
		catch (java.io.IOException e)
		{
		System.out.println(e);
		System.exit(-1);
		}	
		catch (InvalidFormatException e)
		{
		System.out.println(e);
		System.exit(-1);
		}	

		
		p = new GPoint2D(repere,2,2);
		DefaultGraphicalOptions info = (DefaultGraphicalOptions) p.getInfo();
		info.setColor(Color.red);
		DiamondPoint dp = new DiamondPoint();
		dp.setMarksize(5);
		info.setMarktype(dp);

		v = new GVector2D(repere,-3,6);		
		vv = new GVector2D(v);		

		datat = new GData2D(data);

		AffineTransform2D t = new AffineTransform2D();
		t.rotate(Math.PI,0,0); // one rotation
		t.translate(3,-2); // one translation
		t.scale(1.5,0.5); // one scaling
		
		pp = new GPoint2D(p);
		pp.transform(t);
		vv.transform(t);
		datat.transform(t);
		
		getPack2D().add(repere,"repere");
		getPack2D().add(p,"point");
		getPack2D().add(pp,"point_t");
		getPack2D().add(v,"vect");
		getPack2D().add(vv,"vect_t");
		getPack2D().add(data,"data");
		getPack2D().add(datat,"datat");
		}
		

	
	
	public static void main(String[] arg) 		{
		transform t = new transform();
		t.show();
		}
	}
