---------------------------------------------------------------
--
--  RAPID - Rapid Ada Portable Interface Designer
--
--  RAPID.ADB
--  Description : Main procedure
--
--  Copyright (C) 1999, Martin C. Carlisle <carlislem@acm.org>
--
-- RAPID is free software; you can redistribute it and/or
-- modify it without restriction.  However, we ask that you
-- please retain the original author information, and clearly
-- indicate if it has been modified.
--
-- RAPID is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty
-- of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
--
-- As a special exception, if other files instantiate generics from
-- this unit, or you link this unit with other files to produce an
-- executable, this unit does not by itself cause the resulting
-- executable to be covered by the GNU General Public License.
-- This exception does not however invalidate any other reasons
-- why the executable file might be covered by the GNU Public
-- License.  This exception does not apply to executables which
-- are GUI design tools, or that could act as a replacement
-- for RAPID.
---------------------------------------------------------------
with main_window;
with Toolbar;
with Ada.Exceptions;
with mcc.Decode_Command_Line;
with mcc.Gui.Container.Window;
with Rapid_Helpers;
with Ada.Strings.Unbounded;
with mcc.Directory_Operations;
with state;
with gui.Window;
with mcc.Common_Dialogs;
with File_Menu;

procedure Rapid is
   Interactive : Boolean := True;
   Filename : Ada.Strings.Unbounded.Unbounded_String;
   use Ada.Strings.Unbounded;
begin
   mcc.Decode_Command_Line (Filename, Interactive);
   if not Interactive then
      if Filename /= Ada.Strings.Unbounded.Null_Unbounded_String then
         state.Set_Current_Window (state.Allocate_Window);
         state.Set_Filename (To_String (Filename));
         state.Set_Directory (mcc.Directory_Operations.Get_Current_Dir);
         gui.Window.Read_Window
           (Window   => state.Get_Current_Window.all,
            Filename => state.Get_Filename);
         gui.Window.Generate_Window (state.Get_Current_Window.all);
         return;
      end if;
   end if;
   main_window.Generate_Window;
   Toolbar.Initialize_Toolbar;
   -- set minimum window size
   mcc.Gui.Container.Window.Set_Resize_Handler
     (Obj     => main_window.main_window'Access,
      Handler => Rapid_Helpers.Rapid_Resize_Handler'Access);

   -- adapted from submission by Dmitri Anisimkov
   -- allows Windows users to double click a .GUI file
   -- and have it be opened in RAPID
   if Filename /= Ada.Strings.Unbounded.Null_Unbounded_String then
      begin
         state.Set_Current_Window (state.Allocate_Window);
         state.Set_Filename (To_String (Filename));
         state.Set_Directory (mcc.Directory_Operations.Get_Current_Dir);

         gui.Window.Read_Window
           (Window   => state.Get_Current_Window.all,
            Filename => state.Get_Filename);
         gui.Window.Display_Window (Window => state.Get_Current_Window.all);
         state.Set_Changed (False);
      exception
         when others =>
            mcc.Common_Dialogs.Ok_Box
              ("Unable to open " & To_String (Filename));
      end;
   end if;
   mcc.Gui.Container.Window.Set_Close_Handler
     (Obj     => main_window.main_window'Access,
      Handler => File_Menu.Exit_Choice'Access);
   mcc.Gui.Set_Key_Listener
     (Obj      => main_window.main_window'Access,
      Listener => state.Main_Window_Key_Listener'Access);
   mcc.Gui.Container.Window.Event_Loop;
exception
   when E : others =>
      declare
         Window   : gui.Window.Window_Pointer := state.Get_Current_Window;
         Filename : aliased String            := "emergency.gui";
         use type gui.Window.Window_Pointer;
      begin
         if Window /= null then
            Window.Filename := Filename'Unchecked_Access;
            gui.Window.Write_Window (Window.all);
         end if;

      end;
      mcc.Common_Dialogs.Ok_Box
        ("Open window (if any) dumped to emergency.gui" &
         ASCII.LF &
         "Uncaught exception -- contact author:" &
         Ada.Exceptions.Exception_Information (E));
      raise;
end Rapid;
